/*
 * Copyright 2010 Avaya Inc. All Rights Reserved.
 */

$(document).ready(function () {

    var NOTIFY_NEW_SESSION = "-1";
    var NOTIFY_AUTH_FAILED = "100";

    var handleAutologin = function () {
        jQuery.ajax({
            type: 'DELETE',
            url: '/api/session',
            complete: function (xhr) {
                $.ajax({
                    type: "PUT",
                    url: "/api/i18n/lang",
                    data: "lang=" + $("#lang").val(),
                    cache: false,
                    success: function () {
                        createSession();
                    }
                });
            }
        });
    };

    var createSession = function () {
        jQuery.ajax({
            type: 'PUT',
            url: '/api/session',
            data: jQuery('#autologinForm').serialize(),
            complete: function (xhr) {
                switch (xhr.status) {
                    case 200:
                        if (typeof REFERRER !== 'undefined') {
                            var cookie = document.cookie;
                            if (cookie.length > 0) {
                                cookie += "; ";
                            }
                            var strNotif = cookie + 'webpy_session_id=' + xhr.responseText;
                            strNotif = NOTIFY_NEW_SESSION + "|" + strNotif;
                            window.parent.postMessage(strNotif, REFERRER);
                        }
                        window.location.replace('/main');
                        break;

                    case 401:
                    default:
                        $("#feedback").removeClass("busy");
                        //var wcpURL = window.location.protocol + "//" + window.location.host + "/";
                        //var msg = $("#js_authFailed").text();
                        //msg += "<br/>" + $("#js_launchWCPStandalone").text() + " <a target='_blank' href='" + wcpURL + "'>" + wcpURL + "</a>";
                        //$("#feedback").html(msg);
                        if (typeof REFERRER !== 'undefined') {
                            window.parent.postMessage(NOTIFY_AUTH_FAILED, REFERRER);
                        }
                        break;
                }
            }
        });
    };

    handleAutologin();
}); 