# Copyright 2010 Avaya Inc. All Rights Reserved.

"""
URL rewrite support.
"""

import unittest
import re


__author__      = "Avaya Inc."
__copyright__   = "Copyright 2010, Avaya Inc."


class Rule(object):
    """
    URL rewrite rule.
    """
    def __init__(self, from_url, to_url):
        self._re = re.compile(from_url)
        self.to_url = to_url

    def rewrite(self, url):
        return self._re.sub(self.to_url, url)


class Rewrite(object):
    """
    URL rewrite filter.
    """
    def __init__(self):
        self.rules = []

    def add_rule(self, from_url, to_url):
        self.rules.append(Rule(from_url, to_url))

    def rewrite(self, url):
        result = url
        for rule in self.rules:
            result = rule.rewrite(result)
        return result


class Test(unittest.TestCase):

    def test_rewrite(self):
       r = Rewrite()
       r.add_rule('/static/(.*)', r'/a/static/\1')
       r.add_rule('(.*?)/pics/(.*)', r'\1/images/\2')

       self.assertEqual('/a/static/page.html', r.rewrite('/static/page.html'))
       self.assertEqual('/a/images/b/c.png', r.rewrite('/a/pics/b/c.png'))
       self.assertEqual('/a/static/images/b/c.png', r.rewrite('/static/pics/b/c.png'))