# Copyright 2010 Avaya Inc. All Rights Reserved.

"""
Interface with IPOffice service for license check.
"""

import os
import unittest

from core.common import version
from core.system import shell
from core.common import configuration
from core.common import utils

WEBCONTROL_USER = configuration.USERNAME 

__author__      = "Avaya Inc."
__copyright__   = "Copyright 2010, Avaya Inc."

if version.RELEASE_TYPE == 'isa' or version.RELEASE_TYPE == 'abe':
    DEMO_FILE = configuration.SHARED_CONFIGURATION["demo"]["ipoffice_anywhere_file"]
else:
    DEMO_FILE=None
    PASSWORD_PIPE=None


def read_website_file():
    """
    Parse IPOffice website file (if any) and return the file contents packed in a dictionary:

    {'authenticate_message':      message to display when requesting the user to enter the demo password
     'license_expire_message':    message that warns the user the license is about to expire
     'license_warning_message':   general warning message displayed in the Services table from Home page}

    This function will return an empty dictionary if the file does not exists.
    """
    contents = {}
    if DEMO_FILE and os.path.exists(DEMO_FILE):
        contents = {'authenticate_message': None,
                    'license_expire_message': None,
                    'license_warning_message': None}
        utils.read_config(DEMO_FILE, contents)
    return contents


def write_to_password_pipe(message):
    """
    Write user input to IPOffice password pipe.
    The file path for password pipe is read from environment variable IPOFFICE_PASS_PIPE.
    """
    # yeah...I know...
    if DEMO_FILE:
        shell.sudo_call('rm -fr %s' % DEMO_FILE)
    if PASSWORD_PIPE:
        if not os.path.exists(PASSWORD_PIPE):
            shell.sudo_call('mkfifo --mode=0777 %s' % PASSWORD_PIPE)
            shell.sudo_call('chown %s:%s %s' % (WEBCONTROL_USER, WEBCONTROL_USER, PASSWORD_PIPE))
        with open(PASSWORD_PIPE, 'w') as p:
            p.writelines(message+'\n')


class Test(unittest.TestCase):

    def test_read_website_file(self):
        if DEMO_FILE and os.path.exists(DEMO_FILE):
            contents = read_website_file()
            self.assertTrue(contents.has_key('authenticate_message'))
            self.assertTrue(contents.has_key('license_expire_message'))
            self.assertTrue(contents.has_key('license_warning_message'))

if __name__ == '__main__':
    unittest.main()
