# Copyright 2014 Avaya Inc. All Rights Reserved.

"""
Interface with IPOffice service for web services check.
"""

import subprocess
import xml.etree.ElementTree as ET
import unittest

from core.system import shell

__author__ = "Avaya Inc."
__copyright__ = "Copyright 2014, Avaya Inc."

WEB_SERVICES_URL = "https://127.0.0.1:8443/ws/"
WEB_SERVICES_ADMIN = WEB_SERVICES_URL + "admin/system/"


def curl(*args):
    """
    Wrapper around the curl comand line application.
    Usage:
        curl('-k', '-A', "Avaya-WebAdmin", '-u', "Admin:Admin", '-m', '3', '-X', "GET", URL)
    :param args:
        The arguments of the curl command
    :return:
        The stdout of the curl command
    """
    curl_path = '/usr/bin/curl'
    curl_list = [curl_path]
    for arg in args:
        # loop just in case we want to filter args in future.
        curl_list.append(arg)
    curl_result = subprocess.Popen(
        curl_list,
        stderr=subprocess.PIPE,
        stdout=subprocess.PIPE).communicate()[0]
    return curl_result

def port_check(port_no):
    """
    Verifies the port port_no is listned on by an application
    :return:
        true - if a process listens on the port
        false - of the port_no is not open
    """
    port_open = shell.sudo_execute('/usr/sbin/lsof -i :%s' % port_no)
    return True if (port_open != None) else False

def file_verification(fname):
    """
    Verifies if a file exists
    Usage:
        file_verification("/opt/Avaya/.auto_ignition")
    """
    import os.path
    return os.path.isfile(fname)

def xml_check():
    """
    Verifies if the 8433 port is open and if the xml from IPO webservices is proper.
    :return:
        {"ws_ign": true|false, "ws_xml": true|false, "ws_port": true|false}
    """
    response = curl('-k', '-A', "Avaya-WebAdmin", '-u', "Admin:Admin", '-m', '3', '-X', "GET",
                         WEB_SERVICES_ADMIN)
    try:
        tree = ET.fromstring(response).getiterator()
        err = True
    except:
        err = False
    contents = dict(ws_ign=file_verification("/opt/Avaya/.auto_ignition"), ws_port=port_check("8443"), ws_xml=err)
    return contents


class Test(unittest.TestCase):
    def test_xml_check(self):
        print (xml_check())


if __name__ == '__main__':
    unittest.main()
