# Copyright 2010 Avaya Inc. All Rights Reserved.

"""
REST API for I18N support.
"""

import web
import json
import configobj

from core.common import configuration

__author__      = "Avaya Inc."
__copyright__   = "Copyright 2010, Avaya Inc."

LANGUAGES_CONFIG_FILE = 'i18n/languages.ini'
LANGUAGES_CONFIG = configobj.ConfigObj(LANGUAGES_CONFIG_FILE, encoding="utf-8")

class LanguageResource(object):
    """
    REST resource to manage language settings

    Methods:

    GET -- return language
    PUT -- set language
    """
    def GET(self):
        """
        Get language.
        """
        lang = web.ctx.session.lang
        if lang in configuration.SUPPORTED_LANGUAGES:
            return lang
        else:
            return configuration.DEFAULT_SESSION_LANGUAGE

    def PUT(self):
        """
        Set language.

        Input:

        lang = language
        """
        lang = web.input(lang='en_US').lang
        web.setcookie('avaya_webcontrol_lang', lang, 31536000)
        web.ctx.session.lang = lang

class LanguagesResource(object):
    """
    REST resource to list available languages

    Method:

    GET -- return available languages
    """
    def GET(self):
        """
        Return a dictionary {id: name} json string with available languages.
        """
        web.header("Content-Type","application/json")                
        return json.dumps(LANGUAGES_CONFIG.dict())
