/*
 * Copyright 2010 Avaya Inc. All Rights Reserved.
 */

$(document).ready(function() {

    var login = {};
    login.language = "";
    login.languageChanged = false;
    login.passwordRestrictions = 1;
    login.passwordRulesData = null;
    login.ignitionReady = false;

    /**
     * Clears a div text fields.
     *
     * @param divId ID of the div.
     */
    login.clearFields = function (divId) {
        $("#" + divId + " input:text").val("");
        $("#" + divId + " input:password").val("");
    };

    /**
     * Hides change password fields , shows login fields
     */
    login.hideChangePassword = function () {
        globals.variables.loginFormId = "formFields";
        //$("#changePassword").show();
        $("#formFields").show();
        $("#changePasswordFields").hide();
        globals.functions.resizeLogin();
        login.clearFields("changePasswordFields");
        $("#statusDiv label").removeClass("redText");
        if (login.ignitionReady) {
            $("#statusDiv label").text($("#js_pleaseLogOn").text());
        } else {
            $("#username").val("root").attr("disabled", true);
            $("#statusDiv label").text($("#js_pleaseLogOnRoot").text());
        }
        return false;
    };

    /**
     * Hide login fields, shows change password fields.
     */
    login.hideLogin = function () {
        globals.variables.loginFormId = "changePasswordFields";
        $("#changePassword").hide();
        $("#formFields").hide();
        $("#changePasswordFields").show();
        globals.functions.resizeLogin();
        var loginBottom = $("#loginContainer").offset().top + $("#loginContainer").height();
        var eulaBottom = $("#eulaLink").offset().top + $("#eulaLink").height();
        login.clearFields("formFields");
        $("#statusDiv label").removeClass("redText");
        $("#statusDiv label").text($("#js_typeOldAndNewPassword").text());
    };

    /**
     * Changes the message and its color from the statusDiv div.
     *
     * @param isError     true to change the color to red
     *                    false to change the color to black
     * @param msg         the message to display in the div label
     */
    login.showMessage = function (isError, msg) {
        if (isError) {
            $("#statusDiv label").addClass("redText");
        } else {
            $("#statusDiv label").removeClass("redText");
        }
        $("#statusDiv label").text(msg);
    };

    /**
     * Gets the language and selects the proper option from the combo box.
     */
    login.getLanguage = function () {
        $.ajax({
            type: "GET",
            url: "/api/i18n/lang",
            cache: false,
            success: function (data) {
                $("#languageSelect option").attr("selected", false);
                $("#languageSelect option[value=" + data + "]").attr("selected", true);
                login.languageChanged = true;
                login.language = $("#languageSelect").val();
            }
        });
    };

    /**
     * Get supported languages list.
     */
    login.getSupportedLanguages = function () {
        $.ajax({
            type: "GET",
            url: "/api/i18n/langs",
            cache: false,
            success: function (data) {
                // set language options
                var options = "";
                for (var langId in data) {
                    options += "<option id='" + langId + "' value='" + langId + "'>" + data[langId] + "</option>";
                }
                $("#languageSelect").html(options);
                // set selected language for this session
                login.getLanguage();
            }
        });
    };

    /**
     * Gets the login banner text.
     */
    login.getBanner = function () {
        $.ajax({
            type: "GET",
            url: "/api/system/banner",
            cache: false,
            success: function (data) {
                if (data) {
                    var banner = $.trim(data.banner);
                    if (banner.length > 0 && data.show_banner) {
                        $("#bannerDiv").text(banner);
                        $("#bannerDiv").removeClass("hiddenElement");
                        globals.functions.resizeLogin();
                    }
                }
            }
        });
    };

    $("#eulaLink").click( function(e) {
        e.preventDefault();
        window.open("/static/eula/" + login.language + ".html");
    });

    /**
     * Changes the language and reload login page.
     */
    $("#languageSelect").change(function (){
        if (login.languageChanged) {
            $.ajax({
                type: "PUT",
                url: "/api/i18n/lang",
                data: "lang=" + $("#languageSelect").val(),
                cache: false,
                success: function () {
                    window.location.reload();
                }
            });
        }
    });

    /**
     * Shows the enabled password rules
     */
    login.showHidePasswordRules = function () {

        var data = login.passwordRulesData;
        $("#minLengthNumberLogin").text(data.min_length);
        $("#minUppercaseNumberLogin").text(data.min_uppercase);
        $("#minLowercaseNumberLogin").text(data.min_lowercase);
        $("#minNumericNumberLogin").text(data.min_numeric);
        $("#minSpecialNumberLogin").text(data.min_special);
        $("#maxSequenceNumberLogin").text(data.max_allowed_sequence);

        login.passwordRestrictions = 1;

        if (parseInt(data.min_uppercase) > 0) {
            $("#minUppercaseLiLogin").show();
            login.passwordRestrictions++;
        }
        if (parseInt(data.min_lowercase) > 0) {
            $("#minLowercaseLiLogin").show();
            login.passwordRestrictions++;
        }
        if (parseInt(data.min_numeric) > 0) {
            $("#minNumericLiLogin").show();
            login.passwordRestrictions++;
        }
        if (parseInt(data.min_special) > 0) {
            $("#minSpecialLiLogin").show();
            login.passwordRestrictions++;
        }
        if (parseInt(data.max_allowed_sequence) > 0 && !data.allow_sequence) {
            $("#maxSequenceLiLogin").show();
            login.passwordRestrictions++;
        }

    };

    /**
     * Checks if the new password corresponds with the current requirements
     */
    login.validateNewPassword = function () {

        var errors = "";
        var data = login.passwordRulesData;

        var passedLength = validatePassword($("#newPasswordField").val(), {
            length: [data.min_length, Infinity]
        });
        if (!passedLength) {
            errors += "-" + $("#js_invalidLength").text() + " " + data.min_length + "\n";
        }

        var passedUppercase = validatePassword($("#newPasswordField").val(), {
            upper: data.min_uppercase
        });
        if (!passedUppercase) {
            errors += "-" + $("#js_invalidUppercase").text() + " " + data.min_uppercase + "\n";
        }

        var passedLowercase = validatePassword($("#newPasswordField").val(), {
            lower: data.min_lowercase
        });
        if (!passedLowercase) {
            errors += "-" + $("#js_invalidLowercase").text() + " " + data.min_lowercase + "\n";
        }

        var passedNumeric = validatePassword($("#newPasswordField").val(), {
            numeric: data.min_numeric
        });
        if (!passedNumeric) {
            errors += "-" + $("#js_invalidNumeric").text() + " " + data.min_numeric + "\n";
        }

        var passedSpecial = validatePassword($("#newPasswordField").val(), {
            special: data.min_special
        });
        if (!passedSpecial) {
            errors += "-" + $("#js_invalidSpecial").text() + " " + data.min_special + "\n";
        }

        var passed_qwerty_sequence = true;
        var passed_ascii_sequence = true;
        if (!data.allow_sequence) {
            passed_qwerty_sequence = validatePassword($("#newPasswordField").val(), {
                badSequenceLength: parseInt(data.max_allowed_sequence) + 1,
                noQwertySequences: true
            });
            passed_ascii_sequence = globals.functions.checkIfAllowedSequence($("#newPasswordField").val(),
                parseInt(data.max_allowed_sequence));
        }
        if (!passed_qwerty_sequence || !passed_ascii_sequence) {
            errors += "-" + $("#js_invalidSequence").text() + " " + data.max_allowed_sequence;
        }

        return errors;

    };

    /*$("#changePassword").click(function(e){
        e.preventDefault();
        $.ajax({
            type: "GET",
            url: "/api/system/password_rules",
            dataType: "json",
            cache: false,
            success: function(data) {
                login.passwordRulesData = data;
                login.showHidePasswordRules();
                login.hideLogin();
            }
        });
    });*/
    $("#cancelButton").click(login.hideChangePassword);

    jQuery.ajaxSetup({cache: false});

    /**
     * Prints the System ID (SID) number.
     */
    login.printSID = function (e, sysinfo) {
        e.preventDefault();
        var sidWindow = window.open("", "sidwindow", "");
        sidWindow.document.writeln("<html><head><title>" + $("#js_avayaSystemInfo").text() + "</title></head><body>"
            + $("#js_avayaHostId").text() + "<br><b>" + sysinfo.plds_host_id + "</b><br/><br/>"
            + $("#js_avayaWebLMId").text() + "<br><b>" + sysinfo.weblm_host_id + "</b><br/><br/>"
            + "</body></html>");
        sidWindow.document.close();
    };

    // Setup login form
    jQuery('#frmLogin').submit(function() {
        login.showMessage(false, $("#js_pleaseWait").text());

        var dataString = "";
        /*if (!login.ignitionReady) {
            dataString += "username=" + $("#username").val() + "&";
        }*/
        dataString += "username=" + $("#username").val();
        dataString += "&password=" + encodeURIComponent($("#password").val());
        dataString += "&csrf_token=" + $("#csrf_token").val();
        //dataString += jQuery('#frmLogin').serialize();

        jQuery.ajax({
            type: 'PUT',
            url: '/api/session',
            data: dataString,
            complete: function(xhr) {
                switch (xhr.status) {
                    case 200:
                        login.showMessage(false, $("#js_loginSuccessful").text());
                        window.location.replace('/main');
                        break;
                    case 401:
                        login.showMessage(true, $("#js_wrongUserOrPass").text());
                        break;
                    case 503:
                        login.showMessage(true, $("#js_forbiddenSession").text());
                        break;
                    default:
                        login.showMessage(true, $("#js_serverNotResponding").text());
                        break;
                }
            }
        });
        return false;
    });

    // change password
    jQuery('#formChangePassword').submit(function() {
        if ($("#oldPasswordField").val() == "") {
            $("#statusDiv label").addClass("redText");
            $("#statusDiv label").text($("#js_oldPasswordEmpty").text());
        } else if ($("#newPasswordField").val() == "") {
            $("#statusDiv label").addClass("redText");
            $("#statusDiv label").text($("#js_newPasswordEmpty").text());
        } else if ($("#confirmNewPasswordField").val() == "") {
            $("#statusDiv label").addClass("redText");
            $("#statusDiv label").text($("#js_confirmPasswordEmpty").text());
        } else if (login.validateNewPassword().length > 0){
            alert($("#js_invalidPassword").text() + "\n" + login.validateNewPassword());
        } else {
            if ($("#newPasswordField").val() == $("#confirmNewPasswordField").val()) {

                // clear previous errors
                $("#statusDiv label").removeClass("redText");

                // change the passwordz
                login.showMessage(false, $("#js_pleaseWait").text());
                jQuery.ajax({
                    type: 'PUT',
                    url: '/api/system/changepass',
                    data: jQuery('#formChangePassword').serialize(),
                    complete: function(xhr) {
                        switch (xhr.status) {
                            case 200:
                                $("#statusDiv label").text($("#js_passwordChanged").text());
                                alert($("#js_passwordChanged").text());
                                login.hideChangePassword();
                                break;
                            case 401: // authentication error
                            default:
                                $("#statusDiv label").addClass("redText");
                                $("#statusDiv label").text($("#js_wrongPassword").text());
                                login.clearFields("changePasswordFields");
                                break;
                        }
                      }
                });
            } else {
                $("#statusDiv label").addClass("redText");
                $("#statusDiv label").text($("#js_passwordsDoNotMatch").text());
            }
        }

        return false;
    });

    $.ajax({
        type: "GET",
        url: "/setup/run_once",
        success: function (data) {

            // Fix UI
            globals.functions.resizeLogin();

            // Load supported languages
            login.getSupportedLanguages();

            // Load banner
            login.getBanner();

            $("#changePasswordFields").hide();
            login.clearFields("formFields");
            login.clearFields("changePasswordFields");

            if (data.run_once) {
                login.ignitionReady = true;
            } else {
                $("#username").val("root").attr("disabled", true);
                $("#statusDiv label").text($("#js_pleaseLogOnRoot").text());
            }

             // Get and display version and build number
            $.ajax({
                type: "GET",
                url: "/api/version",
                cache: false,
                success: function (data) {
                    // set application title and version info
                    document.title = data.TITLE;
                    $("#titleLabel").text(data.TITLE);
                    $("#logoLabel").text(data.TITLE);
                    $("#versionNumberLabel").text("R" + data.SHORT_VERSION);
                    $("#yearLabel").text(data.COPYRIGHT_YEAR);
                    globals.variables.releaseType = data.RELEASE_TYPE;
                    if (globals.variables.releaseType == "abe") {
                        // Check if the system is virtual
                        $.ajax({
                            type: "GET",
                            url: "/api/system/virtual",
                            success: function (data) {
                                if (!data.virtual_system) {
                                    // Check if Ignition was executed
                                    if (!login.ignitionReady) {
                                        // Ignition not executed, show SID field
                                        // Show System ID field
                                        $(".systemIdRow").removeClass("hiddenElement");
                                        globals.functions.resizeLogin();
                                        $.ajax({
                                            type: "GET",
                                            url: globals.REST_URL.HOST_ID,
                                            success: function (data) {
                                                $("#pldsId").text(data.sysinfo.plds_host_id);
                                                //$("#systemId").text(data.sysinfo.system_id);
                                                $("#weblmId").text(data.sysinfo.weblm_host_id);
                                                $("#systemIdPrint").unbind("click");
                                                $("#systemIdPrint").click(function(e) {
                                                    login.printSID(e, data.sysinfo);
                                                });
                                            }
                                        });
                                    }
                                }
                            }
                        });
                    }
                    $.ajax({
                        type: "GET",
                        url: "/api/system/autoconfig",
                        success: function (data) {
                            if (data.autoconfig_running) {
                                $("#username").attr("disabled", true);
                                $("#password").attr("disabled", true);
                                $("#statusDiv label").addClass("redText").text($("#js_autoconfigInProgress").text());
                                globals.functions.enableButton("loginButton", false);
                            }
                        }
                    });
                }
            });
        }
    });
});
