/*
 * Copyright 2010 Avaya Inc. All Rights Reserved.
 */

$(document).ready(function () {

    var settings = {};

    settings.tab = "";

    settings.currentTimezoneName = "";
    settings.currentDate = "";
    settings.currentHour = "";
    settings.currentMinutes = "";
    settings.currentUseNTP = false;
    settings.currentServers = "";
    settings.currentSync = false;
    settings.currentUseLocalTimeSource = false;
    settings.localeOptions = null;

    settings.dateFinished = true;
    settings.ntpFinished = true;

    settings.debugFinished = true;
    settings.csipoFinished = true;

    settings.currentAppsRepo = "";
    settings.currentAppsCheckboxState = false;
    settings.currentWinappsRepo = "";
    settings.currentWinappsCheckboxState = false;
    settings.currentSystemRepo = "";
    settings.currentSystemCheckboxState = false;

    settings.dhcpEnabled = false;

    settings.currentPort = "";
    settings.currentProtocol = "";
    settings.currentTimeout = "";
    settings.currentIp = "";
    settings.currentHostname = "";

    settings.currentDebugLevel = "";
    settings.currentCsipoDebugLevel = "";
    settings.currentCSIPOPath = "";
    settings.currentCSIPOUsername = "";
    settings.currentCSIPOPassword = "";
    settings.currentCSIPOMount = "";

    settings.currentAsgPort = "";
    settings.currentAsgStatus = "";
    settings.currentUsers = [];
    settings.currentUsersState = [];
    settings.currentCerts = [];

    settings.currentMountPoint = "";
    settings.effectiveSpace = 0;
    settings.invalidMountPoints = [];
    settings.default_mount_point_root = "";

    settings.intervalActive = false;
    settings.doRestoreRefresh = true;
    settings.webcontrolRestartCounter = 20;
    settings.certificateRestartCounter = 60;
    settings.networkRestartCounter = 60;
    settings.asfUploadDelay = 20000;
    settings.settingsChangedModalText = null;

    settings.certificatePasswordRules = null;

    settings.rebootServer = false;

    /**
     * Adjusts the file inputs' width
     */
    settings.adjustFileInputWidth = function () {
        $("#caSubmitForm").parent().show();

        $(".repositoryInputFile").width($(".fakefile").width() + 1);
        $(".repositoryInputFile").height($(".fakefile").height());
        $("#caBrowseButton").height($(".fakefile").height() + 1);
		
        $(".repositoryForm button").height($(".fakefile :text").outerHeight());
        $(".repositoryForm").width($(".repositoryForm .fileinputs").outerWidth(true)
            + $(".repositoryForm .updateButton").outerWidth(true) + 10);

        $("#caSubmitForm button").height($(".fakefile :text").outerHeight());

        if ($("#caPasswordLabel").width() > $("#caFileLabel").width()) {
            $("#caFileLabel").width($("#caPasswordLabel").width());
        } else {
            $("#caPasswordLabel").width($("#caFileLabel").width());
        }
    };

    /**
     * Build the backup and restore fieldset.
     */
    settings.buildBackupAndRestoreFieldset = function () {
        $("#backupAndRestoreFieldset").show();
        $.ajax({
            type: 'GET',
            url : "/api/services",
            dataType: "json",
            cache: false,
            error: function (xmlHttpReq, textStatus, errorThrown) {
                globals.functions.ajaxError(xmlHttpReq, textStatus, errorThrown);
                $("#backupAndRestoreTableDiv").unmask();
            },
            beforeSend: function () {
                $("#backupAndRestoreTableDiv").mask($("#js_loading").text());
            },
            success : function (data) {
                $("#backupAndRestoreTableDiv").unmask();
                $("#backupAndRestoreTbody").empty();
                var rowNumber = 0;
                var backupDisabled = [];
                var restoreDisabled = [];
                var rowString = "";
                for (var i in data) {
                    var service = data[i];

                    if (!(service.backup_supported || service.restore_supported)) {
                        // this service does not support backup or restore
                        // so there's no point in displaying it
                        continue;
                    }
                    if (!service.backup_supported) {
                        backupDisabled.push(service.id);
                    }
                    if (!service.restore_supported) {
                        restoreDisabled.push(service.id);
                    }

                    if (rowNumber % 2 != 0) {
                        rowString += "<tr class='oddRow'>";
                    } else {
                        rowString += "<tr>";
                    }
                    rowString += "<td>" + service.display_name + "</td>";
                    rowString += "<td>";

                    rowString += "<button class='avayaWebcontrolButton' id='" + service.id + "BackupButton' " +
                                   "name='" + service.id + "' >" + $("#js_backup").text() + "</button>";

                    rowString += "<button class='avayaWebcontrolButton' id='" + service.id + "RestoreButton' " +
                                   "name='" + service.id + "'>" + $("#js_restore").text() + "</button>";

                    rowString += "</td></tr>";
                    rowNumber++;
                }
                $("#backupAndRestoreTbody").append(rowString);
                if (rowNumber == 0) {
                    $("#backupAndRestoreTableDiv").height(150);
                }
                globals.functions.showNoDataDiv("backupAndRestoreTableDiv", "backupAndRestoreTable",
                        rowNumber, $("#js_backupRestoreServicesUninstalled").text());
                $("#backupAndRestoreTbody button").each( function () {
                    if (this.id.indexOf("Backup") > -1) {
                        for (var i = 0; i < backupDisabled.length; i++) {
                            if (this.name == backupDisabled[i]) {
                                globals.functions.enableButton(this.id, false);
                                break;
                            }
                        }
                    } else if (this.id.indexOf("Restore") > -1) {
                        for (var i = 0; i < restoreDisabled.length; i++) {
                            if (this.name == restoreDisabled[i]) {
                                globals.functions.enableButton(this.id, false);
                                break;
                            }
                        }
                    }
                });
                $("#backupAndRestoreTbody button").click( function () {
                    var buttonId = this.id;
                    var serviceId = this.name;
                    if (this.id.indexOf("Backup") > -1) {
                        settings.doBackupOrRestoreAjax(serviceId, "backup", null);
                    } else if (this.id.indexOf("Restore") > -1) {
                        settings.checkBackupsAndRestore(serviceId, buttonId);
                    }
                });
            },
            complete: function (xhr) {
                if (xhr.status != 200) {
                    $("#backupAndRestoreTableDiv").unmask();
                } else {
                    settings.checkRestoreStatus();
                }
            }
        });
    };

    /**
     * Gets the backups for an application
     * Restores the application if backups exist
     *
     * @param serviceId     The id of the application
     * @param buttonId      The id of the button to disable while the request is in progress
     */
    settings.checkBackupsAndRestore = function (serviceId, buttonId) {
        $.ajax ({
            type: "GET",
            url: "/api/settings/backup/" + serviceId,
            dataType: "json",
            cache: false,
            success: function (data) {
                if (data.backups_exist) {
                    if (data.backups.length > 0) {
                        settings.openRestoreModal(serviceId, data.backups);    
                    } else {
                        settings.doBackupOrRestoreAjax(serviceId, "restore", null);
                    }
                } else {
                    globals.functions.enableButton(buttonId, true);
                    alert($("#js_noBackupsAvailable").text());
                }
            }
        });
    };

    /**
     * Opens a window that contains the available backups of the application
     *
     * @param serviceId     The application's id
     * @param backups       The available backups
     */
    settings.openRestoreModal = function (serviceId, backups) {

        $('#selectRestoreModal').modal({
            closeHTML: "<a href='' title='" + $("#js_close").text() + "'></a>",
            overlayId: 'modal-overlay',
            containerId: 'selectRestoreModal-container',
            onShow: function () {

                $("#selectRestoreModalCombo").empty();
                for (var i = 0; i < backups.length; i++) {
                    var versionString = backups[i].location;
                    var appendString = "";
                    appendString += "<option value='" + versionString + "'>" + backups[i].name + "</option>";
                    $("#selectRestoreModalCombo").append(appendString);
                }

                // button click events
                $("#selectRestoreModalButtons button").unbind("click");
                $("#selectRestoreModalCancel").click(function () {
                    $.modal.close();
                });
                $("#selectRestoreModalOk").click(function () {
                    var selectedVersion = $("#selectRestoreModalCombo :selected").val();
                    $.modal.close();
                    settings.doBackupOrRestoreAjax(serviceId, "restore", selectedVersion);
                });
            }
        });

    };

    /**
     * Does a backup or restore for specified application.
     *
     * @param serviceId            application id
     * @param action               action to perform: backup|restore
     * @param selectedVersion      location of the selected backup to restore
     */
    settings.doBackupOrRestoreAjax = function (serviceId, action, selectedVersion) {
        settings.validateBackupRestoreAction(serviceId, action, selectedVersion, function(serviceId, action, selectedVersion) {
            var url = "/api/settings/" + action + "/" + serviceId;
            var data = "";
            if (selectedVersion != null && action == "restore") {
                data += "backup_source=" + selectedVersion;
            }
            $.ajax ({
                type: "POST",
                url: url,
                data: data + "&csrf_token="+$("#csrf_token").val(),
                cache: false,
                timeout: globals.variables.BACKUP_RESTORE_TIMEOUT,
                error: function (xmlHttpReq, textStatus, errorThrown) {
                    globals.functions.ajaxError(xmlHttpReq, textStatus, errorThrown);
                    $("#backupAndRestoreTableDiv").unmask();
                },
                beforeSend: function () {
                    if (action == "backup") {
                        $("#backupAndRestoreTableDiv").mask($("#js_backupInProgress").text());
                    } else if (action == "restore") {
                        $("#backupAndRestoreTableDiv").mask($("#js_restoreInProgress").text());
                    }
                },
                complete: function () {
                    settings.checkRestoreStatus();
                }
            });
        });
    };

    settings.validateBackupRestoreAction = function (serviceId, action, selectedVersion, okHandler) {
        okHandler(serviceId, action, selectedVersion);
    };

    /**
     * Checks the status of the restore thread
     */
    settings.checkRestoreStatus = function () {
        $.ajax({
            type: "GET",
            url: "/api/settings/status/restore",
            dataType: "json",
            cache: false,
            error: function (xmlHttpReq, textStatus, errorThrown) {
                globals.functions.ajaxError(xmlHttpReq, textStatus, errorThrown);
                $("#backupAndRestoreTableDiv").unmask();
            },
            success: function (data) {
                if (!data.in_progress) {
                    settings.doRestoreRefresh = false;
                    $("#backupAndRestoreTableDiv").unmask();
                } else {
                    settings.doRestoreRefresh = true;
                    $("#backupAndRestoreTableDiv").mask($("#js_restoreInProgress").text());
                    settings.updateRestoreStatus();
                }
            }
        });
    };

    /**
     * Refreshes the status of the Backup Restore table
     */
    settings.updateRestoreStatus = function () {
        if (!settings.intervalActive) {
            refreshRestoreStatus = function () {
                if (globals.variables.currentTab == "settings" && settings.doRestoreRefresh) {
                    settings.checkRestoreStatus();
                } else {
                    clearInterval(globals.variables.restoreInterval);
                    settings.intervalActive = false;
                }
            };
            globals.variables.restoreInterval = setInterval("refreshRestoreStatus()", 15000);
            settings.intervalActive = true;
        }
    };

    /**
     * Build Watchdog configuration fieldset.
     */
    settings.buildWatchdogFieldset = function () {
        $("#watchdogFieldset").show();
        $.ajax({
            type: "GET",
            url: "/api/settings/logs",
            dataType: "json",
            cache: false,
            error: function (xmlHttpReq, textStatus, errorThrown) {
                globals.functions.ajaxError(xmlHttpReq, textStatus, errorThrown);
                $("#watchdogContentDiv").unmask();
            },
            beforeSend: function () {
                $("#watchdogContentDiv").mask($("#js_loading").text());
            },
            success: function (data) {
                $("#watchdogContentDiv").unmask();
                $("#watchdogInput").val(data.age);
            },
            complete : function (xhr) {
                if (xhr.status != 200) {
                    $("#watchdogContentDiv").unmask();
                }
            }
        });
        $("#saveWatchdogSettings").unbind("click");
        $("#saveWatchdogSettings").click( function () {
            settings.setWatchdogLogAge();
        });
        
    };

    /**
     * Sets watchdog logs age
     */
    settings.setWatchdogLogAge = function () {

        if (!globals.validators.isNumeric($("#watchdogInput").val()) || $("#watchdogInput").val() == 0) {
            alert($("#js_logFileAgePositiveInteger").text());
        } else {
            $.ajax({
                type: "PUT",
                url: "/api/settings/logs",
                data: "age=" + $("#watchdogInput").val() ,
                cache: false,
                error: function (xmlHttpReq, textStatus, errorThrown) {
                    globals.functions.ajaxError(xmlHttpReq, textStatus, errorThrown);
                    globals.functions.enableButton("saveWatchdogSettings",
                            true,
                            $("#js_save").text(),
                            $("#js_saving").text());
                },
                beforeSend: function () {
                    globals.functions.enableButton("saveWatchdogSettings",
                                       false,
                                       $("#js_save").text(),
                                       $("#js_saving").text());
                },
                complete: function () {
                    globals.functions.enableButton("saveWatchdogSettings",
                            true,
                            $("#js_save").text(),
                            $("#js_saving").text());
                }
            });
        }
        
    };

    /**
     * Build SNMP configuration fieldset.
     */
    settings.buildSNMPFieldset = function () {

        $.ajax({
            type: "GET",
            url: "/api/settings/snmp",
            dataType: "json",
            cache: false,
            error: function (xmlHttpReq, textStatus, errorThrown) {
                globals.functions.ajaxError(xmlHttpReq, textStatus, errorThrown);
                $("#snmpSupportContentDiv").unmask();
            },
            beforeSend: function () {
                $("#snmpSupportContentDiv").mask($("#js_loading").text());
            },
            success: function (data) {
                $("#snmpSupportContentDiv").unmask();
                settings.snmp = data;
                $("#watchdogSnmpTrapsIpInput").val(settings.snmp.WDOG_SNMP_ADDRESS_SEND);
                $("#watchdogSnmpTrapsPortInput").val(settings.snmp.WDOG_SNMP_PORT);
                $("#watchdogDevIDInput").val(settings.snmp.WDOG_SNMP_DEVID);
                if (settings.snmp.sysdescr != null) {
                    $("#watchdogSnmpDescInput").val(settings.snmp.sysdescr);
                }
                if (settings.snmp.syslocation != null) {
                    $("#watchdogSnmpLocInput").val(settings.snmp.syslocation);
                }
                $("#SNMPEnableCheckbox").attr("checked", settings.snmp.snmpd_enabled);
                $("#" + settings.snmp.WDOG_SNMP_PROTOCOL).attr("checked", true);
            },
            complete : function (xhr) {
                if (xhr.status != 200) {
                    $("#snmpSupportContentDiv").unmask();
                }
            }
        });

        $.ajax({
            type: "GET",
            url: "/api/settings/mibs/files",
            dataType: "json",
            cache: false,
            success: function (data) {
                if (data.mib_files.length > 0) {
                    $("#snmpMibsDownloadLink").show();
                }
            }
        });

        $("#saveSNMPSettings").unbind("click");
        $("#saveSNMPSettings").click( function () {
            settings.setSNMP();
        });
        
    };

    /**
     * Sets SNMP data
     */
    settings.setSNMP = function () {

        var protocol = $("input[name='watchdogSnmpProtocolInput']:checked").val();
        var trapsIp = $("#watchdogSnmpTrapsIpInput").val();
        var trapsPort = $("#watchdogSnmpTrapsPortInput").val();
        var devID = $("#watchdogDevIDInput").val();
        var sysDesc = $("#watchdogSnmpDescInput").val();
        var sysLoc = $("#watchdogSnmpLocInput").val();
        var snmpdEnabled = "off";
        if ($("#SNMPEnableCheckbox").is(":checked")) {
            snmpdEnabled = "on";
        }

        var snmpDataString = "";
        snmpDataString += "wdog_snmp_protocol=" + protocol;
        snmpDataString += "&wdog_snmp_address_send=" + trapsIp;
        snmpDataString += "&wdog_snmp_port=" + trapsPort;
        snmpDataString += "&wdog_snmp_devid=" + devID;
        snmpDataString += "&snmp_sys_desc=" + sysDesc;
        snmpDataString += "&snmp_sys_loc=" + sysLoc;
        snmpDataString += "&snmpd_enabled=" + snmpdEnabled;

        if(!globals.validators.isValidIP(trapsIp)) {
            alert($("#js_invalidTrapsIp").text());
        } else if (!globals.validators.isValidPort(trapsPort)){
            alert($("#js_invalidTrapsPort").text());
        } else {
            $.ajax({
                type: "PUT",
                url: "/api/settings/snmp",
                data: snmpDataString ,
                cache: false,
                error: function (xmlHttpReq, textStatus, errorThrown) {
                    globals.functions.ajaxError(xmlHttpReq, textStatus, errorThrown);
                    globals.functions.enableButton("saveSNMPSettings",
                            true,
                            $("#js_save").text(),
                            $("#js_saving").text());
                },
                beforeSend: function () {
                    globals.functions.enableButton("saveSNMPSettings",
                                       false,
                                       $("#js_save").text(),
                                       $("#js_saving").text());
                },
                complete: function () {
                    globals.functions.enableButton("saveSNMPSettings",
                            true,
                            $("#js_save").text(),
                            $("#js_saving").text());
                }
            });
        }

    };

    /**
     * Build the webcontrol fieldset.
     */
    settings.buildWebcontrolFieldset = function () {
        $("#webControlFieldset").show();
        if (globals.variables.releaseType != "abe" && globals.variables.releaseType != "appl"
            && globals.variables.releaseType != "apc") {
            $("#webcontrolSettingsDiv").removeAttr("style");
            $("#webcontrolProtocolDiv").removeAttr("style");
        } else {
            $("#webcontrolInput").attr("disabled", "disabled");
        }

        $.ajax({
            type: "GET",
            url: "/api/settings/webcontrol",
            dataType: "json",
            cache: false,
            error: function (xmlHttpReq, textStatus, errorThrown) {
                globals.functions.ajaxError(xmlHttpReq, textStatus, errorThrown);
                $("#webcontrolContentDiv").unmask();
            },
            beforeSend: function () {
                $("#webcontrolContentDiv").mask($("#js_loading").text());
            },
            success: function (data) {
                $("#webcontrolContentDiv").unmask();
                $("#webcontrolInput").val(data.port);
                $("#webcontrolProtocolSelect option[value=" + data.protocol + "]").attr("selected", true);
                $("#timeoutInactivitySelect option[value=" + data.timeout + "]").attr("selected", true);
                settings.currentPort = data.port;
                settings.currentProtocol = data.protocol;
                settings.currentTimeout = data.timeout;
            },
            complete : function (xhr) {
                if (xhr.status != 200) {
                    $("#webcontrolContentDiv").unmask();
                }
            }
        });

        $("#saveWebcontrolSettings").unbind("click");
        $("#saveWebcontrolSettings").click( function () {
            var portChanged = (settings.currentPort != $("#webcontrolInput").val());
            var protocolChanged = (settings.currentProtocol != $("#webcontrolProtocolSelect :selected").val());
            if (portChanged || protocolChanged
                || (settings.currentTimeout != $("#timeoutInactivitySelect :selected").val())) {
                settings.saveWebcontrolSettings(portChanged, protocolChanged);
            }
        });

    };

    /**
     * Updates WCP certificate , then restarts the application
     */
    settings.updateCertificate = function (widgetId) {
        $.ajax({
            type: "PUT",
            url: "/api/settings/certificate",
            cache: false,
            timeout: globals.variables.CERTIFICATE_DISTRIBUTE_TIMEOUT,
            beforeSend: function () {
                $("#" + widgetId).mask($("#js_loading").text());
            },
            success: function () {
                $('#certificateChangedModal').modal({
                    closeHTML: "<a href='' title='" + $("#js_close").text() + "'></a>",
                    overlayId: 'modal-overlay',
                    containerId: 'certificateChangedModal-container',
                    onShow: function () {
                        globals.functions.enableButton("certificateChangedModalOk", false);
                        // do refresh ajax
                        $.ajax({
                            type: "POST",
                            data: "csrf_token="+$("#csrf_token").val(),
                            url: "/api/settings/certificate",
                            cache: false
                        });
                        settings.countDownTimer("certificateChangedModalCounter", settings.certificateRestartCounter,
                            "certificateChangedModalOk", "js_applicationRestartedRefresh", "certificateChangedModalCounter");

                        $("#certificateChangedModalOk").unbind("click");
                        $("#certificateChangedModalOk").click( function () {
                            globals.functions.handleRedirection(globals.variables.REDIRECT_SSL_CERTIFICATE_CHANGED);
                        });
                    }
                });
            },
            complete : function () {
                $("#" + widgetId).unmask();
            }
        });
    };

    /**
     * Applies the new WCP settings , then restarts the application
     *
     * @param port      Web Control's port
     * @param protocol  Web Control's protocol
     * @param timeout   Web Control's inactivity timeout value
     */
    settings.applyWebcontrolSettings = function (port, protocol, timeout) {
        var dataString = "";
        dataString += "port=" + $("#webcontrolInput").val();
        dataString += "&protocol=" + $("#webcontrolProtocolSelect :selected").val();
        dataString += "&timeout=" + $("#timeoutInactivitySelect :selected").val();
        $.ajax({
            type: "PUT",
            url: "/api/settings/webcontrol",
            data: dataString,
            cache: false,
            beforeSend: function () {
                globals.functions.enableButton("saveWebcontrolSettings", false, $("#js_save").text(),
                                               $("#js_saving").text());
            },
            success : function () {
                $('#portChangedModal').modal({
                    closeHTML: "<a href='' title='" + $("#js_close").text() + "'></a>",
                    overlayId: 'modal-overlay',
                    containerId: 'portChangedModal-container',
                    onShow: function () {
                        globals.functions.enableButton("portChangedModalOk", false);
                        var newPortComponent = ":" + $("#webcontrolInput").val();
                        var oldPortComponent = ":" + settings.currentPort;
                        var newProtocolComponent = $("#webcontrolProtocolSelect :selected").val();
                        var oldProtocolComponent = settings.currentProtocol;
                        var newUrl = window.location.href.replace(oldPortComponent, newPortComponent);
                        var newProtocolUrl = newUrl.replace(oldProtocolComponent, newProtocolComponent);
                        var portUrl = newProtocolUrl.substring(0, newProtocolUrl.indexOf("main"));
                        var location = portUrl + "login";
                        // do refresh ajax
                        $.ajax({
                                   type: "POST",
                                   data: "csrf_token="+ $("#csrf_token").val(),
                                   url: "/api/settings/webcontrol",
                                   cache: false
                               });
                        settings.countDownTimer("portChangedModalCounter", settings.webcontrolRestartCounter,
                            "portChangedModalOk", "js_applicationRestartedRefresh", "portChangedModalCounter");
                        $("#portChangedModalOk").unbind("click");
                        $("#portChangedModalOk").click( function () {
                            globals.functions.enableButton("saveWebcontrolSettings", true, $("#js_save").text(),
                                                           $("#js_saving").text());
                            globals.functions.handleRedirection(globals.variables.REDIRECT_WEBCONTROL_SETTINGS_CHANGED, location);
                        });
                    }
                });
            }
        });
    };

    /**
     * Changes the port of the application 
     */
    settings.saveWebcontrolSettings = function (portChanged, protocolChanged) {
        if (portChanged) {
            var port = $("#webcontrolInput").val();
            if (globals.validators.isValidPort(port)) {
                $.ajax({
                    type: "GET",
                    url: "/api/system/network/port",
                    data: "port=" + port,
                    cache: false,
                    beforeSend: function () {
                        globals.functions.enableButton("saveWebcontrolSettings", false, $("#js_save").text(),
                                                       $("#js_saving").text());
                    },
                    error : function () {
                        globals.functions.ajaxError(xmlHttpReq, textStatus, errorThrown);
                        globals.functions.enableButton("saveWebcontrolSettings", true, $("#js_save").text(),
                                                       $("#js_saving").text());
                    },
                    success : function (data) {
                        var warningHTML = "";
                        if (data.is_well_known) {
                            warningHTML += "<p>" + $("#js_portWellKnown").text() + " <b>" + port + "</b></p>";
                        }
                        if (data.is_opened) {
                            warningHTML += "<p>" + $("#js_portOpened").text() + " <b>" + data.service_name + "</b></p>";
                        } else {
                            if (data.is_well_known) {
                                warningHTML += "<p>" + $("#js_portNotOpened").text() + "</p>";
                            }
                        }
                        warningHTML += "<p>" + $("#js_portChangeConfirm").text() + "</p>";
                        var yes = $("#js_Yes").text();
                        var no = $("#js_No").text();
                        var warningHandlers = {};
                        warningHandlers[yes] = function() {
                            $.modal.close();
                            settings.applyWebcontrolSettings();
                        };
                        warningHandlers[no] = function() {
                            $.modal.close();
                            globals.functions.enableButton("saveWebcontrolSettings", true, $("#js_save").text(),
                                                           $("#js_saving").text());
                        };
                        globals.dialog.show(globals.dialog.WARNING, $("#js_warning").text(), warningHTML, warningHandlers, false);
                    }
                });
            } else {
                alert($("#js_invalidWebcontrolPort").text());
            }
        } else {
            settings.applyWebcontrolSettings();
        }
    };

    /**
     * Sets the current values for the repositories fields.
     *
     * @param repositoryID  all|apps|winapps|system
     */
    settings.setCurrentRepositoryValues = function (repositoryID) {
        if (repositoryID == "all" || repositoryID == "apps") {
            settings.currentAppsRepo = $("#appsRepositoryText").val();
            settings.currentAppsCheckboxState = $("#appsRepositoryCheckbox")[0].checked;
        }
        if (repositoryID == "all" || repositoryID == "winapps") {
            settings.currentWinappsRepo = $("#winappsRepositoryText").val();
            settings.currentWinappsCheckboxState = $("#winappsRepositoryCheckbox")[0].checked;
        }
        if (repositoryID == "all" || repositoryID == "system") {
            settings.currentSystemRepo = $("#systemRepositoryText").val();
            settings.currentSystemCheckboxState = $("#systemRepositoryCheckbox")[0].checked;
        }
    };

    /**
     * Disable repository URL input field if necessary.
     *
     * @param checked   indicates if the Local repository checkbox is checked
     * @param name      the name of the checkbox (corresponds to
     *                  the first part of the respective button ids).
     */
    settings.checkLocalRepository = function (checked, name) {
        $("#" + name + "Div .repoFileOp").toggle(checked);
        $("#" + name + "Div .repoURLOp").toggle(!checked);
        globals.functions.enableButton(name + "UploadButton", checked);
        globals.functions.enableButton(name + "FakeBrowseButton", checked);
        $("#" + name + "Text").attr("disabled", checked);
        $("#" + name + "FakeFileField").attr("disabled", !checked);
    };

    /**
     * Save repository settings.
     *
     * @param repositoryName repository to be saved.
     */
    settings.setRepository = function (repositoryName) {
        var local = $("#" + repositoryName + "RepositoryCheckbox")[0].checked;
        var url = $("#" + repositoryName + "RepositoryText").val();
        $.ajax({
            type: "PUT",
            url: "/api/settings/repo/?",
            data: repositoryName + "_repo_local=" + local + "&" + repositoryName + "_repo_url=" + url ,
            cache: false,
            complete: function (xhr) {
                if (xhr.status == 200) {
                    settings.setCurrentRepositoryValues(repositoryName);
                }
                settings.receivedRepositoryCounter++;
                if (settings.receivedRepositoryCounter == settings.sendRepositoryCounter) {
                    globals.functions.enableButton("saveRepositoriesButton", true, $("#js_save").text(),
                            $("#js_saving").text());
                }
            }
        });
    };

    /**
     * Build the repositories fieldset.
     */
    settings.buildUpdatesFieldset = function () {

        settings.adjustFileInputWidth();
        $.ajax({
            type: "GET",
            url: "/api/settings/repo/",
            dataType: "json",
            cache: false,
            error: function (xmlHttpReq, textStatus, errorThrown) {
                globals.functions.ajaxError(xmlHttpReq, textStatus, errorThrown);
                $("#repositoriesContentDiv").unmask();
            },
            beforeSend: function () {
                $("#repositoriesContentDiv").mask($("#js_loading").text());
            },
            success: function (data) {
                $("#repositoriesContentDiv").unmask();
                for (var i in data) {
                    $("#" + i + "RepositoryText").val(data[i].url);
                    if (data[i].local) {
                        $("#" + i + "RepositoryCheckbox").attr("checked", true);
                        $("#" + i + "RepositoryText").val(data[i].default_url);
                    }
                }
                $("#updatesFieldset :checkbox").each( function () {
                    settings.checkLocalRepository(this.checked, this.name);
                });
                settings.setCurrentRepositoryValues("all");
            },
            complete : function (xhr) {
                if (xhr.status != 200) {
                    $("#repositoriesContentDiv").unmask();
                }
            }
        });
        
        $("#updatesFieldset :checkbox").click( function () {
            settings.checkLocalRepository(this.checked, this.name);
        });

        $("#saveRepositoriesButton").click( function() {
            settings.sendRepositoryCounter = 0;
            settings.receivedRepositoryCounter = 0;
            if (settings.currentWinappsRepo != $("#winappsRepositoryText").val() ||
                    settings.currentWinappsCheckboxState != $("#winappsRepositoryCheckbox")[0].checked) {
                settings.sendRepositoryCounter++;
                settings.setRepository("winapps");
            }
            if (settings.currentAppsRepo != $("#appsRepositoryText").val() ||
                    settings.currentAppsCheckboxState != $("#appsRepositoryCheckbox")[0].checked) {
                settings.sendRepositoryCounter++;
                settings.setRepository("apps");
            }
            if (settings.currentSystemRepo != $("#systemRepositoryText").val() ||
                    settings.currentSystemCheckboxState != $("#systemRepositoryCheckbox")[0].checked) {
                settings.sendRepositoryCounter++;
                settings.setRepository("system");
            }
            if (settings.sendRepositoryCounter > 0) {
                globals.functions.enableButton("saveRepositoriesButton", false, $("#js_save").text(),
                        $("#js_saving").text());
            }
        });

        $("#updatesFieldset :file").click( function (e) {
            var repository = this.id.substring(0, this.id.indexOf("RepositoryBrowseButton"));
            if(!$("#" + repository + "RepositoryCheckbox")[0].checked) {
                e.preventDefault();        
            }
        });

        $("#updatesFieldset :file").change( function () {
            var repository = this.id.substring(0, this.id.indexOf("RepositoryBrowseButton"));
            $("#" + repository + "RepositoryFakeFileField").val(this.value);
        });

        var options = {
            data: "csrf_token="+$("#csrf_token").val(),
            timeout: globals.variables.UPLOAD_AJAX_TIMEOUT,
            error: function (xmlHttpReq, textStatus, errorThrown) {
                globals.functions.ajaxError(xmlHttpReq, textStatus, errorThrown);
                $("#repositoriesContentDiv").unmask();
                return false;
            },
            beforeSubmit: function () {
                $("#repositoriesContentDiv").mask($("#js_uploading").text());
            },
            success: function () {
                $("#repositoriesContentDiv").unmask();
                return false
            },
            clearForm: true,
            resetForm: true
        };
        $("#updatesFieldset form").ajaxForm(options);

        $("#updatesFieldset .updateButton").click( function (e){
            if ($("#" + this.name + "RepositoryBrowseButton").val() == "") {
                e.preventDefault();
                alert($("#js_noFileSelectedForUpload").text());
            }
        });

    };


    /**
     * Updates the interface related fields.
     *
     * @param interfaceID  index of the selected option of the
     *                     Network Interface combo box.
     */
    settings.updateInterfaceFields = function (interfaceID) {

        if (settings.networkData.interfaces[interfaceID].name.indexOf(".") > -1) {
            globals.functions.enableButton("deleteSubinterfaceButton", true);
        } else {
            globals.functions.enableButton("deleteSubinterfaceButton", false);
        }
        $("#ipAddressInput").val(settings.networkData.interfaces[interfaceID].ipaddr);
        $("#subnetMaskInput").val(settings.networkData.interfaces[interfaceID].netmask);
        if (settings.networkData.use_prefix) {
            $("#prefixInput").val(settings.networkData.interfaces[interfaceID].prefix);
            if (settings.networkData.interfaces[interfaceID].netmask != null &&
                    settings.networkData.interfaces[interfaceID].prefix == null) {
                $("#prefixInput").val(globals.functions.netmaskToPrefix(settings.networkData.interfaces[interfaceID].netmask));
            }
            if (settings.networkData.interfaces[interfaceID].prefix != null &&
                    settings.networkData.interfaces[interfaceID].netmask == null) {
                $("#subnetMaskInput").val(globals.functions.prefixToNetmask(settings.networkData.interfaces[interfaceID].prefix));
            }
        }
        if (settings.networkData.interfaces[interfaceID].gateway != null) {
            $("#defaultGatewayInput").val(settings.networkData.interfaces[interfaceID].gateway);
        }
        $("#useDhcpCheckbox").attr("checked", settings.networkData.interfaces[interfaceID].use_dhcp);
        $("#autoDNSCheckbox").attr("checked", settings.networkData.interfaces[interfaceID].auto_dns);

        $("#ipAddressInput").attr("disabled", settings.networkData.interfaces[interfaceID].use_dhcp);
        $("#subnetMaskInput").attr("disabled", settings.networkData.interfaces[interfaceID].use_dhcp);
        $("#prefixInput").attr("disabled", settings.networkData.interfaces[interfaceID].use_dhcp);
        $("#defaultGatewayInput").attr("disabled", settings.networkData.interfaces[interfaceID].use_dhcp);
        $("#autoDNSCheckbox").attr("disabled", !settings.networkData.interfaces[interfaceID].use_dhcp);
        $("#dnsInput").attr("disabled", settings.networkData.interfaces[interfaceID].use_dhcp &&
            settings.networkData.interfaces[interfaceID].auto_dns);

        settings.currentIp = $("#ipAddressInput").val();
        settings.dhcpEnabled = settings.networkData.interfaces[interfaceID].use_dhcp;

        if (globals.variables.releaseType == "apc") {
            globals.functions.enableButton("createSubinterfaceButton", false);
            globals.functions.enableButton("deleteSubinterfaceButton", false);
        }
    };

    /**
     *  Builds the network fieldset by populating the elements with the data received from the device
     *  Adds save button click event that opens a modal window 
     */
    settings.buildNetworkFieldset = function () {
        $("#networkFieldset").show();
        $("#prefixDiv").hide();
        $.ajax({
            type: "GET",
            url: "/api/system/network",
            dataType: "json",
            cache: false,
            error: function (xmlHttpReq, textStatus, errorThrown) {
                globals.functions.ajaxError(xmlHttpReq, textStatus, errorThrown);
                $("#networkFieldsetContentDiv").unmask();
            },
            beforeSend: function () {
                $("#networkFieldsetContentDiv").mask($("#js_loading").text());
                globals.functions.enableButton("deleteSubinterfaceButton", false);
            },
            success: function (data) {
                data.use_prefix = false;
                $("#networkFieldsetContentDiv").unmask();
                settings.networkData = data;
                $("#networkInterfaceCombo").empty();
                for (var i = 0; i < settings.networkData.interfaces.length; i++) {
                    $("#networkInterfaceCombo").append("<option value='"
                            + settings.networkData.interfaces[i].name + "'>"
                            + settings.networkData.interfaces[i].name + "</option>");
                }
                $("#networkInterfaceCombo").unbind("change");
                $("#networkInterfaceCombo").change(function () {
                    settings.updateInterfaceFields($("#networkInterfaceCombo :selected")[0].index);
                });
                $("#useDhcpCheckbox").unbind("change");
                $("#useDhcpCheckbox").change(function(){
                    $("#ipAddressInput").attr("disabled", this.checked);
                    $("#subnetMaskInput").attr("disabled", this.checked);
                    $("#prefixInput").attr("disabled", this.checked);
                    $("#defaultGatewayInput").attr("disabled", this.checked);
                    $("#autoDNSCheckbox").attr("disabled", !this.checked);
                    $("#autoDNSCheckbox").attr("checked", this.checked);
                    var disableDNSField = this.checked && $("#autoDNSCheckbox").is(":checked")
                    $("#dnsInput").attr("disabled", disableDNSField);
                });
                settings.updateInterfaceFields(0);
                if (data.use_prefix) {
                    $("#prefixDiv").show();
                } else {
                    $("#prefixDiv").hide();
                }
                settings.currentHostname = settings.networkData.hostname;
                $("#hostNameInput").val(settings.networkData.hostname);
                $("#dnsInput").val(settings.networkData.dns.join());
                $("#autoDNSCheckbox").unbind("change");
                $("#autoDNSCheckbox").change(function(){
                    $("#dnsInput").attr("disabled", !this.disabled && this.checked);
                });
            },
            complete : function (xhr) {
                if (xhr.status != 200) {
                    $("#networkFieldsetContentDiv").unmask();
                }
            }
        });

        $("#saveNetworkSettingsDiv button").unbind("click");
        $("#deleteSubinterfaceButton").click ( function () {
            $.ajax({
                type: "GET",
                url: "/api/system/lan",
                dataType: "json",
                cache: false,
                error: function (xmlHttpReq, textStatus, errorThrown) {
                    globals.functions.ajaxError(xmlHttpReq, textStatus, errorThrown);
                    $("#networkFieldsetContentDiv").unmask();
                },
                beforeSend: function () {
                    $("#networkFieldsetContentDiv").mask($("#js_loading").text());
                },
                success: function (data) {
                    settings.openDeleteSubinterfaceModal($("#networkInterfaceCombo :selected").val(),$("#csrf_token").val(), data.lans);
                }
            });
        });
        $("#createSubinterfaceButton").click ( function () {
            settings.openCreateInterfaceModal();
        });
        $("#saveNetworkSettingsButton").click ( function () {
            settings.setNetwork();
        });
    };

    /**
     * Warns the user that the selected subinterface will be deleted
     *
     * @param name  The name of the subinterface to be deleted
     * @param data  Array containing subinterfaces used by IPOFFICE_LAN variables.
     */
    settings.openDeleteSubinterfaceModal = function (name,token, data) {

        $('#subinterfaceDeleteWarningModal').modal({
            closeHTML: "<a href='' title='" + $("#js_close").text() + "'></a>",
            overlayId: 'modal-overlay',
            containerId: 'subinterfaceDeleteWarningModal-container',
            onShow: function () {

                var lanInUse = false;
                var lanId = null;
                for (var i in data) {
                    if (data[i].value == name) {
                        lanInUse = true;
                        lanId = i;
                        break;
                    }
                }
                if (lanInUse) {
                    globals.functions.composeText("subinterfaceDeleteWarningModalInUse",
                        "js_subinterfaceInUse", [lanId]);
                    $("#subinterfaceDeleteWarningModalNotUsed").hide();
                    $("#subinterfaceDeleteWarningModalYes").hide();
                    $("#subinterfaceDeleteWarningModalNo").hide();
                    $("#subinterfaceDeleteWarningModalInUseDiv").show();
                    $("#subinterfaceDeleteWarningModalOk").show();
                } else {
                    globals.functions.composeText("subinterfaceDeleteWarningModalNotUsed",
                        "js_deleteSubinterface", [name]);
                    $("#subinterfaceDeleteWarningModalInUseDiv").hide();
                    $("#subinterfaceDeleteWarningModalOk").hide();
                    $("#subinterfaceDeleteWarningModalNotUsed").show();
                    $("#subinterfaceDeleteWarningModalNo").show();
                    $("#subinterfaceDeleteWarningModalYes").show();
                }
                //button click events
                $("#subinterfaceDeleteWarningModalButtons button").unbind("click");
                $("#subinterfaceDeleteWarningModalNo").click(function () {
                    $.modal.close();
                    $("#networkFieldsetContentDiv").unmask();
                });
                $("#subinterfaceDeleteWarningModalOk").click(function () {
                    $.modal.close();
                    $("#networkFieldsetContentDiv").unmask();
                });
                $("#subinterfaceDeleteWarningModalYes").click(function () {
                    $.modal.close();
                    settings.deleteSubinterface(name,token)
                });

            }
        });

    };


    /**
     * Deletes the selected subinterface
     *
     * @param name  The name of the subinterface to be deleted
     */
    settings.deleteSubinterface = function (name,token) {

        $.ajax({
            type: "POST",
            url: "/api/system/network/subinterface",
            data: "name=" + name + "&csrf_token="+token,
            timeout: globals.variables.SUBINTERFACE_AJAX_TIMEOUT,
            cache: false,
            error: function (xmlHttpReq, textStatus, errorThrown) {
                globals.functions.ajaxError(xmlHttpReq, textStatus, errorThrown);
                $("#networkFieldsetContentDiv").unmask();
            },
            beforeSend: function () {
                $("#networkFieldsetContentDiv").mask($("#js_loading").text());
                globals.functions.enableButton("deleteSubinterfaceButton", false);
            },
            success: function () {
                settings.buildNetworkFieldset();
                settings.buildVLANFieldset();
            }
        });

    };

    /**
     * Opens the create subinterface form window
     */
    settings.openCreateInterfaceModal = function () {

        $('#subinterfaceCreationModal').modal({
            closeHTML: "<a href='' title='" + $("#js_close").text() + "'></a>",
            overlayId: 'modal-overlay',
            containerId: 'subinterfaceCreationModal-container',
            onShow: function () {

                $("#subinterfaceEthIdCombo").empty();
                for (var i = 0; i < settings.networkData.interfaces.length; i++) {
                    if (settings.networkData.interfaces[i].name.indexOf(".") == -1) {
                        $("#subinterfaceEthIdCombo").append("<option value='"
                            + settings.networkData.interfaces[i].name + "'>"
                            + settings.networkData.interfaces[i].name + "</option>");
                    }
                }

                $("#subinterfaceUseDhcpCheckbox").unbind("change");
                $("#subinterfaceUseDhcpCheckbox").change(function(){
                    settings.enableSubinterfaceModalFields(this.checked);
                });
                $("#subinterfaceUseDhcpCheckbox").attr("checked", true);
                settings.enableSubinterfaceModalFields(true);

                //button click events
                $("#subinterfaceCreationModalButtons button").unbind("click");
                $("#subinterfaceCreationModalCancel").click(function () {
                    $.modal.close();
                });
                $("#subinterfaceCreationModalCreate").click(function () {
                    if(settings.validateSubinterfaceFields()) {
                        settings.createSubinterface();
                        $.modal.close();
                    }
                });

            }

        });

    };

    /**
     * Disable or enable dhcp related fields from the create subinterface form
     *
     * @param dhcpCheckboxStatus        dhco checkbox status
     */
    settings.enableSubinterfaceModalFields = function (dhcpCheckboxStatus) {
        $("#subinterfaceIpAddressInput").attr("disabled", dhcpCheckboxStatus);
        $("#subinterfaceSubnetMaskInput").attr("disabled", dhcpCheckboxStatus);
        $("#subinterfaceAutoDNSCheckbox").attr("disabled", !dhcpCheckboxStatus);
        $("#subinterfaceAutoDNSCheckbox").attr("checked", dhcpCheckboxStatus);
    };

    /**
     * validates data from the create subinterface form
     */
    settings.validateSubinterfaceFields = function () {

        var subinterfaceName = $("#subinterfaceEthIdCombo :selected").val() + "." + $("#subinterfaceVlanIdInput").val();
        if (!globals.validators.isVlan($("#subinterfaceVlanIdInput").val())) {
            alert($("#js_invalidVlanId").text());
            return false;
        }
        for (var i = 0; i < settings.networkData.interfaces.length; i++) {
            if (settings.networkData.interfaces[i].name == subinterfaceName) {
                alert($("#js_subinterfaceAlreadyExists").text());
                return false;
            }
        }

        if (!$("#subinterfaceUseDhcpCheckbox")[0].checked) {
            if (!globals.validators.isValidIP($("#subinterfaceIpAddressInput").val())) {
                alert($("#js_invalidIP").text());
                return false;
            }
            if (!settings.uniqueIp($("#subinterfaceIpAddressInput").val(), "")) {
                alert($("#js_ipUsed").text());
                return false;
            }
            if (!globals.validators.isValidNetMask($("#subinterfaceSubnetMaskInput").val())) {
                alert($("#js_invalidSubnetMask").text());
                return false;
            }
            if (!settings.validSubnet($("#subinterfaceIpAddressInput").val(),
                    $("#subinterfaceSubnetMaskInput").val(), "")) {
                alert($("#js_subnetUsed").text());
                return false;
            }
        }

        return true;

    };

    /**
     * Creates a new subinterface and refreshes the network fieldset
     */
    settings.createSubinterface = function () {

        var subinterfaceName = $("#subinterfaceEthIdCombo :selected").val() + "." + $("#subinterfaceVlanIdInput").val();
        var subinterfaceDataString = "";
        subinterfaceDataString += "name=" + subinterfaceName;
        subinterfaceDataString += "&ipaddr=" + $("#subinterfaceIpAddressInput").val();
        subinterfaceDataString += "&netmask=" + $("#subinterfaceSubnetMaskInput").val();
        subinterfaceDataString += "&gateway=" + $("#defaultGatewayInput").val();
        if ($("#subinterfaceUseDhcpCheckbox")[0].checked) {
            subinterfaceDataString += "&use_dhcp=True";
        } else {
            subinterfaceDataString += "&use_dhcp=";
        }
        if ($("#subinterfaceAutoDNSCheckbox")[0].checked) {
            subinterfaceDataString += "&auto_dns=yes";
        } else {
            subinterfaceDataString += "&auto_dns=no";
        }

        $.ajax({
            type: "PUT",
            url: "/api/system/network/subinterface",
            data: subinterfaceDataString,
            timeout: globals.variables.SUBINTERFACE_AJAX_TIMEOUT,
            cache: false,
            error: function (xmlHttpReq, textStatus, errorThrown) {
                globals.functions.ajaxError(xmlHttpReq, textStatus, errorThrown);
                $("#networkFieldsetContentDiv").unmask();
            },
            beforeSend: function () {
                $("#networkFieldsetContentDiv").mask($("#js_loading").text());
            },
            success: function () {
                settings.buildNetworkFieldset();
                settings.buildVLANFieldset();
            }
        });

    };

    /**
     * Checks if an IP is used by another interface. Excludes the current interface if necessary.
     *
     * @param ip                        The IP to check
     * @param excludeInterfaceName      The interface name to exclude from the search
     */
    settings.uniqueIp = function (ip, excludeInterfaceName) {
        for (var i = 0; i < settings.networkData.interfaces.length; i++) {
            if (settings.networkData.interfaces[i].name != excludeInterfaceName) {
                if (ip == settings.networkData.interfaces[i].ipaddr) {
                    return false;
                }
            }
        }
        return true;
    };

    /**
     * Checks if a subnet is used by another interface. Excludes the current interface if necessary.
     *
     * @param ip                        The IP to consider
     * @param netmask                   The netmask to consider
     * @param excludeInterfaceName       The interface name to exclude from the search
     */
    settings.validSubnet = function (ip, netmask, excludeInterfaceName) {
        for (var i = 0; i < settings.networkData.interfaces.length; i++) {
            if (settings.networkData.interfaces[i].name != excludeInterfaceName) {
                var currentIp = settings.networkData.interfaces[i].ipaddr;
                var currentNetmask = settings.networkData.interfaces[i].netmask;
                if (globals.functions.getSubnet(ip, netmask) == globals.functions.getSubnet(currentIp, currentNetmask)) {
                    return false;
                }
            }
        }
        return true;
    };

    /**
     * Validate and save network configuration.
     */
    settings.setNetwork = function () {

        var networkDataString = "";
        networkDataString += "name=" + $("#networkInterfaceCombo :selected").val();
        networkDataString += "&ipaddr=" + $("#ipAddressInput").val();
        networkDataString += "&netmask=" + $("#subnetMaskInput").val();
        if (settings.networkData.use_prefix) {
            networkDataString += "&prefix=" + $("#prefixInput").val();
        }
        if ($("#defaultGatewayInput").val() != "") {
            networkDataString += "&gateway=" + $("#defaultGatewayInput").val();
        } else {
            networkDataString += "&gateway=";
        }
        if ($("#useDhcpCheckbox")[0].checked) {
            networkDataString += "&use_dhcp=True";
        } else {
            networkDataString += "&use_dhcp=";
        }
        networkDataString += "&hostname=" + $("#hostNameInput").val();
        networkDataString += "&dns=" + $("#dnsInput").val();
        if ($("#autoDNSCheckbox")[0].checked) {
            networkDataString += "&auto_dns=yes";
        } else {
            networkDataString += "&auto_dns=no";
        }

        var validGateway = false;

        if (($("#defaultGatewayInput").val().length > 0) &&
            !globals.validators.isValidIpv4Gateway($("#defaultGatewayInput").val(),
                $("#ipAddressInput").val(), $("#subnetMaskInput").val()))
        {

                for (var i = 0; i < settings.networkData.interfaces.length; i++) {

                    if (globals.validators.isValidIpv4Gateway($("#defaultGatewayInput").val(),
                            settings.networkData.interfaces[i].ipaddr, settings.networkData.interfaces[i].netmask)) {

                        if (settings.networkData.interfaces[i].name != $("#networkInterfaceCombo :selected").val()) {
                            validGateway = true;
                            break;
                        }

                    }

                }
        } else {
            validGateway = true;
        }

        var errMsg = "";
        if (!$("#useDhcpCheckbox")[0].checked) {
            if (!globals.validators.isValidIP($("#ipAddressInput").val())) {
                errMsg += $("#js_invalidIP").text() + "\n";
            } else if (!settings.uniqueIp($("#ipAddressInput").val(),
                    $("#networkInterfaceCombo :selected").val())) {
                errMsg += $("#js_ipUsed").text() + "\n";
            } else if (!globals.validators.isValidNetMask($("#subnetMaskInput").val())) {
                errMsg += $("#js_invalidSubnetMask").text() + "\n";
            } else if (!settings.validSubnet($("#ipAddressInput").val(),
                    $("#subnetMaskInput").val(), $("#networkInterfaceCombo :selected").val())) {
                errMsg += $("#js_subnetUsed").text() + "\n";
            } else if (!globals.validators.isNumeric($("#prefixInput").val()) &&
                        $("#prefixInput").val() > 1 && $("#prefixInput").val() <= 30 &&
                        settings.networkData.use_prefix) {
                errMsg += $("#js_invalidPrefix").text() + "\n";
            } else if (globals.functions.prefixToNetmask($("#prefixInput").val()) != $("#subnetMaskInput").val() &&
                        settings.networkData.use_prefix) {
                errMsg += $("#js_prefixNetmaskConflict").text() + "\n";
            } else if (!validGateway) {
                errMsg += $("#js_invalidGateway").text() + "\n";
            } else if (!globals.validators.isHost($("#hostNameInput").val())) {
                errMsg += $("#js_invalidHostName").text() + "\n";
            }
        } else {
            if (!globals.validators.isHost($("#hostNameInput").val())) {
                alert($("#js_invalidHostName").text());
            }
        }
        if (!$("#autoDNSCheckbox")[0].checked) {
            if (($("#dnsInput").val().length > 0) && !globals.validators.isDNSArray($("#dnsInput").val())) {
                errMsg += $("#js_invalidDns").text();
            }
        }
        if (errMsg.length > 0) {
            alert(errMsg);
        } else {
             $.ajax({
                type: "PUT",
                url: "/api/system/check_hostname",
                cache: false,
                data: "hostname=" + $("#hostNameInput").val(),
                beforeSend: function () {
                    $("#networkFieldsetContentDiv").mask($("#js_loading").text());
                },
                success: function (data) {
                    if (data) {
                        $.ajax({
                            type: "GET",
                            url: "/api/settings/certificate/check_distrib",
                            cache: false,
                            beforeSend: function () {
                                $("#networkFieldsetContentDiv").mask($("#js_loading").text());
                            },
                            success: function (data) {
                                if (data.distrib_status == false) {
                                    settings.openServiceRestartWarningModal(networkDataString);
                                } else {
                                    var actionHandlers = {};
                                    actionHandlers[$("#js_Ok").text()] = function() {
                                        $.modal.close();
                                    };
                                    var warning = $("#js_certDistribInProgress").text();
                                    globals.dialog.show(globals.dialog.WARNING, $("#js_warning").text(), warning,
                                        actionHandlers, "", false);
                                }
                            },
                            complete: function () {
                                $("#networkFieldsetContentDiv").unmask();
                            }
                        });
                    } else {
                        alert($("#js_invalidHostName").text());
                        $("#networkFieldsetContentDiv").unmask();
                    }
                },
                complete: function (xhr) {
                    if (xhr.status != 200) {
                        $("#networkFieldsetContentDiv").unmask();
                    }
                }
             });
        }
    };

    /**
     * Opens a modal that warns that the services will be restarted after the settings are applied
     *
     * @param networkDataString query string with network configuration.
     */
    settings.openServiceRestartWarningModal = function (networkDataString) {

        $('#serviceRestartWarningModal').modal({
            closeHTML: "<a href='' title='" + $("#js_close").text() + "'></a>",
            overlayId: 'modal-overlay',
            containerId: 'serviceRestartWarningModal-container',
            onShow: function () {
                if (globals.variables.autoCertCreation) {
                    $("#certificateReplace").show();
                    networkDataString += "&create_cert=true";
                    if (!(globals.variables.serverType == "Primary"
                        || globals.variables.releaseType == "appl"
                        || globals.variables.releaseType == "apc")) {
                        networkDataString += "&self_signed=true";
                    }
                    var newIp = $("#ipAddressInput").val();
                    if (settings.currentIp != newIp) {
                        var subject = $("#certSubjectInput").val();
                        var altSubject = $("#certAltSubjectInput").val();
                        if (subject.indexOf(settings.currentIp) > -1) {
                            networkDataString += "&subject=" + subject.replace(settings.currentIp, newIp);
                        }
                        if (altSubject.indexOf(settings.currentIp) > -1) {
                            networkDataString += "&alt_subject=" + altSubject.replace(settings.currentIp, newIp);
                        }
                    }
                } else {
                    $("#certificateReplace").hide();
                }
                if (globals.variables.isVirtual && (settings.currentIp != $("#ipAddressInput").val()
                    || settings.currentHostname != $("#hostNameInput").val())) {
                    $("#fingerprintChange").show();
                } else {
                    $("#fingerprintChange").hide();
                }

                //button click events
                $("#serviceRestartWarningModalButtons button").unbind("click");
                $("#serviceRestartWarningModalNo").click(function () {
                    $.modal.close();
                });
                $("#serviceRestartWarningModalYes").click(function () {
                    $.modal.close();
                    settings.saveNetworkSettings(networkDataString)
                });

            }
        });

    };

    /**
     * Save network configuration and opens the refresh page modal if neccesary.
     *
     * @param networkDataString query string with network configuration.
     */
    settings.saveNetworkSettings = function(networkDataString) {
        var local = false;
        if (window.location.href.indexOf("localhost") > -1) {
            local = true;
        }
        if (!local && !settings.dhcpEnabled && $("#useDhcpCheckbox")[0].checked && settings.currentInterfaceChanged()) {
            settings.openDHCPChangedWarning(networkDataString)
        } else {
            settings.sendNetworkData(local, networkDataString);    
        }
    };

    /**
     * Sends the new data to the server
     *
     * @param local                 True for local server, false for remote server
     * @param networkDataString     Data to send to the server
     */
    settings.sendNetworkData = function (local, networkDataString) {
        $.ajax({
            type: "PUT",
            url: "/api/system/network",
            data: networkDataString,
            timeout: globals.variables.SAVE_NETWORK_TIMEOUT,
            cache: false,
            error: function (xmlHttpReq, textStatus, errorThrown) {
                globals.functions.ajaxError(xmlHttpReq, textStatus, errorThrown);
                globals.functions.enableButton("saveNetworkSettingsButton", true, $("#js_save").text(),
                        $("#js_saving").text());
                $("#networkFieldsetContentDiv").unmask();
            },
            beforeSend: function () {
                globals.functions.enableButton("saveNetworkSettingsButton", false, $("#js_save").text(),
                        $("#js_saving").text());
                $("#networkFieldsetContentDiv").mask($("#js_loading").text());
            },
            success: function () {
                globals.functions.enableButton("saveNetworkSettingsButton", true, $("#js_save").text(),
                    $("#js_saving").text());
                settings.buildNetworkFieldset();
            }
        });
        if((settings.currentIp != $("#ipAddressInput").val() && !$("#useDhcpCheckbox")[0].checked
            && settings.currentInterfaceChanged()) || globals.variables.autoCertCreation) {

            settings.openNetworkModal(local);

        }
    };

    /**
     * Opens a warning window if the user attempts to enable DHCP
     *
     * @param networkDataString     Data to send to the server
     */
    settings.openDHCPChangedWarning = function (networkDataString) {

        $('#dhcpChangedModal').modal({
            closeHTML: "<a href='' title='" + $("#js_close").text() + "'></a>",
            overlayId: 'modal-overlay',
            containerId: 'dhcpChangedModal-container',
            onShow: function () {
                //button click events
                $("#dhcpChangedModalButtons button").unbind("click");
                $("#dhcpChangedModalNo").click(function () {
                    $.modal.close();
                });
                $("#dhcpChangedModalYes").click(function () {
                    $.modal.close();
                    settings.sendNetworkData(false, networkDataString)
                });

            }
        });

    };

    /**
     * Opens a modal that warns the user that the application needs to restart.
     *
     * @param local     States if the Web Control application is accessed locally (true) or remotely (false)
     */
    settings.openNetworkModal = function (local) {

        $('#networkChangedModal').modal({
            closeHTML: "<a href='' title='" + $("#js_close").text() + "'></a>",
            overlayId: 'modal-overlay',
            containerId: 'networkChangedModal-container',
            onShow: function () {

                var counter = settings.networkRestartCounter;
                if (globals.variables.autoCertCreation) {
                    counter = globals.variables.SAVE_NETWORK_TIMEOUT/1000 - 20;
                    $("#ipChangedMessage").hide();
                    $("#certChangedMessage").show();
                }

                globals.functions.enableButton("networkChangedModalOk", false);
                settings.countDownTimer("networkChangedModalCounter", counter, "networkChangedModalOk",
                    "js_applicationRestarted", "networkChangedModalCounter");

                var ipUrl = "/";
                var location = window.location.href.replace("/main", "/login");
                if (!local) {
                    var newIpComponent = $("#ipAddressInput").val();
                    var oldIpComponent = settings.currentIp;
                    var newUrl = window.location.href.replace(oldIpComponent, newIpComponent);
                    ipUrl = newUrl.substring(0, newUrl.indexOf("main"));
                    location = ipUrl + "login";
                }

                $("#networkChangedModalOk").click(function () {
                    globals.functions.handleRedirection(globals.variables.REDIRECT_NETWORK_CHANGED, location, $("#ipAddressInput").val());
                });
            }
        });

    };

    /**
     * Checks if the settings of the ethernet interface used by Web Control have been changed
     */
    settings.currentInterfaceChanged = function () {
        var selectedInterface = $("#networkInterfaceCombo :selected").val();
        for (var i = 0; i < settings.networkData.interfaces.length; i++) {
            if (selectedInterface == settings.networkData.interfaces[i].name) {
                if (window.location.host.split(":")[0] == settings.networkData.interfaces[i].ipaddr) {
                    return true;
                }
            }
        }
        return false;
    };

    /**
     * Displays the seconds remaining until the application is ready to restart.
     * Enables the "OK" button when the application is ready to restart.
     *
     * @param labelId       label containing the seconds remaining message
     * @param counter       start value of the counter
     * @param buttonId      button to be enabled
     * @param messageId     the id of the message to be displayed
     */
    settings.countDownTimer = function(labelId, counter, buttonId, messageId, bodyId) {
        decreaseCounter = function () {
            if (counter >= 0) {
                globals.functions.composeText(bodyId, "js_applicationWillRestartIn", [counter]);
                counter--;
            } else {
                var restartReadyString = $("#" + messageId).text();
                $("#" + labelId).text(restartReadyString);
                globals.functions.enableButton(buttonId, true);
                clearInterval(i);
            }
        };
        var i = setInterval("decreaseCounter()", 1000);
    };

    /**
     * Gets the date and time and populates the relevant fields.
     */
    settings.getDateInfo = function () {
        $.ajax({
            type: "GET",
            url: "/api/system/date",
            cache: false,
            error: function (xmlHttpReq, textStatus, errorThrown) {
                globals.functions.ajaxError(xmlHttpReq, textStatus, errorThrown);
                settings.getDateReady = true;
                if (settings.getNtpReady && settings.getDateReady) {
                    $("#dateTimeNtpContentDiv").unmask();
                }
            },
            beforeSend: function () {
                $("#dateTimeNtpContentDiv").mask($("#js_loading").text());
            },
            success: function (data) {
                settings.getDateReady = true;
                if (settings.getDateReady && settings.getNtpReady) {
                    $("#dateTimeNtpContentDiv").unmask();
                }
                var parsedDateObject = globals.functions.splitDateString(data);
                $("#dateInput").val(parsedDateObject.date);
                $("#timeHourInput").val(parsedDateObject.hour);
                $("#timeMinutesInput").val(parsedDateObject.minutes);
                settings.currentDate = parsedDateObject.date;
                settings.currentHour = parsedDateObject.hour;
                settings.currentMinutes = parsedDateObject.minutes;
            },
            complete : function (xhr) {
                settings.getDateReady = true;
                if (xhr.status != 200 && settings.getNtpReady && settings.getDateReady) {
                    $("#dateTimeNtpContentDiv").unmask();
                }
            }
        });
    };

    /**
     * Gets the timezones and populates the timezone field.
     */
    settings.getTimezoneInfo = function () {
        var timezonesArray = [];
        $.ajax({
            type: "GET",
            url: "/api/system/timezone",
            dataType: "json",
            cache: false,
            success: function (data) {
                settings.currentTimezoneName = data.name;
                timezonesArray.push(settings.currentTimezoneName);
                $.ajax({
                    type: "GET",
                    url: "/api/system/timezones",
                    dataType: "json",
                    cache: false,
                    success: function (data) {
                        settings.getTimezonesReady = true;
                        if (settings.getDateReady && settings.getNtpReady && settings.getTimezonesReady) {
                            $("#dateTimeNtpContentDiv").unmask();
                        }
                        for (var i = 0; i < data.length; i++) {
                            if (data[i].name != settings.currentTimezoneName) {
                                timezonesArray.push(data[i].name);
                            }
                        }
                        var sortedTimezonesArray = timezonesArray.sort();
                        for (var i = 0; i < sortedTimezonesArray.length; i++) {
                            $("#selectTimezone").append("<option id='" + sortedTimezonesArray[i]
                                    + "' value='" + sortedTimezonesArray[i]
                                    + "'>" + sortedTimezonesArray[i] + "</option>");
                            }
                        $("#selectTimezone").val(settings.currentTimezoneName);
                    },
                    complete : function (xhr) {
                        settings.getTimezonesReady = true;
                        if (xhr.status != 200 && settings.getDateReady && settings.getNtpReady
                                && settings.getTimezonesReady) {
                            $("#dateTimeNtpContentDiv").unmask();
                        }
                    }
                });
            },
            complete : function (xhr) {
                settings.getTimezonesReady = true;
                if (xhr.status != 200 && settings.getDateReady && settings.getNtpReady && settings.getTimezonesReady) {
                    $("#dateTimeNtpContentDiv").unmask();
                }
            }
        });
    };

    /**
     * Shows the timezone change warning if necessary or calls the setDate or the setNTP function.
     */
    settings.setTimezoneAndDateOrNtp = function () {
        globals.functions.enableButton("saveDateSettingsButton", false, $("#js_save").text(), $("#js_saving").text());
        var timezoneName = $("#selectTimezone :selected").val();
        if (timezoneName != settings.currentTimezoneName) {
            settings.openTimezoneChangedModal(timezoneName);
        } else {
            if (!$("#useNtpCheckbox")[0].checked) {
                settings.setDate();
            }
            settings.setNTP();
        }
    };

    /**
     * Warns the user that the system will require reboot for the timezone change to take effect.
     * Proceeds to apply the changes if the user agrees.
     *
     * @param timezoneName      The new timezone name
     */
    settings.openTimezoneChangedModal = function (timezoneName) {

        $('#timezoneChangedModal').modal({
            closeHTML: "<a href='' title='" + $("#js_close").text() + "'></a>",
            overlayId: 'modal-overlay',
            containerId: 'timezoneChangedModal-container',
            onShow: function () {
                if (globals.variables.isVirtual && settings.currentTimezoneName != $("#selectTimezone :selected").val()) {
                    $("#fingerprintWarning").show();
                } else {
                    $("#fingerprintWarning").hide();
                }

                //button click events
                $("#timezoneChangedModalButtons button").unbind("click");
                $("#timezoneChangedModalNo").click(function () {
                    $.modal.close();
                    globals.functions.enableButton("saveDateSettingsButton", true, $("#js_save").text()
                        , $("#js_saving").text());
                });
                $("#timezoneChangedModalYes").click(function () {
                    $.modal.close();
                    settings.rebootServer = true;
                    settings.setTimezone(timezoneName);
                });
            }
        });

    };

    /**
     * Sets the new timezone and calls the functions that set the date and the NTP.
     *
     * @param timezoneName       The new timezone name
     */
    settings.setTimezone = function (timezoneName) {
        $.ajax({
            type: "PUT",
            url: "/api/system/timezone",
            data: "name=" + timezoneName,
            cache: false,
            complete: function (xhr) {
                if (xhr.status == 200) {
                    settings.currentTimezoneName = timezoneName;
                }
                if (!$("#useNtpCheckbox")[0].checked) {
                    settings.setDate();
                }
                settings.setNTP();
            }
        });
    };

    /**
     * Saves the date if necessary
     */
    settings.setDate = function () {
        if (settings.currentDate != $("#dateInput").val() ||
                settings.currentHour != $("#timeHourInput").val() ||
                settings.currentMinutes != $("#timeMinutesInput").val()) {

            if (!globals.validators.isDate($("#dateInput").val(), settings.localeOptions.validationFormat)) {
                alert(settings.localeOptions.errorText);
                globals.functions.enableButton("saveDateSettingsButton", true, $("#js_save").text(),
                        $("#js_saving").text());
            } else if (!globals.validators.isHour($("#timeHourInput").val())) {
                alert($("#js_invalidHourAndRange").text());
                globals.functions.enableButton("saveDateSettingsButton", true, $("#js_save").text(),
                        $("#js_saving").text());
            } else if (!globals.validators.isMinute($("#timeMinutesInput").val())) {
                alert($("#js_invalidMinutesAndRange").text());
                globals.functions.enableButton("saveDateSettingsButton", true, $("#js_save").text(),
                        $("#js_saving").text());
            } else {
                settings.dateFinished = false;
                $.ajax({
                    type: "GET",
                    url: "/api/services/dependency",
                    data: "property=date_time_dependent",
                    dataType: "json",
                    cache: false,
                    error: function (xmlHttpReq, textStatus, errorThrown) {
                        globals.functions.ajaxError(xmlHttpReq, textStatus, errorThrown);
                        settings.dateFinished = true;
                        settings.finalizeDateTime();
                    },
                    beforeSend: function () {
                        globals.functions.enableButton("saveDateSettingsButton", false, $("#js_save").text(),
                                $("#js_saving").text());
                    },
                    success: function (data) {
                        if (data.length > 0) {
                            settings.openTimeDependencyWarningModal(data);
                        } else {
                            settings.applyDateSettings([]);
                        }
                    },
                    complete: function(xhr) {
                        settings.dateFinished = true;
                        if (xhr.status != 200) {
                            settings.finalizeDateTime();
                        }
                    }
                });
            }
        } else {
            settings.finalizeDateTime();
        }
    };

    /**
     * Warns the user about the services that require restart after the date and time is changed
     *
     * @param dependentServices     Object array that contains the dependent services' ids and display_names
     */
    settings.openTimeDependencyWarningModal = function (dependentServices) {
        $("#timeDependencyWarningModalHeader").text($("#js_warning").text());
        var servicesString = dependentServices[0].display_name;
        var dependentServicesIds = [];
        dependentServicesIds.push(dependentServices[0].id);
        if (dependentServices.length == 1) {
            globals.functions.composeText("timeDependencyWarningModalService", "js_serviceTimeRestart",
                [servicesString]);
            $("#timeDependencyWarningModalService").show();
        } else {
            for (var i = 1; i < dependentServices.length; i++) {
                dependentServicesIds.push(dependentServices[i].id);
                if (i == dependentServices.length-1) {
                    servicesString += " " + $("#js_and").text() + " " + dependentServices[i].display_name;
                } else {
                    servicesString += ", " + dependentServices[i].display_name;
                }
            }
            globals.functions.composeText("timeDependencyWarningModalServices", "js_servicesTimeRestart",
                [servicesString]);
            $("#timeDependencyWarningModalServices").show();
        }

        // button click events
        $("#timeDependencyWarningModalButtons button").unbind("click");
        $("#timeDependencyWarningModalNo").click(function () {
            $.modal.close();
            globals.functions.enableButton("saveDateSettingsButton", true, $("#js_save").text(),
                                           $("#js_saving").text());
        });
        $("#timeDependencyWarningModalYes").click(function () {
            $.modal.close();
            settings.applyDateSettings(dependentServicesIds);
        });
        $('#timeDependencyWarningModal').modal({
            closeHTML: "<a href='' title='" + $("#js_close").text() + "'></a>",
            overlayId: 'modal-overlay',
            containerId: 'timeDependencyWarningModal-container'
        });

    };

    /**
     * Applies the new date
     *
     * @param dependentServicesIds      Array of services to restart after the settings are applied
     */
    settings.applyDateSettings = function (dependentServicesIds) {
        var dateString = "";
        dateString += $("#dateInput").val() + " ";
        dateString += $("#timeHourInput").val() + ":" + $("#timeMinutesInput").val() + ":00";
        $.ajax({
            type: "PUT",
            url: "/api/system/date",
            data: "timestamp=" + dateString,
            cache: false,
            error: function (xmlHttpReq, textStatus, errorThrown) {
                if (xmlHttpReq.status != 200) {
                    globals.functions.ajaxError(xmlHttpReq, textStatus, errorThrown);
                }
            },
            complete: function (xhr) {
                if (xhr.status == 200) {
                    settings.currentDate = $("#dateInput").val();
                    settings.currentHour = $("#timeHourInput").val();
                    settings.currentMinutes = $("#timeMinutesInput").val();
                }
                if (dependentServicesIds.length > 0) {
                    settings.restartAffectedServices(dependentServicesIds);
                } else {
                    settings.finalizeDateTime();
                }
            }
        });
    };

    /**
     * Restarts the services affected by the new settings
     *
     * @param dependentServicesIds      Array of services to restart
     */
    settings.restartAffectedServices = function (dependentServicesIds) {
        $.ajax({
            type: "PUT",
            url: "/api/services/restart",
            data: "services=" + dependentServicesIds,
            cache: false,
            timeout: globals.variables.RESTART_SERVICES_TIMEOUT,
            complete: function () {
                globals.functions.enableButton("saveDateSettingsButton", true, $("#js_save").text(),
                        $("#js_saving").text());
            }
        });
    };

    /**
     * Save NTP configuration.
     */
    settings.setNTP = function () {
        var servers = $("#ntpServersInput").val().split("\n").join(",");
        var useNtp = $("#useNtpCheckbox")[0].checked;
        var sync = $("#syncCheckbox")[0].checked;
        var useLocal = $("#useLocalSourceCheckbox")[0].checked;
        if (settings.currentServers != servers || settings.currentSync != sync
                || settings.currentUseLocalTimeSource != useLocal || settings.currentUseNTP != useNtp) {
            settings.ntpFinished = false;
            $.ajax({
                type: "PUT",
                url: "/api/system/ntp",
                data: "use_ntp=" + useNtp + "&servers=" + servers + "&use_local_source=" + useLocal + "&sync=" + sync,
                cache: false,
                beforeSend: function () {
                    globals.functions.enableButton("saveDateSettingsButton", false, $("#js_save").text(),
                            $("#js_saving").text());
                },
                complete: function (xhr) {
                    settings.ntpFinished = true;
                    if (xhr.status == 200) {
                        settings.currentUseNTP = useNtp;
                        settings.currentServers = servers;
                        settings.currentSync = sync;
                        settings.currentUseLocalTimeSource = useLocal;
                    }
                    settings.finalizeDateTime();
                }
            });
        } else {
            settings.finalizeDateTime();
        }
    };

    /**
     * Called after the date and time settings are applied.
     * Enables the "Save" button and calls the reboot function if necessary.
     */
    settings.finalizeDateTime = function () {
        if (settings.dateFinished && settings.ntpFinished) {
            globals.functions.enableButton("saveDateSettingsButton", true, $("#js_save").text(),
                $("#js_saving").text());
            if (settings.rebootServer) {
                settings.rebootServer = false;
                settings.doServerReboot();
            }
        }
    };

    /**
     * Reboots the server and redirects the user to the login page.
     */
    settings.doServerReboot = function () {
        $.ajax({
            type: 'PUT',
            url: '/api/system/status',
            data: 'restart=true',
            timeout: globals.variables.REBOOT_SHUTDOWN_TIMEOUT,
            success: function() {
                $.ajax({
                    type: 'DELETE',
                    url: '/api/session',
                    complete: function() {
                        globals.functions.handleRedirection(globals.variables.REDIRECT_DATETIME_CHANGED);
                    }
                });
            }
        });
    };

    /**
     * Builds configure date fieldset.
     */
    settings.buildDateFieldset = function () {
        $("#datetimeFieldset").show();
        if (globals.variables.releaseType == "abe") {
            // (IPOFFICE-25648) on Midmarket release "synchronize before starting service"
            // and "use local time source" checkboxes are always enabled and should be hidden
            $("#syncDiv").hide();
            $("#useLocalSourceDiv").hide();
            $("#syncCheckbox").attr("checked", true);
            $("#useLocalSourceCheckbox").attr("checked", true);
        }
        settings.localeOptions = globals.getLocaleOptions(globals.variables.language);
        $.datepicker.setDefaults($.datepicker.regional[settings.localeOptions.language]);
        $("#dateInput").datepicker({
            showOn: 'button',
            buttonImage: '/static/pics/datepicker_icon.gif',
            buttonImageOnly: true,
            dateFormat: settings.localeOptions.format,
            showAnim: ''
        });
        $(".ui-datepicker-trigger").addClass("datepickerIconMargin");
        settings.getDateInfo();
        if (globals.variables.isVirtual) {
            $("#dateTimeDiv").hide();
        }
        $("#selectTimezone").empty();
        settings.getTimezoneInfo();
        settings.getNtpInfo();
        $("#saveDateSettingsButton").click( function () {
            settings.setTimezoneAndDateOrNtp();
        });
    };

    /**
     * Gets the NTP data and populates the NTP related fields.
     */
    settings.getNtpInfo = function () {
        $.ajax({
            type: "GET",
            url: "/api/system/ntp",
            dataType: "json",
            cache: false,
            success: function (data) {
                settings.getNtpReady = true;
                if (settings.getDateReady && settings.getNtpReady && settings.getTimezonesReady) {
                    $("#dateTimeNtpContentDiv").unmask();
                }
                $("#useNtpCheckbox").attr("checked", data.use_ntp);
                if (globals.variables.releaseType != "abe") { //IPOFFICE-25648
                    $("#syncCheckbox").attr("checked", data.sync);
                    $("#useLocalSourceCheckbox").attr("checked", data.use_local_source);
                }
                var serversString = "";
                for (var i = 0; i < data.servers.length; i++) {
                    if (i != data.servers.length-1) {
                        serversString += data.servers[i] + "\n";
                    } else {
                        serversString += data.servers[i];    
                    }
                }
                $("#ntpServersInput").val(serversString);
                settings.disableDateOrNtp(data.use_ntp);
                $("#useNtpCheckbox").change( function(){
                    settings.disableDateOrNtp(this.checked);
                });
                settings.currentServers = data.servers.join(",");
                settings.currentSync = data.sync;
                settings.currentUseLocalTimeSource = data.use_local_source;
                settings.currentUseNTP = data.use_ntp;
            },
            complete : function (xhr) {
                settings.getNtpReady = true;
                if (xhr.status != 200 && settings.getDateReady && settings.getNtpReady && settings.getTimezonesReady) {
                    $("#dateTimeNtpContentDiv").unmask();
                }
            }
        });
    };

    /**
     * Disables the date components or the NTP components.
     *
     * @param useNtp    true to disable the date fields
     *                  false to disable the NTP related fields
     */
    settings.disableDateOrNtp = function (useNtp) {
        $("#dateInput").attr("disabled", useNtp);
        if (useNtp) {
            $("#dateInput").datepicker("option", "showOn", "focus");
        } else {
            $("#dateInput").datepicker("option", "showOn", "button");
        }
        $("#timeMinutesInput").attr("disabled", useNtp);
        $("#timeHourInput").attr("disabled", useNtp);
        $("#ntpServersInput").attr("disabled", !useNtp);
        $("#syncCheckbox").attr("disabled", !useNtp);
        $("#useLocalSourceCheckbox").attr("disabled", !useNtp);        
    };
    
    settings.disableBanner = function (showBanner) {
        $("#loginBannerInput").attr("disabled", !showBanner);  
    };

    /**
     * Builds the Login Banner fieldset.
     */
    settings.buildBannerFieldset = function () {

        $("#loginBannerFieldset").show();
        $.ajax({
            type: "GET",
            url: "/api/system/banner",
            dataType: "json",
            cache: false,
            error: function (xmlHttpReq, textStatus, errorThrown) {
                globals.functions.ajaxError(xmlHttpReq, textStatus, errorThrown);
                $("#loginBannerContentDiv").unmask();
            },
            beforeSend: function () {
                $("#loginBannerContentDiv").mask($("#js_loading").text());
            },
            success: function (data) {
                $("#showBannerCheckbox").attr("checked", data.show_banner);
                if (data && (data.banner.length > 0)) {
                    $("#loginBannerInput").val(data.banner.trim());
                }
                if (!data.show_banner) {
                    $("#loginBannerInput").val('');
                    settings.disableBanner(data.show_banner);
                }
                $("#showBannerCheckbox").change( function(){
                    settings.disableBanner(this.checked);
                });
                $("#loginBannerContentDiv").unmask();
            }
        });

        $("#saveLoginBannerSettings").unbind("click");
        $("#saveLoginBannerSettings").click( function () {
            settings.saveLoginBanner();
        });

    };

    /**
     * Saves the new login banner text.
     */
    settings.saveLoginBanner = function () {
        var dataString = "banner_text=";
        var showBanner = $("#showBannerCheckbox")[0].checked;
        dataString = encodeURIComponent($("#loginBannerInput").val());
        $.ajax({
            type: "PUT",
            url: "/api/system/banner",
            data: "show_banner=" + showBanner + "&banner_text=" + dataString,
            cache: false,
            beforeSend: function () {
                globals.functions.enableButton("saveLoginBannerSettings",
                    false,
                    $("#js_save").text(),
                    $("#js_saving").text());
            },
            complete: function () {
                globals.functions.enableButton("saveLoginBannerSettings",
                    true,
                    $("#js_save").text(),
                    $("#js_saving").text());
            }
        });
    };


    /**
     * Build the debug settings fieldset.
     */
    settings.buildDebugFieldset = function () {
        $("#debugFieldset").show();
        var debugLoaded = false;
        var csipoLoaded = false;
        //always hide CSIPO fields for now
        if (false/*globals.variables.releaseType == "isa" || globals.variables.releaseType == "abe"*/) {
            $("#csipoFieldset").show();
            $.ajax({
                type: "GET",
                url: "/api/settings/csipo",
                dataType: "json",
                cache: false,
                error: function (xmlHttpReq, textStatus, errorThrown) {
                    globals.functions.ajaxError(xmlHttpReq, textStatus, errorThrown);
                    csipoLoaded = true;
                    if (debugLoaded && csipoLoaded) {
                        $("#debugContentDiv").unmask();
                    }
                },
                beforeSend: function () {
                    $("#debugContentDiv").mask($("#js_loading").text());
                },
                success: function (data) {
                    $("#csipoPathInput").val(data.csipo_path);
                    $("#csipoUsernameInput").val(data.csipo_username);
                    $("#csipoPasswordInput").val(data.csipo_password);
                    $("#csipoMountCheckbox").attr("checked", data.csipo_mount);
                    settings.currentCSIPOPath = data.csipo_path;
                    settings.currentCSIPOUsername = data.csipo_username;
                    settings.currentCSIPOPassword = data.csipo_password;
                    settings.currentCSIPOMount = data.csipo_mount;
                    csipoLoaded = true;
                    if (debugLoaded && csipoLoaded) {
                        $("#debugContentDiv").unmask();
                    }
                },
                complete: function (xhr) {
                    if (xhr.status != 200) {
                        csipoLoaded = true;
                        if (debugLoaded && csipoLoaded) {
                            $("#debugContentDiv").unmask();
                        }
                    }
                }
            });
        } else {
            csipoLoaded = true;
            $("#csipoFieldset").hide();
        }
        $.ajax({
            type: "GET",
            url: "/api/settings/debug",
            dataType: "json",
            cache: false,
            error: function (xmlHttpReq, textStatus, errorThrown) {
                if (xmlHttpReq.status == 404) {
                    //voicemail not installed -> hide the widget
                    $("#debugFieldset").hide();
                } else {
                    globals.functions.ajaxError(xmlHttpReq, textStatus, errorThrown);
                }
                debugLoaded = true;
                if (debugLoaded && csipoLoaded) {
                    $("#debugContentDiv").unmask();
                }
            },
            beforeSend: function () {
                $("#debugContentDiv").mask($("#js_loading").text());
            },
            success: function (data) {
                $("#debugFieldset").show();
                debugLoaded = true;
                if (debugLoaded && csipoLoaded) {
                    $("#debugContentDiv").unmask();
                }
                $("#debugSettingSelect option[value=" + data["Filter Level"] + "]").attr("selected", true);
                settings.currentDebugLevel = data["Filter Level"];
            },
            complete : function (xhr) {
                if (xhr.status != 200) {
                    debugLoaded = true;
                    if (debugLoaded && csipoLoaded) {
                        $("#debugContentDiv").unmask();
                    }
                }
            }
        });
        $("#saveDebugSettings").unbind("click");
        $("#saveDebugSettings").click( function () {
            if (settings.currentDebugLevel != $("#debugSettingSelect :selected").val()) {
                settings.saveDebugSettings();
            }
            if (globals.variables.releaseType == "isa" || globals.variables.releaseType == "abe") {
                if (settings.currentCSIPOMount != $("#csipoMountCheckbox")[0].checked ||
                        settings.currentCSIPOPath != $("#csipoPathInput").val() ||
                        settings.currentCSIPOUsername != $("#csipoUsernameInput").val() ||
                        settings.currentCSIPOPassword != $("#csipoPasswordInput").val()) {
                    settings.saveCSIPOSettings();
                }
            }
        });
    };

    /**
     * Build the CSIPO debug settings fieldset.
     */
    settings.buildCsipoDebugFieldset = function () {
        $.ajax({
            type: "GET",
            url: "/api/settings/csipo/debug",
            dataType: "json",
            cache: false,
            error: function (xmlHttpReq, textStatus, errorThrown) {
                if (xmlHttpReq.status == 404) {
                    //CSIPO not installed -> hide the widget
                    $("#csipoDebugFieldset").hide();
                } else {
                    globals.functions.ajaxError(xmlHttpReq, textStatus, errorThrown);
                }
                $("#csipoDebugContentDiv").unmask();
            },
            beforeSend: function () {
                $("#csipoDebugContentDiv").mask($("#js_loading").text());
            },
            success: function (data) {
                $("#csipoDebugFieldset").show();
                $("#csipoDebugContentDiv").unmask();
                $("#csipoDebugSettingSelect option[value=" + data.log_level + "]").attr("selected", true);
                settings.currentCsipoDebugLevel = data["Filter Level"];
            },
            complete : function (xhr) {
                if (xhr.status != 200) {
                    $("#csipoDebugContentDiv").unmask();
                }
            }
        });
        $("#saverCsipoDebugSettings").unbind("click");
        $("#saverCsipoDebugSettings").click( function () {
            if (settings.currentCsipoDebugLevel != $("#csipoDebugSettingSelect :selected").val()) {
                settings.saveCsipoDebugSettings();
            }
        });
    };

    /**
     * Save CSIPO debug level value.
     */
    settings.saveCsipoDebugSettings = function () {
        var dataString = "";
        dataString += "debug_level=" + $("#csipoDebugSettingSelect :selected").val();
        $.ajax({
            type: "PUT",
            url: "/api/settings/csipo/debug",
            data: dataString,
            cache: false,
            error: function (xmlHttpReq, textStatus, errorThrown) {
                globals.functions.ajaxError(xmlHttpReq, textStatus, errorThrown);
                $("#csipoDebugSettingSelect option[value=" + settings.currentDebugLevel + "]").attr("selected", true);
                    globals.functions.enableButton("saverCsipoDebugSettings",
                        true,
                        $("#js_save").text(),
                        $("#js_saving").text());
            },
            beforeSend: function () {
                globals.functions.enableButton("saverCsipoDebugSettings",
                    false,
                    $("#js_save").text(),
                    $("#js_saving").text());
            },
            success: function () {
                settings.currentDebugLevel = $("#csipoDebugSettingSelect :selected").val();
            },
            complete: function () {
                globals.functions.enableButton("saverCsipoDebugSettings",
                    true,
                    $("#js_save").text(),
                    $("#js_saving").text());
            }
        });
    };

    /**
     * Saves the CSIPO settings
     */
    settings.saveCSIPOSettings = function () {

        settings.csipoFinished = false;
        var dataString = "";
        dataString += "csipo_path=" + encodeURIComponent($("#csipoPathInput").val());
        dataString += "&csipo_username=" + encodeURIComponent($("#csipoUsernameInput").val());
        dataString += "&csipo_password=" + encodeURIComponent($("#csipoPasswordInput").val());
        dataString += "&csipo_mount=" + $("#csipoMountCheckbox")[0].checked;
        $.ajax({
            type: "PUT",
            url: "/api/settings/csipo",
            data: dataString,
            cache: false,
            error: function (xmlHttpReq, textStatus, errorThrown) {
                globals.functions.ajaxError(xmlHttpReq, textStatus, errorThrown);
                $("#csipoPathInput").val(settings.currentCSIPOPath);
                $("#csipoUsernameInput").val(settings.currentCSIPOUsername);
                $("#csipoPasswordInput").val(settings.currentCSIPOPassword);
                $("#csipoMountCheckbox").attr("checked", settings.currentCSIPOMount);
                settings.csipoFinished = true;
                if (settings.debugFinished && settings.csipoFinished) {
                    globals.functions.enableButton("saveDebugSettings",
                            true,
                            $("#js_save").text(),
                            $("#js_saving").text());
                }
            },
            beforeSend: function () {
                globals.functions.enableButton("saveDebugSettings",
                                   false,
                                   $("#js_save").text(),
                                   $("#js_saving").text());
            },
            success: function () {
                settings.currentCSIPOPath = $("#csipoPathInput").val();
                settings.currentCSIPOUsername = $("#csipoUsernameInput").val();
                settings.currentCSIPOPassword = $("#csipoPasswordInput").val();
                settings.currentCSIPOMount = $("#csipoMountCheckbox")[0].checked;
            },
            complete: function () {
                settings.csipoFinished = true;
                if (settings.debugFinished && settings.csipoFinished) {
                    globals.functions.enableButton("saveDebugSettings",
                            true,
                            $("#js_save").text(),
                            $("#js_saving").text());
                }
            }
        });

    };

    /**
     * Save debug level value.
     */
    settings.saveDebugSettings = function () {
        settings.debugFinished = false;
        var dataString = "";
        dataString += "debug_level=" + $("#debugSettingSelect :selected").val();
        $.ajax({
            type: "PUT",
            url: "/api/settings/debug",
            data: dataString,
            cache: false,
            error: function (xmlHttpReq, textStatus, errorThrown) {
                globals.functions.ajaxError(xmlHttpReq, textStatus, errorThrown);
                $("#debugSettingSelect option[value=" + settings.currentDebugLevel + "]").attr("selected", true);
                settings.debugFinished = true;
                if (settings.debugFinished && settings.csipoFinished) {
                    globals.functions.enableButton("saveDebugSettings",
                            true,
                            $("#js_save").text(),
                            $("#js_saving").text());
                }
            },
            beforeSend: function () {
                globals.functions.enableButton("saveDebugSettings",
                                   false,
                                   $("#js_save").text(),
                                   $("#js_saving").text());
            },
            success: function () {
                settings.currentDebugLevel = $("#debugSettingSelect :selected").val();
            },
            complete: function () {
                settings.debugFinished = true;
                if (settings.debugFinished && settings.csipoFinished) {
                    globals.functions.enableButton("saveDebugSettings",
                            true,
                            $("#js_save").text(),
                            $("#js_saving").text());
                }
            }
        });
    };
    /**
     * Build the IRA debug settings fieldset.
     */
    settings.buildIraDebugFieldset = function () {
        $.ajax({
            type: "GET",
            url: "/api/settings/ira/debug",
            dataType: "json",
            cache: false,
            error: function (xmlHttpReq, textStatus, errorThrown) {
                if (xmlHttpReq.status == 404) {
                    $("#iraDebugFieldset").hide();
                } else {
                    globals.functions.ajaxError(xmlHttpReq, textStatus, errorThrown);
                }
                $("#iraDebugContentDiv").unmask();
            },
            beforeSend: function () {
                $("#iraDebugContentDiv").mask($("#js_loading").text());
            },
            success: function (data) {
                $("#iraDebugFieldset").show();
                $("#iraDebugContentDiv").unmask();
                $("#iraDebugSettingSelect option[value=" + data.log_level + "]").attr("selected", true);
                settings.currentIraDebugLevel = data["Filter Level"];
            },
            complete : function (xhr) {
                if (xhr.status != 200) {
                    $("#iraDebugContentDiv").unmask();
                }
            }
        });
        $("#saverIraDebugSettings").unbind("click");
        $("#saverIraDebugSettings").click( function () {
            if (settings.currentIraDebugLevel != $("#iraDebugSettingSelect :selected").val()) {
                settings.saveIraDebugSettings();
            }
        });
    };

    /**
     * Save IRA debug level value.
     */
    settings.saveIraDebugSettings = function () {
        var dataString = "";
        dataString += "debug_level=" + $("#iraDebugSettingSelect :selected").val();
        $.ajax({
            type: "PUT",
            url: "/api/settings/ira/debug",
            data: dataString,
            cache: false,
            error: function (xmlHttpReq, textStatus, errorThrown) {
                globals.functions.ajaxError(xmlHttpReq, textStatus, errorThrown);
                $("#iraDebugSettingSelect option[value=" + settings.currentDebugLevel + "]").attr("selected", true);
                    globals.functions.enableButton("saverIraDebugSettings",
                        true,
                        $("#js_save").text(),
                        $("#js_saving").text());
            },
            beforeSend: function () {
                globals.functions.enableButton("saverIraDebugSettings",
                    false,
                    $("#js_save").text(),
                    $("#js_saving").text());
            },
            success: function () {
                settings.currentIRADebugLevel = $("#iraDebugSettingSelect :selected").val();
            },
            complete: function () {
                globals.functions.enableButton("saverIraDebugSettings",
                    true,
                    $("#js_save").text(),
                    $("#js_saving").text());
            }
        });
    };

    /**
     * Builds the IP Office VLAN Configuration fieldset
     */
    settings.buildVLANFieldset = function () {
        if (globals.variables.releaseType != "apc") {
            $("#lanFieldset").show();
            $.ajax({
                type: "GET",
                url: "/api/system/lan",
                dataType: "json",
                cache: false,
                error: function (xmlHttpReq, textStatus, errorThrown) {
                    globals.functions.ajaxError(xmlHttpReq, textStatus, errorThrown);
                    $("#lanFieldsetContentDiv").unmask();
                },
                beforeSend: function () {
                    $("#lanFieldsetContentDiv").mask($("#js_loading").text());
                },
                success: function (data) {

                    var optionsString = "";
                    for (var i = 0; i < data.interfaces.length; i++) {
                        var interfaceName = data.interfaces[i];
                        optionsString += "<option value='" + interfaceName + "'>";
                        optionsString += interfaceName;
                        optionsString += "</option>";
                    }
                    $("#lan1InterfaceCombo").empty();
                    $("#lan2InterfaceCombo").empty();
                    $("#lan1InterfaceCombo").append(optionsString);
                    optionsString += "<option value='none'>" + $("#js_none").text() + "</option>";
                    $("#lan2InterfaceCombo").append(optionsString);

                    for (var lanId in data.lans) {
                        $("#lan" + lanId + "InterfaceCombo option[value=" + data.lans[lanId].value + "]")
                            .attr("selected", true);
                    }

                    $("#trafficControlLan1Checkbox").attr("checked", data.tc_lan1);
                    $("#trafficControlLan2Checkbox").attr("checked", data.tc_lan2);

                    $("#lanFieldsetContentDiv button").unbind("click");
                    $("#lanFieldsetContentDiv button").click( function () {
                        var id = this.id.split("saveVlan")[1].substring(0,1);
                        var check_id = 1;
                        if (id == 1) {
                            check_id = 2;
                        }
                        var dataString = settings.buildLanDataString(id, check_id);
                        $.ajax({
                            type: "GET",
                            url: "/api/settings/certificate/check_distrib",
                            cache: false,
                            beforeSend: function () {
                                $("#lanFieldsetContentDiv").mask($("#js_loading").text());
                            },
                            success: function (data) {
                                if (data.distrib_status == false) {
                                    if (globals.variables.autoCertCreation) {
                                        settings.openLanRestartWarningModal(dataString, id, check_id, null);
                                    } else {
                                        $.ajax({
                                            type: "GET",
                                            url: "/api/services/dependency",
                                            data: "property=mapping_dependent",
                                            dataType: "json",
                                            cache: false,
                                            beforeSend: function () {
                                                $("#lanFieldsetContentDiv").mask($("#js_checkingDependencies").text());
                                            },
                                            success: function (data) {
                                                if (data.length > 0) {
                                                    settings.openLanRestartWarningModal(dataString, id, check_id, data);
                                                } else {
                                                    settings.saveLANSettings(dataString, id, check_id);
                                                }
                                            },
                                            complete: function () {
                                                $("#lanFieldsetContentDiv").unmask();
                                            }
                                        });
                                    }
                                } else {
                                    var actionHandlers = {};
                                    actionHandlers[$("#js_Ok").text()] = function() {
                                        $.modal.close();
                                    };
                                    var warning = $("#js_certDistribInProgress").text();
                                    globals.dialog.show(globals.dialog.WARNING, $("#js_warning").text(), warning,
                                        actionHandlers, "", false);
                                }
                            },
                            complete: function () {
                                $("#lanFieldsetContentDiv").unmask();
                            }
                        });
                    });

                    $("#lanFieldsetContentDiv").unmask();
                }
            });
        }
    };

    /**
     * Builds the data string to be used to configure an IP Office LAN
     *
     * @param id            LAN id
     * @param check_id      Id of the LAN to compare with
     */
    settings.buildLanDataString = function (id, check_id) {

        var dataString = "";
        dataString += "lan_id=" + id;
        dataString += "&eth_id=" + $("#lan" + id + "InterfaceCombo :selected").val();
        dataString += "&lan_check_id=" + check_id;
        if ($("#trafficControlLan" + id + "Checkbox").is(":checked")) {
            dataString += "&traffic_control=on";
        } else {
            dataString += "&traffic_control=off";
        }
        return dataString;

    };

    /**
     * Opens a modal that warns that the services which depend on LAN mapping
     * will be restarted after the LAN settings are applied.
     *
     * @param lanDataString         query string with LAN configuration.
     * @param id                    Id of the LAN to change.
     * @param check_id              Id of the other LAN.
     * @param dependentServices     Object array that contains the dependent services' ids and display_names
     */
    settings.openLanRestartWarningModal = function (lanDataString, id, check_id, dependentServices) {

        $('#lanRestartWarningModal').modal({
            closeHTML: "<a href='' title='" + $("#js_close").text() + "'></a>",
            overlayId: 'modal-overlay',
            containerId: 'lanRestartWarningModal-container',
            onShow: function () {

                if (dependentServices != null) {
                    var servicesString = dependentServices[0].display_name;
                    var dependentServicesIds = [];
                    dependentServicesIds.push(dependentServices[0].id);
                    if (dependentServices.length == 1) {
                        globals.functions.composeText("lanRestartWarningModalService",
                            "js_serviceLanRestart", [servicesString]);
                        $("#lanRestartWarningModalService").show();
                    } else {
                        for (var i = 1; i < dependentServices.length; i++) {
                            dependentServicesIds.push(dependentServices[i].id);
                            if (i == dependentServices.length-1) {
                                servicesString += " " + $("#js_and").text() + " " + dependentServices[i].display_name;
                            } else {
                                servicesString += ", " + dependentServices[i].display_name;
                            }
                        }
                        globals.functions.composeText("lanRestartWarningModalServices",
                            "js_servicesLanRestart", [servicesString]);
                        $("#lanRestartWarningModalServices").show();
                    }
                    lanDataString += "&services_ids=" + dependentServicesIds.join(",");
                } else {
                    lanDataString += "&create_cert=true";
                    if (!(globals.variables.serverType == "Primary"
                        || globals.variables.releaseType == "appl"
                        || globals.variables.releaseType == "apc")) {
                        lanDataString += "&self_signed=true"
                    }
                    $("#lanCertificateWarningModalServices").show();
                }

                //button click events
                $("#lanRestartWarningModalButtons button").unbind("click");
                $("#lanRestartWarningModalNo").click(function () {
                    $.modal.close();
                });
                $("#lanRestartWarningModalYes").click(function () {
                    $.modal.close();
                    settings.saveLANSettings(lanDataString, id, check_id);
                });

            }
        });

    };

    /**
     * Saves the LAN configuration changes
     *
     * @param lanDataString     Data string to send to the backend
     * @param id                Id of the changed LAN
     * @param check_id          Id of the LAN to compare to
     */
    settings.saveLANSettings = function (lanDataString, id, check_id) {

        $.ajax({
            type: "PUT",
            url: "/api/system/lan",
            data: lanDataString,
            timeout: globals.variables.SAVE_LAN_TIMEOUT,
            cache: false,
            beforeSend: function () {
                globals.functions.enableButton("saveVlan" + id + "SettingsButton", false, 
                        $("#js_save").text(), $("#js_saving").text());
                globals.functions.enableButton("saveVlan" + check_id + "SettingsButton", false);
            },
            success: function () {
                if (globals.variables.autoCertCreation) {
                    settings.updateCertificate("lanFieldsetContentDiv");
                }
            },
            complete: function () {
                globals.functions.enableButton("saveVlan" + id + "SettingsButton", true,
                        $("#js_save").text(), $("#js_saving").text());
                globals.functions.enableButton("saveVlan" + check_id + "SettingsButton", true);
            }
        });

    };

    /**
     * Builds the password rules settings fieldset
     */
    settings.buildPasswordRulesFieldset = function (showSettings) {
        if (showSettings) {
            $("#passwordRulesFieldset").removeClass("hiddenElement");
        }
        $.ajax({
            type: "GET",
            url: "/api/system/password_rules",
            dataType: "json",
            cache: false,
            error: function (xmlHttpReq, textStatus, errorThrown) {
                globals.functions.ajaxError(xmlHttpReq, textStatus, errorThrown);
                $("#passwordRulesFieldsetContentDiv").unmask();
                if (showSettings) {
                    $("#changeRootPassFieldsetContentDiv").unmask();
                    $("#changeLocalPassFieldsetContentDiv").unmask();
                }
            },
            beforeSend: function () {
                $("#passwordRulesFieldsetContentDiv").mask($("#js_loading").text());
                if (showSettings) {
                    $("#changeRootPassFieldsetContentDiv").mask($("#js_loading").text());
                    $("#changeLocalPassFieldsetContentDiv").mask($("#js_loading").text());
                }
            },
            success: function (data) {
                if (showSettings) {
                    $("#minPassLengthInput").val(data.min_length);
                    $("#minUppercaseInput").val(data.min_uppercase);
                    $("#minLowercaseInput").val(data.min_lowercase);
                    $("#minNumericInput").val(data.min_numeric);
                    $("#minSpecialInput").val(data.min_special);
                    $("#allowSequenceCheckbox").attr("checked", data.allow_sequence);
                    $("#maxSequenceInput").val(data.max_allowed_sequence);
                    $("#maxSequenceInput").attr("disabled", data.allow_sequence);

                    $("#allowSequenceCheckbox").unbind("change");
                    $("#allowSequenceCheckbox").change( function () {
                        $("#maxSequenceInput").attr("disabled", this.checked);
                    });

                    $("#savePasswordRulesButton").unbind("click");
                    $("#savePasswordRulesButton").click( function () {
                        settings.validatePasswordRules();
                    });
                }

                globals.functions.showHidePasswordRules(data);

                $("#passwordRulesFieldsetContentDiv").unmask();
                if (showSettings) {
                    $("#changeRootPassFieldsetContentDiv").unmask();
                    $("#changeLocalPassFieldsetContentDiv").unmask();
                }

            }
        });

    };

    /**
     * Checks if the fields of the password rules settings fieldset have valid values
     */
    settings.validatePasswordRules = function () {
        var minCharSum = parseInt($("#minUppercaseInput").val()) + parseInt($("#minLowercaseInput").val())
            + parseInt($("#minNumericInput").val()) + parseInt($("#minSpecialInput").val());
        if (!globals.validators.isNumeric($("#minPassLengthInput").val()) || $("#minPassLengthInput").val() < 1) {
            alert($("#js_invalidMinLength").text());
        } else if (!globals.validators.isNumeric($("#minUppercaseInput").val())) {
            alert($("#js_invalidMinUppercase").text());
        } else if (!globals.validators.isNumeric($("#minLowercaseInput").val())) {
            alert($("#js_invalidMinLowercase").text());
        } else if (!globals.validators.isNumeric($("#minNumericInput").val())) {
            alert($("#js_invalidMinNumeric").text());
        } else if (!globals.validators.isNumeric($("#minSpecialInput").val())) {
            alert($("#js_invalidMinSpecial").text());
        } else if (minCharSum > $("#minPassLengthInput").val()) {
            alert($("#js_minLengthTooSmall").text());
        } else if (!$("#allowSequenceCheckbox")[0].checked) {
            if (!globals.validators.isNumeric($("#maxSequenceInput").val()) || parseInt($("#maxSequenceInput").val()) < 2) {
                alert($("#js_invalidMaxSequenceLength").text());
            } else {
                settings.setPasswordRules();
            }
        } else {
           settings.setPasswordRules();
        }

    };

    /**
     * Applies the new password rules settings
     */
    settings.setPasswordRules = function () {

        var dataString = "";
        dataString += "min_length=" + $("#minPassLengthInput").val();
        dataString += "&min_uppercase=" + $("#minUppercaseInput").val();
        dataString += "&min_lowercase=" + $("#minLowercaseInput").val();
        dataString += "&min_numeric=" + $("#minNumericInput").val();
        dataString += "&min_special=" + $("#minSpecialInput").val();
        dataString += "&allow_sequence=" + $("#allowSequenceCheckbox")[0].checked;
        if ($("#allowSequenceCheckbox")[0].checked) {
            dataString += "&max_allowed_sequence=0";
        } else {
            dataString += "&max_allowed_sequence=" + $("#maxSequenceInput").val();
        }

        $.ajax({
            type: "PUT",
            url: "/api/system/password_rules",
            data: dataString,
            cache: false,
            beforeSend: function () {
                globals.functions.enableButton("savePasswordRulesButton", false, $("#js_save").text(),
                        $("#js_saving").text());
                $("#changeRootPassFieldsetContentDiv").mask($("#js_loading").text());
                $("#changeLocalPassFieldsetContentDiv").mask($("#js_loading").text());
            },
            success: function () {
                var data = {
                    min_length: $("#minPassLengthInput").val(),
                    min_uppercase: $("#minUppercaseInput").val(),
                    min_lowercase: $("#minLowercaseInput").val(),
                    min_numeric: $("#minNumericInput").val(),
                    min_special: $("#minSpecialInput").val(),
                    allow_sequence: $("#allowSequenceCheckbox")[0].checked,
                    max_allowed_sequence: $("#maxSequenceInput").val()
                };
                globals.functions.showHidePasswordRules(data);
            },
            complete: function () {
                globals.functions.enableButton("savePasswordRulesButton", true, $("#js_save").text(),
                        $("#js_saving").text());
                $("#changeRootPassFieldsetContentDiv").unmask();
                $("#changeLocalPassFieldsetContentDiv").unmask();
            }
        });

    };

    /**
     * Builds the Authentication fieldset (to manage referred authentication)
     */
    settings.buildAuthModeFieldset = function () {
        $("#authModeFieldset").show();
        $.ajax({
            type: "GET",
            url: "/setup/auth_mode",
            dataType: "json",
            cache: false,
            error: function (xmlHttpReq, textStatus, errorThrown) {
                globals.functions.ajaxError(xmlHttpReq, textStatus, errorThrown);
                $("#authModeFieldsetContentDiv").unmask();
            },
            beforeSend: function () {
                $("#authModeFieldsetContentDiv").mask($("#js_loading").text());
            },
            success: function (data) {
                $("#referredAuthCheckbox").attr("checked", data.referred);
            },
            complete : function (xhr) {
                $("#saveAuthModeButton").unbind("click");
                $("#saveAuthModeButton").click( function () {
                    if ( $("#referredAuthCheckbox").is(":checked") == 0) {
                        var warning = $("#js_referredwarn").text();
                        warning += "<br/>" + $("#js_continue").text();
                        var actionHandlers = {};
                        actionHandlers[$("#js_Yes").text()] = function() {
                            $.modal.close();
                            settings.setAuthMode();
                        };
                        actionHandlers[$("#js_No").text()] = function() {
                            $.modal.close();
                        };
                        globals.dialog.show(globals.dialog.WARNING, $("#js_warning").text(),
                            warning, actionHandlers, "", false);
                    } else {
                        settings.setAuthMode();
                    }
                });
                $("#authModeFieldsetContentDiv").unmask();
            }
        });
    };

    settings.setAuthMode = function () {
        var referred = $("#referredAuthCheckbox").is(":checked");
        $.ajax({
            type: "PUT",
            url: "/setup/auth_mode",
            data: "referred=" + referred,
            cache: false,
            error: function (xmlHttpReq, textStatus, errorThrown) {
                globals.functions.ajaxError(xmlHttpReq, textStatus, errorThrown);
                $("#authModeFieldsetContentDiv").unmask();
            },
            beforeSend: function () {
                $("#authModeFieldsetContentDiv").mask($("#js_loading").text());
            },
            success: function () {
                globals.dialog.showMessage(globals.dialog.INFO, $("#js_success").text(), $("#js_authModeSaved").text());
            },
            complete : function (xhr) {
                $("#authModeFieldsetContentDiv").unmask();
            }
        });
    };


    /**
     * Builds the Authentication fieldset (to manage referred authentication)
     */
    settings.buildHTTPServerFieldset = function () {
        $("#httpServerFieldset").show();
        $.ajax({
            type: "GET",
            url: "/api/system/httpserver",
            dataType: "json",
            cache: false,
            beforeSend: function () {
                $("#httpServerFieldsetContentDiv").mask($("#js_loading").text());
            },
            success: function (data) {
                $("#httpServerCheckbox").attr("checked", data.filestore);
            },
            complete : function (xhr) {
                $("#httpServerFieldsetContentDiv").unmask();
            }
        });

        $("#saveHttpServerButton").unbind("click");
        $("#saveHttpServerButton").click( function () {
            settings.setHTTPServerSettings();
        });
    };

    /**
     * Applies the HTTP Server settings.
     */
    settings.setHTTPServerSettings = function () {
        $.ajax({
            type: "PUT",
            url: "/api/system/httpserver",
            data: "enable=" + $("#httpServerCheckbox").is(":checked"),
            cache: false,
            beforeSend: function () {
                $("#httpServerFieldsetContentDiv").mask($("#js_loading").text());
                globals.functions.enableButton("saveHttpServerButton", false, $("#js_save").text(),
                    $("#js_saving").text());
            },
            complete : function () {
                $("#httpServerFieldsetContentDiv").unmask();
                globals.functions.enableButton("saveHttpServerButton", true, $("#js_save").text(),
                        $("#js_saving").text());
            }
        });
    };

    /**
     * Builds the Change Root Password fieldset
     */
    settings.buildChangeRootPasswordFieldset = function () {

        $("#changeRootPassFieldset").show();
        $("#saveRootPassButton").unbind("click");
        $("#saveRootPassButton").click( function () {
            var errMessage = null;
            if ($("#newRootPasswordInput").val() == "") {
                errMessage = $("#js_emptyNewPassword").text();
            } else if ($("#confirmRootPasswordInput").val() == "") {
                errMessage = $("#js_emptyConfirmPassword").text();
            } else if ($("#newRootPasswordInput").val() != $("#confirmRootPasswordInput").val()) {
                errMessage = $("#js_passwordsDoNotMatch").text();
            } else {
                settings.validatePassword("saveRootPassButton","oldRootPasswordInput","newRootPasswordInput", "root",
                    "confirmRootPasswordInput", "js_passwordChangeOk");
                return;
            }
            globals.dialog.showMessage(globals.dialog.ERROR, $("#js_warning").text(), errMessage);
        });
    };

    /**
     * Builds the Change Local Account Password fieldset
     */
    settings.buildChangeLocalPasswordFieldset = function () {

        $("#changeLocalPassFieldset").show();
        $("#saveLocalPassButton").unbind("click");
        $("#saveLocalPassButton").click( function () {
            var errMessage = null;
            if ($("#newLocalPasswordInput").val() == "") {
                errMessage = $("#js_emptyNewPassword").text();
            } else if ($("#confirmLocalPasswordInput").val() == "") {
                errMessage = $("#js_emptyConfirmPassword").text();
            } else if ($("#newLocalPasswordInput").val() != $("#confirmLocalPasswordInput").val()) {
                errMessage = $("#js_passwordsDoNotMatch").text();
            } else {
                settings.validatePassword("saveLocalPassButton","oldLocalPasswordInput", "newLocalPasswordInput", "Administrator",
                    "confirmLocalPasswordInput", "js_passwordLocalChangeOk");
                return;
            }
            globals.dialog.showMessage(globals.dialog.ERROR, $("#js_warning").text(), errMessage);
        });
    };

    /**
     * Checks if the password fulfills the minimum requirements
     */
    settings.validatePassword = function (buttonId,oldinputId, inputId, user, confirmId, messageId) {

        $.ajax({
            type: "GET",
            url: "/api/system/password_rules",
            dataType: "json",
            cache: false,
            error: function (xmlHttpReq, textStatus, errorThrown) {
                globals.functions.ajaxError(xmlHttpReq, textStatus, errorThrown);
                globals.functions.enableButton(buttonId, true, $("#js_save").text(),
                        $("#js_saving").text());
            },
            beforeSend: function () {
                globals.functions.enableButton(buttonId, false, $("#js_save").text(),
                        $("#js_saving").text());
            },
            success: function (data) {

                var passedLength = validatePassword($("#" + inputId).val(), {
                    length: [data.min_length, Infinity]
                });
                var passedUppercase = globals.functions.validateCharacterType(CodePointSets.UPPERCASE,
                    $("#" + inputId).val(), data.min_uppercase);
                var passedLowercase = globals.functions.validateCharacterType(CodePointSets.LOWERCASE,
                    $("#" + inputId).val(), data.min_lowercase);
                var passedNumeric = globals.functions.validateCharacterType(CodePointSets.NUMERIC,
                    $("#" + inputId).val(), data.min_numeric);
                var passedSpecial = globals.functions.validateCharacterType(CodePointSets.SPECIAL,
                    $("#" + inputId).val(), data.min_special);
                var passed_qwerty_sequence = true;
                var passed_ascii_sequence = true;
                if (!data.allow_sequence) {
                    passed_qwerty_sequence = validatePassword($("#" + inputId).val(), {
                        badSequenceLength: parseInt(data.max_allowed_sequence) + 1,
                        noQwertySequences: true
                    });
                    passed_ascii_sequence = globals.functions.checkIfAllowedSequence($("#" + inputId).val(),
                        parseInt(data.max_allowed_sequence));
                }
                if (passedLength && passedUppercase && passedLowercase && passedNumeric && passedSpecial
                        && passed_qwerty_sequence && passed_ascii_sequence) {
                    settings.setRootPassword(user, oldinputId, inputId, confirmId, buttonId, messageId);
                } else {
                    globals.functions.enableButton(buttonId, true, $("#js_save").text(),
                        $("#js_saving").text());
                    settings.openInvalidPasswordModal(data, passedLength, passedUppercase, passedLowercase, passedNumeric,
                            passedSpecial, passed_qwerty_sequence, passed_ascii_sequence);
                }

            },
            complete: function(xhr) {
                if (xhr.status != 200) {
                    globals.functions.enableButton(buttonId, true, $("#js_save").text(),
                        $("#js_saving").text());
                }
            }
        });

    };

    /**
     * Applies the new root password
     */
    settings.setRootPassword = function (user,oldinputId, inputId, confirmId, buttonId, messageId) {
        var dataString = "newpass=";
        dataString += encodeURIComponent($("#" + inputId).val());
        dataString += "&oldpass=";
        dataString += encodeURIComponent($("#" + oldinputId).val());
        dataString += "&user=" + user;
        $.ajax({
            type: "PUT",
            url: "/api/system/change_root_pass",
            data: dataString,
            cache: false,
            success: function (data) {
                globals.functions.enableButton(buttonId, true, $("#js_save").text(),
                        $("#js_saving").text());
                $("#" + oldinputId).val("");
                $("#" + inputId).val("");
                $("#" + confirmId).val("");
                if ( data.password_changed == true ) {
                    globals.dialog.showMessage(globals.dialog.NONE, $("#js_success").text(), $("#" + messageId).text());
                } else {
                    var actionHandlers = {};
                    actionHandlers[$("#js_Ok").text()] = function() {
                        $.modal.close();
                    };
                    globals.dialog.show(globals.dialog.ERROR, $("#js_error").text(),
                            $("#js_passwordsSetFail").text(), actionHandlers, "", false);
                }
            }
        });
    };

    /**
     * Opens a warning modal that shows the user which password restrictions are not fulfilled
     *
     * @param data                      Object containing the password rules.
     * Format:
     * {
     *      min_length: 8,
     *      min_uppercase: 0,
     *      min_lowercase: 0,
     *      min_numeric: 0,
     *      min_special: 0,
     *      allow_sequence: false,
     *      max_allowed_sequence: 4
     * }
     * @param passedLength              True if the length requirement is fulfilled.
     * @param passedUppercase           True if the uppercase characters requirement is fulfilled.
     * @param passedLowercase           True if the lowercase characters requirement is fulfilled.
     * @param passedNumeric             True if the numeric characters requirement is fulfilled.
     * @param passedSpecial             True if the special characters requirement is fulfilled.
     * @param passed_qwerty_sequence    True if the password doesn't contain qwerty sequences.
     * @param passed_ascii_sequence     True if the password doesn't contain ascii sequences.
     */
    settings.openInvalidPasswordModal = function (data, passedLength, passedUppercase, passedLowercase, passedNumeric,
                                                  passedSpecial, passed_qwerty_sequence, passed_ascii_sequence) {

        if (!passedLength) {
            $("#minPassLengthNumber").text(data.min_length);
            $("#minPassLengthLi").show();
        } else {
            $("#minPassLengthLi").hide();
        }

        if (!passedUppercase) {
            $("#minPassUppercaseNumber").text(data.min_uppercase);
            $("#minPassUppercaseLi").show();
        } else {
            $("#minPassUppercaseLi").hide();
        }

        if (!passedLowercase) {
            $("#minPassLowercaseNumber").text(data.min_lowercase);
            $("#minPassLowercaseLi").show();
        } else {
            $("#minPassLowercaseLi").hide();
        }

        if (!passedNumeric) {
            $("#minPassNumericNumber").text(data.min_numeric);
            $("#minPassNumericLi").show();
        } else {
            $("#minPassNumericLi").hide();
        }

        if (!passedSpecial) {
            $("#minPassSpecialNumber").text(data.min_special);
            $("#minPassSpecialLi").show();
        } else {
            $("#minPassSpecialLi").hide();
        }

        if (!passed_qwerty_sequence || !passed_ascii_sequence) {
            $("#maxPassSequenceNumber").text(data.max_allowed_sequence);
            $("#maxPassSequenceLi").show();
        } else {
            $("#maxPassSequenceLi").hide();
        }

        //button click events
        $("#invalidPasswordModalOk button").unbind("click");
        $("#invalidPasswordModalOk").click(function () {
            $.modal.close();
        });
        $('#invalidPasswordModal').modal({
            closeHTML: "<a href='' title='" + $("#js_close").text() + "'></a>",
            overlayId: 'modal-overlay',
            containerId: 'invalidPasswordModal-container'
        });

    };

    /**
     * Builds the licensing info portlet (system identification number and licensing mode)
     */
    settings.buildLicensingInfoFieldset = function () {
        $("#systemLicensingFieldset").show();
        $("#systemLicensingFieldsetContentDiv").mask($("#js_loading").text());
        $.ajax({
            type: "GET",
            cache: false,
            dataType: "json",
            url: globals.REST_URL.SID,
            error: function (xmlHttpReq, textStatus, errorThrown) {
                globals.functions.ajaxError(xmlHttpReq, textStatus, errorThrown);
                $("#systemLicensingFieldsetContentDiv").unmask();
            },
            success: function (data) {
                $("#systemIdDiv").text("" + data.SID);
            },
            complete: function () {
                $("#systemLicensingFieldsetContentDiv").unmask();
            }
        });
        $.ajax({
            type: "GET",
            url: globals.REST_URL.LICENCE,
            cache: false,
            timeout: globals.variables.GLOBAL_AJAX_TIMEOUT,
            error: function (xmlHttpReq, textStatus, errorThrown) {
                globals.functions.ajaxError(xmlHttpReq, textStatus, errorThrown);
                $("#systemLicensingFieldsetContentDiv").unmask();
            },
            success: function (data) {
                switch (data.licence_type) {
                    case "Internal":
                        $("#licensingModeDiv").text($("#js_licenseInternal").text());
                        break;
                    case "USB_Dongle":
                        $("#licensingModeDiv").text($("#js_licenseUSB").text());
                        break;
                }
            },
            complete: function () {
                $("#systemLicensingFieldsetContentDiv").unmask();
            }
        });
    };

    /**
     * Checks the ipoffice mode and builds the one-X Portal settings fieldset if necessary
     */
    settings.buildOneXConfigFieldset = function () {

        $("#oneXConfigFieldset").show();
        $.ajax({
            type: 'GET',
            url: globals.REST_URL.ONEX_CONFIG,
            cache: false,
            beforeSend: function () {
                $("#oneXConfigContentDiv").mask($("#js_loading").text());
            },
            success: function(data) {
                $("#useLocalCheckbox").attr("checked", data.use_local);
                $("#remoteIpInput").attr("disabled", data.use_local);
                $("#remoteIpDiv").toggle(!data.use_local);
                $("#remoteIpInput").val(data.onex_ip);

                $("#useLocalCheckbox").unbind("change");
                $("#useLocalCheckbox").change( function() {
                    $("#remoteIpInput").attr("disabled", this.checked);
                    $("#remoteIpDiv").toggle(!this.checked);
                });

                $("#saveOneXConfigSettings").unbind("click");
                $("#saveOneXConfigSettings").click( function () {
                    settings.saveOneXSettings();
                });
            },
            complete: function () {
                $("#oneXConfigContentDiv").unmask();
            }
        });

    };

    /**
     * Applies the one-X Portal settings
     */
    settings.saveOneXSettings = function () {
        var dataString = "";
        if ($("#useLocalCheckbox")[0].checked) {
            dataString += "onex_ip=";
        } else {
            if (globals.validators.isValidIPv4Address($("#remoteIpInput").val())) {
                dataString += "onex_ip=" + $("#remoteIpInput").val();
            } else {
                alert($("#js_invalidIP").text());
            }
        }
        if (dataString.length > 0) {
            $.ajax({
                type: "PUT",
                url: globals.REST_URL.ONEX_CONFIG,
                data: dataString,
                cache: false,
                beforeSend: function () {
                    globals.functions.enableButton("saveOneXConfigSettings",
                        false,
                        $("#js_save").text(),
                        $("#js_saving").text());
                },
                complete: function () {
                    globals.functions.enableButton("saveOneXConfigSettings",
                        true,
                        $("#js_save").text(),
                        $("#js_saving").text());
                }
            });
        }
    };

    /**
     * Build Syslog configuration fieldset.
     */
    settings.buildSyslogFieldset = function () {
        settings.adjustSyslogLayout();
        $("#syslogFieldset").show();

        settings.displaySyslogSettings();

        $("#syslogContentDiv .enableSyslogControls").unbind("change");
        $("#syslogContentDiv .enableSyslogControls").change( function () {
            if (this.id == "enableSyslogReceiver") {
                $("#receiverTcp").attr("disabled", !this.checked);
                $("#receiverUdp").attr("disabled", !this.checked);
                settings.enableSyslogReceiverControls();
            } else {
                $("#syslogContentDiv ." + this.name + "Control").attr("disabled", !this.checked);
                if (this.id == "enableForwarding1Destination") {
                    if (!this.checked) {
                        $("#enableForwarding2Destination").attr("checked", false);
                        $("#syslogContentDiv .forwarding2Control").attr("disabled", true);
                    }
                    $("#enableForwarding2Destination").attr("disabled", !this.checked);
                    $("#syslogFwDest1 > div").toggle($("#enableForwarding1Destination").attr("checked"));
                }
                if (this.id == "enableForwarding2Destination") {
                    $("#syslogFwDest2 > div").toggle($("#enableForwarding2Destination").attr("checked"));
                }
            }
        });

        $("#saveSyslogSettings").unbind("click");
        $("#saveSyslogSettings").click( function () {
            settings.saveSyslogSettings();
        });
    };

    /**
     * Gets syslog data and populates the syslog fields.
     */
    settings.displaySyslogSettings = function () {

        $.ajax({
            type: "GET",
            url: "/api/settings/syslog",
            dataType: "json",
            cache: false,
            beforeSend: function () {
                $("#syslogContentDiv").mask($("#js_loading").text());
            },
            success: function (data) {

                $("#syslogAgeInput").val(data.age);
                $("#syslogSizeInput").val(Math.round(data.max_size/(1024*1024)));
                $("#syslogSecurityAgeInput").val(data.security_age);
                $("#syslogSecuritySizeInput").val(Math.round(data.security_max_size/(1024*1024)));
                $("#syslogAuditAgeInput").val(data.audit_age);
                $("#syslogAuditSizeInput").val(Math.round(data.audit_max_size/(1024*1024)));
                $("#syslogOperationalAgeInput").val(data.operational_age);
                $("#syslogOperationalSizeInput").val(Math.round(data.operational_max_size/(1024*1024)));
                $("#syslogDebugAgeInput").val(data.debug_age);
                $("#syslogDebugSizeInput").val(Math.round(data.debug_max_size/(1024*1024)));

                $("#syslogPortTcpInput").val(data.port_tcp);
                $("#syslogPortTlsInput").val(data.port_tls);
                $("#syslogPortUdpInput").val(data.port_udp);
                if (!(data.port_tcp.length > 0 || data.port_udp.length > 0 || data.port_tls.length > 0)) {
                    $("#enableSyslogReceiver").attr("checked", false);
                }

                $("#selectSourceFieldset :checkbox").each(function () {
                    $("#" + this.id).attr("checked", false);
                    if (data.sources.indexOf(this.value) > -1) {
                        $("#" + this.id).attr("checked", true);
                    }
                });

                $("#applyFilesAge").unbind("change");
                $("#applyFilesAge").change( function () {
                    if (this.checked) {
                        $("#syslogLFA input:text").val($("#syslogAgeInput").val());
                    }
                });
                $("#applyFilesSize").unbind("change");
                $("#applyFilesSize").change( function () {
                    if (this.checked) {
                        $("#syslogMLS input:text").val($("#syslogSizeInput").val());
                    }
                });

                $("#syslogLFA input:text").unbind("keyup");
                $("#syslogLFA input:text").keyup( function () {
                    if ($("#applyFilesAge").is(":checked")) {
                        $("#syslogLFA input:text").val(this.value);
                    }
                });
                $("#syslogMLS input:text").unbind("keyup");
                $("#syslogMLS input:text").keyup( function () {
                    if ($("#applyFilesSize").is(":checked")) {
                        $("#syslogMLS input:text").val(this.value);
                    }
                });

                settings.enableSyslogReceiverControls();

                $("#receiverTcp").unbind("change");
                $("#receiverTcp").change( function () {
                    $("#syslogPortTcpInput").attr("disabled", !this.checked);
                });

                $("#receiverTls").unbind("change");
                $("#receiverTls").change( function () {
                    $("#syslogPortTlsInput").attr("disabled", !this.checked);
                });

                $("#receiverUdp").unbind("change");
                $("#receiverUdp").change( function () {
                    $("#syslogPortUdpInput").attr("disabled", !this.checked);
                });

                $("#forwarding1DestinationIpInput").val(data.otherapp1_ip);
                $("#forwarding1DestinationPortInput").val(data.otherapp1_port);
                if (!(data.otherapp1_ip.length > 0 && data.otherapp1_port.length > 0)) {
                    $("#enableForwarding1Destination").attr("checked", false);
                    $("#syslogContentDiv .forwarding1Control").attr("disabled", true);
                    $("#enableForwarding2Destination").attr("disabled", true);
                }
                $('#syslogFwDest1 :radio[value="' + data.otherapp1_protocol + '"]').attr("checked", true);
                $("#forwarding2DestinationIpInput").val(data.otherapp2_ip);
                $("#forwarding2DestinationPortInput").val(data.otherapp2_port);
                if (!(data.otherapp2_ip.length > 0 && data.otherapp2_port.length > 0)) {
                    $("#enableForwarding2Destination").attr("checked", false);
                    $("#syslogContentDiv .forwarding2Control").attr("disabled", true);
                }
                $('#syslogFwDest2 :radio[value="' + data.otherapp2_protocol + '"]').attr("checked", true);

                $("#syslogFwDest1 > div").toggle($("#enableForwarding1Destination").attr("checked"));
                $("#syslogFwDest2 > div").toggle($("#enableForwarding2Destination").attr("checked"));
            },
            complete : function () {
                $("#syslogContentDiv").unmask();
            }
        });

    };

    /**
     * Adjusts the syslog widget's layout depending on the way webcontrol is accessed.
     */
    settings.adjustSyslogLayout = function () {
        var cols = 3;
        var width = "30%";
        if (typeof globals.variables.REFERRER !== 'undefined') {
            $("#selectSourceFieldset li").each(function (idx) {
                $(this).css("width", "94%");
            });
            cols = 2;
            width = "46.5%";
        }
        $("#syslogLFA li").each(function (idx) {
            $(this).css("width", width);
            if ((idx % cols) == 0) {
                $(this).css("clear", "left");
            }
        });
        $("#syslogMLS li").each(function (idx) {
            $(this).css("width", width);
            if ((idx % cols) == 0) {
                $(this).css("clear", "left");
            }
        });
    };

    /**
     * Enables or disables syslog receiver TCP and UDP fields
     */
    settings.enableSyslogReceiverControls = function () {
        if ($("#enableSyslogReceiver").is(":checked")) {
            if ($("#syslogPortTcpInput").val().length > 0) {
                $("#syslogPortTcpInput").attr("disabled", false);
                $('#receiverTcp').attr("checked", true);
            } else {
                $("#syslogPortTcpInput").attr("disabled", true);
                $('#receiverTcp').attr("checked", false);
            }
            if ($("#syslogPortTlsInput").val().length > 0) {
                $("#syslogPortTlsInput").attr("disabled", false);
                $('#receiverTls').attr("checked", true);
            } else {
                $("#syslogPortTlsInput").attr("disabled", true);
                $('#receiverTls').attr("checked", false);
            }
            if ($("#syslogPortUdpInput").val().length > 0) {
                $("#syslogPortUdpInput").attr("disabled", false);
                $('#receiverUdp').attr("checked", true);
            } else {
                $("#syslogPortUdpInput").attr("disabled", true);
                $('#receiverUdp').attr("checked", false);
            }
            $("#syslogRSDetails").css("display", "table");
        } else {
            $("#syslogPortTcpInput").attr("disabled", true);
            $("#syslogPortUdpInput").attr("disabled", true);
            if ($("#syslogPortTcpInput").val().length > 0) {
                $('#receiverTcp').attr("checked", true);
            } else {
                $('#receiverTcp').attr("checked", false);
            }
            $("#syslogPortTlsInput").attr("disabled", true);
            $("#syslogPortUdpInput").attr("disabled", true);
            if ($("#syslogPortTlsInput").val().length > 0) {
                $('#receiverTls').attr("checked", true);
            } else {
                $('#receiverTls').attr("checked", false);
            }
            if ($("#syslogPortUdpInput").val().length > 0) {
                $('#receiverUdp').attr("checked", true);
            } else {
                $('#receiverUdp').attr("checked", false);
            }
            $("#syslogRSDetails").css("display", "none");
        }

    };

    /**
     * Saves syslog settings.
     */
    settings.saveSyslogSettings = function () {
        if (!globals.validators.isNumeric($("#syslogAgeInput").val())
            || $("#syslogAgeInput").val() <= 0 || $("#syslogAgeInput").val() > 365) {
            alert($("#js_syslogAgePositiveInteger").text());
        } else if (!globals.validators.isNumeric($("#syslogSecurityAgeInput").val())
            || $("#syslogSecurityAgeInput").val() <= 0 || $("#syslogSecurityAgeInput").val() > 365) {
            alert($("#js_syslogSecurityAgePositiveInteger").text());
        } else if (!globals.validators.isNumeric($("#syslogAuditAgeInput").val())
            || $("#syslogAuditAgeInput").val() <= 0 || $("#syslogAuditAgeInput").val() > 365) {
            alert($("#js_syslogAuditAgePositiveInteger").text());
        } else if (!globals.validators.isNumeric($("#syslogOperationalAgeInput").val())
            || $("#syslogOperationalAgeInput").val() <= 0 || $("#syslogOperationalAgeInput").val() > 365) {
            alert($("#js_syslogOperationalAgePositiveInteger").text());
        } else if (!globals.validators.isNumeric($("#syslogDebugAgeInput").val())
            || $("#syslogDebugAgeInput").val() <= 0 || $("#syslogDebugAgeInput").val() > 365) {
            alert($("#js_syslogDebugAgePositiveInteger").text());
        } else if (!globals.validators.isNumeric($("#syslogSizeInput").val())
            || $("#syslogSizeInput").val() == 0) {
            alert($("#js_syslogSizePositiveInteger").text());
        } else if (!globals.validators.isNumeric($("#syslogSecuritySizeInput").val())
            || $("#syslogSecuritySizeInput").val() == 0) {
            alert($("#js_syslogSecuritySizePositiveInteger").text());
        } else if (!globals.validators.isNumeric($("#syslogAuditSizeInput").val())
            || $("#syslogAuditSizeInput").val() == 0) {
            alert($("#js_syslogAuditSizePositiveInteger").text());
        } else if (!globals.validators.isNumeric($("#syslogOperationalSizeInput").val())
            || $("#syslogOperationalSizeInput").val() == 0) {
            alert($("#js_syslogOperationalSizePositiveInteger").text());
        } else if (!globals.validators.isNumeric($("#syslogDebugSizeInput").val())
            || $("#syslogDebugSizeInput").val() == 0) {
            alert($("#js_syslogDebugSizePositiveInteger").text());
        } else if (!$("#syslogPortTcpInput").is(':disabled') &&
            !globals.validators.isValidPort($("#syslogPortTcpInput").val())) {
            alert($("#js_invalidReceiverTcpPort").text());
        } else if (!$("#syslogPortTlsInput").is(':disabled') &&
            !globals.validators.isValidPort($("#syslogPortTlsInput").val())) {
            alert($("#js_invalidReceiverTlsPort").text());
        } else if (!$("#syslogPortUdpInput").is(':disabled') &&
            !globals.validators.isValidPort($("#syslogPortUdpInput").val())) {
            alert($("#js_invalidReceiverUdpPort").text());
        } else if (!$("#forwarding1DestinationIpInput").is(':disabled') &&
            !globals.validators.isValidIP($("#forwarding1DestinationIpInput").val())) {
            alert($("#js_invalidForwarding1Ip").text());
        } else if (!$("#forwarding1DestinationPortInput").is(':disabled') &&
            !globals.validators.isValidPort($("#forwarding1DestinationPortInput").val())) {
            alert($("#js_invalidForwarding1Port").text());
        } else if (!$('input[name="forwarding1DestinationProtocolInput"]').is(':disabled') &&
            $('input[name="forwarding1DestinationProtocolInput"]:checked').val() === undefined) {
            alert($("#js_invalidForwarding1Protocol").text());
        } else if (!$("#forwarding2DestinationIpInput").is(':disabled') &&
            !globals.validators.isValidIP($("#forwarding2DestinationIpInput").val())) {
            alert($("#js_invalidForwarding2Ip").text());
        } else if (!$("#forwarding2DestinationPortInput").is(':disabled') &&
            !globals.validators.isValidPort($("#forwarding2DestinationPortInput").val())) {
            alert($("#js_invalidForwarding2Port").text());
        } else if (!$('input[name="forwarding2DestinationProtocolInput"]').is(':disabled') &&
            $('input[name="forwarding2DestinationProtocolInput"]:checked').val() === undefined) {
            alert($("#js_invalidForwarding2Protocol").text());
        } else {
            var dataString = "";
            dataString += "age=" + $("#syslogAgeInput").val();
            dataString += "&max_size=" + globals.functions.parseBytes($("#syslogSizeInput").val() + "M");
            dataString += "&security_age=" + $("#syslogSecurityAgeInput").val();
            dataString += "&security_max_size=" + globals.functions.parseBytes($("#syslogSecuritySizeInput").val() + "M");
            dataString += "&audit_age=" + $("#syslogAuditAgeInput").val();
            dataString += "&audit_max_size=" + globals.functions.parseBytes($("#syslogAuditSizeInput").val() + "M");
            dataString += "&operational_age=" + $("#syslogOperationalAgeInput").val();
            dataString += "&operational_max_size=" + globals.functions.parseBytes($("#syslogOperationalSizeInput").val() + "M");
            dataString += "&debug_age=" + $("#syslogDebugAgeInput").val();
            dataString += "&debug_max_size=" + globals.functions.parseBytes($("#syslogDebugSizeInput").val() + "M");
            if ($("#enableSyslogReceiver").is(":checked")) {
                if ($("#receiverTcp").is(":checked")) {
                    dataString += "&port_tcp=" + $("#syslogPortTcpInput").val();
                }
                if ($("#receiverTls").is(":checked")) {
                    dataString += "&port_tls=" + $("#syslogPortTlsInput").val();
                }
                if ($("#receiverUdp").is(":checked")) {
                    dataString += "&port_udp=" + $("#syslogPortUdpInput").val();
                }
            }
            if ($("#enableForwarding1Destination").is(":checked")) {
                dataString += "&otherapp1_ip=" + $("#forwarding1DestinationIpInput").val();
                dataString += "&otherapp1_port=" + $("#forwarding1DestinationPortInput").val();
                dataString += "&otherapp1_protocol=" + $('input[name="forwarding1DestinationProtocolInput"]:checked').val();
            }
            if ($("#enableForwarding2Destination").is(":checked")) {
                dataString += "&otherapp2_ip=" + $("#forwarding2DestinationIpInput").val();
                dataString += "&otherapp2_port=" + $("#forwarding2DestinationPortInput").val();
                dataString += "&otherapp2_protocol=" + $('input[name="forwarding2DestinationProtocolInput"]:checked').val();
            }
            dataString += "&sources=";
            $("#selectSourceFieldset :checkbox").each( function (){
                if (this.checked) {
                    dataString += this.value + ",";
                }
            });
            $.ajax({
                type: "PUT",
                url: "/api/settings/syslog",
                data: dataString,
                timeout: globals.variables.SYSLOG_SETTINGS_TIMEOUT,
                cache: false,
                error: function (xmlHttpReq, textStatus, errorThrown) {
                    globals.functions.ajaxError(xmlHttpReq, textStatus, errorThrown);
                    globals.functions.enableButton("saveSyslogSettings",
                        true,
                        $("#js_save").text(),
                        $("#js_saving").text());
                },
                beforeSend: function () {
                    globals.functions.enableButton("saveSyslogSettings",
                        false,
                        $("#js_save").text(),
                        $("#js_saving").text());
                },
                complete: function () {
                    globals.functions.enableButton("saveSyslogSettings",
                        true,
                        $("#js_save").text(),
                        $("#js_saving").text());
                    settings.displaySyslogSettings();
                }
            });
        }
    };

    /**
     * Renders the hardware configuration fieldset
     */
    settings.buildHddConfigFieldset = function () {
        $("#hddConfigFieldset").show();
        $.ajax({
            type: "GET",
            url: "/api/system/newhw",
            dataType: "json",
            timeout: globals.variables.NEW_HARDWARE_TIMEOUT,
            cache: false,
            beforeSend: function () {
                $("#hddConfigContentDiv").mask($("#js_loading").text());
                $(".partitionElement").hide();
                $("#newHddSerialNumberElement").hide();
                $("#createPartitionsCheckbox").attr("checked", false);
            },
            success: function (data) {
                if (data.length > 0) {
                    var newHdd = data[0];
                    $("#noNewHardwareDiv").hide();
                    $("#newHardwareDetectedDiv").show();
                    $("#newHddName").text(newHdd.name);
                    $("#newHddType").text(newHdd.device_type);
                    $("#newHddProduct").text(newHdd.product);
                    $("#newHddVendor").text(newHdd.vendor);
                    $("#newHddCapacity").text(newHdd.user_capacity);
                    $("#newHddEffectiveCapacity").text(newHdd.remaining_space + $("#js_gb").text());
                    $("#mountPointInput").val(newHdd.root_mount_point);
                    $("#mountPartitionPoints").html(newHdd.partitions_mount_point.replace(/\n/g,'<br/>'));
                    $("#partition1Input").val(newHdd.remaining_space);
                    $("#partition2Input").val($("#js_noneNewHddLabel").text());
                    $("#partition3Input").val($("#js_noneNewHddLabel").text());
                    if (newHdd.serial_number !== undefined && newHdd.virtualized == false) {
                        $("#newHddSerialNumberElement").show();
                        $("#newHddSerialNumber").text(newHdd.serial_number);
                    }
                    settings.currentMountPoint = newHdd.root_mount_point;
                    settings.invalidMountPoints = newHdd.restricted_folders;
                    settings.default_mount_point_root = newHdd.default_mount_point;
                    settings.effectiveSpace = parseFloat(newHdd.remaining_space).toFixed(2);

                    $("#saveHddConfigSettings").unbind("click");
                    $("#saveHddConfigSettings").click( function () {
                        settings.saveHddSettings(newHdd.name);
                    });
                    $("#mountCheckbox").unbind("change");
                    $("#mountCheckbox").change( function() {
                        $("#mountPointInput").attr("disabled", !this.checked);
                    });
                    $("#createPartitionsCheckbox").unbind("change");
                    $("#createPartitionsCheckbox").change( function() {
                        if (this.checked) {
                            $(".partitionElement").show();
                        } else {
                            $(".partitionElement").hide();
                        }
                    });
                } else {
                    $("#newHardwareDetectedDiv").hide();
                    $("#noNewHardwareDiv").show();
                }
            },
            complete: function () {
                $("#hddConfigContentDiv").unmask();
            }
        });
    };

    /**
     * Checks if the mount path is not among the ones already in use by the system.
     */
    settings.validMountPoint = function () {
        var mountPoint = $("#mountPointInput").val();
        var root = settings.default_mount_point_root.split("#")[0];
        if (mountPoint.indexOf(root) == 0) {
            return true;
        }
        return false;
    };

    /**
     * Checks if user input in the partitions size fields is valid.
     */
    settings.validPartitions = function () {
        if ($("#createPartitionsCheckbox").is(":checked")) {
            var sum = 0;
            for (var i = 0; i < $(".partitionField").length; i++) {
                var field = $(".partitionField")[i];
                if (field.value != $("#js_noneNewHddLabel").text()) {
                    if (!globals.validators.isFloat(field.value)) {
                        alert($("#js_invalidSpaceValue").text().replace("%s0", field.name));
                        return false;
                    }
                    sum += parseFloat(field.value);
                }
            }
            if (sum == 0) {
                alert($("#js_pleaseAssignSpace").text());
                return false;
            } else if (sum > settings.effectiveSpace) {
                alert($("#js_spaceExceeded").text().replace("%s0", settings.effectiveSpace));
                return false;
            }
        }
        return true;
    };

    /**
     * Mounts/unmounts the additional hardware and creates partitions iof necessary.
     */
    settings.saveHddSettings = function (path) {
        if ($("#mountCheckbox").is(":checked") && $("#mountPointInput").val() == "") {
            alert($("#js_noMountPoint").text());
        } else if ($("#mountCheckbox").is(":checked") && !settings.validMountPoint()) {
            alert($("#js_invalidMountPoint").text().replace("%s0", settings.default_mount_point_root.split("#")[0]));
        } else if ($("#mountCheckbox").is(":checked") && $("#mountPointInput").val() == settings.currentMountPoint
            && !$("#createPartitionsCheckbox").is(":checked")) {
            // do nothing
        } else {
            var hddSettings = "";
            if ($("#mountCheckbox").is(":checked")) {
                hddSettings += "activate=True";
            } else {
                hddSettings += "activate=False";
            }
            hddSettings += "&mount_path=" + encodeURIComponent($("#mountPointInput").val());
            hddSettings += "&path=" + encodeURIComponent(path);
            if ($("#createPartitionsCheckbox").is(":checked")) {
                if (settings.validPartitions()) {
                    var unmountCommand = "activate=False";
                    unmountCommand += "&path=" + encodeURIComponent(path);
                    unmountCommand += "&mount_path=" + encodeURIComponent($("#mountPointInput").val());
                    $.ajax({
                        type: "PUT",
                        url: "/api/system/newhw",
                        data: unmountCommand,
                        timeout: globals.variables.NEW_HARDWARE_TIMEOUT,
                        cache: false,
                        beforeSend: function () {
                            globals.functions.enableButton("saveHddConfigSettings",
                                false,
                                $("#js_save").text(),
                                $("#js_saving").text());
                        },
                        complete: function (xhr) {
                            if (xhr.status != 200) {
                                globals.functions.enableButton("saveHddConfigSettings",
                                    true,
                                    $("#js_save").text(),
                                    $("#js_saving").text());
                            } else {
                                hddSettings += "&format_drive=True";
                                for (var i = 0; i < $(".partitionField").length; i++) {
                                    var field = $(".partitionField")[i];
                                    var index = i + 1;
                                    if (field.value == $("#js_noneNewHddLabel").text()) {
                                        hddSettings += "&partition" + index + "_size=0";
                                    } else {
                                        hddSettings += "&partition" + index + "_size=" + field.value;
                                    }
                                }
                                $.ajax({
                                    type: "POST",
                                    url: "/api/system/newhw",
                                    data: hddSettings + "&csrf_token="+$("#csrf_token").val(),
                                    timeout: globals.variables.NEW_HARDWARE_TIMEOUT,
                                    cache: false,
                                    complete: function () {
                                        globals.functions.enableButton("saveHddConfigSettings",
                                            true,
                                            $("#js_save").text(),
                                            $("#js_saving").text());
                                        settings.buildHddConfigFieldset();
                                    }
                                });
                            }
                        }
                    });
                }
            } else {
                $.ajax({
                    type: "PUT",
                    url: "/api/system/newhw",
                    data: hddSettings,
                    timeout: globals.variables.NEW_HARDWARE_TIMEOUT,
                    cache: false,
                    beforeSend: function () {
                        globals.functions.enableButton("saveHddConfigSettings",
                            false,
                            $("#js_save").text(),
                            $("#js_saving").text());
                    },
                    complete: function () {
                        globals.functions.enableButton("saveHddConfigSettings",
                            true,
                            $("#js_save").text(),
                            $("#js_saving").text());
                        settings.buildHddConfigFieldset();
                    }
                });
            }
        }
    };

    /**
     * Builds the Firewall Settings widget.
     */
    settings.buildFirewallFieldset = function () {
        $("#firewallFieldset").show();
        $.ajax({
            type: "GET",
            url: "/api/system/firewall",
            dataType: "json",
            cache: false,
            beforeSend: function () {
                $("#firewallFieldsetContentDiv").mask($("#js_loading").text());
            },
            success: function (data) {

                if (data.status == "on") {
                    $("#firewallStatusLabel").text($("#js_firewallOn").text());
                    $("#activateFirewallCheckbox").attr("checked", true);
                } else if (data.status == "off") {
                    $("#firewallStatusLabel").text($("#js_firewallOff").text());
                    $("#activateFirewallCheckbox").attr("checked", false);
                }

                if (data.ports.filtering == "true") {
                    $("#filteringFirewallCheckbox").attr("checked", true);
                } else {
                    $("#filteringFirewallCheckbox").attr("checked", false);
                }

                $("#enableTcpList").empty().append(settings.checkboxGroupList(
                    data.ports.default_tcp.split(","), 8, "enableTcp"));
                $("#enableUdpList").empty().append(settings.checkboxGroupList(
                    data.ports.default_udp.split(","), 8, "enableUdp"));

                $(".enableTcp").each( function () {
                    for (var i = 0; i < data.ports.allowed_tcp.split(",").length; i++) {
                        if (this.value == data.ports.allowed_tcp.split(",")[i]) {
                            $("#" + this.id).attr("checked", true);
                        }
                    }
                });
                $(".enableUdp").each( function () {
                    for (var i = 0; i < data.ports.allowed_udp.split(",").length; i++) {
                        if (this.value == data.ports.allowed_udp.split(",")[i]) {
                            $("#" + this.id).attr("checked", true);
                        }
                    }
                });
                var updatesPortEnabled = $("#enableTcp" + globals.variables.upgradesTcpPort).attr("checked");

                $("#saveFirewallSettingsButton").unbind("click");
                $("#saveFirewallSettingsButton").click( function () {
                    var filteringStatus = $("#filteringFirewallCheckbox").is(":checked");
                    var currentFilteringStatus = data.ports.filtering;
                    var actionHandlers = {};
                    actionHandlers[$("#js_Yes").text()] = function() {
                        settings.saveFirewallSettings();
                        $.modal.close();
                    };
                    actionHandlers[$("#js_No").text()] = function() {
                        $.modal.close();
                    };
                    var content = "";
                    if (filteringStatus == true && currentFilteringStatus == "false") {
                        content += $("#js_filteringPortConfigWarning").text();
                        content += "<br/><br/>";
                    }
                    if (!$("#enableTcp" + globals.variables.upgradesTcpPort).attr("checked") && updatesPortEnabled) {
                        content += $("#js_upgradesPortDisableWarning").text().replace("%s0", globals.variables.upgradesTcpPort);
                        content += "<br/><br/>";
                    }
                    if (content != "") {
                        content += $("#js_continue").text();
                        globals.dialog.show(globals.dialog.WARNING, $("#js_warning").text(), content,
                            actionHandlers, "", false);
                    } else {
                        settings.saveFirewallSettings();
                    }
                });
            },
            complete: function () {
                $("#firewallFieldsetContentDiv").unmask();
            }
        });
    };

    /**
     * Builds the Firewall Settings widget.
     */
    settings.buildAsgFieldset = function () {
        $.ajax({
            type: "GET",
            url: "/api/settings/asg",
            dataType: "json",
            cache: false,
            beforeSend: function () {
                $("#asgContentDiv").mask($("#js_loading").text());
            },
            success: function (data) {
                $('#asgContentDiv :radio[value="' + data.status + '"]').attr("checked", true);
                $("#asgPortInput").val(data.port);
                $("#asgPolicySelect option[value=" + data.listening + "]").attr("selected", true);
                $("#asfIdLabel").text(data.afs_id.replace(/\n/g,''));
                $("#selectEASGUser").empty();
                for (var i = 0; i < data.easgusers.length; i++) {
                    $("#selectEASGUser").append("<option id='" + i
                                    + "' value='" + data.easgusers[i]
                                    + "'>" + data.easgusers[i] + "</option>");
                }
                 
                $("#selectEASGUser option[value=" + data.easgusers[0]  +"]").attr('selected', true);
                $("#selectEASGUserState input").attr('checked', false);
                $("#selectEASGUserState input[value=" + data.easgusers_state[0]  +"]").attr('checked', true);
                var easgcerts = '';
                $("#selectEASGCerts").empty();
                for (var i = 0; i < data.easgcerts.length; i++) {
                    $("#selectEASGCerts").append("<option id='" + i
                                    + "' value='" + i
                                    + "'>" + data.easgcerts[i] + "</option>");
                }
  
                settings.currentAsgUsers = data.easgusers;
                settings.currentAsgUsersState = data.easgusers_state;
                settings.currentAsgCerts = data.easgcerts;
                settings.currentAsgPort = data.port;
                settings.currentAsgStatus = data.status;
                settings.currentAsgListening = data.listening;
                if (settings.currentAsgUsers.length == 0 ){
			$('#selectEASGUser').attr('disabled', 'disabled');
         		$('#selectEASGUserState input[name="EASGUserState"]').attr('disabled', 'disabled');
		}
                if (settings.currentAsgCerts.length == 0 ){
                        $('#selectEASGCerts').attr('disabled', 'disabled');
                        $('#asgDeleteSelectedCerts').attr('disabled', 'disabled');
                } else {
                        $('#selectEASGCerts').attr('enabled', 'enabled');
                        $('#asgDeleteSelectedCerts').attr('enabled', 'enabled');
                 }
                $("#saveAsgSettings").unbind("click");
                $("#saveAsgSettings").click( function () {
                    settings.processAsgSettings();
                });

                $("#asgBrowseButton").unbind("change");
                $("#asgBrowseButton").change( function () {
                    if (!globals.validators.isValidExtension(this.value, "p7b")) {
                        alert($("#js_invalidAsgCertFile").text());
                    } else {
                        $("#asgFakeFileField").val(this.value);
                    }
                });

                $("#asgUploadButton").unbind("click");
                $("#asgUploadButton").click( function () {
                    settings.uploadAsfFile();
                });

                $("#selectEASGUser").unbind("change");
                $("#selectEASGUser").change( function () {
                    $("#selectEASGUserState input").attr('checked', false);
                    var userId = $('option:selected',this).index();
                    $("#selectEASGUserState input[value=" + settings.currentAsgUsersState[userId]  +"]").attr('checked', true);
                    
                });
                $("#selectEASGUserState").unbind("change");
                $("#selectEASGUserState").change( function () {
                    var userId = $('#selectEASGUser option:selected').index();
                    var userName = settings.currentAsgUsersState[userId];
                    settings.processAsgUserStateChange($('#selectEASGUser option:selected').val(), $("input[checked]",this).val());
                });
                settings.lastAsgCert = "";
                settings.lastAsgCertPass = "";
                var options = {
                    data: "csrf_token="+$("#csrf_token").val(),
                    timeout: globals.variables.UPLOAD_AJAX_TIMEOUT,
                    url: "/api/settings/asg",
                    cache: false,
                    error: function () {
                        $("#asgContentDiv").unmask();
                        return false;
                    },
                    beforeSubmit: function () {
                        settings.lastAsgCert=$("#asgFakeFileField").val();
                        settings.lastAsgCertPass=$("#asgCertPassword").val();
                        if ( settings.lastAsgCertPass.length < 10 || settings.lastAsgCertPass.length > 20 ){
                             alert($("#js_invalidAsgPasswordLength").text());
                             return false;
                        }
                        $("#asgContentDiv").mask($("#js_uploading").text());
                    },
                    complete: function (xhr) {
                        if (xhr.status != 200) {
                            setTimeout(function () {
                                $("#asgContentDiv").unmask();
                                settings.buildAsgFieldset();
                            }, settings.asfUploadDelay);
                        }
                        return false;
                    },
                    success: function () {
                        $.ajax({
                            type: "GET",
                            url: "/api/settings/asg",
                            data: "password=" + encodeURIComponent(settings.lastAsgCertPass) + "&cert_name="+ settings.lastAsgCert,
                            cache: false,
                            success: function (data) {
                                $("#asgCertPassword").val("");
                                settings.buildAsgFieldset();
                                }
                        });
                        return false;
                    }, 
                    clearForm: true,
                    resetForm: true
                };
                $("#asgSubmitForm").ajaxForm(options);

                $("#asgUploadButton").unbind("click");
                $("#asgUploadButton").click( function (e){
                    if ($("#asgBrowseButton").val() == "") {
                        e.preventDefault();
                        var actionHandlers = {};
                        actionHandlers[$("#js_Ok").text()] = function() {
                            $.modal.close();
                        };
                        globals.dialog.show(globals.dialog.ERROR, $("#js_error").text(),
                            $("#js_noFileSelectedForUpload").text(), actionHandlers, "", false);
                    }
                });

                $("#asgResetButton").unbind("click");
                $("#asgResetButton").click( function () {
                    settings.resetAsg();
                });
                $("#asgDeleteSelectedCerts").unbind("click");
                $("#asgDeleteSelectedCerts").click( function () {
                        settings.deleteAsgCerts();
                });
                $("#asgViewSelectedCerts").unbind("click");
                $("#asgViewSelectedCerts").click( function () {
                        settings.viewAsgCerts();
                });
                if (settings.currentAsgCerts.length == 0 ){
                        $('#selectEASGCerts').attr('disabled', 'disabled');
                        globals.functions.enableButton("asgDeleteSelectedCerts", false);
                        globals.functions.enableButton("asgViewSelectedCerts", false);
                } else {
                        $('#selectEASGCerts').attr('enabled', 'enabled');
                        globals.functions.enableButton("asgDeleteSelectedCerts", true);
                        globals.functions.enableButton("asgViewSelectedCerts", true);
                }


            },
            complete: function () {
                $("#asgContentDiv").unmask();
            }
        });
    };

    /**
     * Resets the ASG packages.
     */
    settings.resetAsg = function() {
         $.ajax({
            type: "DELETE",
            url: "/api/settings/asg",
            cache: false,
            beforeSend: function () {
                globals.functions.enableButton("saveAsgSettings", false);
                $("#asgContentDiv").mask($("#js_loading").text());
            },
            complete: function () {
                globals.functions.enableButton("saveAsgSettings", true);
                $("#asgContentDiv").unmask();
                settings.buildAsgFieldset();
            }
        });
    };

    /*
     * Delete selected ASG certificates
     */
    settings.deleteAsgCerts = function() {
        var selectedCertIndex =  $('#selectEASGCerts option:selected').index();
        $.ajax({
            type: "PUT",
            url: "/api/settings/asg",
            data: "deletecert="+settings.currentAsgCerts[selectedCertIndex],
            cache: false,
            beforeSend: function () {
                globals.functions.enableButton("saveAsgSettings", false);
                $("#asgContentDiv").mask($("#js_loading").text());
            },
            complete: function () {
                    globals.functions.enableButton("saveAsgSettings", true);
                    $("#asgContentDiv").unmask();
                    settings.buildAsgFieldset();
            }
        });  
    };

    settings.viewAsgCerts = function() {
        var selectedCertIndex =  $('#selectEASGCerts option:selected').index();
        $.ajax({
            type: "GET",
            url: "/api/settings/asg",
            dataType: "json",
            data: "showcert="+settings.currentAsgCerts[selectedCertIndex],
            cache: false,
            success: function (received) {
                globals.dialog.showMessage(globals.dialog.INFO, settings.currentAsgCerts[selectedCertIndex], received.cert_text.replace(/\n/g,'<br/>'));

            }
        });
    };
    settings.acceptAsgterms = function(answer,status,port,listening) {
        var selectedAns = answer;
        var selectedStatus = status;
        var selectedPort = port;
        var selectedListening = listening;
        $.ajax({
            type: "GET",
            url: "/api/settings/asg",
            dataType: "json",
            data: "acceptterms="+ answer,
            cache: false,
            success: function () {
                if (selectedAns == "yes") {
                    settings.saveAsgSettings(selectedStatus,selectedPort,selectedListening)
                }
            }
        });
    };


    /**
     * Process ASG settings and show appropriate warnings.
     */
    settings.processAsgSettings = function () {
        var warning = "";
        var port = $("#asgPortInput").val();
        var listening = $("#asgPolicySelect :selected").val();
        var status = $('input[name="asgOption"]:checked').val();

        if (!globals.validators.isValidPort(port)) {
            alert($("#js_invalidAsgPort").text());
        } else {
            if (port != settings.currentAsgPort) {
                warning += $("#js_changeAsgPort").text() + "<br/>";
            }
            if (listening != settings.currentAsgListening && listening == "any") {
                warning += $("#js_changeAsgListening").text() + "<br/>";
            }
            if (warning != "") {
                warning += "<br/>" + $("#js_continue").text();
                var actionHandlers = {};
                actionHandlers[$("#js_Yes").text()] = function() {
                    $.modal.close();
                    settings.saveAsgSettings(status, port, listening);
                };
                actionHandlers[$("#js_No").text()] = function() {
                    $.modal.close();
                };
                globals.dialog.show(globals.dialog.WARNING, $("#js_warning").text(),
                    warning, actionHandlers, "", false);
            } else {
                settings.saveAsgSettings(status, port, listening);
            }
        }
    };

    /**
     * Saves the ASG settings
     *
     * @param status        New status of the ASG service.
     * @param port          New ASG port.
     * @param listening     New ASG listening policy.
     */
    settings.saveAsgSettings = function (status, port, listening) {
        var warning = $("#js_disabledAsgWarning").text() + "<br/>";
        if ( status == "disabled" && settings.currentAsgStatus == "enabled" ){
            var actionHandlers = {};
            actionHandlers[$("#js_Yes").text()] = function() {
                $.modal.close();
                settings.sendAsgChanges(status, port, listening);
            };
            actionHandlers[$("#js_No").text()] = function() {
                $.modal.close();
                globals.functions.enableButton("saveAsgSettings",
                    true,
                    $("#js_save").text(),
                    $("#js_saving").text());
                   settings.buildAsgFieldset();
            };
            warning += "<br/>" + $("#js_continue").text();
            globals.dialog.show(globals.dialog.WARNING, $("#js_warning").text(), warning, actionHandlers, "",
                 false);
        } else {
            settings.sendAsgChanges(status, port, listening);
        }
     };
     settings.sendAsgChanges = function(status,port,listening){
        $.ajax({
            type: "PUT",
            url: "/api/settings/asg",
            data: "status=" + status + "&port=" + port + "&listening=" + listening ,
            cache: false,
            beforeSend: function () {
                globals.functions.enableButton("saveAsgSettings",
                    false,
                    $("#js_save").text(),
                    $("#js_saving").text());
            },
            success: function (data) {
                if (data.enable_status == "terms issue"){
                    var actionHandlers = {};
                    actionHandlers[$("#js_Yes").text()] = function() {
                        settings.acceptAsgterms("yes",status,port,listening);
                        $.modal.close();
                    };
                    actionHandlers[$("#js_No").text()] = function() {
                        settings.acceptAsgterms("no",status,port,listening);
                        $.modal.close();
                        globals.functions.enableButton("saveAsgSettings",
                            true,
                            $("#js_save").text(),
                            $("#js_saving").text());
                        settings.buildAsgFieldset();
                    }
                    var message = $("#js_enabledAsgWarning").text() + "<br/>";
                    globals.dialog.show(globals.dialog.WARNING, $("#js_warning").text(), message, actionHandlers, "",
                        false);
                } else {
                    globals.functions.enableButton("saveAsgSettings",
                        true,
                        $("#js_save").text(),
                        $("#js_saving").text());
                        settings.buildAsgFieldset();
                }
            }
        });
    };
    settings.processAsgUserStateChange = function (username,state) {
         $.ajax({
            type: "PUT",
            url: "/api/settings/asg",
            data: "asgusername="+username+"&asguserstate="+state,
            cache: false,
            beforeSend: function () {
                globals.functions.enableButton("saveAsgSettings",
                    false,
                    $("#js_save").text(),
                    $("#js_saving").text());
                $('#selectEASGUser').attr('disabled', 'disabled');
                $('#selectEASGUserState input[name="EASGUserState"]').attr('disabled', 'disabled');
            },
            complete: function () {
                globals.functions.enableButton("saveAsgSettings",
                    true,
                    $("#js_save").text(),
                    $("#js_saving").text());
                $('#selectEASGUser').removeAttr('disabled');
                $('#selectEASGUserState input[name="EASGUserState"]').removeAttr('disabled');
                settings.buildAsgFieldset();
            }

        });
    };
    /**
     * Uploads an ASF file on the server.
     */
    settings.uploadAsfFile = function (){

    };

    /**
     * Builds a checkbox group HTML string based on a list.
     *
     * @param listArray          The list to use.
     * @param elementsPerRow     Number of checkboxes on a single row.
     * @param groupClass         Class name used to identify elements in this group.
     */
    settings.checkboxGroupList = function (listArray, elementsPerRow, groupClass) {

        if (listArray.length > 0) {
            var startIndex = 0;
            var endIndex = elementsPerRow;
            var listHtmlString = "";
            var numberOfRows = listArray.length / elementsPerRow +1;

            for (var i = 0; i < numberOfRows; i++) {
                if (endIndex > listArray.length) {
                    endIndex = listArray.length;
                }
                listHtmlString += "<li>";
                for (var j = startIndex; j < endIndex; j++) {
                    listHtmlString += "<span>";
                    listHtmlString += "<input type='checkbox' id='" + groupClass + listArray[j] + "' " +
                        "class='" + groupClass + "' value='" + listArray[j] + "'/>";
                    listHtmlString += "<label for='" +  groupClass + listArray[j] + "'>";
                    listHtmlString += listArray[j];
                    listHtmlString += "</label>";
                    listHtmlString += "</span>";
                }
                listHtmlString += "</li>";
                startIndex += elementsPerRow;
                endIndex += startIndex;
            }
            return listHtmlString;

        } else {
            return "";
        }
    };

    /**
     * Saves the firewall settings
     */
    settings.saveFirewallSettings = function () {
        var firewallDataString = "activate=" + $("#activateFirewallCheckbox").is(":checked");
        var tcpEnableList = "";
        var udpEnableList = "";

        firewallDataString += "&filtering=" + $("#filteringFirewallCheckbox").is(":checked");

        $(".enableTcp").each( function () {
            if (this.checked) {
                tcpEnableList += "," + this.value;
            }
        });
        $(".enableUdp").each( function () {
            if (this.checked) {
                udpEnableList += "," + this.value;
            }
        });
        if (tcpEnableList.indexOf(",") > -1) {
            tcpEnableList = tcpEnableList.substring(tcpEnableList.indexOf(",") + 1);
        }
        if (udpEnableList.indexOf(",") > -1) {
            udpEnableList = udpEnableList.substring(udpEnableList.indexOf(",") + 1);
        }
        firewallDataString += "&enable_tcp=" + tcpEnableList + "&enable_udp=" + udpEnableList;

        $.ajax({
            type: "PUT",
            url: "/api/system/firewall",
            data: firewallDataString,
            cache: false,
            beforeSend: function () {
                globals.functions.enableButton("saveFirewallSettingsButton",
                    false,
                    $("#js_save").text(),
                    $("#js_saving").text());
            },
            complete: function () {
                globals.functions.enableButton("saveFirewallSettingsButton",
                    true,
                    $("#js_save").text(),
                    $("#js_saving").text());
                settings.buildFirewallFieldset();
            }
        });
    };

    /**
     * Builds the certificate settings fieldset
     */
    settings.buildCertificatesFieldset = function () {

        if (!(globals.variables.serverType == "Primary"
            || globals.variables.releaseType == "appl"
            || globals.variables.releaseType == "apc")) {
            $("#securityCaSettings").hide();
            $("#createForDifferentMachineUl").hide();
            $("#certificateSettingsUl").hide();
            $("#certificateButtonsDiv button").hide();
            $(".downloadIdCert").show();
        }

        $.ajax({
            type: "GET",
            url: "/api/system/password_rules",
            dataType: "json",
            cache: false,
            beforeSend: function () {
                $("#settingsCertContentDiv").mask($("#js_loading").text());
            },
            success: function (data) {
                settings.certificatePasswordRules = data;
                globals.functions.showHidePasswordRules(data);
            },
            complete: function () {
                $.ajax({
                    type: "GET",
                    url: "/api/settings/certificate/generate",
                    timeout: globals.variables.CERTIFICATE_DEFAULTS_TIMEOUT,
                    cache: false,
                    success: function (data) {
                        $("#autoCertCheckbox").attr("checked", data.auto_generate);
                        if (data.auto_generate) {
                            $("#regenerateWarning").show();
                            $("#noRegenerateWarning").hide();
                        } else {
                            $("#regenerateWarning").hide();
                            $("#noRegenerateWarning").show();
                        }
                        if (globals.variables.serverType == "Primary"
                            || globals.variables.releaseType == "appl"
                            || globals.variables.releaseType == "apc") {
                            $("#certSubjectInput").val(data.subject);
                            $("#certAltSubjectInput").val(data.subject_alt_name);
                            $("#certDurationInput").val(data.validity);
                            $("#rsaSelect option[value=" + data.rsa_key_length + "]").attr("selected", true);
                            $("#shaSelect option[value=" + data.sha_version.split("-sha")[1] + "]").attr("selected", true);
                        }
                    },
                    complete: function () {
                        $("#settingsCertContentDiv").unmask();
                    }
                });
            }
        });

        $("#differentMachineCheckbox").attr("checked", false);
        $(".certDifferentMachineElement").hide();
        $("#certPasswordRulesContainer input").val("");

        if (globals.variables.serverType == "Primary"
            || globals.variables.releaseType == "appl"
            || globals.variables.releaseType == "apc") {
            if ($("#importCa").is(":checked")) {
                $("#caSubmitForm").parent().show();
                $("#generateRootCA").parent().hide();
                $("#exportCaPassword").parent().hide();
            } else if ($("#exportCa").is(":checked")) {
                $("#caSubmitForm").parent().hide();
                $("#generateRootCA").parent().hide();
                $("#exportCaPassword").parent().show();
            } else {
                $("#caSubmitForm").parent().hide();
                $("#generateRootCA").parent().show();
                $("#exportCaPassword").parent().hide();
            }

            $("#caBrowseButton").unbind("change");
            $("#caBrowseButton").change( function () {
                $("#caFakeFileField").val(this.value);
            });

            $("#differentMachineCheckbox").unbind("change");
            $("#differentMachineCheckbox").change( function () {
                if (this.checked) {
                    $(".certDifferentMachineElement").show();
                    $("#generateCertificate").text($("#js_generateLabel").text());
                } else {
                    $("#generateCertificate").text($("#js_generateApplyLabel").text());
                    $(".certDifferentMachineElement").hide();
                }
            });

            $("input[name='caOption']").unbind("change");
            $("input[name='caOption']").change(function() {
                var importCa = $("#importCa").is(":checked");
                var exportCa = $("#exportCa").is(":checked");
                if (importCa) {
                    $("#caSubmitForm").parent().show();
                    $("#generateRootCA").parent().hide();
                    $("#exportCaPassword").parent().hide();
                } else if (exportCa) {
                    $("#caSubmitForm").parent().hide();
                    $("#generateRootCA").parent().hide();
                    $("#exportCaPassword").parent().show();
                } else {
                    $("#caSubmitForm").parent().hide();
                    $("#generateRootCA").parent().show();
                    $("#exportCaPassword").parent().hide();
                }
            });

            $("#exportRootCA").unbind("click");
            $("#exportRootCA").click( function () {
                if (settings.validateExportCaPassword()) {
                    $.ajax({
                        type: "PUT",
                        url: "/api/settings/certificate/ca",
                        cache: false,
                        data: "pkcs_12=true&password=" + encodeURIComponent($("#exportCaPasswordInput").val()),
                        beforeSend: function () {
                            $("#settingsCertContentDiv").mask($("#js_loading").text());
                        },
                        success: function () {

                            var actionHandlers = {};
                            actionHandlers[$("#js_Ok").text()] = function() {
                                $.ajax({
                                    type: "DELETE",
                                    url: "/api/settings/certificate/ca/root-ca-p12",
                                    cache: false,
                                    complete: function () {
                                        $.modal.close();
                                    }
                                });
                            };
                            var content = "";
                            content += $("#js_caExported").text();
                            content += " ";
                            content += "<a href='/api/settings/certificate/ca/root-ca-p12'>";
                            content += "root-ca-p12";
                            content += "</a>";
                            content += "<br/>";
                            content += $("#js_caWillBeDeleted").text();
                            globals.dialog.show(globals.dialog.WARNING, $("#js_warning").text(),
                                content, actionHandlers, "", false);

                            $("#settingsCertContentDiv").unmask();
                            $("#exportCaPasswordInput").val("");
                            $("#confirmExportCaPasswordInput").val("");

                        }
                    });
                }
            });

            $("#generateRootCA").unbind("click");
            $("#generateRootCA").click( function () {
                var actionHandlers = {};
                actionHandlers[$("#js_Yes").text()] = function() {
                    $.modal.close();
                    if ($("#autoCa").is(":checked")) {
                        $.ajax({
                            type: "PUT",
                            url: "/api/settings/certificate/ca",
                            cache: false,
                            beforeSend: function () {
                                $("#settingsCertContentDiv").mask($("#js_loading").text());
                            },
                            success: function () {
                                var actionHandlers = {};
                                actionHandlers[$("#js_Ok").text()] = function() {
                                    $.modal.close();
                                };
                                globals.dialog.show(globals.dialog.WARNING, $("#js_warning").text(),
                                    $("#js_newCaAvailable").text(), actionHandlers, "", false);
                                $("#settingsCertContentDiv").unmask();
                            }
                        });
                    } else if ($("#regenerateCa").is(":checked")) {
                        $.ajax({
                            type: "PUT",
                            url: "/api/settings/certificate/ca",
                            data: "regenerate=true",
                            cache: false,
                            beforeSend: function () {
                                $("#settingsCertContentDiv").mask($("#js_loading").text());
                            },
                            success: function () {
                                var actionHandlers = {};
                                actionHandlers[$("#js_Ok").text()] = function() {
                                    $.modal.close();
                                };
                                globals.dialog.show(globals.dialog.WARNING, $("#js_warning").text(),
                                    $("#js_newCaAvailable").text(), actionHandlers, "", false);
                                $("#settingsCertContentDiv").unmask();
                            }
                        });
                    }
                };
                actionHandlers[$("#js_No").text()] = function() {
                    $.modal.close();
                };
                var warning = ""
                if ($("#regenerateCa").is(":checked")) {
                    warning = $("#js_regenerateCaWarning").text() + "<br/>" + $("#js_continue").text();
                } else {
                    warning = $("#js_newCaWarning").text() + "<br/><br/>";
                    warning += $("#js_newCaTcs").text() + "<br/><br/>";
                    warning += $("#js_continue").text();
                }
                globals.dialog.show(globals.dialog.WARNING, $("#js_warning").text(), warning, actionHandlers, "", false);
            });

            $(".downloadRootCA").unbind("click");
            $(".downloadRootCA").click( function () {
                if ($("#autoCa").is(":checked") || $("#regenerateCa").is(":checked")) {
                    location.href = "/api/settings/certificate/ca/root-ca." + this.name;
                }
            });

            var options = {
                data: "csrf_token="+$("#csrf_token").val(),
                timeout: globals.variables.UPLOAD_AJAX_TIMEOUT,
                error: function () {
                    $("#ignitionSecurityDiv").unmask();
                    return false;
                },
                beforeSubmit: function () {
                    $("#ignitionSecurityDiv").mask($("#js_uploading").text());
                },
                success: function () {
                    $.ajax({
                        type: "GET",
                        url: "/api/settings/certificate/ca",
                        data: "password=" + encodeURIComponent($("#caPasswordInput").val()),
                        cache: false,
                        success: function (data) {
                            $("#caPasswordInput").val("");
                            if (data.import_status == "invalid password") {
                                var actionHandlers = {};
                                actionHandlers[$("#js_Ok").text()] = function() {
                                    $.modal.close();
                                };
                                globals.dialog.show(globals.dialog.ERROR, $("#js_error").text(),
                                    $("#js_invalidCaPassword").text(), actionHandlers, "", false);
                            } else if (data.import_status == "invalid file") {
                                var actionHandlers = {};
                                actionHandlers[$("#js_Ok").text()] = function() {
                                    $.modal.close();
                                };
                                globals.dialog.show(globals.dialog.ERROR, $("#js_error").text(),
                                    $("#js_invalidCaFile").text(), actionHandlers, "", false);
                            } else {
                                var actionHandlers = {};
                                actionHandlers[$("#js_Ok").text()] = function() {
                                    $.modal.close();
                                };
                                globals.dialog.show(globals.dialog.WARNING, $("#js_warning").text(),
                                    $("#js_newCaImported").text(), actionHandlers, "", false);
                            }
                        },
                        complete: function () {
                            $("#ignitionContentDiv").unmask();
                        }
                    });
                    return false;
                },
                complete: function (xhr) {
                    if (xhr.status != 200) {
                        $("#ignitionContentDiv").unmask();
                    }
                    return false;
                },
                clearForm: true,
                resetForm: true
            };
            $("#caSubmitForm").ajaxForm(options);

            $("#caUploadButton").click( function (e, options){
                options = options || {};
                if ($("#caBrowseButton").val() == "") {
                    e.preventDefault();
                    var actionHandlers = {};
                    actionHandlers[$("#js_Ok").text()] = function() {
                        $.modal.close();
                    };
                    globals.dialog.show(globals.dialog.ERROR, $("#js_error").text(),
                        $("#js_noFileSelectedForImport").text(), actionHandlers, "", false);
                } else if ($("#caPasswordInput").val() == "") {
                    e.preventDefault();
                    var actionHandlers = {};
                    actionHandlers[$("#js_Ok").text()] = function() {
                        $.modal.close();
                    };
                    globals.dialog.show(globals.dialog.ERROR, $("#js_error").text(),
                        $("#js_noCaPassword").text(), actionHandlers, "", false);
                } else {
                    if (!options.warningsDone) {
                        e.preventDefault();
                        var actionHandlers = {};
                        actionHandlers[$("#js_Yes").text()] = function() {
                            $.modal.close();
                            $("#caSubmitForm").trigger("submit", {"warningsDone": true});
                        };
                        actionHandlers[$("#js_No").text()] = function() {
                            $.modal.close();
                        };
                        var warning = $("#js_newCaWarning").text() + "<br/>" + $("#js_continue").text();
                        globals.dialog.show(globals.dialog.WARNING, $("#js_warning").text(), warning, actionHandlers, "", false);
                    }
                }
            });

            $("#generateCertificate").unbind("click");
            $("#generateCertificate").click( function () {
                if (settings.validCertificate()) {
                    if ($("#differentMachineCheckbox").is(":checked")) {
                        settings.generateCertificate();
                    } else {
                        $.ajax({
                            type: "GET",
                            url: "/api/settings/certificate/check_distrib",
                            cache: false,
                            beforeSend: function () {
                                $("#settingsCertContentDiv").mask($("#js_loading").text());
                            },
                            success: function (data) {
                                var actionHandlers = {};
                                var warning = "";
                                if (data.distrib_status == false) {
                                    actionHandlers = {};
                                    actionHandlers[$("#js_Yes").text()] = function() {
                                        $.modal.close();
                                        settings.generateCertificate();
                                    };
                                    actionHandlers[$("#js_No").text()] = function() {
                                        $.modal.close();
                                    };
                                    warning = $("#js_newIdCertWarning").text() + "<br/>" + $("#js_continue").text();
                                    globals.dialog.show(globals.dialog.WARNING, $("#js_warning").text(), warning,
                                        actionHandlers, "", false);
                                } else {
                                    actionHandlers = {};
                                    actionHandlers[$("#js_Ok").text()] = function() {
                                        $.modal.close();
                                    };
                                    warning = $("#js_certDistribInProgress").text();
                                    globals.dialog.show(globals.dialog.WARNING, $("#js_warning").text(), warning,
                                        actionHandlers, "", false);
                                }
                            },
                            complete: function () {
                                $("#settingsCertContentDiv").unmask();
                            }
                        });
                    }
                }
            });
        }

        $(".downloadIdCert").unbind("click");
        $(".downloadIdCert").click( function () {
            location.href = "/api/settings/certificate/generate/cert." + this.name;
        });

        $("#autoCertCheckbox").unbind("change");
        $("#autoCertCheckbox").change( function () {
            if (this.checked) {
                $("#regenerateWarning").show();
                $("#noRegenerateWarning").hide();
            } else {
                $("#regenerateWarning").hide();
                $("#noRegenerateWarning").show();
            }
            $.ajax({
                type: "POST",
                url: "/api/settings/certificate/generate",
                cache: false,
                data: "auto_generate=" + this.checked + "&csrf_token="+$("#csrf_token").val(),
                beforeSend: function () {
                    $("#settingsCertContentDiv").mask($("#js_loading").text());
                },
                success: function () {
                    globals.variables.autoCertCreation = $("#autoCertCheckbox").is(":checked");
                },
                complete: function () {
                    $("#settingsCertContentDiv").unmask();
                }
            });
        });

    };

    /**
     * Performs certificate validations.
     */
    settings.validCertificate = function() {
        var duration = $("#certDurationInput").val();
        if (!globals.validators.isNumeric(duration) || !(parseInt(duration) > 0)) {
            alert($("#js_invalidDuration").text());
        } else if ($("#differentMachineCheckbox").is(":checked")) {
            return settings.validCertificateDifferentMachine();
        } else {
            return true;
        }
        return false;
    };

    /**
     * Generates the certificate.
     */
    settings.generateCertificate = function () {
        var dataString = "";
        dataString += "subject=" + $("#certSubjectInput").val();
        dataString += "&alt_subject=" + $("#certAltSubjectInput").val();
        dataString += "&duration=" + $("#certDurationInput").val();
        dataString += "&rsa=" + $("#rsaSelect option:selected").val();
        dataString += "&sha=" + $("#shaSelect option:selected").val();
        if ($("#differentMachineCheckbox").is(":checked")) {
            dataString += "&ip=" + $("#machineIpInput").val();
            dataString += "&encrypted=true";
            dataString += "&password=" + encodeURIComponent($("#certPasswordInput").val());
        }
        $.ajax({
            type: "PUT",
            url: "/api/settings/certificate/generate",
            data: dataString,
            cache: false,
            beforeSend: function () {
                $("#settingsCertContentDiv").mask($("#js_loading").text());
            },
            success: function (data) {
                var actionHandlers = {};
                if ($("#differentMachineCheckbox").is(":checked")) {
                    actionHandlers[$("#js_Ok").text()] = function() {
                        $.ajax({
                            type: "DELETE",
                            url: "/api/settings/certificate/generate/" + data.name,
                            cache: false,
                            complete: function () {
                                $.modal.close();
                            }
                        });
                    };
                    var content = "";
                    content += $("#js_useLinkToDownloadCert").text().replace("%s0", $("#machineIpInput").val());
                    content += "<br/>";
                    content += "<a href='/api/settings/certificate/generate/" + data.name + "'>";
                    content += data.name;
                    content += "</a>";
                    content += "<br/>";
                    content += $("#js_certWillBeDeleted").text();
                    globals.dialog.show(globals.dialog.WARNING, $("#js_warning").text(),
                        content, actionHandlers, "", false);
                    $("#settingsCertContentDiv").unmask();
                } else {
                    settings.updateCertificate("settingsCertContentDiv");
                }
            },
            complete: function(xhr) {
                if (xhr.status != 200) {
                    $("#settingsCertContentDiv").unmask();
                }
            }
        });
    };

    /**
     * Performs password validation for the encrypted CA.
     */
    settings.validateExportCaPassword = function () {

        var passwordField = $("#exportCaPasswordInput").val();
        var confirmPasswordField = $("#confirmExportCaPasswordInput").val();
        if (passwordField == "") {
            alert($("#js_emptyCaPassword").text());
        } else if (confirmPasswordField == "") {
            alert($("#js_emptyConfirmCaPassword").text());
        } else if (passwordField != confirmPasswordField) {
            alert($("#js_passwordsDoNotMatch").text());
        } else if (settings.certificatePasswordRules != null) {
            return settings.validPassword(passwordField);
        } else {
            return true;
        }
        return false;

    };

    /**
     * Checks if the password fulfills the current restrictions.
     */
    settings.validPassword = function (passwordField) {
        var passedLength = validatePassword(passwordField, {
            length: [settings.certificatePasswordRules.min_length, Infinity]
        });
        var passedUppercase = validatePassword(passwordField, {
            upper: settings.certificatePasswordRules.min_uppercase
        });
        var passedLowercase = validatePassword(passwordField, {
            lower: settings.certificatePasswordRules.min_lowercase
        });
        var passedNumeric = validatePassword(passwordField, {
            numeric: settings.certificatePasswordRules.min_numeric
        });
        var passedSpecial = validatePassword(passwordField, {
            special: settings.certificatePasswordRules.min_special
        });
        var passed_qwerty_sequence = true;
        var passed_ascii_sequence = true;
        if (!settings.certificatePasswordRules.allow_sequence) {
            passed_qwerty_sequence = validatePassword(passwordField, {
                badSequenceLength: parseInt(settings.certificatePasswordRules.max_allowed_sequence) + 1,
                noQwertySequences: true
            });
            passed_ascii_sequence = globals.functions.checkIfAllowedSequence(passwordField,
                parseInt(settings.certificatePasswordRules.max_allowed_sequence));
        }
        if (passedLength && passedUppercase && passedLowercase && passedNumeric && passedSpecial
                && passed_qwerty_sequence && passed_ascii_sequence) {
             return true;
        } else {
            settings.openInvalidPasswordModal(settings.certificatePasswordRules, passedLength, passedUppercase,
                passedLowercase, passedNumeric, passedSpecial, passed_qwerty_sequence, passed_ascii_sequence);
            return false;
        }
    };

    /**
     * Performs IP and password validations for a certificate created for another machine.
     */
    settings.validCertificateDifferentMachine = function() {
        var ipRestriction = settings.ipFromAltSubject($("#certAltSubjectInput").val());
        var otherMachineIp = $("#machineIpInput").val();
        var passwordField = $("#certPasswordInput").val();
        var confirmPasswordField = $("#confirmCertPasswordInput").val();
        if (!globals.validators.isValidIP(otherMachineIp)) {
            alert($("#js_invalidMachineIp").text());
        } else if (ipRestriction != "" && ipRestriction != otherMachineIp) {
            alert($("#js_changeRemoveIpRestriction").text());
        } else if (passwordField == "") {
            alert($("#js_emptyCertPassword").text());
        } else if (confirmPasswordField == "") {
            alert($("#js_emptyConfirmCertPassword").text());
        } else if (passwordField != confirmPasswordField) {
            alert($("#js_passwordsDoNotMatch").text());
        } else if (settings.certificatePasswordRules != null) {
            return settings.validPassword(passwordField);
        } else {
            return true;
        }
        return false;
    };

    /**
     * Creates the increase partition fieldset
     */
    settings.buildIncreasePartitionFieldset = function () {
        $("#increasePartitionFieldset").show();
        $.ajax({
            type: "GET",
            url: "/api/settings/partition_size",
            cache: false,
            beforeSend: function () {
                $("#increasePartitionFieldsetContentDiv").mask($("#js_loading").text());
            },
            success: function (data) {
                if (data.available_size > 0) {
                    var bytesValue = globals.functions.parseBytes(data.available_size + "M");
                    var parsedValue = globals.functions.bytesToSize(bytesValue, 2);
                    $("#increasePartitionStatus").text($("#js_partitionIncreasePossible").text()
                        .replace("%s0", parsedValue));
                    globals.functions.enableButton("increasePartitionButton", true);
                } else {
                    $("#increasePartitionStatus").text($("#js_noPartitionSpace").text());
                    globals.functions.enableButton("increasePartitionButton", false);
                }
            },
            complete : function () {
                $("#increasePartitionFieldsetContentDiv").unmask();
            }
        });

        $("#increasePartitionButton").unbind("click");
        $("#increasePartitionButton").click( function () {
            var confirm_msg = $("#js_partitionIncreaseBackup").text();
            confirm_msg += "<br/>" + $("#js_partitionIncreaseReboot").text();
            confirm_msg += "<br/><br/>" + $("#js_redirectToLogin").text();
            confirm_msg += $("#js_pleaseWaitRebootComplete").text();
            confirm_msg += "<br/><br/>" + $("#js_continue").text();

            var actionHandlers = {};
            actionHandlers[$("#js_Yes").text()] = function() {
                $.modal.close();
                settings.increaseRootPartition();
            };
            actionHandlers[$("#js_No").text()] = function() {
                $.modal.close();
            };
            globals.dialog.show(globals.dialog.WARNING, $("#js_warning").text(), confirm_msg, actionHandlers, "", false);
        });
    };

    /**
     * Applies the root partition increase
     */
    settings.increaseRootPartition = function () {
        $.ajax({
            type: "GET",
            url: "/api/system/flag",
            data: "flag_id=" + globals.variables.increasePartitionFlag,
            cache: false,
            beforeSend: function () {
                $("#increasePartitionFieldsetContentDiv").mask($("#js_loading").text());
            },
            success: function (data) {
                if (data == true) {
                    var actionHandlers = {};
                    actionHandlers[$("#js_Ok").text()] = function() {
                        $.modal.close();
                    };
                    globals.dialog.show(globals.dialog.ERROR, $("#js_error").text(),
                        $("#js_expandPartitionInProgress").text(), actionHandlers, "", false);
                    $("#increasePartitionFieldsetContentDiv").unmask();
                } else {
                    $.ajax({
                        type: "PUT",
                        url: "/api/services",
                        data: "action=stop",
                        cache: false,
                        timeout: globals.variables.STOP_ALL_SERVICES_TIMEOUT,
                        beforeSend: function () {
                            $("#increasePartitionFieldsetContentDiv").mask($("#js_StoppingServices").text());
                        },
                        success: function () {
                            $.ajax({
                                type: "PUT",
                                url: "/api/settings/partition_size",
                                data: "",
                                cache: false,
                                beforeSend: function () {
                                    $("#increasePartitionFieldsetContentDiv").mask($("#js_IncreasingPartition").text());
                                },
                                success: function () {
                                    $.ajax({
                                        type: 'PUT',
                                        url: '/api/system/status',
                                        data: 'restart=true',
                                        timeout: globals.variables.REBOOT_SHUTDOWN_TIMEOUT,
                                        beforeSend: function () {
                                            $("#increasePartitionFieldsetContentDiv").mask($("#js_RebootSystem").text());
                                        },
                                        success: function() {
                                            $.ajax({
                                                type: 'DELETE',
                                                url: '/api/session',
                                                complete: function() {
                                                    globals.functions.handleRedirection
                                                        (globals.variables.REDIRECT_REBOOT_SHUTDOWN);
                                                }
                                            });
                                        }
                                    });
                                }
                            });
                        }
                    });
                }
            }
        });
    };

    /**
     * Parses the IP restriction value from an altSubject string
     *
     * @param altSubject    String composed of comma separated properties.
     *                      Example: URI.1:iposerver-00:0c:29:bb:0f:bf.avaya.com, IP.1:192.168.127.147
     */
    settings.ipFromAltSubject = function (altSubject) {
        var ip = "";
        if (altSubject.length == 0) {
            return ip;
        }
        var restrictions = altSubject.split(",");
        for (var i = 0; i < restrictions.length; i++) {
            var value = restrictions[i].split(":")[1].trim();
            if (globals.validators.isValidIP(value)) {
                ip = value;
                break;
            }
        }
        return ip;
    };

    /**
     * Builds the Package Capture Settings fieldset.
     */
    settings.buildTcpdumpsFieldset = function () {
        $.ajax({
            type: "GET",
            url: "/api/settings/tcpdumps",
            dataType: "json",
            cache: false,
            beforeSend: function () {
                $("#tcpdumpsContentDiv").mask($("#js_loading").text());
            },
            success: function (data) {
                $("#tcpdumpsMaxSizeInput").val(data.max_size);
                $("#tcpdumpsMaxNumberInput").val(data.max_number);
                var totalSize = parseInt(data.total_size/1024);
                if (totalSize < 0) {
                    totalSize = 0;
                }
                $("#tcpdumpsMaxTotalSize").text(totalSize);

                globals.functions.enableButton("tcpdumpsStopButton", data.is_running);
                globals.functions.enableButton("tcpdumpsStartButton", !data.is_running);

                if (data.is_running) {
                    $("#tcpdumpsStatusLabel").text($("#js_running").text());
                } else {
                    $("#tcpdumpsStatusLabel").text($("#js_stopped").text());
                }

                var interfaces = '<option value="all">' + $("#js_All").text() + '</option>';
                for (var i = 0; i < data.interfaces.length; i++) {
                    interfaces += '<option value="' + data.interfaces[i] + '">';
                    interfaces += data.interfaces[i];
                    interfaces += '</option>';
                }
                $("#tcpdumpsInterfaceSelect").empty().append(interfaces);
            },
            complete: function () {
                $("#tcpdumpsContentDiv").unmask();
            }
        });

        $("#tcpdumpsStartButton").unbind("click").click( function () {

            var maxSize = $("#tcpdumpsMaxSizeInput").val();
            var maxNumber = $("#tcpdumpsMaxNumberInput").val();
            var interfaceName = $("#tcpdumpsInterfaceSelect").val();
            var totalSize = $("#tcpdumpsMaxTotalSize").text();

            if (!globals.validators.isNumeric(maxSize) || maxSize <= 0 || maxSize > 2000) {
                alert($("#js_invalidMaxSize").text());
            } else if (!globals.validators.isNumeric(maxNumber) || maxNumber <= 0) {
                alert($("#js_invalidMaxNumber").text());
            } else if (parseInt(maxNumber) * parseInt(maxSize) > parseInt(totalSize)) {
                alert($("#js_totalSizeExceeded").text());
            } else {
                var warningHTML = $("#js_packetDeleteWarning").text();
                warningHTML += "<br/><br/>" + $("#js_continue").text();
                var warningHandlers = {};
                warningHandlers[$("#js_Yes").text()] = function() {
                    $.modal.close();
                    settings.startTcpdumps();
                };
                warningHandlers[$("#js_No").text()] = function() {
                    $.modal.close();
                };
                globals.dialog.show(globals.dialog.WARNING, $("#js_warning").text(), warningHTML, warningHandlers, false);
            }

        });

        $("#tcpdumpsStopButton").unbind("click").click( function () {
            settings.stopTcpdumps();
        });
    };

    /**
     * Starts package capture with the user's preferences.
     */
    settings.startTcpdumps = function () {
        var dataString = "";
        dataString += "interface=" + $("#tcpdumpsInterfaceSelect").val();
        dataString += "&max_size=" + $("#tcpdumpsMaxSizeInput").val();
        dataString += "&max_number=" + $("#tcpdumpsMaxNumberInput").val();
        $.ajax({
            type: "PUT",
            url: "/api/settings/tcpdumps",
            data: dataString,
            cache: false,
            beforeSend: function () {
                $("#tcpdumpsContentDiv").mask($("#js_loading").text());
            },
            complete: function () {
                $("#tcpdumpsContentDiv").unmask();
                settings.buildTcpdumpsFieldset();
            }
        });
    };

    /**
     *  Stops package capture.
     */
    settings.stopTcpdumps = function () {
        $.ajax({
            type: "DELETE",
            url: "/api/settings/tcpdumps",
            cache: false,
            beforeSend: function () {
                $("#tcpdumpsContentDiv").mask($("#js_loading").text());
            },
            complete: function () {
                $("#tcpdumpsContentDiv").unmask();
                settings.buildTcpdumpsFieldset();
            }
        });
    };

    /**
     * Renders a sub tab from the Settings tab.
     *
     * @param subTabName sub tab to render.
     */
    settings.renderSubtab = function (subTabName) {
        if (subTabName == "generalSettings") {
            if (globals.variables.hasAdminRights) {
                settings.buildUpdatesFieldset();
                settings.buildWatchdogFieldset();
                if (globals.variables.serverType == "Primary" || globals.variables.serverType == "OneX") {
                    settings.buildOneXConfigFieldset();
                }
                settings.buildWebcontrolFieldset();
                if (typeof globals.variables.REFERRER === 'undefined') {
                    settings.buildBackupAndRestoreFieldset();
                }
                settings.buildDebugFieldset();

                if (globals.variables.hasSecurityRights && globals.variables.hasAsg ==  "true") {
                     settings.buildAsgFieldset();
                } else {
                     $("#asgFieldset").hide();
                }
                settings.buildCsipoDebugFieldset();
                settings.buildIraDebugFieldset();
                settings.buildBannerFieldset();
                settings.buildTcpdumpsFieldset();
                if (globals.variables.serverType == "Primary" || globals.variables.serverType == "Secondary"
                    || globals.variables.releaseType == "appl" || globals.variables.releaseType == "apc") {
                    settings.buildSyslogFieldset();
                    $("#watchdogFieldset").appendTo($("#generalSettingsRightDiv"));
                    $("#loginBannerFieldset").appendTo($("#generalSettingsRightDiv"));
                    if (globals.variables.serverType == "Primary") {
                        $("#oneXConfigFieldset").appendTo($("#generalSettingsRightDiv"));
                    }
                }

            } else {
                $("#updatesFieldset").hide();
                $("#asgFieldset").hide();
            }
            if (globals.variables.hasSecurityRights) {
                settings.buildCertificatesFieldset();
            } else {
                $("#settingsCertFieldset").hide();
            }
        } else if (subTabName == "systemSettings") {
            settings.getDateReady = false;
            settings.getTimezonesReady = false;
            settings.getNtpReady = false;
            if (globals.variables.hasAdminRights) {
                settings.buildNetworkFieldset();
                settings.buildDateFieldset();
                settings.buildHddConfigFieldset();
                settings.buildFirewallFieldset();
                settings.buildHTTPServerFieldset();
                if (globals.variables.releaseType == "abe") {
                    settings.buildLicensingInfoFieldset();
                }
                settings.buildVLANFieldset();
                if (globals.variables.isVirtual) {
                    settings.buildIncreasePartitionFieldset();
                }
            }
            if (globals.variables.hasSecurityRights) {
                settings.buildAuthModeFieldset();
                settings.buildPasswordRulesFieldset(typeof globals.variables.REFERRER === 'undefined');
                settings.buildChangeRootPasswordFieldset();
                settings.buildChangeLocalPasswordFieldset();
            }
        }
    };

    try {
        for (var pluginName in globals.plugins) {
            if (globals.plugins[pluginName].tabsHandler) {
                globals.plugins[pluginName].tabsHandler("settings", settings);
            }
        }
    } catch(err) {}

    var filter = ":first";
    /**
     * Makes an ajax request and calls the render sub tab function when a sub tab is clicked.
     */
    $("#settingsTabs li a").click(function (e) {
    
        e.preventDefault();
        if (settings.tab != this.name) {
            $("#settingsTabs li a").removeClass("selected");
            $(this).addClass("selected");

            if (this.name == "generalSettings") {
                $("#generalSettingsDiv").removeClass("hiddenElement");
                $("#systemSettingsDiv").addClass("hiddenElement");
            } else if (this.name == "systemSettings") {
                $("#systemSettingsDiv").removeClass("hiddenElement");
                $("#generalSettingsDiv").addClass("hiddenElement");
            }
            settings.renderSubtab(this.name);
            settings.tab = this.name;
        }
                
    }).filter(filter).click();

});
