/*
 * Copyright 2010 Avaya Inc. All Rights Reserved.
 */

$(document).ready(function () {
    
    var updates = {};

    updates.viewedServicesTable = false;

    updates.servicesVersions = [];
    updates.simultaneousUpdates = 0;

    updates.osInfoReady = false;
    updates.updatesInfoReady = false;

    updates.doSystemRefresh = true;
    updates.showRestartModal = false;
    updates.updatesInProgress = false;

    updates.intervalActive = false;
    updates.appsIntervalActive = false;
    updates.finishedUpdating = false;

    updates.webcontrolData = {};
    updates.webcontrolValue = null;

    updates.stoppedServicesArray = [];
    updates.stoppedServicesVersion = [];
    updates.stoppedServicesOperation = [];
    updates.updateServicesArray = [];

    updates.webcontrolRestartCounter = 20;

    updates.tableResizeHandler = null;
    updates.fixedHeaderTables = [];

    updates.addFixedTableHeader = function(tableId) {
        updates.fixedHeaderTables.push(tableId);
    };

    /*
    updates.updateServicesTableDivHeight = parseInt($(window).height() - $("#updateServicesContentDiv").offset().top
        - $("#updateServicesFieldset .groupHeader").outerHeight() - 10 - $("#updateSystemFieldset").outerHeight());
    */
    updates.updateServicesTableDivHeight = parseInt($(window).height() - $("#updateServicesContentDiv").offset().top - 16);
    if (updates.updateServicesTableDivHeight > 80) {
        $("#updateServicesTableDiv").css("max-height", "" + updates.updateServicesTableDivHeight + "px");
    } else {
        $("#updateServicesTableDiv").css("height", "" + updates.updateServicesTableDivHeight + "px");
    }
    $("#updateServicesTableDiv").addClass("scroll");


    /**
     * Builds the update services fieldset.
     * Assigns click events to the buttons.
     */
    updates.buildUpdateServicesFieldset = function () {

        updates.getServicesVersionsData();

        $("#checkServicesUpdatesButtonDiv button").unbind("click");
        $("#checkServicesUpdatesButton").click( function() {
            updates.getServicesVersionsData();
        });
        $("#updateAllServicesButton").click( function() {
            updates.stoppedServicesArray = [];
            updates.stoppedServicesVersion = [];
            updates.stoppedServicesOperation = [];
            updates.updateServicesArray = [];
            var servicesToUpdate = [];
            var latestVersions = [];
            for (var i = 0; i < updates.servicesVersions.length; i++) {
                var application = updates.servicesVersions[i];
                if (application.status == ServiceVersionStatus.OUT_OF_DATE && application.change_version_supported) {
                    if (application.id.indexOf("webcontrol") > -1) {
                        globals.variables.upgradeWebcontrol = true;
                    } else {
                        updates.updateServicesArray.push(application);
                        servicesToUpdate.push(application.id);
                        latestVersions.push(application.latest_version);
                    }
                }
            }

            updates.checkPackagesDependencies(servicesToUpdate, "updateAll", latestVersions);

        });
        $("#clearLocalCacheButton").click( function() {
            updates.openClearCacheWarningModal();
        });
    };

    /**
     * Checks services status and updates the number of simultaneous system updates to do
     *
     * @param serviceId     The service to check
     * @param version       The version of the service
     */
    updates.checkManagedServicesStatus = function (serviceId, version) {
        $.ajax({
            type: "GET",
            url: "/api/service",
            dataType: "json",
            data: "name=" + serviceId,
            cache: false,
            error: function (xmlHttpReq, textStatus, errorThrown) {
                if (xmlHttpReq.status == 404) {
                    updates.simultaneousUpdates++;
                    $("#updateServicesContentDiv").unmask();
                    if (updates.simultaneousUpdates == updates.updateServicesArray.length) {
                        updates.doUpdateAll();
                    }
                } else {
                    globals.functions.ajaxError(xmlHttpReq, textStatus, errorThrown);
                    $("#updateServicesContentDiv").unmask();
                }
            },
            beforeSend: function () {
                $("#updateServicesContentDiv").mask($("#js_checkingState").text());
            },
            success: function (data) {
                $("#updateServicesContentDiv").unmask();
                switch(data.run_info.state) {
                    case ServiceState.RUNNING:
                    case ServiceState.STOPPING:
                    case ServiceState.STARTING:
                        globals.functions.composeText("stopServiceWarningModalName",
                            "js_serviceIsRunning", [data.display_name]);
                        var confirmText = $("#stopServiceWarningModalName").text() + "\n";
                        confirmText += $("#stopServiceWarningModalServiceUpdate").text().trim() + "\n\n";
                        confirmText += $("#stopServiceWarningModalContinue").text();
                        var stopService = confirm(confirmText);
                        if (stopService) {
                            /*if (data.restart_required) {
                                updates.stopManagedService(serviceId, version, "stop");
                            } else {*/
                                updates.simultaneousUpdates++;
                                if (updates.simultaneousUpdates == updates.updateServicesArray.length) {
                                    updates.doUpdateAll();
                                }
                            //}
                        } else {
                            updates.removeFromUpdatesArray(serviceId);
                            if (updates.simultaneousUpdates == updates.updateServicesArray.length &&
                                    updates.updateServicesArray.length > 0) {
                                updates.doUpdateAll();
                            }
                        }
                        break;
                    case ServiceState.STOPPED:
                    case ServiceState.UNKNOWN:
                        updates.simultaneousUpdates++;
                        if (updates.simultaneousUpdates == updates.updateServicesArray.length) {
                            updates.doUpdateAll();
                        }
                        break;
                }
            },
            complete : function (xhr) {
                if (xhr.status != 200 && xhr.status != 404) {
                    $("#updateServicesContentDiv").unmask();
                }
            }
        });
    };

    /**
     * Stops a service before calling the update all function
     *
     * @param serviceId     Service to stop
     * @param version       Latest version of the service
     * @param action        Stop or forcestop the service
     */
    updates.stopManagedService = function (serviceId, version, action) {

        var loadingText = "";
        if (action == "stop") {
            loadingText = $("#js_stoppingService").text();
        } else if (action == "forcestop") {
            loadingText = $("#js_forceStoppingService").text();
        }
        $.ajax({
            type: 'PUT',
            url : "/api/service",
            cache: false,
            data: "name=" + serviceId + "&action=" + action + "&csrf_token="+$("#csrf_token").val(),
            error: function (xmlHttpReq, textStatus, errorThrown) {
                globals.functions.ajaxError(xmlHttpReq, textStatus, errorThrown);
                $("#updateServicesContentDiv").unmask();
            },
            beforeSend: function () {
                $("#updateServicesContentDiv").mask(loadingText);
            },
            success: function () {
                updates.stoppedServicesArray.push(serviceId);
                updates.stoppedServicesVersion.push(version);
                delayFunction = function () {
                    var currentService = updates.stoppedServicesArray.shift();
                    var versionToApply = updates.stoppedServicesVersion.shift();
                    $("#updateServicesContentDiv").unmask();
                    if (action == "forcestop") {
                        updates.simultaneousUpdates ++;
                        if (updates.simultaneousUpdates == updates.updateServicesArray.length) {
                            updates.doUpdateAll();
                        }
                    } else if (action == "stop") {
                        $.ajax({
                            type: "GET",
                            url: "/api/service",
                            dataType: "json",
                            data: "name=" + currentService,
                            cache: false,
                            error: function (xmlHttpReq, textStatus, errorThrown) {
                                globals.functions.ajaxError(xmlHttpReq, textStatus, errorThrown);
                                $("#updateServicesContentDiv").unmask();
                            },
                            beforeSend: function () {
                                $("#updateServicesContentDiv").mask($("#js_checkingState").text());
                            },
                            success: function (data) {
                                $("#updateServicesContentDiv").unmask();
                                switch (data.run_info.state) {
                                    case ServiceState.RUNNING:
                                    case ServiceState.STOPPING:
                                        updates.stopManagedService(currentService, versionToApply, "forcestop");
                                        break;
                                    case ServiceState.STOPPED:
                                        updates.simultaneousUpdates ++;
                                        if (updates.simultaneousUpdates == updates.updateServicesArray.length) {
                                            updates.doUpdateAll();
                                        }
                                        break;
                                }
                            },
                            complete : function (xhr) {
                                if (xhr.status != 200) {
                                    $("#updateServicesContentDiv").unmask();
                                }
                            }
                        });
                    }
                };
                setTimeout("delayFunction()", 10000);

            },
            complete : function (xhr) {
                if (xhr.status != 200) {
                    $("#updateServicesContentDiv").unmask();
                }
            }
        });

    };

    /**
     * Removes a service from the updateServicesArray
     *
     * @param serviceId     The service to be removed
     */
    updates.removeFromUpdatesArray = function(serviceId) {

        for (var i = 0; i < updates.updateServicesArray.length; i++) {
            if (serviceId == updates.updateServicesArray[i].id) {
                updates.updateServicesArray.splice(i, 1);
                break;
            }
        }

    };

    /**
     * Updates all out of date services
     */
    updates.doUpdateAll = function () {

        var packages = [];
        var versions = [];
        globals.variables.appUpdateThreads++;
        if (globals.variables.appUpdateThreads == 1) {

            for (var i = 0; i < updates.updateServicesArray.length; i++) {
                packages.push(updates.updateServicesArray[i].id);
                versions.push(updates.updateServicesArray[i].latest_version);
            }

            $.ajax({
                type: "PUT",
                url: "/api/updates/applications/all",
                data: "packages=" + packages.join(",") + "&versions=" + versions.join(",") + "&csrf_token="+$("#csrf_token").val(),
                cache: false,
                error: function (xmlHttpReq, textStatus, errorThrown) {
                    globals.functions.ajaxError(xmlHttpReq, textStatus, errorThrown);
                    $("#updateServicesContentDiv").unmask();
                },
                beforeSend: function () {
                    $("#updateServicesContentDiv").mask($("#js_updating").text());
                },
                success: function () {
                    updates.getApplicationsStatusInfo();
                }
            });
            
        }

    };

    /**
     * Checks the status of the update thread
     */
    updates.getApplicationsStatusInfo = function () {

        $.ajax({
            type: "GET",
            url: "/api/updates/applications/all/status",
            dataType: "json",
            cache: false,
            beforeSend: function () {
                $("#updateServicesContentDiv").mask($("#js_updating").text());
            },
            error: function (xmlHttpReq, textStatus, errorThrown) {
                globals.functions.ajaxError(xmlHttpReq, textStatus, errorThrown);
                $("#updateServicesContentDiv").unmask();
            },
            success: function (data) {
                if (!data.in_progress) {
                    $("#updateServicesContentDiv").unmask();
                    if (globals.variables.startStoppedServices) {
                        updates.startStoppedServices();
                    } else {
                        if (globals.variables.upgradeWebcontrol) {
                            for (var i = 0; i < updates.servicesVersions.length; i++) {
                                if (updates.servicesVersions[i].id.indexOf("webcontrol") > -1
                                    && updates.servicesVersions[i].id.indexOf("plugin") < 0) {
                                    updates.upgradeWebcontrolApplication(
                                            updates.servicesVersions[i].id,
                                            updates.servicesVersions[i].latest_version,
                                            "update"
                                        );
                                }
                            }
                        }
                        if (updates.updatesInProgress) {
                            updates.getServicesVersionsData();
                        }
                        updates.updatesInProgress = false;
                    }
                    globals.variables.appUpdateThreads = 0;
                } else {
                    updates.updatesInProgress = true;
                    updates.refreshApplicationsStatus();
                }
            },
            complete: function (xhr) {
                if (xhr.status != 200) {
                    $("#updateServicesContentDiv").unmask();
                }
            }
        });

    };

    /**
     * Creates the check application status interval if it is not active
     */
    updates.refreshApplicationsStatus = function () {
        if (!updates.appsIntervalActive) {
            refreshAppStatus = function () {
                if (globals.variables.currentTab == "updates" && updates.updatesInProgress) {
                    updates.getApplicationsStatusInfo();
                } else {
                    clearInterval(globals.variables.appsInterval);
                    updates.appsIntervalActive = false;
                }
            };
            globals.variables.appsInterval = setInterval("refreshAppStatus()", 30000);
            updates.appsIntervalActive = true;
        }
    };

    /**
     * Similar to updates.getServicesVersionsData(), but with no data from update repository
     * (e.g. no 'Available Version', 'Status' is unknown, etc.)
     * Used when version info cannot be retrieved from the repository (because of an error).
     */
    updates.getBasicServicesVersionsData = function () {

        $.ajax({
            type: "GET",
            url: "/api/updates/applications?basic=True",
            dataType: "json",
            cache: false,
            beforeSend: function () {
                $("#updateServicesContentDiv").mask($("#js_loading").text());
            },
            success: function (data) {
                $("#updateServicesContentDiv").unmask();
                updates.servicesVersions = data;
                updates.buildUpdateServicesTable(data);

                $("#updateServicesTable button").unbind("click");
                $("#updateServicesTable button").click( function() {
                    updates.simultaneousUpdates = 1;
                    var serviceNumber = this.name.substring(0, this.name.indexOf("_"));
                    var serviceAction = this.name.substring(this.name.indexOf("_") + 1);
                    var serviceId = updates.servicesVersions[serviceNumber].id;
                    var serviceStatus = updates.servicesVersions[serviceNumber].status;
                    var latestVersion = data[serviceNumber].latest_version;
                    if (this.id.indexOf("ChangeVer") > -1) {        // change version buttons
                        if (serviceStatus == ServiceVersionStatus.UNINSTALLED) {
                            updates.openChangeVersionModal(serviceNumber, "install");
                        } else {
                            updates.openChangeVersionModal(serviceNumber, "change");
                        }
                    } else  {    // update , install , uninstall buttons
                        updates.getServiceStatusAndUpdate(serviceId, latestVersion, serviceAction);
                    }
                });
            },
            complete : function (xhr) {
                if (xhr.status != 200) {
                    $("#updateServicesContentDiv").unmask();
                }
            }
        });

    };

    /**
     * Gets data related to the services' available and current versions
     * Calls the function that builds the services updates table
     * Assigns click events to the buttons from the table
     */
    updates.getServicesVersionsData = function () {

        $.ajax({
            type: "GET",
            url: "/api/updates/applications",
            dataType: "json",
            timeout: globals.variables.GET_UPDATES_TIMEOUT,
            cache: false,
            error: function (xmlHttpReq, textStatus, errorThrown) {
                globals.functions.ajaxError(xmlHttpReq, textStatus, errorThrown);
                updates.getBasicServicesVersionsData();
            },
            beforeSend: function () {
                $("#updateServicesContentDiv").mask($("#js_loadingUpdatesTable").text());
            },
            success: function (data) {
                updates.servicesVersions = data;
                updates.buildUpdateServicesTable(data);
                updates.enableDisableUpdateAllButton();
                $("#updateServicesTable button").unbind("click");
                $("#updateServicesTable button").click( function() {
                    updates.stoppedServicesArray = [];
                    updates.stoppedServicesVersion = [];
                    updates.stoppedServicesOperation = [];
                    updates.simultaneousUpdates = 1;
                    var serviceNumber = this.name.substring(0, this.name.indexOf("_"));
                    var serviceAction = this.name.substring(this.name.indexOf("_") + 1);
                    var serviceId = updates.servicesVersions[serviceNumber].id;
                    var serviceStatus = updates.servicesVersions[serviceNumber].status;
                    var latestVersion = data[serviceNumber].latest_version;
                    if (this.id.indexOf("ChangeVer") > -1) {        // change version buttons
                        if (serviceStatus == ServiceVersionStatus.UNINSTALLED) {
                            updates.openChangeVersionModal(serviceNumber, "install");
                        } else {
                            updates.openChangeVersionModal(serviceNumber, "change");    
                        }
                    } else  {    // update , install , uninstall buttons
                        if (serviceId.indexOf("webcontrol") > -1) {
                            updates.upgradeWebcontrolApplication(serviceId, latestVersion, serviceAction);
                        } else {
                            updates.checkPackagesDependencies([serviceId], serviceAction, [latestVersion]);
                        }
                    }
                });
                updates.getApplicationsStatusInfo();
            },
            complete : function (xhr) {
                if (xhr.status != 200) {
                    $("#updateServicesContentDiv").unmask();
                }
            }
        });

    };

    /**
     * Disables the Update All button if all applications are up to date
     * Enables the Update All button if there are out of date applications
     */
    updates.enableDisableUpdateAllButton = function () {

        var updatePossible = false;
        for (var i = 0; i < updates.servicesVersions.length; i++) {
            if (updates.servicesVersions[i].status == ServiceVersionStatus.OUT_OF_DATE) {
                updatePossible = true;
                break;
            }
        }
        globals.functions.enableButton("updateAllServicesButton", updatePossible);

    };

    /**
     * Builds the update services table using data received from the device.
     * 
     * @param data  Format:
     * [{current_version: "6.2", latest_version: "6.2", display_name: "watchdog", id: "watchdog", status: 0},...]
     */
    updates.buildUpdateServicesTable = function (data) {

        var tableString = "<tbody>";

        for (var i = 0; i < data.length; i++) {
            var not_installed = false;

            if (i % 2 != 0) {
                tableString += "<tr class='oddRow'><td>" + data[i].display_name + "</td>";
            } else {
                tableString += "<tr><td>" + data[i].display_name + "</td>";
            }

            var description = "-";
            if (data[i].description) {
                description = data[i].description;
            }
            tableString += "<td>" + description + "</td>";

            var current_version = "-";
            if (data[i].current_version) {
                current_version = data[i].current_version;
            }
            tableString += "<td><label id='" + data[i].id + "CurrentVersionLabel'>"
                    + current_version + "</label></td>";

            var latest_version = "-";
            if (data[i].latest_version) {
                latest_version = data[i].latest_version;
            }
            tableString += "<td><label id='" + data[i].id + "LatestVersionLabel'>"
                    + latest_version + "</label></td>";

            switch (data[i].status) {
                case ServiceVersionStatus.UP_TO_DATE:
                    tableString += "<td><label class='greenText' id='" + data[i].id + "UpdateStatusLabel'>"
                            + $("#js_upToDate").text() + "</label></td>";
                    not_installed = false;
                    break;
                case ServiceVersionStatus.OUT_OF_DATE:
                    tableString += "<td><label class='accentRedText' id='" + data[i].id + "UpdateStatusLabel'>"
                            + $("#js_outOfDate").text() + "</label></td>";
                    not_installed = false;
                    break;
                case ServiceVersionStatus.UNINSTALLED:
                    tableString += "<td><label class='blackText' id='" + data[i].id + "UpdateStatusLabel'>"
                            + $("#js_uninstalled").text() + "</label></td>";
                    not_installed = true;
                    break;
                case ServiceVersionStatus.UNKNOWN:
                    tableString += "<td><label class='accentRedText' id='" + data[i].id + "UpdateStatusLabel'>"
                            + "-" + "</label></td>";
                    not_installed = false;
                    break;
                default:
                    tableString += "<td><label id='" + data[i].id + "updateStatusLabel'>-</label></td>";

            }

            tableString += "<td><button class='avayaWebcontrolButton buttonGroupMargin' id='" + data[i].id +
                    "ChangeVer' " + "name='" + i + "_change'>" + $("#js_change").text() + "</button>";
            tableString += "<button class='avayaWebcontrolButton buttonGroupMargin' id='" + data[i].id +
                    "Update' " + "name='" + i + "_update'>" + $("#js_update").text() + "</button>";

            if (data[i].status != ServiceVersionStatus.UNKNOWN) {
                if (not_installed) {
                    tableString += "<button class='avayaWebcontrolButton buttonGroupMargin installButton' id='"
                            + data[i].id + "Install' " + "name='" + i + "_install'>"
                            + $("#js_install").text() + "</button>";
                } else {
                    tableString += "<button class='avayaWebcontrolButton buttonGroupMargin installButton' id='"
                            + data[i].id + "Install' " + "name='" + i + "_uninstall'>"
                            + $("#js_uninstall").text() + "</button>";
                }
            }
            
            tableString += "</td></tr>";

        }
        tableString += "</tbody>";
        $("#updateServicesTable tbody").remove();
        $("#updateServicesTable").append(tableString);
        for (var j = 0; j < data.length; j++) {
            var currentVersionId = data[j].id + "CurrentVersionLabel";
            var latestVersionId = data[j].id + "LatestVersionLabel";
            updates.formatVersion(currentVersionId, data[j].current_version);
            updates.formatVersion(latestVersionId, data[j].latest_version);
        }

        if (updates.viewedServicesTable) {
            try {
                $("#updateServicesTable").trigger("update");
                $("#updateServicesTable").trigger("sorton",[[[1,0]]]);
            } catch (e) {}
        } else {
            try {
                $("#updateServicesTable").tablesorter({
                    sortList: [[1,0]],
                    widgets: ['zebra']
                });
                $("#updateServicesTable thead").height($("#updateServicesTable thead").height());
                globals.functions.makeFixedTableHeader("updateServicesTable");
                updates.addFixedTableHeader("updateServicesTable");
            } catch (e) {}
        }
        updates.viewedServicesTable = true;

        $("#updateServicesTable button").each( function() {
            var serviceNumber = this.name.substring(0, this.name.indexOf("_"));
            var service = updates.servicesVersions[serviceNumber];
            if (this.id.indexOf("Update") > -1) {
                if (service.status == ServiceVersionStatus.UP_TO_DATE || 
                        service.status == ServiceVersionStatus.UNINSTALLED ||
                        service.status == ServiceVersionStatus.UNKNOWN ||
                        (!service.change_version_supported && service.status != ServiceVersionStatus.UNINSTALLED)) {
                    $("#updateServicesTable [name='" + this.name + "']").attr("disabled", true);
                    $("#updateServicesTable [name='" + this.name + "']").addClass("ui-state-disabled");
                } else {
                    $("#updateServicesTable [name='" + this.name + "']").attr("disabled", false);
                    $("#updateServicesTable [name='" + this.name + "']").removeClass("ui-state-disabled");
                }
            } else if (this.id.indexOf("ChangeVer") > -1) {
                if (service.available_versions.length == 0 ||
                        (!service.change_version_supported && service.status != ServiceVersionStatus.UNINSTALLED) ||
                        (service.available_versions.length == 1 && service.status == ServiceVersionStatus.UNINSTALLED)) {
                    globals.functions.enableButton(this.id, false);
                } else {
                    globals.functions.enableButton(this.id, true);    
                }
            }
        });
        
    };

    /**
     *  Transforms a version label from the integer format to the string format , if possible.
     *
     * @param labelId           The id of the label containing the version.
     * @param labelVersion      The version contained by the label.
     */
    updates.formatVersion = function (labelId, labelVersion) {
        if (labelVersion != null) {
            var version = globals.functions.parseVersion(labelVersion).versionNumber;
            var build = globals.functions.parseVersion(labelVersion).buildNumber;
            if (version != null && build != null) {
                globals.functions.composeText(labelId, "js_versionFormat", [version, build]);
            }
        }
    };

    /**
     * Requests a service's status and changes its version.
     *
     * @param serviceId     ID of the service
     * @param version       new version
     * @param action        Action to take (update, change, install, uninstall)
     */
    updates.getServiceStatusAndUpdate = function (serviceId, version, action) {
        if (action != "install") {
            $.ajax({
                type: "GET",
                url: "/api/service",
                dataType: "json",
                data: "name=" + serviceId,
                cache: false,
                error: function (xmlHttpReq, textStatus, errorThrown) {
                    if (xmlHttpReq.status == 404) {
                        $("#updateServicesContentDiv").unmask();
                        updates.updateInstallUninstallService(serviceId, version, action);
                    } else {
                        globals.functions.ajaxError(xmlHttpReq, textStatus, errorThrown);
                        $("#updateServicesContentDiv").unmask();
                    }
                },
                beforeSend: function () {
                    $("#updateServicesContentDiv").mask($("#js_checkingState").text());
                },
                success: function (data) {
                    $("#updateServicesContentDiv").unmask();
                    switch(data.run_info.state) {
                        case ServiceState.RUNNING:
                        case ServiceState.STOPPING:
                        case ServiceState.STARTING:
                            if (updates.simultaneousUpdates > 1) {
                                globals.functions.composeText("stopServiceWarningModalName",
                                    "js_serviceIsRunning", [data.display_name]);
                                var confirmText = $("#stopServiceWarningModalName").text() + "\n";
                                confirmText += $("#stopServiceWarningModalServiceUpdate").text().trim() + "\n\n";
                                confirmText += $("#stopServiceWarningModalContinue").text();
                                var stopService = confirm(confirmText);
                                if (stopService) {
                                    if (data.restart_required) {
                                        updates.forceStopService(serviceId, version, "stop", action);
                                    } else {
                                        if (action == "uninstall") {
                                            updates.openUninstallWarningModal(serviceId, version, true);
                                        } else {
                                            updates.updateInstallUninstallService(serviceId, version, action);
                                        }
                                    }
                                }
                            } else {
                                updates.openStopServiceWarningModal(serviceId, data.display_name, version,
                                        action, data.restart_required);
                            }
                            break;
                        default:
                            if (action == "uninstall") {
                                updates.openUninstallWarningModal(serviceId, version, true);
                            } else {
                                updates.updateInstallUninstallService(serviceId, version, action);
                            }
                    }
                },
                complete : function (xhr) {
                    if (xhr.status != 200 && xhr.status != 404) {
                        $("#updateServicesContentDiv").unmask();
                    }
                }
            });
        } else {
            updates.updateInstallUninstallService(serviceId, version, action);
        }

    };

    /**
     * Opens a modal containing the available versions of the application
     *
     * @param serviceNumber     The index of the application
     * @param action            Action to take (install or change)
     */
    updates.openChangeVersionModal = function (serviceNumber, action) {
        var data = updates.servicesVersions[serviceNumber];
        $("#selectVersionModalHeader").text($("#js_selectVersion").text() + data.display_name);
        $("#selectVersionModalTableBody").empty();
        if (navigator.appName.indexOf("Internet Explorer") > -1) {
            $("#selectVersionModalContent").addClass("fullWidth");
        }

        // build the table
        if (data.available_versions != null) {
            globals.functions.showNoDataDiv("selectVersionModalTableDiv", "selectVersionModalTable"
                , data.available_versions.length, $("#js_noAvailableVersions").text() + data.display_name);
            for (var i = 0; i < data.available_versions.length;  i++) {
                var versionString = data.available_versions[i];
                var version = globals.functions.parseVersion(versionString).versionNumber;
                var build = globals.functions.parseVersion(versionString).buildNumber;
                var versionText = $("#js_versionFormat").text();
                versionText = versionText.replace("%s0", version);
                versionText = versionText.replace("%s1", build);
                var appendString = "";
                if (i % 2 != 0) {
                    appendString += "<tr class='oddRow'><td id='" + versionString + "Label'>" +
                        versionText + "</td>";
                } else {
                    appendString += "<tr><td id='" + versionString + "Label'>" + versionText + "</td>";
                }
                appendString += "<td><input type='radio' name='restoreVersionRadio' " +
                    "value='" + data.available_versions[i] + "' " +
                    "id='" + versionString + "'/></td></tr>";
                $("#selectVersionModalTableBody").append(appendString);
            }
            if (data.available_versions.length > 0) {
                $("#selectVersionModalTableBody :radio")[0].checked = true;
            }
        } else {
            globals.functions.showNoDataDiv("selectVersionModalTableDiv", "selectVersionModalTable"
                , 0, $("#js_noAvailableVersions").text() + data.id);
        }
        // button click events
        $("#selectVersionModalButtons button").unbind("click");
        $("#selectVersionModalCancel").click(function () {
            $.modal.close();
        });
        $("#selectVersionModalOk").click(function () {
            var selectedVersion = $("input[name='restoreVersionRadio']:checked").val();
            if (data.id.indexOf("webcontrol") > -1) {
                updates.upgradeWebcontrolApplication(data.id, selectedVersion, action);
            } else {
                updates.checkPackagesDependencies([data.id], action, [selectedVersion]);
            }
            $.modal.close();
        });
        $('#selectVersionModal').modal({
            closeHTML: "<a href='' title='" + $("#js_close").text() + "'></a>",
            overlayId: 'modal-overlay',
            containerId: 'selectVersionModal-container'
        });

    };

    /**
     * Opens a modal that warns the user that a service will be stopped before it is updated.
     *
     * @param serviceId         ID of the service
     * @param serviceName       display name of the service
     * @param version           Update version
     * @param action            Action to take (update, change, install, uninstall)
     * @param restartRequired   True if the service requires restart from the Web Control interface
     */
    updates.openStopServiceWarningModal = function (serviceId, serviceName, version, action, restartRequired) {
        $("#stopServiceWarningModalHeader").text($("#js_warning").text());
        globals.functions.composeText("stopServiceWarningModalName", "js_serviceIsRunning", [serviceName]);
        if (action == "uninstall") {
            $("#stopServiceWarningModalServiceUpdate").addClass("hiddenElement");
            $("#stopServiceWarningModalServiceUninstall").removeClass("hiddenElement");
        } else {
            $("#stopServiceWarningModalServiceUninstall").addClass("hiddenElement");
            $("#stopServiceWarningModalServiceUpdate").removeClass("hiddenElement");
        }
        // button click events
        $("#stopServiceWarningModalButtons button").unbind("click");
        $("#stopServiceWarningModalNo").click(function () {
            updates.simultaneousUpdates--;
            if (updates.simultaneousUpdates > 0) {
                $("#updateServicesContentDiv").mask($("#js_updating").text());
            }
            $.modal.close();
        });
        $("#stopServiceWarningModalYes").click(function () {
            $.modal.close();
            if (action == "uninstall") {
                updates.openUninstallWarningModal(serviceId, version, false);
            } else {
                /*if (restartRequired) {
                    updates.forceStopService(serviceId, version, "stop", action);
                } else {*/
                    updates.updateInstallUninstallService(serviceId, version, action);
                //}
            }
        });
        $('#stopServiceWarningModal').modal({
            closeHTML: "<a href='' title='" + $("#js_close").text() + "'></a>",
            overlayId: 'modal-overlay',
            containerId: 'stopServiceWarningModal-container'
        });

    };

    /**
     * Opens a warning when the user attempts to uninstall a service
     *
     * @param serviceId         The id of the service
     * @param version           The latest version of the service
     * @param stopped           True if the service is stopped , false if it is not stopped
     * @param restartRequired   True if the service requires to be stopped by Web Control before uninstall
     */
    updates.openUninstallWarningModal = function (serviceId, version, stopped, restartRequired) {
        var serviceName = "";
        for (var i = 0; i < updates.servicesVersions.length; i++) {
            if (serviceId == updates.servicesVersions[i].id) {
                serviceName = updates.servicesVersions[i].display_name;
                break;
            }
        }
        globals.functions.composeText("uninstallWarningModalRestart", "js_uninstallService", [serviceName]);
        // button click events
        $("#uninstallWarningModalButtons button").unbind("click");
        $("#uninstallWarningModalNo").click(function () {
            $.modal.close();
        });
        $("#uninstallWarningModalYes").click(function () {
            $.modal.close();
            if (stopped) {
                updates.updateInstallUninstallService(serviceId, version, "uninstall");
            } else {
                updates.forceStopService(serviceId, version, "stop", "uninstall");
            }
        });
        $('#uninstallWarningModal').modal({
            closeHTML: "<a href='' title='" + $("#js_close").text() + "'></a>",
            overlayId: 'modal-overlay',
            containerId: 'uninstallWarningModal-container'
        });
    };

    /**
     * Attempts to stop a service. Force stops a service if it's not stopped after 10 seconds ,
     * then calls the update function.
     *
     * @param serviceId  ID of the service to stop
     * @param version    Selected version of the service
     * @param action     The way to stop a service ( stop or forcestop )
     * @param operation  What to do after the service is stopped (uninstall , update or change)
     */
    updates.forceStopService = function (serviceId, version, action, operation) {

        var loadingText = "";
        if (action == "stop") {
            loadingText = $("#js_stoppingService").text();    
        } else if (action == "forcestop") {
            loadingText = $("#js_forceStoppingService").text();    
        }
        $.ajax({
            type: 'PUT',
            url : "/api/service",
            cache: false,
            data: "name=" + serviceId + "&action=" + action + "&csrf_token="+$("#csrf_token").val(),
            error: function (xmlHttpReq, textStatus, errorThrown) {
                globals.functions.ajaxError(xmlHttpReq, textStatus, errorThrown);
                $("#updateServicesContentDiv").unmask();
            },
            beforeSend: function () {
                $("#updateServicesContentDiv").mask(loadingText);
            },
            success: function () {
                updates.stoppedServicesArray.push(serviceId);
                updates.stoppedServicesVersion.push(version);
                updates.stoppedServicesOperation.push(operation);
                delayFunction = function () {
                    var currentService = updates.stoppedServicesArray.shift();
                    var versionToApply = updates.stoppedServicesVersion.shift();
                    var operationToPerform = updates.stoppedServicesOperation.shift();
                    $("#updateServicesContentDiv").unmask();
                    if (action == "forcestop") {
                        updates.updateInstallUninstallService(currentService, versionToApply, operationToPerform);
                    } else if (action == "stop") {
                        $.ajax({
                            type: "GET",
                            url: "/api/service",
                            dataType: "json",
                            data: "name=" + currentService,
                            cache: false,
                            error: function (xmlHttpReq, textStatus, errorThrown) {
                                globals.functions.ajaxError(xmlHttpReq, textStatus, errorThrown);
                                $("#updateServicesContentDiv").unmask();
                            },
                            beforeSend: function () {
                                $("#updateServicesContentDiv").mask($("#js_checkingState").text());
                            },
                            success: function (data) {
                                $("#updateServicesContentDiv").unmask();
                                switch (data.run_info.state) {
                                    case ServiceState.RUNNING:
                                    case ServiceState.STOPPING:
                                        updates.forceStopService(currentService, versionToApply, "forcestop", operationToPerform);
                                        break;
                                    case ServiceState.STOPPED:
                                        updates.updateInstallUninstallService(currentService, versionToApply, operationToPerform);
                                        break;
                                }
                            },
                            complete : function (xhr) {
                                if (xhr.status != 200) {
                                    $("#updateServicesContentDiv").unmask();
                                }
                            }
                        });
                    }
                };
                setTimeout("delayFunction()", 10000);

            },
            complete : function (xhr) {
                if (xhr.status != 200) {
                    $("#updateServicesContentDiv").unmask();
                }
            }
        });
        
    };

    /**
     * Updates , installs or uninstalls a service and rebuilds the table.
     *
     * @param serviceId     ID of the service
     * @param version       new version
     * @param action        Action to take (install , uninstall, update, change)
     */
    updates.updateInstallUninstallService = function (serviceId, version, action) {

        var ajaxType = "";
        var parameters = "";
        var timeout = globals.variables.UPDATE_AJAX_TIMEOUT;
        switch (action) {
            case "update":
            case "change":
                ajaxType = "PUT";
                parameters = "id=" + serviceId + "&version=" + version;
                break;
            case "install":
            case "uninstall":
                ajaxType = "POST";
                parameters = "id=" + serviceId + "&version=" + version + "&action=" + action;
                timeout = globals.variables.INSTALL_AJAX_TIMEOUT;
                break;
            default:
                ajaxType = "PUT";
                parameters = "id=" + serviceId + "&version=" + version;
        }
        $.ajax({
            type: ajaxType,
            url : "/api/updates/applications",
            cache: false,
            data: parameters + "&csrf_token="+$("#csrf_token").val(),
            timeout: timeout,
            error: function (xmlHttpReq, textStatus, errorThrown) {
                updates.simultaneousUpdates--;
                globals.functions.ajaxError(xmlHttpReq, textStatus, errorThrown);
                if (updates.simultaneousUpdates == 0) {
                    $("#updateServicesContentDiv").unmask();
                    if (globals.variables.upgradeWebcontrol) {
                        for (var i = 0; i < updates.servicesVersions.length; i++) {
                            if (updates.servicesVersions[i].id.indexOf("webcontrol") > -1
                                && updates.servicesVersions[i].id.indexOf("plugin") < 0) {
                                updates.upgradeWebcontrolApplication(
                                        updates.servicesVersions[i].id,
                                        updates.servicesVersions[i].latest_version,
                                        action
                                    );
                            }
                        }
                    }
                }
            },
            beforeSend: function () {
                $("#updateServicesContentDiv").mask($("#js_updating").text());
            },
            success: function () {
                updates.simultaneousUpdates--;
                if (updates.simultaneousUpdates == 0) {
                    $("#updateServicesContentDiv").unmask();
                    if (globals.variables.upgradeWebcontrol) {
                        for (var i = 0; i < updates.servicesVersions.length; i++) {
                            if (updates.servicesVersions[i].id.indexOf("webcontrol") > -1
                                && updates.servicesVersions[i].id.indexOf("plugin") < 0) {
                                updates.upgradeWebcontrolApplication(
                                        updates.servicesVersions[i].id,
                                        updates.servicesVersions[i].latest_version,
                                        action
                                    );
                            }
                        }
                    } else {
                        updates.buildUpdateServicesFieldset();
                        globals.functions.showHideUpdatesAvailableIcon();
                    }
                }
            },
            complete: function (xhr) {
                if (xhr.status != 200) {
                    $("#updateServicesContentDiv").unmask();
                }
            }
        });

    };

    /**
     * Function used to upgrade/downgrade Web Control
     *
     * @param serviceId     The id of the Web Control rpm
     * @param version       The version of Web Control to upgrade/downgrade to
     * @param action        Action to take (update, change, install, uninstall)
     */
    updates.upgradeWebcontrolApplication = function (serviceId, version, action) {

        globals.variables.upgradeWebcontrol = false;
        var ajaxType = "";
        var parameters = "";
        var timeout = globals.variables.GLOBAL_AJAX_TIMEOUT;
        switch (action) {
            case "update":
            case "change":
                ajaxType = "PUT";
                parameters = "id=" + serviceId + "&version=" + version;
                break;
            case "install":
            case "uninstall":
                ajaxType = "POST";
                parameters = "id=" + serviceId + "&version=" + version + "&action=" + action;
                timeout = globals.variables.INSTALL_AJAX_TIMEOUT;
                break;
            default:
                ajaxType = "PUT";
                parameters = "id=" + serviceId + "&version=" + version;
        }
        $.ajax({
            type: ajaxType,
            url : "/api/updates/applications",
            cache: false,
            data: parameters + "&csrf_token="+$("#csrf_token").val(),
            timeout: timeout,
            beforeSend: function () {
                $("#updateServicesContentDiv").mask($("#js_updating").text());
            },
            error: function (xmlHttpReq, textStatus, errorThrown) {
                if (navigator.appName.toLowerCase().indexOf("internet explorer") > -1 &&
                        xmlHttpReq.responseText.indexOf("Failed dependencies") == -1) {
                    updates.openWebcontrolChangedModal();
                } else {
                    globals.functions.ajaxError(xmlHttpReq, textStatus, errorThrown);
                }
            },
            complete: function () {
                $("#updateServicesContentDiv").unmask();
                updates.openWebcontrolChangedModal();
            }
        });

    };

    /**
     * Opens a modal that warns the user that the application needs to restart.
     * Redirects the user to the login page if the "OK" button is pressed
     */
    updates.openWebcontrolChangedModal = function () {
        globals.functions.enableButton("webcontrolChangedModalOk", false);
        updates.countDownTimer();
        $("#webcontrolChangedModalOk").click( function () {
            $.ajax({
                       type: 'DELETE',
                       url: '/api/session',
                       complete: function(xhr, statusText) {
                           globals.functions.handleRedirection(globals.variables.REDIRECT_WEBCONTROL_RESTART);
                       }
                   });
        });
        $('#webcontrolChangedModal').modal({
            closeHTML: "<a href='' title='" + $("#js_close").text() + "'></a>",
            overlayId: 'modal-overlay',
            containerId: 'webcontrolChangedModal-container'
        });
    };

    /**
     * Displays the seconds remaining until the application is ready to restart.
     * Enables the "OK" button when the application is ready to restart.
     */
    updates.countDownTimer = function () {
        var counter = updates.webcontrolRestartCounter;
        decrease = function () {
            if (counter >= 0) {
                globals.functions.composeText("webcontrolTimerDiv", "js_applicationWillRestartIn", [counter]);
                counter--;
            } else {
                $("#webcontrolTimerDiv").hide();
                $("#webcontrolRedirectLabel").show();
                globals.functions.enableButton("webcontrolChangedModalOk", true);
                clearInterval(i);
            }
        };
        var i = setInterval("decrease()", 1000);
    };

    /**
     * Builds the update system fieldset
     */
    updates.buildUpdateSystemFieldset = function () {

        //build the table
        updates.getOSInfo();
        updates.getUpdatesStatusInfo();
        
        //assign click events
        $("#updateSystemButtonsDiv button").unbind("click");
        $("#checkSystemUpdatesButton").click( function () {
            updates.getUpdatesStatusInfo();
        });
        $("#reviewSystemUpdatesButton").click( function () {
            updates.openSystemUpdatesModal();
        });
        $("#updateSystemButton").click( function () {
            $.ajax({
                type: "GET",
                url: "/api/updates/os",
                dataType: "json",
                cache: false,
                timeout: globals.variables.UPDATES_OS_TIMEOUT,
                error: function (xmlHttpReq, textStatus, errorThrown) {
                    globals.functions.ajaxError(xmlHttpReq, textStatus, errorThrown);
                    $("#updateSystemContentDiv").unmask();
                },
                beforeSend: function () {
                    $("#updateSystemContentDiv").mask($("#js_loading").text());
                },
                success: function (data) {
                    var updatesArray  = [];
                    for (var i = 0; i < data.status.length; i++) {
                        if (data.status[i].name.indexOf("webcontrol") > -1 || data.status[i].name.indexOf("cli-commands") > -1) {
                            globals.variables.upgradeWebcontrolOs = true;
                            updates.webcontrolValue = data.status[i].name;
                        } else {
                            updatesArray.push(data.status[i].name);
                        }
                    }
                    updates.doSystemUpdateAjax(updatesArray);
                    $("#updateSystemContentDiv").unmask();
                },
                complete : function (xhr) {
                    if (xhr.status != 200) {
                        $("#updateSystemContentDiv").unmask();
                    }
                }
            });
        });
        
    };

    /**
     * Get OS info and update the respective labels
     */
    updates.getOSInfo = function () {
        $.ajax({
            type: "GET",
            url: "/api/system/status",
            dataType: "json",
            cache: false,
            error: function (xmlHttpReq, textStatus, errorThrown) {
                globals.functions.ajaxError(xmlHttpReq, textStatus, errorThrown);
                updates.osInfoReady = true;
                if (updates.osInfoReady && updates.updatesInfoReady) {
                    $("#updateSystemContentDiv").unmask();
                }
            },
            beforeSend: function () {
                $("#updateSystemContentDiv").mask($("#js_loading").text());
            },
            success: function (data) {
                updates.osInfoReady = true;
                if (updates.osInfoReady && updates.updatesInfoReady) {
                    $("#updateSystemContentDiv").unmask();
                }
                var osString = data.os.version;
                var os = osString.split(" ")[0];
                var version = osString.substring(osString.indexOf(" ") + 1);
                $("#systemOSCell").text(os);
                $("#systemVersionCell").text(version);
                $("#systemKernelCell").text(data.os.kernel);
                if (data.os.last_update) {
                    var timestamp = globals.functions.stringToTimestamp(data.os.last_update);
                    $("#systemLastUpdateCell").text(globals.functions.timestampToString(timestamp,
                        globals.variables.language));
                }
            },
            complete: function (xhr) {
                if (xhr.status != 200) {
                    updates.osInfoReady = true;
                    if (updates.osInfoReady && updates.updatesInfoReady) {
                        $("#updateSystemContentDiv").unmask();
                    }
                }
            }
        });
    };

    /**
     * Gets the status of the system updates and changes the status label accordingly
     */
    updates.getUpdatesStatusInfo = function () {

        $.ajax({
            type: "GET",
            url: "/api/updates/os/status",
            dataType: "json",
            cache: false,
            error: function (xmlHttpReq, textStatus, errorThrown) {
                globals.functions.ajaxError(xmlHttpReq, textStatus, errorThrown);
                updates.updatesInfoReady = true;
                if (updates.osInfoReady && updates.updatesInfoReady) {
                    $("#updateSystemContentDiv").unmask();
                }
            },
            success: function (data) {
                // if there are no updates in progress , check if there are any available updates
                if (!data.in_progress) {
                    updates.showRestartModal = data.require_reboot;
                    updates.doSystemRefresh = false;
                    updates.getOSInfo();
                    $.ajax({
                        type: "GET",
                        url: "/api/updates/os",
                        dataType: "json",
                        cache: false,
                        timeout: globals.variables.UPDATES_OS_TIMEOUT,
                        success: function (data) {
                            updates.updatesInfoReady = true;
                            $("#systemStatusCell").removeClass();
                            if (data.kernel_reboot) {
                                // Reboot is required
                                $("#systemStatusCell").addClass("accentRedText");
                                $("#systemStatusCell").text($("#js_rebootRequired").text());
                                globals.functions.enableButton("reviewSystemUpdatesButton", false);
                                globals.functions.enableButton("updateSystemButton", false);
                            } else if (data.status.length > 0) {
                                // updates available
                                $("#systemStatusCell").addClass("accentRedText");
                                $("#systemStatusCell").text($("#js_updatesAvailable").text());
                                globals.functions.enableButton("reviewSystemUpdatesButton", true);
                                globals.functions.enableButton("updateSystemButton", true);
                            } else {
                                // no updates available
                                $("#systemStatusCell").addClass("greenText");
                                $("#systemStatusCell").text($("#js_upToDate").text());
                                globals.functions.enableButton("reviewSystemUpdatesButton", false);
                                globals.functions.enableButton("updateSystemButton", false);
                            }
                            globals.functions.enableButton("checkSystemUpdatesButton", true);
                            if (updates.osInfoReady && updates.updatesInfoReady) {
                                $("#updateSystemContentDiv").unmask();
                            }
                            globals.functions.showHideUpdatesAvailableIcon();
                        },
                        complete: function (xhr) {
                            if (updates.showRestartModal && updates.finishedUpdating) {
                                updates.finishedUpdating = false;
                                updates.openRebootSystemWarningModal();
                            } else if (globals.variables.upgradeWebcontrolOs && updates.webcontrolValue != null) {
                                updates.upgradeWebcontrolFromOs();
                            }
                            if (xhr.status != 200) {
                                updates.updatesInfoReady = true;
                                if (updates.osInfoReady && updates.updatesInfoReady) {
                                    $("#updateSystemContentDiv").unmask();
                                }
                            }
                        }
                    });
                // updates are being installed
                } else {
                    updates.doSystemRefresh = true;
                    updates.updatesInfoReady = true;
                    updates.finishedUpdating = true;
                    if (updates.osInfoReady && updates.updatesInfoReady) {
                        $("#updateSystemContentDiv").unmask();
                    }
                    if (data.total > 1) {
                        globals.functions.composeText("systemStatusCell", "js_packagesInstalled",
                            [data.current, data.completed, data.total]);
                    } else {
                        globals.functions.composeText("systemStatusCell", "js_packageInstalled",
                            [data.current, data.completed, data.total]);
                    }
                    $("#systemStatusCell").removeClass();
                    globals.functions.enableButton("reviewSystemUpdatesButton", false);
                    globals.functions.enableButton("updateSystemButton", false);
                    globals.functions.enableButton("checkSystemUpdatesButton", false);
                    // refresh the status periodically
                    updates.updateSystemStatus();
                }
            },
            complete: function (xhr) {
                if (xhr.status != 200) {
                    updates.updatesInfoReady = true;
                    if (updates.osInfoReady && updates.updatesInfoReady) {
                        $("#updateSystemContentDiv").unmask();
                    }
                }
            }
        });

    };

    /**
     * Refreshes the status of the system updates table
     */
    updates.updateSystemStatus = function () {
        if (!updates.intervalActive) {
            refreshSystemStatus = function () {
                if (globals.variables.currentTab == "updates" && updates.doSystemRefresh) {
                    updates.getUpdatesStatusInfo();
                } else {
                    clearInterval(globals.variables.osInterval);
                    updates.intervalActive = false;                    
                }
            };
            globals.variables.osInterval = setInterval("refreshSystemStatus()", 15000);
            updates.intervalActive = true;
        }

    };

    /**
     * Opens a modal window that contains the available system updates
     */
    updates.openSystemUpdatesModal = function () {
        
        $('#selectSystemUpdatesModal').modal({
            closeHTML: "<a href='' title='" + $("#js_close").text() + "'></a>",
            overlayId: 'modal-overlay',
            containerId: 'selectSystemUpdatesModal-container',
            onShow: function () {
                var updatesNumber = 0;
                $("#selectSystemUpdatesModalTableDiv").height($("#selectSystemUpdatesModal-container").height() * 80/100);
                $("#selectSystemUpdatesModalTableDiv").addClass("scroll");
                //request available updates and build the table
                $.ajax({
                    type: "GET",
                    url: "/api/updates/os",
                    dataType: "json",
                    cache: false,
                    timeout: globals.variables.UPDATES_OS_TIMEOUT,
                    error: function (xmlHttpReq, textStatus, errorThrown) {
                        globals.functions.ajaxError(xmlHttpReq, textStatus, errorThrown);
                        $("#selectSystemUpdatesModalTableDiv").unmask();
                    },
                    beforeSend: function () {
                        $("#selectSystemUpdatesModalTableDiv").mask($("#js_loading").text());
                    },
                    success: function (data) {
                        updatesNumber = data.status.length;
                        $("#selectSystemUpdatesModalTableDiv").unmask();
                        $("#selectSystemUpdatesModalTableBody").empty();
                        globals.functions.showNoDataDiv("selectSystemUpdatesModalTableDiv",
                                    "selectSystemUpdatesModalTable", data.status.length,
                                    $("#js_noSystemUpdates").text());
                        for (var i = 0; i < data.status.length;  i++) {
                            var checkboxId = data.status[i].name;
                            var appendString = "";
                            if (i % 2 != 1) {
                                appendString += "<tr class='odd'><td><input type='checkbox' " +
                                        "value='"+ data.status[i].name + "' " + "id='" + checkboxId + "'/></td>";
                            } else {
                                appendString += "<tr class='even'><td><input type='checkbox' " +
                                        "value='" + data.status[i].name + "' " + "id='" + checkboxId + "'/></td>";
                            }
                            appendString += "<td>" + data.status[i].name + "</td>";
                            appendString += "<td>" + data.status[i].new_version + "</td>";
                            appendString += "<tr>";

                            $("#selectSystemUpdatesModalTableBody").append(appendString);
                            $("#selectSystemUpdatesModalTableBody :checkbox").attr("checked", true);
                        }
                        $("#selectSystemUpdatesModalTable thead").height($("#selectSystemUpdatesModalTable thead").height());
                        globals.functions.makeFixedTableHeader("selectSystemUpdatesModalTable");
                    },
                    complete : function (xhr) {
                        if (xhr.status != 200) {
                           $("#selectSystemUpdatesModalTableDiv").unmask();
                        }
                    }
                });
                
                // button click events
                $("#selectSystemUpdatesModalButtons button").unbind("click");
                $("#selectSystemUpdatesModalCancel").click(function () {
                    $.modal.close();
                });
                $("#selectSystemUpdatesModalSelectAll").click( function() {
                    $("#selectSystemUpdatesModalTableBody :checkbox").attr("checked", true);
                });
                $("#selectSystemUpdatesModalUnselectAll").click( function() {
                    $("#selectSystemUpdatesModalTableBody :checkbox").attr("checked", false);
                });
                $("#selectSystemUpdatesModalAddSelected").click( function() {
                    var selectedUpdatesArray = [];
                    $("#selectSystemUpdatesModalTableBody :checkbox").each( function () {
                        if (this.checked) {
                            if (this.value.indexOf("webcontrol") > -1 || this.value.indexOf("cli-commands") > -1) {
                                globals.variables.upgradeWebcontrolOs = true;
                                updates.webcontrolValue = this.value;
                            } else {
                                selectedUpdatesArray.push(this.value);
                            }
                        }
                    });
                    if (selectedUpdatesArray.length == 0 && globals.variables.upgradeWebcontrolOs == false) {
                        alert($("#js_noUpdatesSelected").text());
                    } else {
                        $.modal.close();
                        if (updatesNumber == selectedUpdatesArray.length && selectedUpdatesArray.length != 0) {
                            updates.doSystemUpdateAjax("");
                        } else {
                            if (selectedUpdatesArray.length != 0) {
                                updates.doSystemUpdateAjax(selectedUpdatesArray.join(","));
                            } else {
                                updates.upgradeWebcontrolFromOs();
                            }
                        }
                    }
                });
            }
        });

    };

    /**
     * Applies the selected updates
     * 
     * @param updatesString  string containing the updates' names separated by comma
     */
    updates.doSystemUpdateAjax = function (updatesString) {
        $.ajax({
            type: 'PUT',
            url : "/api/updates/os",
            cache: false,
            timeout: globals.variables.UPDATES_OS_TIMEOUT,
            data: "packages=" + updatesString + "&csrf_token="+$("#csrf_token").val(),
            success: function () {
                updates.finishedUpdating = false;
                updates.getUpdatesStatusInfo();
            }
        });
    };

    /**
     * Checks if the packages to be upgraded/downgraded/installed/uninstalled affect the Avaya services
     *
     * @param packageArray  the packages to consider
     * @param action        the action to take (update, change, install, uninstall or updateAll)
     * @param versions      the versions to apply after performing the check
     */
    updates.checkPackagesDependencies = function (packageArray, action, versions) {

        $.ajax({
            type: 'GET',
            url : "/api/updates/dependencies",
            cache: false,
            data: "packages=" + packageArray.join(","),
            dataType: "json",
            beforeSend: function () {
                $("#updateServicesContentDiv").mask($("#js_checkingDependencies").text());
            },
            error: function (xmlHttpReq, textStatus, errorThrown) {
                globals.functions.ajaxError(xmlHttpReq, textStatus, errorThrown);
                $("#updateServicesContentDiv").unmask();
            },
            success: function (returnData) {
                $("#updateServicesContentDiv").unmask();
                if (returnData.length == 0) {
                    if (action == "updateAll") {
                         updates.startUpdateAllProcess();
                    } else {
                        updates.getServiceStatusAndUpdate(packageArray[0], versions[0], action);
                    }
                } else {
                    updates.openDependencyWarningModal(packageArray, action, returnData, versions);
                }
            }
        });

    };

    /**
     * Opens a warning that tells the user the services which will be restarted when the selected packages are updated
     *
     * @param packageArray          The packages which affect the Avaya services
     * @param action                Action to take (update, change, install, uninstall or updateAll)
     * @param dependentServices     Affected Avaya services
     * @param versions              Versions to apply , if the user decides to continue
     */
    updates.openDependencyWarningModal = function (packageArray, action, dependentServices, versions) {
        $("#dependencyWarningModalHeader").text($("#js_warning").text());
        var servicesString = dependentServices[0].display_name;
        var dependentServicesIds = [];
        dependentServicesIds.push(dependentServices[0].id);
        if (dependentServices.length == 1) {
            if (action != "updateAll") {
                globals.functions.composeText("dependencyWarningModalMessage", "js_serviceDependency_" + action,
                    [servicesString, packageArray[0]]);
            } else {
                globals.functions.composeText("dependencyWarningModalMessage", "js_serviceDependency_" + action,
                    [servicesString]);
            }
        } else {
            for (var i = 1; i < dependentServices.length; i++) {
                dependentServicesIds.push(dependentServices[i].id);
                if (i == dependentServices.length-1) {
                    servicesString += " " + $("#js_and").text() + " " + dependentServices[i].display_name;
                } else {
                    servicesString += ", " + dependentServices[i].display_name;
                }
            }
            if (action != "updateAll") {
                globals.functions.composeText("dependencyWarningModalMessage", "js_servicesDependency_" + action,
                    [servicesString, packageArray[0]]);
            } else {
                globals.functions.composeText("dependencyWarningModalMessage", "js_servicesDependency_" + action,
                    [servicesString]);
            }
        }

        // button click events
        $("#dependencyWarningModalButtons button").unbind("click");
        $("#dependencyWarningModalNo").click(function () {
            $.modal.close();
        });
        $("#dependencyWarningModalYes").click(function () {
            $.modal.close();
            if (action == "updateAll") {
                $.ajax({
                    type: 'PUT',
                    url : "/api/updates/dependencies",
                    cache: false,
                    data: "services=" + dependentServicesIds.join(",") + "&csrf_token="+$("#csrf_token").val(),
                    timeout: globals.variables.STOP_SERVICES_TIMEOUT,
                    beforeSend: function () {
                        $("#updateServicesContentDiv").mask($("#js_stoppingServices").text());
                    },
                    error: function (xmlHttpReq, textStatus, errorThrown) {
                        globals.functions.ajaxError(xmlHttpReq, textStatus, errorThrown);
                        $("#updateServicesContentDiv").unmask();
                    },
                    success: function () {
                        globals.variables.startStoppedServices = true;
                        updates.startUpdateAllProcess();
                    }
                });
            } else {
                updates.getServiceStatusAndUpdate(packageArray[0], versions[0], action);
            }
        });
        $('#dependencyWarningModal').modal({
            closeHTML: "<a href='' title='" + $("#js_close").text() + "'></a>",
            overlayId: 'modal-overlay',
            containerId: 'dependencyWarningModal-container'
        });

    };

    /**
     * Starts the update all process
     */
    updates.startUpdateAllProcess = function () {
        if (updates.updateServicesArray.length == 0) {
            if (globals.variables.upgradeWebcontrol) {
                for (var i = 0; i < updates.servicesVersions.length; i++) {
                    if (updates.servicesVersions[i].id.indexOf("webcontrol") > -1
                        && updates.servicesVersions[i].id.indexOf("plugin") < 0) {
                        updates.upgradeWebcontrolApplication(
                                updates.servicesVersions[i].id,
                                updates.servicesVersions[i].latest_version,
                                "update"
                            );
                    }
                }
            }
        } else {
            for (var j = 0; j < updates.updateServicesArray.length; j++) {
                updates.checkManagedServicesStatus(updates.updateServicesArray[j].id,
                        updates.updateServicesArray.latest_version);
            }
        }
    };

    /**
     * Starts the services which were stopped before the update all process
     */
    updates.startStoppedServices = function () {

        $.ajax({
            type: 'POST',
            url : "/api/updates/dependencies",
            data: "csrf_token="+$("#csrf_token").val(),
            cache: false,
            timeout: globals.variables.STOP_SERVICES_TIMEOUT,
            beforeSend: function () {
                $("#updateServicesContentDiv").mask($("#js_startingServices").text());
            },
            error: function (xmlHttpReq, textStatus, errorThrown) {
                globals.functions.ajaxError(xmlHttpReq, textStatus, errorThrown);
                $("#updateServicesContentDiv").unmask();
            },
            success: function () {
                globals.variables.startStoppedServices = false;
                if (globals.variables.upgradeWebcontrol) {
                    for (var i = 0; i < updates.servicesVersions.length; i++) {
                        if (updates.servicesVersions[i].id.indexOf("webcontrol") > -1
                            && updates.servicesVersions[i].id.indexOf("plugin") < 0) {
                            updates.upgradeWebcontrolApplication(
                                    updates.servicesVersions[i].id,
                                    updates.servicesVersions[i].latest_version,
                                    "update"
                                );
                        }
                    }
                }
                if (updates.updatesInProgress) {
                    updates.getServicesVersionsData();
                }
                updates.updatesInProgress = false;
            }
        });

    };

    /**
     * Opens a warning modal that warns the user that it has to restart
     * the system fo the kernel update to take effect.
     */
    updates.openRebootSystemWarningModal = function () {
        $("#rebootSystemWarningModalHeader").text($("#js_warning").text());
        // button click events
        $("#rebootSystemWarningModalButtons button").unbind("click");
        $("#rebootSystemWarningModalOk").click(function () {
            $.modal.close();
            if (globals.variables.upgradeWebcontrolOs && updates.webcontrolValue != null) {
                updates.upgradeWebcontrolFromOs();
            }
        });
        $('#rebootSystemWarningModal').modal({
            closeHTML: "<a href='' title='" + $("#js_close").text() + "'></a>",
            overlayId: 'modal-overlay',
            containerId: 'rebootSystemWarningModal-container'
        });

    };

    /**
     * Handles webcontrol upgrade from the OS repository
     */
    updates.upgradeWebcontrolFromOs = function () {
        $.ajax({
            type: "PUT",
            url : "/api/updates/os",
            cache: false,
            data: "packages=" + updates.webcontrolValue+"&csrf_token="+$("#csrf_token").val(),
            beforeSend: function () {
                $("#selectSystemUpdatesModalTableDiv").mask($("#js_updating").text());
            },
            error: function (xmlHttpReq, textStatus, errorThrown) {
                if (navigator.appName.toLowerCase().indexOf("internet explorer") > -1 &&
                    xmlHttpReq.responseText.indexOf("Failed dependencies") == -1) {
                    updates.openWebcontrolChangedModal();
                } else {
                    globals.functions.ajaxError(xmlHttpReq, textStatus, errorThrown);
                }
            },
            complete: function () {
                globals.variables.upgradeWebcontrolOs = false;
                updates.webcontrolValue = null;
                $("#selectSystemUpdatesModalTableDiv").unmask();
                updates.openWebcontrolChangedModal();
            }
        });
    };

    updates.refreshServicesUpdatesFildset = false;

    /**
     * Displays a warning before cleaning the cache
     */
    updates.openClearCacheWarningModal = function () {
        $("#clearCacheWarningModalHeader").text($("#js_warning").text());
        //button click events
        $("#clearCacheWarningModalButtons button").unbind("click");
        $("#clearCacheWarningModalNo").click(function () {
            $.modal.close();
            if (updates.refreshServicesUpdatesFildset) {
                updates.refreshServicesUpdatesFildset = false;
                updates.buildUpdateServicesFieldset();
            }
        });
        $("#clearCacheWarningModalYes").click(function () {
            $("#clearCacheWarningModalText label").text($("#js_clearCacheInProgress").text());
            globals.functions.enableButton("clearCacheWarningModalYes", false);
            globals.functions.enableButton("clearCacheWarningModalNo", false);
            $.ajax({
                type: 'PUT',
                url: '/api/updates/cache',
                data: "csrf_token="+$("#csrf_token").val(),
                error: function (xmlHttpReq, textStatus, errorThrown) {
                    globals.functions.ajaxError(xmlHttpReq, textStatus, errorThrown);
                    $("#clearCacheWarningModalText label").text($("#js_clearCacheError").text());
                    $("#clearCacheWarningModalYes").hide();
                    $("#clearCacheWarningModalNo").text($("#js_Ok").text());
                    globals.functions.enableButton("clearCacheWarningModalNo", true);
                    updates.refreshServicesUpdatesFildset = true;
                },
                success: function() {
                    $("#clearCacheWarningModalText label").text($("#js_clearCacheDone").text());
                    $("#clearCacheWarningModalYes").hide();
                    $("#clearCacheWarningModalNo").text($("#js_Ok").text());
                    globals.functions.enableButton("clearCacheWarningModalNo", true);
                    updates.refreshServicesUpdatesFildset = true;
                }
            });
        });
        $('#clearCacheWarningModal').modal({
            closeHTML: "<a href='' title='" + $("#js_close").text() + "'></a>",
            overlayId: 'modal-overlay',
            containerId: 'clearCacheWarningModal-container'
        });
    };


    updates.buildUpdateServicesFieldset();
    updates.buildUpdateSystemFieldset();


    updates.adjustTableHeadersOnResize = function() {
        if (globals.variables.currentTab != "updates") {
            $(window).unbind("resize", updates.adjustTableHeadersOnResize);
            return;
        }
        for (var tableIdx in updates.fixedHeaderTables) {
            tableId = updates.fixedHeaderTables[tableIdx];
            globals.functions.resizeFixedTableHeader(tableId);
        }
    }

    $(window).bind("resize", function() {
        if (updates.tableResizeHandler) {
            clearTimeout(updates.tableResizeHandler);
        }
        updates.tableResizeHandler = setTimeout(updates.adjustTableHeadersOnResize, 300);
    });

});
