# Copyright 2010 Avaya Inc. All Rights Reserved.

"""
REST API for 3rd party vendor integration.
"""

import web
import json
import configobj
import glob
import os

from core.common import vendor_i18n
from core.common import version
from core.plugins import plugin_manager

__author__      = "Avaya Inc."
__copyright__   = "Copyright 2010, Avaya Inc."

VENDOR_CONFIG_DIRECTORY = 'static/vendor_config'

class VendorSystemInfoResource(object):
    """"
    REST resource to access 3rd party system information.
    """
    def GET(self):
        """
        Return a json string with vendor system info
        """
        web.header("Content-Type","application/json")
        
        info = {}
        for plugin in plugin_manager.PLUGINS:
            if hasattr(plugin, 'system_info') and hasattr(plugin, 'name'):
                info['vendor_name'] = plugin.name()
                info['system_info'] = plugin.system_info()
                break
        return json.dumps(info)

class VendorTabsResource(object):
    """"
    REST resource to access and render 3rd party tabs
    """
    def GET(self, id):
        """
        Returns a json string with the available vendors if id is not provided
        Renders an html file if the id is provided
        """
        if id:
            page = web.template.frender('templates/vendor_tabs/%s.html' % id,
                                        globals={'_': vendor_i18n.custom_gettext, 'build': version.BUILD_UID})
            return page()
        else:
            vendors_config = configobj.ConfigObj()
            for config_file in glob.glob(os.path.join(VENDOR_CONFIG_DIRECTORY, '*.ini')):
                cfg = configobj.ConfigObj(config_file)
                vendors_config.merge(cfg)
            web.header("Content-Type","application/json")
            return json.dumps(vendors_config.dict())
