/*
/*
 * Copyright 2010 Avaya Inc. All Rights Reserved.
 */

$(document).ready(function() {

    var ignition = {};

    ignition.REDIRECT_SESSION_EXPIRED = 0;
    ignition.REDIRECT_IGNITION_CANCELED = 1;
    ignition.REDIRECT_IGNITION_COMPLETED = 2;
    ignition.REDIRECT_IGNITION_COMPLETED_NEW_IP = 3;

    ignition.previousStep = 1;
    ignition.currentStep = 1;
    ignition.firstStep = 1;
    ignition.lastStep = 9;

    ignition.language = "";

    ignition.eulaStep = 1;
    ignition.serverTypeStep = 2;
    ignition.addHardwareStep = 3;
    ignition.networkStep = 4;
    ignition.timeCompandingStep = 5;
    ignition.changePassStep = 6;
    ignition.servicesStep = 7;
    ignition.securityStep = 8;
    ignition.summaryStep = 9;

    ignition.stepsPassed = [];

    ignition.changePassword = false;
    ignition.passwordRules = null;
    ignition.caPresent = false;
    ignition.displayedCaWarnings = false;
    ignition.caSubject = "";
    ignition.caIssuedBy = "";

    ignition.totalSpace = null;
    ignition.effectiveSpace = null;

    ignition.networkData = null;
    ignition.ntpData = null;

    ignition.currentIp = null;
    ignition.initialUseDHCP = false;
    ignition.dhcpEnabled = false;
    ignition.url = "/";

    ignition.currentDate = null;
    ignition.currentHour = null;
    ignition.currentMinutes = null;
    ignition.callSetDateAndTime = false;
    ignition.callSetNtp = false;

    ignition.serverHwRequirementsData = null;
    ignition.systemHwData = null;
    ignition.serverType = null;
    ignition.factoryFlagSet = false;
    ignition.localeOptions = null;
    ignition.newHddPresent = false;
    ignition.invalidMountPoints = [];
    ignition.default_mount_point_root = "";

    ignition.compandingReady = false;
    ignition.timezoneReady = false;
    ignition.ntpReady = false;
    ignition.dateReady = false;
    ignition.passwordReady = false;
    ignition.adminPasswordReady = false;
    ignition.serverTypeReady = false;
    ignition.authTypeReady = false;
    ignition.isVirtualized = false;
    ignition.hwReady = false;

    ignition.systemId = "";

    ignition.SET_SERVER_MODE_TIMEOUT      = 7 * 60 * 1000;   // ms

    globals.functions.verticalAlignContainer("ignitionContainer");

    // Get inactivity timeout value and initialize the activity monitor
    $.ajax({
        type: "GET",
        url: "/api/settings/webcontrol",
        dataType: "json",
        cache: false,
        error: function (xmlHttpReq, textStatus, errorThrown) {
            ignition.requestErrorHandler(xmlHttpReq, textStatus, errorThrown, $("#js_failedGetTimeout").text());
        },
        success: function(data) {
            // Initialize activity monitor
            $.activity.init({
                // Set interval check to every 5 seconds
                interval: 1000*5,
                intervalFn: function(info){
                    //do nothing
                },
                // Set inactive check
                inactive: 1000 * data.timeout,
                inactiveFn: function(info) {
                    alert($("#js_sessionExpiredLabel").text() + ". " + $("#js_redirectToLogin").text());
                    jQuery.ajax({
                        type: 'DELETE',
                        url: '/api/session',
                        complete: function(xhr, statusText) {
                            ignition.handleRedirection(ignition.REDIRECT_SESSION_EXPIRED);
                        }
                    });
                }
            });

            // Handle activity reactivation and update
            $(document).click(function(){
                if ( $.activity.isActive() ) {
                    $.activity.update();
                } else {
                    $.activity.reActivate();
                }
            });
        }
    });

    /**
     * Calls EULA tab functions
     */
    ignition.renderEula = function () {
        /**
        * Gets the language and selects the proper option from the combo box.
        */
        //$("#prevLink")[0].innerHTML = $("#js_decline").text();
        $("#nextLink").show();
        //$("#prevLink").show();
        $("#prevLink").hide();
        $("#applyIgnitionSettings").hide();
        if (ignition.eulaStep in ignition.stepsPassed) {
            return;
        }
        $.ajax({
            type: "GET",
            url: "/api/i18n/lang",
            cache: false,
            error: function (xmlHttpReq, textStatus, errorThrown) {
                ignition.requestErrorHandler(xmlHttpReq, textStatus, errorThrown, $("#js_failedGetLanguage").text());
            },
            success: function (data) {
                ignition.language = data;
            },
            complete: function () {
                $("#avayaLicense").load("/static/eula/" + ignition.language + ".html", function () {
                    $("#printLicence").unbind("click");
                    $("#printLicence").click( function(e) {
                        e.preventDefault();
                        window.open("/static/eula/" + ignition.language + ".html")
                    });
                    $("#ignitionContentDiv").unmask();
                });
            }
        });       
        $("#ignitionContentDiv").mask($("#js_loading").text());
    };

    /**
     * Renders the hardware settings step.
     */
    ignition.renderHardwareStep = function () {

        $("#nextLink").show();
        $("#applyIgnitionSettings").hide();
        if (ignition.addHardwareStep in ignition.stepsPassed) {
            return;
        }
        $.ajax({
            type: "GET",
            url: "/api/system/newhw",
            dataType: "json",
            timeout: globals.variables.NEW_HARDWARE_TIMEOUT,
            cache: false,
            error: function (xmlHttpReq, textStatus, errorThrown) {
                ignition.requestErrorHandler(xmlHttpReq, textStatus, errorThrown, $("#js_failedGetNetworkData").text());
                $("#ignitionContentDiv").unmask();
            },
            beforeSend: function () {
                $("#ignitionContentDiv").mask($("#js_loading").text());
            },
            success: function (data) {

                if (data.length > 0) {

                    $("#noHardwareDetectedLabel").hide();
                    $("#addHddInfoDiv").show();
                    var newHdd = data[0];
                    $("#addHddName").text(newHdd.name);
                    $("#addHddType").text(newHdd.device_type);
                    $("#addHddProduct").text(newHdd.product);
                    $("#addHddVendor").text(newHdd.vendor);
                    $("#addHddCapacity").text(newHdd.user_capacity);
                    $("#addHddEffectiveCapacity").text(newHdd.remaining_space + $("#js_gb").text());
                    $("#partition1Input").val(newHdd.remaining_space);
                    $("#partition2Input").val($("#js_noneNewHdd").text());
                    $("#partition3Input").val($("#js_noneNewHdd").text());
                    $("#mountPointInput").val(newHdd.default_mount_point);
                    if (newHdd.serial_number !== undefined && newHdd.virtualized == false) {
                        $("#serialNumberDiv").show();
                        $("#addHddSerialNumber").text(newHdd.serial_number);
                    } else {
                        $("#serialNumberDiv").hide();
                    }
                    ignition.effectiveSpace = parseFloat(newHdd.remaining_space).toFixed(2);
                    ignition.invalidMountPoints = newHdd.restricted_folders;
                    ignition.default_mount_point_root = newHdd.default_mount_point;

                    if ($('#createPartitionsCheckbox').is(":checked")) {
                        $(".partitionField").attr("disabled", false);
                    } else { 
                        $(".partitionField").attr("disabled", true);
                    }

                    $("#createPartitionsCheckbox").unbind("change");
                    $("#createPartitionsCheckbox").change( function(){
                        $(".partitionField").attr("disabled", !this.checked);
                    });
                    $("#mountHardwareCheckbox").unbind("change");
                    $("#mountHardwareCheckbox").change( function(){
                        $("#mountPointInput").attr("disabled", !this.checked);
                        if (this.checked) {
                            $("#mountLater").hide();
                        } else {
                            $("#mountLater").show();
                        }
                    });
                    ignition.newHddPresent = true;

                } else {
                    $("#noHardwareDetectedLabel").show();
                    $("#addHddInfoDiv").hide();
                    ignition.newHddPresent = false;
                }

                $("#ignitionContentDiv").unmask();

            }
        });

    };

    /**
     * Checks if the mount path is not among the ones already in use by the system.
     */
    ignition.validMountPoint = function () {
        var mountPoint = $("#mountPointInput").val();
        var root = ignition.default_mount_point_root.split("#")[0];
        if (mountPoint.indexOf(root) == 0) {
            return true;
        }
        return false;
        /*if (mountPoint.indexOf("/") != 0) {
            mountPoint = "/" + mountPoint;
        }
        var mountPointBase = mountPoint.split("/")[1];
        for (var i = 0; i < ignition.invalidMountPoints.length; i++) {
            if (ignition.invalidMountPoints[i].split("/")[1] == mountPointBase) {
                return false;
            }
        }
        return true;*/
    };

    /**
     * Performs validation checks for the new hardware settings
     *
     * @return {Boolean}    false if validation fails , true otherwise
     */
    ignition.performAddHddChecks = function () {
        if (ignition.newHddPresent) {
            if  ($("#mountHardwareCheckbox")[0].checked && $("#mountPointInput").val() == "") {
                alert($("#js_noMountPoint").text());
                return false;
            } else if ($("#mountHardwareCheckbox")[0].checked && !ignition.validMountPoint()) {
                alert($("#js_invalidMountPoint").text().replace("%s0", ignition.default_mount_point_root.split("#")[0]));
                return false;
            }
            if ($("#createPartitionsCheckbox")[0].checked) {
                var sum = 0;
                for (var i = 0; i < $(".partitionField").length; i++) {
                    var field = $(".partitionField")[i];
                    if (field.value != $("#js_noneNewHdd").text()) {
                        if (!globals.validators.isFloat(field.value)) {
                            alert($("#js_invalidSpaceValue").text().replace("%s0", field.name));
                            return false;
                        }
                        sum += parseFloat(field.value);
                    }
                }
                if (sum == 0) {
                    alert($("#js_pleaseAssignSpace").text());
                    return false;
                } else if (sum > ignition.effectiveSpace) {
                    alert($("#js_spaceExceeded").text().replace("%s0", ignition.effectiveSpace));
                    return false;
                }
            }
        }
        return true;
    };

    /**
     * Applies the hardware settings.
     */
    ignition.setHardware = function () {
        if (ignition.newHddPresent) {
            var hddSettings = "";
            if ($("#mountHardwareCheckbox")[0].checked) {
                hddSettings += "activate=True";
            } else {
                hddSettings += "activate=False";
            }
            hddSettings += "&mount_path=" + encodeURIComponent($("#mountPointInput").val());
            hddSettings += "&path=" + encodeURIComponent($("#addHddName").text());
            if (!$("#createPartitionsCheckbox").is(":checked")) {
                $.ajax({
                    type: "PUT",
                    url: "/api/system/newhw",
                    data: hddSettings + "&csrf_token="+$("#csrf_token").val(),
                    timeout: globals.variables.NEW_HARDWARE_TIMEOUT,
                    cache: false,
                    error: function (xmlHttpReq, textStatus, errorThrown) {
                        ignition.requestErrorHandler(xmlHttpReq, textStatus, errorThrown, $("#js_addHddFailed").text());
                    },
                    complete: function () {
                        ignition.hwReady = true;
                        ignition.notifySettingsApplied();
                    }
                });
            } else {
                hddSettings += "&format_drive=True";
                for (var i = 0; i < $(".partitionField").length; i++) {
                    var field = $(".partitionField")[i];
                    var index = i + 1;
                    if (field.value == $("#js_noneNewHdd").text()) {
                        hddSettings += "&partition" + index + "_size=0";
                    } else {
                        hddSettings += "&partition" + index + "_size=" + field.value;
                    }
                }
                $.ajax({
                    type: "POST",
                    url: "/api/system/newhw",
                    data: hddSettings + "&csrf_token="+$("#csrf_token").val(),
                    timeout: globals.variables.NEW_HARDWARE_TIMEOUT,
                    cache: false,
                    error: function (xmlHttpReq, textStatus, errorThrown) {
                        ignition.requestErrorHandler(xmlHttpReq, textStatus, errorThrown, $("#js_addHddFailed").text());
                    },
                    complete: function () {
                        ignition.hwReady = true;
                        ignition.notifySettingsApplied();
                    }
                });
            }
        } else {
            ignition.hwReady = true;
            ignition.notifySettingsApplied();
        }
    };

    /**
     * Calls Network Config tab functions
     */
    ignition.renderNetworkConfig = function () {
        $("#nextLink").show();
        $("#applyIgnitionSettings").hide();
        if (ignition.networkStep in ignition.stepsPassed) {
            return;
        }
        $.ajax({
            type: "GET",
            url: "/api/system/network",
            dataType: "json",
            cache: false,
            error: function (xmlHttpReq, textStatus, errorThrown) {
                ignition.requestErrorHandler(xmlHttpReq, textStatus, errorThrown, $("#js_failedGetNetworkData").text());
                $("#ignitionContentDiv").unmask();
            },
            beforeSend: function () {
                $("#ignitionContentDiv").mask($("#js_loading").text());
            },
            success: function (data) {
                data.use_prefix = false;

                ignition.networkData = data;
                var interfaceID = 0;
                var interfaceObj = ignition.networkData.interfaces[interfaceID];
                $("#ignitionNetworkInterfaceIndicator em").text(interfaceObj.name);
                $("#ipAddressInput").val(interfaceObj.ipaddr);
                $("#subnetMaskInput").val(interfaceObj.netmask);
                if (ignition.networkData.use_prefix) {
                    $("#prefixInput").val(interfaceObj.prefix);
                    if (interfaceObj.netmask != null && interfaceObj.prefix == null) {
                        $("#prefixInput").val(globals.functions.netmaskToPrefix(interfaceObj.netmask));
                    }
                    if (interfaceObj.prefix != null && interfaceObj.netmask == null) {
                        $("#subnetMaskInput").val(globals.functions.prefixToNetmask(interfaceObj.prefix));
                    }
                    $("#networkPrefixDiv").show();
                } else {
                    $("#networkPrefixDiv").hide();
                }
                if (interfaceObj.gateway != null) {
                    $("#defaultGatewayInput").val(interfaceObj.gateway);
                }
                $("#useDhcpCheckbox").attr("checked", interfaceObj.use_dhcp);
                $("#ignitionIPAddrFieldset input:text").attr("disabled", interfaceObj.use_dhcp);
                $("#defaultGatewayInput").attr("disabled", interfaceObj.use_dhcp);
                $("#autoDNSCheckbox").attr("checked", interfaceObj.auto_dns);
                $("#autoDNSCheckbox").attr("disabled", !interfaceObj.use_dhcp);
                $("#ignitionDNSFieldset input:text").attr("disabled", interfaceObj.use_dhcp && interfaceObj.auto_dns);
                $("#dnsInput1").val(ignition.networkData.dns[0]);
                $("#dnsInput2").val(ignition.networkData.dns[1]);
                $("#hostNameInput").val(ignition.networkData.hostname);
                ignition.initialUseDHCP = interfaceObj.use_dhcp;
                ignition.currentIp = interfaceObj.ipaddr;
                $("#ignitionContentDiv").unmask();

            },
            complete: function (xhr) {
                if (xhr.status != 200) {
                    $("#ignitionContentDiv").unmask();
                }
            }
        });

        // Use DHCP checkbox click event
        $("#useDhcpCheckbox").unbind("click");
        $("#useDhcpCheckbox").change( function(){
            $("#ignitionIPAddrFieldset input:text").attr("disabled", this.checked);
            $("#defaultGatewayInput").attr("disabled", this.checked);
            $("#autoDNSCheckbox").attr("disabled", !this.checked);
            $("#autoDNSCheckbox").attr("checked", this.checked);
            $("#ignitionDNSFieldset input:text").attr("disabled", this.checked && $("#autoDNSCheckbox").is(":checked"));
        });

        // Auto DNS checkbox click event
        $("#autoDNSCheckbox").unbind("change");
        $("#autoDNSCheckbox").change( function(){
            $("#ignitionDNSFieldset input:text").attr("disabled", this.checked);
        });
    };

    ignition.renderTimezone = function(factoryFlagSet, callback) {
        // Get timezones data
        $.ajax({
            type: "GET",
            url: "/api/system/timezones",
            dataType: "json",
            cache: false,
            error: function (xmlHttpReq, textStatus, errorThrown) {
                ignition.requestErrorHandler(xmlHttpReq, textStatus, errorThrown, $("#js_failedGetTimezones").text());
                $("#ignitionContentDiv").unmask();
            },
            beforeSend: function () {
                $("#ignitionContentDiv").mask($("#js_loading").text());
            },
            success: function (data) {
                var timezonesArray = [];
                if (factoryFlagSet) {
                    timezonesArray.push("");
                }
                for (var i = 0; i < data.length; i++) {
                   timezonesArray.push(data[i].name);
                }
                var sortedTimezonesArray = timezonesArray.sort();
                for (var i = 0; i < sortedTimezonesArray.length; i++) {
                   $("#selectTimezone").append("<option id='" + sortedTimezonesArray[i]
                                                   + "' value='" + sortedTimezonesArray[i]
                                                   + "'>" + sortedTimezonesArray[i] + "</option>");
                }
                if (!factoryFlagSet) {
                    $.ajax({
                        type: "GET",
                        url: "/api/system/timezone",
                        dataType: "json",
                        cache: false,
                        error: function (xmlHttpReq, textStatus, errorThrown) {
                            ignition.requestErrorHandler(xmlHttpReq, textStatus, errorThrown,
                                $("#js_failedGetTimezone").text());
                        },
                        success: function (data) {
                            $("#selectTimezone").val(data.name);
                        },
                        complete: function () {
                            callback();
                        }
                    });
                } else {
                    callback();
                }
            }
        });
    };

    /**
     * Calls Time & Companding tab functions.
     */
    ignition.renderTimeCompanding = function () {
        $("#nextLink").show();
        $("#applyIgnitionSettings").hide();

        var timezonesReady = false;
        var ntpReady = false;
        var dateReady = false;

        var isAppl = (ignition.serverType == "Appl");
        $("#ignitionCompandingFieldset").toggle(!isAppl);
        $("#ignitionCompandingMsgFieldset").toggle(isAppl);

        var showNTP = ((ignition.serverType == "Primary") || (ignition.serverType == "Appl"));
        $(".ignitionNTPSettings").toggle(showNTP);
        $(".ignitionDateTimeSettings").toggle(showNTP && !ignition.isVirtualized);
        if (!showNTP) {
            $("#useNtpCheckbox").attr("checked", false);
            ignition.disableDateOrNtp(false);
            ntpReady = true;
        } else {
            if (ignition.ntpData == null) {
                // Get ntp data
                $.ajax({
                    type: "GET",
                    url: "/api/system/ntp",
                    dataType: "json",
                    cache: false,
                    error: function (xmlHttpReq, textStatus, errorThrown) {
                        ignition.requestErrorHandler(xmlHttpReq, textStatus, errorThrown, $("#js_failedGetNTP").text());
                        $("#ignitionContentDiv").unmask();
                    },
                    success: function (data) {
                        ignition.ntpData = data;
                        $("#useNtpCheckbox").attr("checked", ignition.ntpData.use_ntp);
                        var serversString = "";
                        for (var i = 0; i < ignition.ntpData.servers.length; i++) {
                            if (i != data.servers.length-1) {
                                serversString += data.servers[i] + ",";
                            } else {
                                serversString += data.servers[i];
                            }
                        }
                        $("#ntpServersInput").val(serversString.split(",")[0]);

                        $("#useNtpCheckbox").unbind("change");
                        ignition.disableDateOrNtp(data.use_ntp);
                        $("#useNtpCheckbox").change( function(){
                            ignition.disableDateOrNtp(this.checked);
                        });
                    },
                    complete: function () {
                        ntpReady = true;
                        if (timezonesReady && ntpReady && dateReady) {
                            $("#ignitionContentDiv").unmask();
                        }
                    }
                });
            } else {
                ntpReady = true;
            }
        }

        if (ignition.timeCompandingStep in ignition.stepsPassed) {
            return;
        }
        ignition.stepsPassed[ignition.timeCompandingStep] = 1;

        ignition.localeOptions = globals.getLocaleOptions(ignition.language);
        $.datepicker.setDefaults($.datepicker.regional[ignition.localeOptions.language]);
        $("#dateInput").datepicker({
            showOn: 'focus',
            dateFormat: ignition.localeOptions.format,
            showAnim: ''
        });
        $(".ui-datepicker-trigger").addClass("datepickerIconMargin");

        // Get install type (factory/manual) and set timezone accordingly
        $.ajax({
            type: "GET",
            url: globals.REST_URL.INSTALLER_TYPE,
            cache: false,
            error: function (xmlHttpReq, textStatus, errorThrown) {
                ignition.requestErrorHandler(xmlHttpReq, textStatus, errorThrown, $("#js_failedGetInstallType").text());
            },
            beforeSend: function () {
                $("#ignitionContentDiv").mask($("#js_loading").text());
            },
            success: function (data) {
                ignition.factoryFlagSet = data.factory_flag;
            },
            complete: function () {
                ignition.renderTimezone(ignition.factoryFlagSet, function() {
                    timezonesReady = true;
                    if (timezonesReady && ntpReady && dateReady) {
                        $("#ignitionContentDiv").unmask();
                    }
                });
            }
        });

        // Get date and time
        $.ajax({
            type: "GET",
            url: "/api/system/date",
            cache: false,
            error: function (xmlHttpReq, textStatus, errorThrown) {
                ignition.requestErrorHandler(xmlHttpReq, textStatus, errorThrown, $("#js_faildGetDate").text());
                $("#ignitionContentDiv").unmask();
            },
            success: function (data) {
                var parsedDateObject = globals.functions.splitDateString(data);
                $("#dateInput").val(parsedDateObject.date);
                $("#timeHourInput").val(parsedDateObject.hour);
                $("#timeMinutesInput").val(parsedDateObject.minutes);
                ignition.currentDate = parsedDateObject.date;
                ignition.currentHour = parsedDateObject.hour;
                ignition.currentMinutes = parsedDateObject.minutes;
            },
            complete: function () {
                dateReady = true;
                if (timezonesReady && ntpReady && dateReady) {
                    $("#ignitionContentDiv").unmask();
                }
            }
        });
        if (showNTP) {
            $("#timeHourInput").keyup( function(e) {
                e.preventDefault(e);
                $("#timeHourInput").val($("#timeHourInput").val().replace(/[^\d]/,''));

            });
            $("#timeMinutesInput").keyup( function(e) {
                e.preventDefault(e);
                $("#timeMinutesInput").val($("#timeMinutesInput").val().replace(/[^\d]/,''));

            });
        }
    };

    /**
     * Disables the date components or the NTP components.
     *
     * @param useNtp    true to disable the date fields
     *                  false to disable the NTP related fields
     */
    ignition.disableDateOrNtp = function (useNtp) {
        $("#dateInput").attr("disabled", useNtp);
        $("#timeMinutesInput").attr("disabled", useNtp);
        $("#timeHourInput").attr("disabled", useNtp);
        $("#ntpServersInput").attr("disabled", !useNtp);
    };

    /**
     * Calls Change Password tab functions
     */
    ignition.renderChangePass = function () {
        $("#nextLink").show();
        $("#applyIgnitionSettings").hide();
        ignition.changePassword = true;
        if (ignition.changePassStep in ignition.stepsPassed) {
            return;
        }
        $(".ignitionPasswordRulesLink").unbind("click").click(function (e) {
            e.preventDefault();
            var message = $("#js_passwordRules").text().replace("%s0", this.name) + "\n";
            if (this.name == "root") {
                message += $("#js_minLength").text().replace("%s0", globals.variables.minPasswordLength) + "\n";
                message += $("#js_maxLength").text().replace("%s0", globals.variables.maxPasswordLength) + "\n";
                message += $("#js_codePointSets").text().replace("%s0", globals.variables.minCodePointSets) + "\n";
                message += $("#js_consecutiveChars").text().replace("%s0", globals.variables.passwordSequenceLength) + "\n";
                message += $("#js_wellKnownWords").text() + "\n";
            } else if (this.name == "Administrator") {
                message += $("#js_minLength").text().replace("%s0", globals.variables.minPasswordLength) + "\n";
                message += $("#js_maxLength").text().replace("%s0", globals.variables.maxPasswordLength) + "\n";
                message += $("#js_codePointSets").text().replace("%s0", globals.variables.minCodePointSets) + "\n";
                message += $("#js_consecutiveChars").text().replace("%s0", globals.variables.passwordSequenceLength) + "\n";
                message += $("#js_wellKnownWords").text() + "\n";
            } else {
                message += $("#js_minLength").text().replace("%s0", globals.variables.minSystemPasswordLength) + "\n";
                message += $("#js_maxLength").text().replace("%s0", globals.variables.maxPasswordLength) + "\n";
                message += $("#js_identicalSystemPassword").text() + "\n";
                message += $("#js_wellKnownWords").text() + "\n";
                message += $("#js_nonASCIIChars").text() + "\n";
            }
            alert(message);
        });
    };

    /**
     * Calls Server Type tab functions
     */
    ignition.renderServerType = function () {
        $("#nextLink").show();
        $("#applyIgnitionSettings").hide();
        if (ignition.serverTypeStep in ignition.stepsPassed) {
            return;
        }
        return;
        /*
        if (ignition.isVirtualized) {
            //IPOFFICE-29957 - do not display hw requirements if IPO is virtualized
            $(".hwreq").hide();
            $("#hwRequirementsWarning").hide();
            return;
        }
        // Get recommended hardware profiles
        $.ajax({
            type: "GET",
            url: globals.REST_URL.HW_PROFILES,
            dataType: "json",
            cache: false,
            error: function (xmlHttpReq, textStatus, errorThrown) {
                ignition.requestErrorHandler(xmlHttpReq, textStatus, errorThrown,
                    $("#js_failedGetHardwareProfile").text());
                $("#ignitionContentDiv").unmask();
            },
            success: function (data) {
                ignition.serverHwRequirementsData = data;
            },
            complete: function () {
                for (var hwRequirement in ignition.serverHwRequirementsData) {
                    var cpuModel = $("#js_" + ignition.serverHwRequirementsData[hwRequirement]["cpu_model"]).text();
                    var cpuMhz = ignition.serverHwRequirementsData[hwRequirement]["cpu_mhz"];
                    var cpuCores = ignition.serverHwRequirementsData[hwRequirement]["cpu_cores"];
                    var hdd = ignition.serverHwRequirementsData[hwRequirement]["disk_total"];
                    var mem = ignition.serverHwRequirementsData[hwRequirement]["mem_total"];
                    var eth = ignition.serverHwRequirementsData[hwRequirement]["port_ethernet"];
                    var dvd = ignition.serverHwRequirementsData[hwRequirement]["dvd"];
                    var usb = ignition.serverHwRequirementsData[hwRequirement]["port_usb"];

                    var cpuSize = (parseInt(cpuMhz) / 1000).toString().replace(".", $("#js_decimalSeparator").text());
                    var hddSize = globals.functions.bytesToSize(parseInt(hdd) * 1024, 0);
                    var memSize = globals.functions.bytesToSize(parseInt(mem) * 1024, 0);

                    globals.functions.composeText("hwRequirements-" + hwRequirement, "js_specs",
                        [cpuModel, cpuSize, cpuCores, memSize, hddSize, eth, dvd, usb]);
                }
                $("#ignitionContentDiv").unmask();
            }
        });
        $("#ignitionContentDiv").mask($("#js_loading").text());
        */
    };

    /**
     * Renders the summary step , with the selected settings
     */
    ignition.renderSummaryInfo = function() {
        if (ignition.serverType == "Appl") {
            $("#summaryVMProLabel").text(($("#useVoiceMailPro:checked").val() != undefined) ? $("#js_Yes").text() : $("#js_No").text());
            $("#summaryOneXLabel").text(($("#useOneXportal:checked").val() != undefined) ? $("#js_Yes").text() : $("#js_No").text());
            $("#ignitionSummaryData .serviceSummary").show();
        } else {
            $("#ignitionSummaryData .serviceSummary").hide();
        }
        $("#summarySystemIdLabel").text(ignition.systemId);
        var useDHCP = $("#useDhcpCheckbox:checked").val() != undefined;
        $("#summaryIpLabel").text((useDHCP) ? $("#js_automaticDhcp").text() : $("#ipAddressInput").val());
        $("#summaryNetmaskLabel").text((useDHCP) ? $("#js_automaticDhcp").text() : $("#subnetMaskInput").val());
        if (ignition.networkData.use_prefix) {
            $("#summaryPrefixLabel").text((useDHCP) ? $("#js_automaticDhcp").text() : $("#prefixInput").val());
            $("#summaryPrefixCaption").show();
            $("#summaryPrefixLabel").show();
        } else {
            $("#summaryPrefixCaption").hide();
            $("#summaryPrefixLabel").hide();
        }
        $("#summaryGatewayLabel").text((useDHCP) ? $("#js_automaticDhcp").text() : $("#defaultGatewayInput").val());

        var autoDNS = $("#autoDNSCheckbox:checked").val() != undefined;
        $("#summaryPrimaryDnsLabel").text((autoDNS) ? $("#js_automaticDhcp").text() : $("#dnsInput1").val());
        $("#summarySecondaryDnsLabel").text((autoDNS) ? $("#js_automaticDhcp").text() : $("#dnsInput2").val());

        $("#summaryHostnameLabel").text($("#hostNameInput").val());
        $("#summaryTimezoneDnsLabel").text($("#selectTimezone option:selected").text());

        var showNTP = ((ignition.serverType == "Primary") || (ignition.serverType == "Appl"));
        $(".ignitionNTPSummary").toggle(showNTP);
        if (showNTP) {
            var useNTP = ($("#useNtpCheckbox:checked").val() != undefined);
            $("#summaryUseNtpDnsLabel").text((useNTP) ? $("#js_Yes").text() : $("#js_No").text());
            if (useNTP) {
                $("#summaryNtpServerLabel").text($("#ntpServersInput").val());
                $("#summaryNtpServerDnsLabel").text($("#ntpServersInput").val());
                $(".ntpServerValue").show();
            } else {
                $("#summaryNtpServerDnsLabel").text("");
                $(".ntpServerValue").hide();
            }
        }
        var companding = $("#js_notAvaliable").text();
        if (ignition.serverType != "Appl") {
            companding = $("input[name='compandingMode']:checked").val();
            if (companding == "u-law") {
                companding = $("#js_uLaw").text();
            } else if (companding == "A-law") {
                companding = $("#js_aLaw").text();
            }
        }
        $("#summaryCompandingLabel").text(companding);

        if (ignition.newHddPresent) {
            if ($("#mountHardwareCheckbox").is(":checked")) {
                globals.functions.composeText("addHardwareLabel", "js_newHddMounted",
                    [$("#addHddName").text(), $("#mountPointInput").val()]);
            } else {
                globals.functions.composeText("addHardwareLabel", "js_newHddNotMounted", [$("#addHddName").text()]);
            }
        } else {
            $("#addHardwareLabel").text($("#js_noNewHddAvailable").text());
        }

        if (ignition.serverType == "Primary" || ignition.serverType == "Appl") {
            $(".caSummary").show();
            $("#caNotPresent").remove();
            if (!ignition.caPresent) {
                $("#downloadCaPem").remove();
                $("#downloadCaDer").remove();
                $("#caSummaryLink").append('<label id="caNotPresent" class="redText">' + $("#js_caNotPresent").text() + '</label>');
            }
        } else {
            $(".caSummary").hide();
        }

        $("#summaryServerTypeLabel").text($("#js_server" + $("input[name='serverType']:checked").val()).text());

        $("#printSummary").unbind("click");
        $("#printSummary").click( function(e) {
            e.preventDefault();
            var linkStartIndex = $("#ignitionSummaryData").html().indexOf('<a id="downloadCaPem" href="/api/settings/certificate/ca/root-ca.pem">');
            var linkStopIndex = $("#ignitionSummaryData").html().lastIndexOf('</a>') + 4;
            var linkSubstring = $("#ignitionSummaryData").html().substring(linkStartIndex, linkStopIndex);
            var printContent = $("#ignitionSummaryData").html();
            if (linkStartIndex > -1) {
                printContent = $("#ignitionSummaryData").html().replace(linkSubstring, "");
            }
            var ignitionSummaryPrint = window.open("", "ignitionSummaryPrint", "");
            var html = "<!doctype html><html><head><title>IP Office Server Edition Ignition</title>";
            html += "<link rel='stylesheet' href='/static/css/ignition.css' type='text/css'>";
            html += "</head><body class='ignitionSummaryPrintPage'>";
            html += "<h1>IP Office Server Edition - " + $("#js_ignitionSummary").text() + "</h1>";
            html += "<div id='ignitionSettingsListDiv'><dl>" + printContent + "</dl></div>";
            html += "</body></html>";
            ignitionSummaryPrint.document.writeln(html);
            ignitionSummaryPrint.document.close();
        });

        if (ignition.isVirtualized) {
            $("#systemIdVirtualWarning").show();
        }
        $("#applyIgnitionSettings").unbind("click");
        $("#applyIgnitionSettings").click( function(){
            ignition.applySettings();
        });
    };

    /**
     * Render configure services step.
     */
    ignition.renderServicesStep = function () {
        $("#nextLink").show();
        $("#applyIgnitionSettings").hide();
    };

    /**
     * Renders the security step
     */
    
    ignition.renderSecurityStep = function () {

        $.ajax({
            type: "GET",
            url: "/api/settings/certificate/generate",
            timeout: globals.variables.CERTIFICATE_DEFAULTS_TIMEOUT,
            cache: false,
            beforeSend: function () {
                $("#ignitionSecurityDiv").mask($("#js_loading").text());
            },
            success: function (data) {
                ignition.caSubject = data.ca_issued_to;
                ignition.caIssuedBy = data.ca_issued_by;
            },
            complete: function () {
                $("#ignitionContentDiv").unmask();
            }
        });

        if ($("#importCa").is(":checked")) {
            $("#caSubmitForm").parent().show();
        } else {
            $("#caSubmitForm").parent().hide();
        }

        $("#caBrowseButton").unbind("change");
        $("#caBrowseButton").change( function () {
            $("#caFakeFileField").val(this.value);
        });

        $("input[name='caOption']").unbind("change");
        $("input[name='caOption']").change(function() {
            var importCa = $("#importCa").is(":checked");
            if (importCa) {
                $("#caSubmitForm").parent().show();
            } else {
                $("#caSubmitForm").parent().hide();
            }
            ignition.importCa = importCa;
            ignition.displayedCaWarnings = false;
        });

        var options = {
            data: "csrf_token="+$("#csrf_token").val(),
            timeout: globals.variables.UPLOAD_AJAX_TIMEOUT,
            error: function () {
                $("#ignitionSecurityDiv").unmask();
                return false;
            },
            beforeSubmit: function () {
                $("#ignitionSecurityDiv").mask($("#js_uploading").text());
            },
            success: function () {
                $.ajax({
                    type: "GET",
                    url: "/api/settings/certificate/ca",
                    data: "password=" + encodeURIComponent($("#caPasswordInput").val()),
                    cache: false,
                    success: function (data) {
                        $("#caPasswordInput").val("");
                        if (data.import_status == "invalid password") {
                            alert($("#js_invalidCaPassword").text());
                            ignition.caPresent = false;
                        } else if (data.import_status == "invalid file") {
                            alert($("#js_invalidCaFile").text());
                            ignition.caPresent = false;
                        } else {
                            alert($("#js_uploadSuccessfulCaFile").text());
                            ignition.caPresent = true;
                        }
                    },
                    complete: function () {
                        $("#ignitionContentDiv").unmask();
                    }
                });
                return false;
            },
            complete: function (xhr) {
                if (xhr.status != 200) {
                    $("#ignitionContentDiv").unmask();
                }
                return false;
            },
            clearForm: true,
            resetForm: true
        };
        $("#caSubmitForm").ajaxForm(options);

        $("#caUploadButton").click( function (e){
            if ($("#caBrowseButton").val() == "") {
                e.preventDefault();
                alert($("#js_noFileSelectedForImport").text());
            } else if ($("#caPasswordInput").val() == "") {
                e.preventDefault();
                alert($("#js_noCaPassword").text());
            }
        });

        $("#nextLink").show();
        $("#applyIgnitionSettings").hide();
    };

    /**
     * Adjusts file input size
     */
    ignition.adjustUploadFile = function () {
        $("#caSubmitForm").parent().show();
        $(".repositoryInputFile").width($(".fakefile").width() + 1);
        $(".repositoryInputFile").height($(".fakefile").height());
        $(".repositoryForm button").height($(".fakefile :text").outerHeight());
        $(".repositoryForm").width($(".repositoryForm .fileinputs").outerWidth(true)
            + $(".repositoryForm .updateButton").outerWidth(true) + 10);
    };

    /**
     * Calls Summary tab functions
     */
    ignition.renderSummary = function () {
        $("#nextLink").hide();
        $("#applyIgnitionSettings").show();
        $.ajax({
            type: "GET",
            url: "/api/system/virtual",
            beforeSend: function () {
                $("#ignitionContentDiv").mask($("#js_loading").text());
            },
            success: function (data) {
                if (!data.virtual_system) {
                    $.ajax({
                        type: "GET",
                        url: globals.REST_URL.SID,
                        beforeSend: function () {
                            $("#ignitionContentDiv").mask($("#js_loading").text());
                        },
                        success: function (data) {
                            ignition.systemId =  data.SID;
                        },
                        error: function (xmlHttpReq, textStatus, errorThrown) {
                            ignition.requestErrorHandler(xmlHttpReq, textStatus, errorThrown, $("#js_failedGetSid").text());
                        },
                        complete: function () {
                            $("#summarySystemId").show();
                            $("#summarySystemIdLabel").show();
                            ignition.renderSummaryInfo();
                            $("#ignitionContentDiv").unmask();
                        }
                    });
                } else {
                    ignition.renderSummaryInfo();
                    $.ajax({
                            type: "GET",
                            url: "/api/settings/certificate/generate",
                            timeout: globals.variables.CERTIFICATE_DEFAULTS_TIMEOUT,
                            cache: false,
                            beforeSend: function () {
                            },
                            success: function (data) {
                                ignition.caSubject = data.ca_issued_to;
                                ignition.caIssuedBy = data.ca_issued_by;
                                $("#summarySubjectLabel").text(ignition.caSubject);
                                $("#issuerSubjectLabel").text(ignition.caIssuedBy);
                            },
                            complete: function () {
                                $("#ignitionContentDiv").unmask();
                            }
                        });
                }
            }
        });
    };

    /**
     * Applies the selected settings.
     */
    ignition.applySettings = function() {
        $.ajax({
            type: "GET",
            url: "/api/session",
            cache: false,
            error: function (xmlHttpReq, textStatus, errorThrown) {
                ignition.requestErrorHandler(xmlHttpReq, textStatus, errorThrown);
            },
            success: function(data) {
                globals.functions.enableButton("abortLink", false);
                globals.functions.enableButton("prevLink", false);
                globals.functions.enableButton("applyIgnitionSettings", false);
                globals.variables.ip = data.ip.split(':')[0];

                $.ajax({
                    type: "PUT",
                    url: '/setup/',
                    cache: false,
                    timeout: globals.variables.GLOBAL_AJAX_TIMEOUT,
                    beforeSend: function () {
                        $("#ignitionContentDiv").mask($("#js_applySettingsMask").text());
                    },
                    error: function (xmlHttpReq, textStatus, errorThrown) {
                        ignition.requestErrorHandler(xmlHttpReq, textStatus, errorThrown);
                    },
                    success: function () {
                        ignition.notifySettingsApplied();
                    }
                });
            }
        });
    };

    /**
     * Sets the date and time of the server.
     */
    ignition.setTime = function () {
        var dateString = "timestamp=";
        dateString += $("#dateInput").val() + " ";
        dateString += $("#timeHourInput").val() + ":" + $("#timeMinutesInput").val() + ":00";
        $.ajax({
            type: "PUT",
            url: "/api/system/date",
            data: dateString,
            cache: false,
            timeout: globals.variables.GLOBAL_AJAX_TIMEOUT,
            beforeSend: function () {
                $("#ignitionContentDiv").mask($("#js_dateTimeMask").text());
            },
            error: function (xmlHttpReq, textStatus, errorThrown) {
                if (xmlHttpReq.status != 200) {
                    var message = $("#js_dateTimeFailed").text() + "\n" + $("#js_TryWebMain").text();
                    ignition.requestErrorHandler(xmlHttpReq, textStatus, errorThrown, message);
                    $("#ignitionContentDiv").unmask();
                }
            },
            complete: function (xhr) {
                ignition.dateReady = true;
                ignition.notifySettingsApplied();
            }
        });
    };

    /**
     * Applies the timezone settings
     */
    ignition.setTimezone = function () {
        $.ajax({
            type: "PUT",
            url: "/api/system/timezone",
            data: "name=" + $("#selectTimezone :selected").val(),
            cache: false,
            timeout: globals.variables.GLOBAL_AJAX_TIMEOUT,
            beforeSend: function () {
                $("#ignitionContentDiv").mask($("#js_settingTimezone").text());
            },
            error: function (xmlHttpReq, textStatus, errorThrown) {
                $("#ignitionContentDiv").unmask();
                var message = $("#js_ApplyTimezone").text() + "\n" + $("#js_TryWebMain").text();
                ignition.requestErrorHandler(xmlHttpReq, textStatus, errorThrown, message);
            },
            complete: function () {
                ignition.timezoneReady = true;
                ignition.notifySettingsApplied();
            }
        });
    };

    /**
     * Applies the NTP settings
     */
    ignition.setNTP = function () {
        $.ajax({
            type: "PUT",
            url: "/api/system/ntp",
            data: ignition.buildNtpDataString(),
            cache: false,
            timeout: globals.variables.GLOBAL_AJAX_TIMEOUT,
            beforeSend: function () {
                $("#ignitionContentDiv").mask($("#js_NTPMask").text());
            },
            error: function (xmlHttpReq, textStatus, errorThrown) {
                $("#ignitionContentDiv").unmask();
                var message = $("#js_ApplyNTP").text() + "\n" + $("#js_TryWebMain").text();
                ignition.requestErrorHandler(xmlHttpReq, textStatus, errorThrown, message)
            },
            complete: function () {
                ignition.ntpReady = true;
                ignition.notifySettingsApplied();
            }
        });
    };

    /**
     * Applies the new root password
     */
    ignition.setPassword = function () {
        var dataString = "newpass=";
        dataString += encodeURIComponent($("#newRootPasswordInput").val());
        dataString += "&oldpass=IGN";
        $.ajax({
            type: "PUT",
            url: "/api/system/change_root_pass",
            data: dataString,
            cache: false,
            timeout: globals.variables.GLOBAL_AJAX_TIMEOUT,
            beforeSend: function () {
                $("#ignitionContentDiv").mask($("#js_settingRootPassword").text());
            },
            error: function (xmlHttpReq, textStatus, errorThrown) {
                $("#ignitionContentDiv").unmask();
                var message = $("#js_PasswordFailed").text() + "\n" + $("#js_TryWebMain").text();
                ignition.requestErrorHandler(xmlHttpReq, textStatus, errorThrown, message);
            },
            complete: function () {
                ignition.setAdminPassword();
            }
        });
    };

    /**
     * Applies the new "Administrator" password
     */
    ignition.setAdminPassword = function () {
        var dataString = "newpass=";
        dataString += encodeURIComponent($("#newAdminPasswordInput").val());
        dataString += "&oldpass=IGN";
        dataString += "&user=Administrator";
        $.ajax({
            type: 'PUT',
            url: '/api/system/change_root_pass',
            data: dataString,
            beforeSend: function () {
                $("#ignitionContentDiv").mask($("#js_settingAdminPassword").text());
            },
            error: function (xmlHttpReq, textStatus, errorThrown) {
                $("#ignitionContentDiv").unmask();
                var message = $("#js_adminPasswordFailed").text();
                ignition.requestErrorHandler(xmlHttpReq, textStatus, errorThrown, message);
            },
            complete: function() {
                ignition.encryptPassword();
            }
        });
    };

    /**
     * Encrypts the new passwords
     */
    ignition.encryptPassword = function () {
        var dataString = "root_pass=";
        dataString += encodeURIComponent($("#newRootPasswordInput").val());
        dataString += "&admin_pass=";
        dataString += encodeURIComponent($("#newAdminPasswordInput").val());
        dataString += "&system_pass=";
        dataString += encodeURIComponent($("#newSystemPasswordInput").val());
        $.ajax({
            type: 'PUT',
            url: '/api/system/encrypt_pass',
            data: dataString,
            complete: function() {
                ignition.passwordReady = true;
                ignition.notifySettingsApplied();
            }
        });
    };

    /**
     * Applies companding settings
     */
    ignition.setCompanding = function () {
        if (ignition.serverType == "Appl") {
            ignition.compandingReady = true;
            ignition.notifySettingsApplied();
            return;
        }
        var compandingData = "companding=";
        compandingData += ($("input[name='compandingMode']:checked").val() == "A-law") ? "ALaw" : "MULaw";
        $.ajax({
            type: "PUT",
            url: globals.REST_URL.COMPANDING,
            data: compandingData,
            cache: false,
            timeout: globals.variables.GLOBAL_AJAX_TIMEOUT,
            error: function (xmlHttpReq, textStatus, errorThrown) {
                ignition.requestErrorHandler(xmlHttpReq, textStatus, errorThrown, $("#js_compandingFailed").text());
            },
            complete: function () {
                ignition.compandingReady = true;
                ignition.notifySettingsApplied();
            }
        });
    };

    /**
     * Applies server type settings
     */
    ignition.setServerType = function () {
        var serverTypeData = "mode=" + $("input[name='serverType']:checked").val();
        $.ajax({
            type: "PUT",
            url: globals.REST_URL.IPOFFICE_MODE,
            data: serverTypeData,
            cache: false,
            timeout: ignition.SET_SERVER_MODE_TIMEOUT,
            beforeSend: function () {
                $("#ignitionContentDiv").mask($("#js_settingServerMode").text());
            },
            error: function (xmlHttpReq, textStatus, errorThrown) {
                ignition.requestErrorHandler(xmlHttpReq, textStatus, errorThrown, $("#js_failedSetServerType").text());
            },
            complete: function () {
                ignition.serverTypeReady = true;
                ignition.notifySettingsApplied();
            }
        });
    };

    /**
     * Sets the authentication mode for Primary , Secondary and Expansion server types.
     */
    ignition.setAuthType = function () {
        //IPOFFICE-45001 - enable referred auth at fresh install for all editions (Server Edition and Application Server)
        $.ajax({
            type: "PUT",
            url: "/setup/auth_mode",
            data: "referred=true",
            cache: false,
            timeout: globals.variables.GLOBAL_AJAX_TIMEOUT,
            error: function (xmlHttpReq, textStatus, errorThrown) {
                ignition.requestErrorHandler(xmlHttpReq, textStatus, errorThrown, $("#js_authTypeFailed").text());
            },
            complete: function () {
                ignition.authTypeReady = true;
                ignition.notifySettingsApplied();
            }
        });
    };

    /**
     * Determines if the application is run locally or remotely.
     * Calls the save network settings function
     */
    ignition.setNetwork = function () {
        var local = false;
        if (window.location.href.indexOf("localhost") > -1) {
            local = true;
        }
        ignition.saveNetworkSettings(local);
    };

    /**
     * Applies the network settings and calls the redirection function
     */
    ignition.saveNetworkSettings = function (local) {
        var ipChanged = !local && (!$("#useDhcpCheckbox")[0].checked);
        ignition.dhcpEnabled = !local && !ignition.initialUseDHCP && $("#useDhcpCheckbox").is(":checked");
        $.ajax({
            type: "PUT",
            url: "/api/system/network",
            data: ignition.buildNetworkDataString(),
            cache: false,
            timeout: globals.variables.SAVE_NETWORK_TIMEOUT,
            beforeSend: function () {
                $("#ignitionContentDiv").mask($("#js_savingNetworkSettings").text());
            },
            error: function (xmlHttpReq, textStatus, errorThrown) {
                if (parseInt(xmlHttpReq.status) != 0 ){
                    $("#ignitionContentDiv").unmask();
                    if (!ignition.dhcpEnabled) {
                        if (navigator.appName.toLowerCase().indexOf("microsoft") < 0 || xmlHttpReq.status != 12002) {
                            ignition.requestErrorHandler(xmlHttpReq, textStatus, errorThrown,
                                $("#js_applySettingsFailed").text());
                        }
                    }
                }
            },
            complete: function () {
                if (!ipChanged && !ignition.displayedCaWarnings) {
                    ignition.networkReady = true;
                    ignition.notifySettingsApplied();
                } else if (local && !ignition.displayedCaWarnings) {
                    ignition.networkReady = true;
                    ignition.notifySettingsApplied();
                }
            }
        });
        if (ipChanged || ignition.displayedCaWarnings) {
            ignition.redirectToNewIP();
        }
    };

    /**
     * Builds the network data string to send to the device
     */
    ignition.buildNetworkDataString = function() {
        var networkDataString = "name=eth0";
        networkDataString += "&ipaddr=" + $("#ipAddressInput").val();
        networkDataString += "&netmask=" + $("#subnetMaskInput").val();
        if (ignition.networkData.use_prefix) {
            networkDataString += "&prefix=" + $("#prefixInput").val();
        }
        if ($("#defaultGatewayInput").val() != "") {
            networkDataString += "&gateway=" + $("#defaultGatewayInput").val();
        } else {
            networkDataString += "&gateway=";
        }
        if ($("#useDhcpCheckbox")[0].checked) {
            networkDataString += "&use_dhcp=True";
        } else {
            networkDataString += "&use_dhcp=";
        }
        networkDataString += "&hostname=" + $("#hostNameInput").val();
        if ($("#autoDNSCheckbox")[0].checked) {
            networkDataString += "&auto_dns=yes";
            networkDataString += "&dns=";
        } else {
            networkDataString += "&auto_dns=no";
            networkDataString += "&dns=" + $("#dnsInput1").val();
            var dns2 = $("#dnsInput2").val();
            if (dns2.length > 0) {
                networkDataString += "," + dns2;
            }
        }
        networkDataString +="&start_stopped_services=" + true;
        if (ignition.serverType == "Appl") {
            networkDataString +="&start_selected_services=ipoffice,webrtcgw,callanalytics,";
            $("#ignitionServicesDiv :checkbox").each(function (){
                if (this.checked) {
                    networkDataString += this.name + ",";
                }
            });
        } else if (ignition.serverType == "Primary") {
            networkDataString +="&start_selected_services=ipoffice,voicemail,onexportal,weblm,webrtcgw";
        } else if (ignition.serverType == "Secondary") {
            networkDataString +="&start_selected_services=ipoffice,voicemail,onexportal,weblm,webrtcgw";
        } else {
            networkDataString +="&start_selected_services=ipoffice,voicemail,weblm";
        }
        networkDataString += "&create_cert=true";
        networkDataString += "&auto_generate=true";
        if (ignition.serverType != "Primary" && ignition.serverType != "Appl") {
            networkDataString += "&self_signed=true";
        }

        return networkDataString;
    };

    /**
     * Builds the NTP data string to send to the device
     */
    ignition.buildNtpDataString = function () {
        var ntpData = "";
        ntpData += "use_ntp=" + $("#useNtpCheckbox")[0].checked;
        ntpData += "&servers=" + $("#ntpServersInput").val();
        ntpData += "&use_local_source=" + true; //IPOFFICE-25648
        ntpData += "&sync=" + true; //IPOFFICE-25648
        return ntpData;
    };

    /**
     * Composes the new login page url after a delay necessary for the network settings to be applied
     * Calls the redirection function
     */
    ignition.redirectToNewIP = function () {
        redirectFunction = function () {
            clearTimeout(t);
            ignition.networkReady = true;
            ignition.notifySettingsApplied(true);
        };
        var t = setTimeout("redirectFunction()", globals.variables.SAVE_NETWORK_TIMEOUT - 20000);
    };

    /**
     * Controls the order in which the settings are saved and serialize the execution.
     * Redirects the user to the main page or to the login page
     * after all the settings have been applied.
     */
    ignition.notifySettingsApplied = function(changeIp) {
        if (!ignition.timezoneReady) {
            ignition.setTimezone();
        } else if (!ignition.dateReady && ignition.callSetDateAndTime) {
            ignition.setTime();
        } else if (!ignition.ntpReady && ((ignition.serverType == "Primary") || (ignition.serverType == "Appl"))) {
            ignition.setNTP();
        } else if (!ignition.passwordReady) {
            ignition.setPassword();
        } else if (!ignition.compandingReady) {
            ignition.setCompanding();
        } else if (!ignition.serverTypeReady) {
            ignition.setServerType();
        } else if (!ignition.authTypeReady) {
            ignition.setAuthType();
        } else if (!ignition.hwReady) {
            ignition.setHardware();
        } else if (!ignition.networkReady) {
            ignition.setNetwork();
        } else {
            if (changeIp === undefined) {
                if (ignition.dhcpEnabled) {
                    $("#ignitionPrevNextDiv button").hide();
                    $("#ignitionContentDiv").unmask();
                    alert($("#js_AppliedDhcp").text() + " \n" + $("#js_useNewIP").text());
                } else {
                    ignition.handleRedirection(ignition.REDIRECT_IGNITION_COMPLETED);
                }
            } else {
                ignition.handleRedirection(ignition.REDIRECT_IGNITION_COMPLETED_NEW_IP);
            }
        }
    };

    /**
     * Checks if the password is correct and moves to the next screen.
     * Shows an error message if the new password is incorrect
     */
    ignition.checkPasswordRestrictions = function() {
        var dataString = "newpass=";
        dataString += encodeURIComponent($("#newRootPasswordInput").val());
        $.ajax({
            type: "GET",
            url: "/api/system/change_root_pass",
            data: dataString,
            cache: false,
            async: false,
            beforeSend: function () {
                $("#ignitionContentDiv").mask($("#js_checkingPassword").text());
            },
            error: function (xmlHttpReq, textStatus, errorThrown) {
                if (xmlHttpReq.status == 400) {
                    alert($("#js_unsupportedCharsInPassword").text().replace("%s0", "root"));
                } else {
                    ignition.requestErrorHandler(xmlHttpReq, textStatus, errorThrown, $("#js_passwordCheckFaild").text());
                }
                $("#ignitionContentDiv").unmask();
            },
            success: function (data) {
                if (data.length != 0) {
                    $("#ignitionContentDiv").unmask();
                    alert($("#js_incorrectAccountPassword").text().replace("%s0", "root") + " " + data);
                } else {
                    var dataString = "newpass=";
                    dataString += encodeURIComponent($("#newAdminPasswordInput").val());
                    dataString += "&user=Administrator";
                    $.ajax({
                        type: "GET",
                        url: "/api/system/change_root_pass",
                        data: dataString,
                        cache: false,
                        async: false,
                        error: function (xmlHttpReq, textStatus, errorThrown) {
                            if (xmlHttpReq.status == 400) {
                                alert($("#js_unsupportedCharsInPassword").text().replace("%s0", "Administrator"));
                            } else {
                                ignition.requestErrorHandler(xmlHttpReq, textStatus, errorThrown,
                                    $("#js_passwordCheckFaild").text());
                            }
                            $("#ignitionContentDiv").unmask();
                        },
                        success: function (data) {
                            $("#ignitionContentDiv").unmask();
                            if (data.length != 0) {
                                alert($("#js_incorrectAccountPassword").text().replace("%s0", "Administrator")
                                    + " " + data);
                            } else {
                                ignition.changePassword = false;
                            }
                        }
                    });
                }
            }
        });
    };

    /**
     * Shows the relevant content div and hides the other content divs
     * Shows the bullet that corresponds to the navigation tree label
     * Hides the other bullets
     *
     * @param stepNumber    The number of the step to show
     */
    ignition.changePage = function (stepNumber) {
        var divContentName = $("#step" + stepNumber + " label")[0].id;
        $(".ignitionStepContent").hide();
        $("#" + divContentName + "Div").show();

        //$("#step" + ignition.previousStep).removeClass("crt");
        //$("#step" + stepNumber).addClass("crt");
        $("#step" + ignition.previousStep).removeClass("crt");
        if (stepNumber > ignition.previousStep) {
            $("#step" + ignition.previousStep).addClass("done");
        } else {
            $("#step" + ignition.previousStep).removeClass("done");
        }
        $("#step" + stepNumber).addClass("crt");

        if (stepNumber == ignition.eulaStep || stepNumber == ignition.serverTypeStep) {
            $("#ignitionTitleLabel").text($("#js_defaultTitle").text());
        } else {
            if (ignition.serverType == "Appl") {
                $("#ignitionTitleLabel").text($("#js_applicationServerTitle").text());
            } else if (ignition.serverType != null) {
                $("#ignitionTitleLabel").text($("#js_serverEditionTitle").text());
            }
        }

        switch (stepNumber) {
            case ignition.eulaStep:
                ignition.renderEula();
                break;
            case ignition.networkStep:
                ignition.renderNetworkConfig();
                break;
            case ignition.timeCompandingStep:
                ignition.renderTimeCompanding();
                break;
            case ignition.changePassStep:
                ignition.renderChangePass();
                break;
            case ignition.serverTypeStep:
                ignition.renderServerType();
                break;
            case ignition.addHardwareStep:
                ignition.renderHardwareStep();
                break;
            case ignition.servicesStep:
                ignition.renderServicesStep();
                break;
            case ignition.securityStep:
                if (ignition.serverType == "Primary" || ignition.serverType == "Appl")  {
                    ignition.adjustUploadFile();
                    ignition.renderSecurityStep();}
                break;
            case ignition.summaryStep:
                ignition.renderSummary();
                break;
        }
    };

    /*
    ignition.updateStepsProgress = function (crtStep) {
        $("#step" + ignition.previousStep).removeClass("crt");
        $("#step" + ignition.previousStep).addClass("done");
        $("#step" + stepNumber).addClass("crt");

        for (var i = 1; i < crtStep; i++) {
            $("#step" + i).removeClass("crt");
            $("#step" + i).removeClass("done");
            $("#step" + stepNumber).addClass("crt");
        }
    };
    */

    /**
     * Performs checks for the accept license step
     */
    ignition.eulaChecks = function () {
        if (!$("#agreeLicenseCheckbox").is(":checked")) {
            alert($("#js_agreeLicense").text());
            return false;
        }
        return true;
    };

    /**
     * Performs checks for the change password step
     */
    ignition.performChangePasswordChecks = function () {
        var adminPasswordOk = false;
        var systemPasswordOk = false;
        var rootPasswordOk = ignition.validatePasswordFields("newRootPasswordInput",
            "newRootPasswordAgainInput", "root");
        if (rootPasswordOk == true) {
            adminPasswordOk = ignition.validatePasswordFields("newAdminPasswordInput",
                "newAdminPasswordAgainInput", "Administrator");
            if (adminPasswordOk == true) {
                systemPasswordOk = ignition.validateSystemPassword();
            }
        }
        return (rootPasswordOk && adminPasswordOk && systemPasswordOk);
    };

    /**
     * Validates a set of password inputs.
     *
     * @param passwordFieldId           Id of the password field.
     * @param repeatPasswordFieldId     Id of the confirm password field.
     * @param accountName               Name of the account in question.
     * @returns {boolean}               true if all checks pass, false and an appropriate error message otherwise.
     */
    ignition.validatePasswordFields = function (passwordFieldId, repeatPasswordFieldId, accountName) {

        var passwordFieldValue = $("#" + passwordFieldId).val();
        var repeatPasswordFieldValue = $("#" + repeatPasswordFieldId).val();
        var passedMinLength = (passwordFieldValue.length >= globals.variables.minPasswordLength);
        var passedMaxLength = (passwordFieldValue.length <= globals.variables.maxPasswordLength);
        var passedCodePointSets = (globals.functions.countPointCodeSets(passwordFieldValue) >=
            globals.variables.minCodePointSets);
        var passedSequenceCheck = (globals.functions.validSequences(passwordFieldValue,
            globals.variables.passwordSequenceLength));
        var passedDefaultPass = true;
        var defaultPasswords = ["Administrator", "securitypwd", "password"];
        for (var i = 0; i < defaultPasswords.length; i++) {
            if (passwordFieldValue == defaultPasswords[i]) {
                passedDefaultPass = false;
                break;
            }
        }

        if (passwordFieldValue == "") {
            alert($("#js_insertAccountPassword").text().replace("%s0", accountName));
            return false;
        } else if (repeatPasswordFieldValue == "") {
            alert($("#js_confirmAccountPassword").text().replace("%s0", accountName));
            return false;
        } else if (passwordFieldValue != repeatPasswordFieldValue) {
            alert($("#js_identicalAccountPassword").text().replace("%s0", accountName));
            return false;
        } else if (!passedMinLength) {
            alert($("#js_accountPasswordTooShort").text().replace("%s0", accountName)
                .replace("%s1", globals.variables.minPasswordLength));
            return false;
        } else if (!passedMaxLength) {
            alert($("#js_accountPasswordTooLong").text().replace("%s0", accountName)
                .replace("%s1", globals.variables.maxPasswordLength));
            return false;
        } else if (!passedCodePointSets) {
            alert($("#js_accountPasswordCodePointSets").text().replace("%s0", accountName)
                .replace("%s1", globals.variables.minCodePointSets));
            return false;
        } else if (!passedSequenceCheck) {
            alert($("#js_accountPasswordConsecutiveChars").text().replace("%s0", accountName)
                .replace("%s1", globals.variables.passwordSequenceLength));
            return false;
        } else if (!passedDefaultPass) {
            alert($("#js_accountPasswordDefault").text().replace("%s0", accountName));
            return false;
        }
        return true;

    };

    /**
     * Perform System password validation.
     *
     * @returns {boolean}
     */
    ignition.validateSystemPassword = function () {
        var systemPassValue = $("#newSystemPasswordInput").val();
        var systemRepeatPassValue = $("#newSystemPasswordAgainInput").val();
        var rootPassValue = $("#newRootPasswordInput").val();
        var adminPassValue = $("#newAdminPasswordInput").val();
        var defaultPasswords = ["Administrator", "securitypwd", "password"];
        var passedDefaultPass = true;
        var passedMinLength = (systemPassValue.length >= globals.variables.minSystemPasswordLength);
        var passedMaxLength = (systemPassValue.length <= globals.variables.maxPasswordLength);

        for (var i = 0; i < defaultPasswords.length; i++) {
            if (systemPassValue == defaultPasswords[i]) {
                passedDefaultPass = false;
                break;
            }
        }

        if (systemPassValue == "") {
            alert($("#js_insertAccountPassword").text().replace("%s0", "System"));
            return false;
        } else if (systemRepeatPassValue == "") {
            alert($("#js_confirmAccountPassword").text().replace("%s0", "System"));
            return false;
        } else if (systemRepeatPassValue != systemPassValue) {
            alert($("#js_identicalAccountPassword").text().replace("%s0", "System"));
            return false;
        } else if (!passedMinLength) {
            alert($("#js_accountPasswordTooShort").text().replace("%s0", "System")
                .replace("%s1", globals.variables.minSystemPasswordLength));
            return false;
        } else if (!passedMaxLength) {
            alert($("#js_accountPasswordTooLong").text().replace("%s0", "System")
                .replace("%s1", globals.variables.maxPasswordLength));
            return false;
        } else if (!passedDefaultPass) {
            alert($("#js_accountPasswordDefault").text().replace("%s0", "System"));
            return false;
        } else if (systemPassValue == rootPassValue) {
            alert($("#js_systemPasswordIdentical").text().replace("%s0", "root"));
            return false;
        } else if (systemPassValue == adminPassValue) {
            alert($("#js_systemPasswordIdentical").text().replace("%s0", "Administrator"));
            return false;
        } else if (!globals.validators.isASCII(systemPassValue)) {
            alert($("#js_nonASCIISystemPassword").text());
            return false;
        }
        return true;
    };

    /**
     * Performs checks for the network configuration step.
     */
    ignition.performNetworkConfigChecks = function () {
        var isOK = true;
        var errMsg = "";
        if (!$("#useDhcpCheckbox")[0].checked) {
            if (!globals.validators.isValidIP($("#ipAddressInput").val())) {
                isOK = false;
                errMsg += $("#js_invalidIP").text() + "\n";
            }
            if (!globals.validators.isValidNetMask($("#subnetMaskInput").val())) {
                isOK = false;
                errMsg += $("#js_invalidSubnetMask").text() + "\n";
            }
            if (ignition.networkData.use_prefix) {
                if (!globals.validators.isNumeric($("#prefixInput").val()) &&
                    $("#prefixInput").val() > 1 && $("#prefixInput").val() <= 30) {
                    isOK = false;
                    errMsg += $("#js_invalidPrefix").text() + "\n";
                }
                if (globals.functions.prefixToNetmask($("#prefixInput").val()) != $("#subnetMaskInput").val()) {
                    isOK = false;
                    errMsg += $("#js_prefixNetmaskConflict").text() + "\n";
                }
            }
            var validGateway = false;
            if (($("#defaultGatewayInput").val().length > 0) && !globals.validators.isValidIpv4Gateway(
                    $("#defaultGatewayInput").val(), $("#ipAddressInput").val(), $("#subnetMaskInput").val())) {

                for (var i = 0; i < ignition.networkData.interfaces.length; i++) {

                    if (globals.validators.isValidIpv4Gateway($("#defaultGatewayInput").val(),
                        ignition.networkData.interfaces[i].ipaddr, ignition.networkData.interfaces[i].netmask)) {

                        if (ignition.networkData.interfaces[i].name != "eth0") {
                            validGateway = true;
                            break;
                        }

                    }

                }
            } else {
                validGateway = true;
            }
            if (!validGateway) {
                isOK = false;
                errMsg += $("#js_invalidGateway").text() + "\n";
            }
        }

        if (!$("#autoDNSCheckbox")[0].checked) {
            if (($("#dnsInput1").val().length > 0) && !globals.validators.isDNS($("#dnsInput1").val())) {
                isOK = false;
                errMsg += $("#js_invalidPrimaryDns").text() + "\n";
            }
            if (($("#dnsInput2").val().length > 0) && !globals.validators.isDNS($("#dnsInput2").val())) {
                isOK = false;
                errMsg += $("#js_invalidSecondaryDns").text() + "\n";
            }
        }
        var hostname = $("#hostNameInput").val();
        if ((hostname.length < 1) || !globals.validators.isHost(hostname)) {
            isOK = false;
            errMsg += $("#js_invalidHostname").text();
        } else {
            $.ajax({
                type: "PUT",
                url: "/api/system/check_hostname",
                cache: false,
                async: false,
                data: "hostname=" + $("#hostNameInput").val(),
                beforeSend: function () {
                    $("#ignitionContentDiv").mask($("#js_loading").text());
                },
                success: function (data) {
                    $("#ignitionContentDiv").unmask();
                    if (!data) {
                        isOK = false;
                        errMsg += $("#js_invalidHostname").text();
                    }
                },
                complete: function (xhr) {
                    if (xhr.status != 200) {
                        $("#ignitionContentDiv").unmask();
                    }
                }
            });
        }
        if (!isOK) {
            alert(errMsg);
        }
        return isOK;
    };
    

    /**
     * Performs checks for the hostname step
     */
    ignition.performTimeCompandingChecks = function () {
        var isOK = true;
        var errMsg = $("#js_validationErrors").text();
        if ($("#useNtpCheckbox:checked").val() != undefined) {
            var ntpServer = $("#ntpServersInput").val();
            if ((ntpServer.length < 1) || !(globals.validators.isHost(ntpServer) || globals.validators.isValidIP(ntpServer))) {
                isOK = false;
                errMsg += $("#js_invalidNtpServer").text() + ntpServer + "\n";
                ignition.callSetNtp = false;
            } else {
                ignition.callSetNtp = true;
            }
        } else {
            if (ignition.currentDate != $("#dateInput").val() ||
                ignition.currentHour != $("#timeHourInput").val() ||
                ignition.currentMinutes != $("#timeMinutesInput").val()) {

                if (!globals.validators.isDate($("#dateInput").val(), ignition.localeOptions.validationFormat)) {
                    isOK = false;
                    errMsg += "- " + ignition.localeOptions.errorText + "\n"
                } else if (!globals.validators.isHour($("#timeHourInput").val())) {
                    isOK = false;
                    errMsg += $("#js_invalidHour").text() + $("#timeHourInput").val() + "\n"
                } else if (!globals.validators.isMinute($("#timeMinutesInput").val())) {
                    isOK = false;
                    errMsg += $("#js_invalidMinutes").text() + $("#timeMinutesInput").val() + "\n"
                } else {
                    ignition.callSetDateAndTime = true;
                }
            }
        }
        if ($("#selectTimezone :selected").val().length == 0) {
            isOK = false;
            errMsg += $("#js_noTimezoneSelected").text();
        }
        if ((ignition.serverType != "Appl") && ($("input[name='compandingMode']:checked").val() == undefined)) {
            isOK = false;
            errMsg += $("#js_noCompandingSelected").text();
        }
        if (!isOK) {
            alert(errMsg);
        }
        return isOK;
    };

    ignition.performServerTypeChecks = function() {
        ignition.serverType = $("input[name='serverType']:checked").val();
        if (ignition.serverType == "Appl") {
            $("#step" + ignition.servicesStep).show();
        } else {
            $("#step" + ignition.servicesStep).hide();
        }
        $("#step" + ignition.securityStep).show();
        return true;
    };

    /**
     * Checks if the certificate parameters are valid.
     *
     * @returns {boolean} true if the parameters are valid , false otherwise
     */
    ignition.performSecurityChecks = function() {
        /*if (!globals.validators.isNumeric($("#certDurationInput").val()) || $("#certDurationInput").val() <= 0) {
            alert($("#js_invalidDuration").text());
            return false;
        }*/
        return true;
    };
    
    /**
     *
     */
    ignition.createRootCa = function () {
        if (!ignition.displayedCaWarnings) {
            if ($("#autoCa").is(":checked")) {
                $.ajax({
                    type: "PUT",
                    url: "/api/settings/certificate/ca",
                    cache: false,
                    async: false,
                    beforeSend: function () {
                        $("#ignitionContentDiv").mask($("#js_creatingCaFile").text());
                    },
                    error: function (xmlHttpReq, textStatus, errorThrown) {
                        ignition.requestErrorHandler(xmlHttpReq, textStatus, errorThrown, $("#js_creatingCaFailed").text());
                        $("#ignitionContentDiv").unmask();
                        ignition.caPresent = false;
                    },
                    success: function () {
                        $("#ignitionContentDiv").unmask();
                        ignition.caPresent = true;
                    }
                });
                if (ignition.caPresent) {
                    alert($("#js_applyCa").text());
                }
            } else {
                if (ignition.caPresent) {
                    alert($("#js_caAvailable").text());
                } else {
                    alert($("#js_caNotPresent").text());
                }
            }
        }
        ignition.displayedCaWarnings = true;
    };

    /**
     *
     */

    /**
     * Composes and displays an error message when an ajax request fails
     *
     * @param xmlHttpReq    The request object.
     * @param textStatus    Request status.
     * @param errorThrown   The error thrown by the browser.
     * @param message       Optional message to show before the ajax related message.
     */
    ignition.requestErrorHandler = function (xmlHttpReq, textStatus, errorThrown, message) {
        if (textStatus == "timeout") {
            var timeoutText = "";
            if (message != undefined) {
                timeoutText = message + "\n";
            }
            xmlHttpReq.abort();
            timeoutText += "\n" + $("#js_httpErrorMessageLabel").text() + ": " + textStatus + "\n";
            alert(timeoutText);
        } else {
            if (xmlHttpReq.status == 200 // XXX this is ugly
                && errorThrown
                && typeof(errorThrown) == "string"
                && errorThrown.indexOf('Session expired') > 0) {
                // session expired, redirect to login page
                alert($("#js_sessionExpiredLabel").text());
                ignition.handleRedirection(ignition.REDIRECT_SESSION_EXPIRED);
            } else if (xmlHttpReq.status == 401) {
                // unauthenticated, automatically redirect to login page
                alert($("#js_sessionExpiredLabel").text());
                ignition.handleRedirection(ignition.REDIRECT_SESSION_EXPIRED);
            } else if (xmlHttpReq.status != 500) { // hide internal server errors
                var details  = "";
                if (message != undefined) {
                    details += message + "\n";
                }
                if (xmlHttpReq.responseText) {
                    details += "\n" + $("#js_requestErrorLabel").text() + $("#js_colon").text() + " " +
                        xmlHttpReq.responseText;
                } else if (xmlHttpReq.status == 408) {
                    details += "\n" + $("#js_requestTimeoutErrorLabel").text();
                } else {
                    details += "\n" + $("#js_httpErrorCodeLabel").text() + $("#js_colon").text() + " " +
                        xmlHttpReq.status + "\n";
                    if (textStatus) {
                        details += "\n" + $("#js_httpErrorMessageLabel").text() + $("#js_colon").text() + " " +
                            textStatus + "\n";
                    }
                    if (errorThrown) {
                        details += "\n" + $("#js_httpErrorExceptionLabel").text() + $("#js_colon").text() + " " +
                            errorThrown;
                    }
                }
                if (details.length > 0) {
                    alert(details);
                }
            }
        }
    };

    /**
     * Returns the user to the previous step.
     */
    $("#prevLink").click( function(e) {
        e.preventDefault(e);
        $.ajax({
            type: "GET",
            url: "/api/session",
            cache: false,
            error: function (xmlHttpReq, textStatus, errorThrown) {
                ignition.requestErrorHandler(xmlHttpReq, textStatus, errorThrown);
            },
            success: function() {
                if (ignition.currentStep > ignition.firstStep) {
                    if (ignition.currentStep == ignition.eulaStep) {
                        $("#prevLink")[0].innerHTML = $("#js_previous").text();
                    }
                    ignition.previousStep = ignition.currentStep;
                    ignition.currentStep --;
                    // if ((ignition.serverType != "Primary" && ignition.serverType != "Appl")
                    //     && ignition.currentStep == ignition.securityStep) {
                    //     ignition.currentStep --;
                    // }
                    if (ignition.serverType != "Appl" && ignition.currentStep == ignition.servicesStep) {
                        ignition.currentStep --;
                    }
                    ignition.changePage(ignition.currentStep);
                }
            }
        });
    });

    ignition.acceptAsgterms = function(answer,status,port,listening) {
        var selectedAns = answer;
        var selectedStatus = status;
        var selectedPort = port;
        var selectedListening = listening;
        $.ajax({
            type: "GET",
            url: "/api/settings/asg",
            dataType: "json",
            data: "acceptterms="+ answer,
            cache: false,
            success: function () {
                if (selectedAns == "yes") {
                    ignition.sendAsgChanges(selectedStatus,selectedPort,selectedListening)
                }
            }
        });
    };


    ignition.sendAsgChanges = function(status,port,listening){
        var selectedAns = "";
        $.ajax({
            type: "PUT",
            url: "/api/settings/asg",
            data: "status=" + status + "&port=" + port + "&listening=" + listening ,
            cache: false,
            beforeSend: function () {
            },
            success: function (data) {
                if (data.enable_status == "terms issue"){
                    selectedAns = "yes";
                } else {
                    selectedAns = "no";
                }
                ignition.acceptAsgterms(selectedAns,status,port,listening);
            }
        });
    };

    ignition.processAsgSettings = function () {
        var warning = "";
        var port = "2222";
        var listening = "anytunnel";
        var status = $('input[name="asgOption"]:checked').val();
        var EASG = $("#js_notAvaliable").text();
        var answ = "";
        if (status == "enabled") {
            warning = $("#js_enabledAsgWarning").text();
            EASG = $("#js_EASGon").text();
        } else {
            warning = $("#js_disabledAsgWarning").text();
            EASG = $("#js_EASGoff").text();
        }
        $("#summaryEASGLabel").text(EASG);
        if (warning != "") {
            warning += "" + $("#js_continue").text();
            answ = window.confirm(warning);
            if (answ == true){
                ignition.sendAsgChanges(status, port, listening);
            } else {
                alert("Cannot proceed without agreement of terms and conditions, considering the option selected for EASG Settings.")
            }
        }
        return answ;
    };
    
    /**
     * Handles local checks and moves the user to the next page if possible.
     */
    $("#nextLink").click( function(e) {
        e.preventDefault(e);
        $.ajax({
            type: "GET",
            url: "/api/session",
            cache: false,
            error: function (xmlHttpReq, textStatus, errorThrown) {
                ignition.requestErrorHandler(xmlHttpReq, textStatus, errorThrown);
            },
            success: function() {
                if (ignition.currentStep < ignition.lastStep && !$("#nextLink").hasClass("disabledLink")) {
                    var passedLocalChecks = true;
                    var waitForRequest = false;
                    switch (ignition.currentStep) {
                        case ignition.eulaStep:
                            waitForRequest = false;
                            passedLocalChecks = ignition.eulaChecks();
                            break;
                        case ignition.serverTypeStep:
                            waitForRequest = false;
                            passedLocalChecks = ignition.performServerTypeChecks();
                            break;
                        case ignition.addHardwareStep:
                            waitForRequest = false;
                            passedLocalChecks = ignition.performAddHddChecks();
                            break;
                        case ignition.networkStep:
                            waitForRequest = false;
                            passedLocalChecks = ignition.performNetworkConfigChecks();
                            break;
                        case ignition.timeCompandingStep:
                            waitForRequest = false;
                            passedLocalChecks = ignition.performTimeCompandingChecks();
                            if (passedLocalChecks) {
                                ignition.dateTimeSet = true;
                            }
                            break;
                        case ignition.changePassStep:
                            waitForRequest = false;
                            passedLocalChecks = ignition.performChangePasswordChecks();
                            if (ignition.serverType == "Primary" || ignition.serverType == "Appl")  {
                                 $("#securityCaSettings").show();
                             }
                             else {
                                 $("#securityCaSettings").hide();
                             }
                            break;
                        case ignition.securityStep:
                            waitForRequest = false;
                            passedLocalChecks = ignition.performSecurityChecks();
                            if ($("#activeAsg").is(":checked") || $("#disabledAsg").is(":checked")) {
                                response = true;}
                            else {
                                response = false;
                            }
                            if (response == true && passedLocalChecks == true) {
                                answ = ignition.processAsgSettings();
                                if (answ == false){
                                    ignition.nextLink();
                                }
                                if (ignition.serverType == "Primary" || ignition.serverType == "Appl")  {
                                    ignition.createRootCa();}
                            }
                            else {
                                alert("Please select a value for EASG Settings.");
                                ignition.nextLink();
                            }
                            break;
                        default:
                            waitForRequest = false;
                            passedLocalChecks = true;
                            break;

                    }
                    if (passedLocalChecks) {
                        ignition.stepsPassed[ignition.currentStep] = 1;
                        ignition.previousStep = ignition.currentStep;
                        if (!waitForRequest) {
                            if (ignition.currentStep == ignition.eulaStep) {
                                $("#prevLink")[0].innerHTML = $("#js_previous").text();
                                $("#prevLink").show();
                            }
                            ignition.currentStep ++;
                            if (ignition.serverType != "Appl" && ignition.currentStep == ignition.servicesStep) {
                                ignition.currentStep ++;
                            }
                            // if ((ignition.serverType != "Primary" && ignition.serverType != "Appl") && ignition.currentStep == ignition.securityStep) {
                            //     ignition.currentStep ++;
                            // }
                            ignition.changePage(ignition.currentStep);
                        }
                    }
                    globals.functions.enableButton("prevLink", true);
                }
            }
        });
    });

    /**
     * Handles abort button click: logout from current session and returns to login page.
     */
    $("#abortLink").click(function (e) {
        e.preventDefault();
        if (confirm($("#js_confirmAbort").text())) {
            $.ajax({
               type: 'DELETE',
               url: '/api/session',
               complete: function(xhr, statusText) {
                   ignition.handleRedirection(ignition.REDIRECT_IGNITION_CANCELED);
               }
            });
        }
    });

    $.ajax({
        type: "GET",
        url: globals.REST_URL.VIRTUALIZATION,
        dataType: "json",
        cache: false,
        error: function (xmlHttpReq, textStatus, errorThrown) {
            ignition.isVirtualized = false;
        },
        success: function(data) {
            ignition.isVirtualized = data.virtualized;
        },
        complete: function(xhr, statusText) {
            ignition.renderEula();
        }
    });

    ignition.handleRedirection = function(event) {
        var webmanagerPort = parseInt(window.location.port) - 1;
        var smaPort = 8443;
        var webmanagerURL = 'https://' + window.location.hostname + ':' + webmanagerPort + '/WebManagement/autoLogin';
        var webmanagerIsAlive = 'https://' + window.location.hostname + ':' + webmanagerPort + '/WebManagement/status';
        var smaURL = 'https://' + window.location.hostname + ':' + smaPort + '/WebMgmtEE/WebManagement.html';
        var wcpURL = 'https://' + window.location.hostname + ':' + window.location.port + '/login';

        if (event == ignition.REDIRECT_IGNITION_COMPLETED_NEW_IP) {
            if ( globals.variables.ip == ignition.networkData.interfaces[0].ipaddr )
            {
                var url = webmanagerURL.replace(window.location.hostname, $("#ipAddressInput").val());
                var urlSMA = smaURL.replace(window.location.hostname, $("#ipAddressInput").val());
                var isAliveUrl = webmanagerIsAlive.replace(window.location.hostname, $("#ipAddressInput").val());
                var fallbackURL = wcpURL.replace(window.location.hostname, $("#ipAddressInput").val());
            }
            else
            {
                var url = webmanagerURL.replace(window.location.hostname, globals.variables.ip);
                var urlSMA = smaURL.replace(window.location.hostname, globals.variables.ip);
                var isAliveUrl = webmanagerIsAlive.replace(window.location.hostname, globals.variables.ip);
                var fallbackURL = wcpURL.replace(window.location.hostname, globals.variables.ip);
            }
            if (ignition.serverType == "Expansion") {
                alert($("#js_Applied").text() + " \n" + $("#js_redirectToLogin").text());
                window.location.replace(urlSMA);
            } else {
                $.ajax({
                    type: "GET",
                    url: isAliveUrl,
                    dataType: "json",
                    cache: false,
                    error: function () {},
                    complete: function(xhr) {
                        if (xhr.status == 200) {
                            alert($("#js_Applied").text() + " \n" + $("#js_redirectToIcu").text());
                            $("#autologinUser").val("Administrator");
                            $("#autologinPassword").val($("#newAdminPasswordInput").val());
                            $("#autologinLanguage").val(ignition.language);
                            $("#autologinForm")[0].action = url;
                            $("#autologinForm")[0].submit();
                        } else {
                            alert($("#js_redirectToWcp").text());
                            window.location.replace(fallbackURL);
                        }
                    }
                });
            }

        } else {
            if (typeof globals.variables.REFERRER === 'undefined') {
                window.location.replace(webmanagerURL);
            } else {
                window.location.replace(globals.variables.REFERRER);
            }
        }
    }

});
