# Copyright 2010 Avaya Inc. All Rights Reserved.

"""
Web app audit logger.
"""

import web
import core.logs.audit

__author__      = "Avaya Inc."
__copyright__   = "Copyright 2010, Avaya Inc."

logger = core.logs.audit.AuditLog()

def log(message, username=None):
    """
    Add an entry to audit log.

    If no username is specified then current logged in user will be used.
    """
    if username:
        logger.log(username, message)
    else:
        logger.log(web.ctx.session.user, message)
