# Copyright 2010 Avaya Inc. All Rights Reserved.

"""
Utility decorators
"""

__author__      = "Avaya Inc."
__copyright__   = "Copyright 2010, Avaya Inc."

def synchronized(lock):
    """
    Synchronization decorator.
    """
    def wrap(f):
        def new_function(*args, **kw):
            lock.acquire()
            try:
                return f(*args, **kw)
            finally:
                lock.release()
        return new_function
    return wrap
