# Copyright 2010 Avaya Inc. All Rights Reserved.

"""
I18N support.

See http://webpy.org/cookbook/runtime-language-switch
"""

import web
import gettext

# See http://webpy.org/cookbook/runtime-language-switch

LOCALE_DIR = 'i18n/'
ALL_TRANSLATIONS = web.storage()


def _get_translations(lang='en_US'):
    # init translations
    if lang in ALL_TRANSLATIONS.keys():
        translation = ALL_TRANSLATIONS[lang]
    elif lang is None:
        translation = gettext.NullTranslations()
    else:
        try:
            translation = gettext.translation(
                    'messages',
                    LOCALE_DIR,
                    languages=[lang],
                    )
        except IOError:
            translation = gettext.NullTranslations()
    return translation


def _load_translations(lang):
    """Return the translations for the locale."""
    lang = str(lang)
    translation  = ALL_TRANSLATIONS.get(lang)
    if translation is None:
        translation = _get_translations(lang)
        ALL_TRANSLATIONS[lang] = translation
        # delete unused translations
        for lk in list(ALL_TRANSLATIONS):
            if lk != lang:
                del ALL_TRANSLATIONS[lk]
    return translation


def custom_gettext(string):
    """Translate a given string to the language of the application."""
    if hasattr(web.ctx, 'session'):
        # web context
        translation = _load_translations(web.ctx.session.get('lang'))
    else:
        # cli context, probably unittest
        translation = None
    if translation is None:
        return unicode(string)
    return translation.gettext(string)

