# Copyright 2010 Avaya Inc. All Rights Reserved.

"""
Application version
"""

import os
import re
from . import configuration
from . import log

# XXX maybe we should move this module under to core.system ??? to avoid this ugly import
from core.system import rpm
from datetime import datetime

__author__ = "Avaya Inc."
__copyright__ = "Copyright 2010, Avaya Inc."

# detect release type ISA, APPL, APC, ABG or ABE
RELEASE_TYPE = None
COPYRIGHT_YEAR = '2010'
BUILD_DATE = ''
VERSION_FILE = '/opt/webcontrol/.version'
TAG = "version"

log.info(TAG, 'loading version information...')

for name in configuration.SHARED_CONFIGURATION['release_config']:
    if os.path.exists(configuration.SHARED_CONFIGURATION['release_config'][name]):
        RELEASE_TYPE = name
        log.info(TAG, 'release type is <%s>' % name)
        with open(configuration.SHARED_CONFIGURATION['release_config'][name]) as f:
            for line in f:
                line = line.strip()
                if line.startswith('BUILD_DATE'):
                    val = line.split('=')
                    BUILD_DATE = val[1].split(';')[0].strip()
                    dt = datetime.strptime(BUILD_DATE, '%Y-%m-%d_%H:%M')
                    COPYRIGHT_YEAR = dt.year
                    break
        break

APP_VERSION = {'RELEASE_TYPE': RELEASE_TYPE,
               'TITLE': configuration.SHARED_CONFIGURATION['webapp']['title'][RELEASE_TYPE],
               'BUILD_DATE': BUILD_DATE,
               'COPYRIGHT_YEAR': COPYRIGHT_YEAR}

if os.path.exists(VERSION_FILE):
    with open(VERSION_FILE) as f:
        NAME = f.readline().strip()
        VERSION = f.readline().strip()
        RELEASE = f.readline().strip()
    APP_VERSION.update({"NAME" : NAME, "VERSION" : VERSION, "RELEASE" : RELEASE})
else:
    APP_VERSION.update(rpm.query_package(configuration.SHARED_CONFIGURATION['webapp']['package_name']))

if 'VERSION' in APP_VERSION:
    # add short version string
    m = re.match('(\d+)\.(\d+)', APP_VERSION['VERSION'])
    short_version = m.group(0)
    APP_VERSION.update({'SHORT_VERSION' : short_version})

log.info(TAG, 'app_version information is %s' % APP_VERSION)

BUILD_UID = APP_VERSION['BUILD_DATE']
