# Copyright 2010 Avaya Inc. All Rights Reserved.

"""
Simple plugin API.

A plugin is a Python module located under WEBCONTROL_HOME/<name>/plugin.py.
"""

import os
import glob

from core.common import log

__author__      = "Avaya Inc."
__copyright__   = "Copyright 2010, Avaya Inc."

PLUGINS = []

PLUGINS_DIR = os.path.join(os.getenv('WEBCONTROL_HOME'), 'vendor_plugins')

if os.path.exists(PLUGINS_DIR):
    dirs = [os.path.basename(d) for d in glob.glob('vendor_plugins/*') if os.path.isdir(d)]
    for name in dirs:
        try:
            PLUGINS.append( __import__('vendor_plugins.' + name + '.plugin', fromlist=['']))
            log.SHARED_LOGGER.info('loaded plugin %s' % name)
        except ImportError:
            log.SHARED_LOGGER.exception('unable to load plugin %s' % name)
