# Copyright 2010 Avaya Inc. All Rights Reserved.

"""
Web application configuration
"""
import configobj
import unittest

from core.common import configuration
from core.common import utils
from core.system import sshd


__author__      = "Avaya Inc."
__copyright__   = "Copyright 2010, Avaya Inc."

TAG = 'webapp'

PORT_PARAM_NAME = 'WEBCONTROL_PORT'
PROTOCOL_PARAM_NAME = 'WEBCONTROL_PROTOCOL'
SESSION_TIMEOUT_PARAM_NAME = 'WEBCONTROL_SESSION_TIMEOUT'

def read_settings():
    """
    Returns Webcontrol web application configuration: port, protocol, session timeout
    Throws:
        IOError, OSError, ValueError
    """
    config_file = configuration.SHARED_CONFIGURATION['webapp']['config_file']
    params = {PORT_PARAM_NAME: None,
              PROTOCOL_PARAM_NAME: None,
              SESSION_TIMEOUT_PARAM_NAME: configuration.DEFAULT_SESSION_TIMEOUT}
    utils.read_config(config_file, params)
    return params

def write_settings(port, protocol, timeout):
    """
    Saves Webcontrol web application configuration to file: port, protocol, session timeout
    Throws:
        IOError, OSError, ValueError
    """
    config_file = configuration.SHARED_CONFIGURATION['webapp']['config_file']
    params = {}
    if port:
        params[PORT_PARAM_NAME] = int(port)
    if protocol:
        params[PROTOCOL_PARAM_NAME] = str(protocol)
    if timeout:
        params[SESSION_TIMEOUT_PARAM_NAME] = int(timeout)
    utils.update_config(config_file, params)
    if timeout:
        sshd.set_timeout(int(timeout))
