# Copyright 2010 Avaya Inc. All Rights Reserved.

"""
Utility VNC functions.
"""

import os
from . import shell

from core.common import configuration
from core.common import utils
from core.common import i18n

__author__      = "Avaya Inc."
__copyright__   = "Copyright 2010, Avaya Inc."

VNC_CONFIG_FILE = configuration.SHARED_CONFIGURATION['vnc']['vnc_settings_file']

PORT_CLASS = 5800

class ConfigFileError(Exception):
    """
    For listing VNC Configuration errors.
    """
    def __str__(self):
        return self.args[0]

def port_to_id(port):
    """
    Returns the last digit(s) of a port
    """
    return str(int(port) - PORT_CLASS)

def get_vnc_settings():
    """
    Get VNC data
    """
    if os.path.isfile(VNC_CONFIG_FILE):
        vnc_settings = {'port': None,
                        'running': True}
        utils.read_config(VNC_CONFIG_FILE, vnc_settings)
        output = shell.sudo_execute('bash -c \'ps -ef | grep -v grep | grep -o "Xvnc :%s "\''
                    % port_to_id(vnc_settings['port']))
        if output is None:
            vnc_settings['running'] = False
        return vnc_settings
    else:
        raise ConfigFileError(i18n.custom_gettext("The %s file does not exist.") % VNC_CONFIG_FILE)

def set_vnc_settings(port):
    """
    Set VNC data
    """
    if os.path.isfile(VNC_CONFIG_FILE):
        vnc_settings = {}
        if port:
            vnc_settings['port'] = port
        utils.update_config(VNC_CONFIG_FILE, vnc_settings)
    else:
        raise ConfigFileError(i18n.custom_gettext("The %s file does not exist.") % VNC_CONFIG_FILE)


