#!/usr/bin/env python2.6

# Copyright 2010 Avaya Inc. All Rights Reserved.

"""
Run tests for Web Control.
"""

import unittest

from core.auth import passwd
from core.common import configuration
from core.common import utils
from core.logs import applications as app_logs
from core.logs import audit
from core.logs import archives
from core.services import manager
from core.services import monitor
from core.services import license
from core.settings import applications as app_settings
from core.settings import repositories
from core.settings import backup_restore
from core.system import network
from core.system import shell
from core.system import syslog
from core.system import systime
from core.system import rpm
from core.system import yum
from core.system import sshd
from core.updates import windows_clients
from core.updates import applications as app_updates

__author__      = "Avaya Inc."
__copyright__   = "Copyright 2010, Avaya Inc."

core_modules = (passwd,
           configuration,
           utils,
           app_logs,
           audit,
           archives,
           manager,
           monitor,
           license,
           app_settings,
           repositories,
           backup_restore,
           network,
           shell,
           syslog,
           systime,
           rpm,
           yum,
           sshd,
           windows_clients,
           app_updates)

test_loader = unittest.TestLoader()
core_tests = unittest.TestSuite()
for mod in core_modules:
    core_tests.addTests(test_loader.loadTestsFromModule(mod))

unittest.TextTestRunner(verbosity=2).run(core_tests)
