/*
 * Copyright 2010 Avaya Inc. All Rights Reserved.
 */

$(document).ready(function () {

    $("#javascriptStringsHelpDiv").load("/messages", function () {

        $.ajax({
            type: "GET",
            url : "/api/version",
            dataType: "json",
            cache: false,
            success : function (data) {

                var help = {};
                help.previous = "";
                help.next = "";
                help.current = "";
                help.disablePrevious = true;
                help.disableNext = false;
                help.newTopics = "";
                help.numberOfTopics = $("#helpLeftDiv a").length;
                globals.variables.releaseType = data.RELEASE_TYPE;

                if (globals.variables.releaseType == "appl" || globals.variables.releaseType == "apc") {
                    help.newTopics = '<div id="helpItemDiv'+ help.numberOfTopics +'" class="helpItemDivClass">' +
                        '<a href="" id=link'+ help.numberOfTopics +' name="troubleshooting">' +
                        $("#js_troubleshooting").text() + '</a></div>';
                    help.numberOfTopics++;
                } else {
                    help.newTopics = '<div id="helpItemDiv'+ help.numberOfTopics +'" class="helpItemDivClass">' +
                        '<a href="" id=link'+ help.numberOfTopics +' name="vnc">' +
                        $("#js_vncTab").text() + '</a> </div>';
                    help.numberOfTopics++;
                    help.newTopics += '<div id="helpItemDiv'+ help.numberOfTopics +'" class="helpItemDivClass">' +
                        '<a href="" id=link'+ help.numberOfTopics +' name="troubleshooting">' +
                        $("#js_troubleshooting").text() + '</a></div>';
                    help.numberOfTopics++;
                }
                $("#helpLeftDiv").append(help.newTopics);

                /**
                 * Disables or enables Previous and Next links.
                 */
                help.enableOrDisableLinks = function () {
                    if (help.disablePrevious) {
                        $("#helpPreviuosPage").addClass("disabledLink");
                    } else {
                        $("#helpPreviuosPage").removeClass("disabledLink");
                    }
                    if (help.disableNext) {
                        $("#helpNextPage").addClass("disabledLink");
                    } else {
                        $("#helpNextPage").removeClass("disabledLink");
                    }
                };

                /**
                 * Loads the help file in the help window.
                 *
                 * @param topicName     name to use in the URL (ex home , settings, logs)
                 * @param topicId       ID of the clicked element
                 * @param offset         0  if a menu link is clicked
                 *                       1  if next is clicked
                 *                      -1  if previous is clicked
                 */
                help.loadContent = function (topicName, topicId, offset) {
                    $("#helpContentDiv").load(
                        "/help/" + topicName,
                        function() {
                            $("#helpPrevNextLinksDiv").show();
                            var currentLinkNumber = parseInt(topicId.substring(topicId.indexOf("link")+4)) + offset;
                            var previousLinkNumber = currentLinkNumber - 1;
                            var nextLinkNumber = currentLinkNumber + 1;

                            if (previousLinkNumber < 0) {
                                help.disablePrevious = true;
                                help.previous = "";
                            } else {
                                help.disablePrevious = false;
                                help.previous = "link" + previousLinkNumber;
                            }
                            if (nextLinkNumber > help.numberOfTopics-1) {
                                help.disableNext = true;
                                help.next = "";
                            } else {
                                help.disableNext = false;
                                help.next = "link" + nextLinkNumber;
                            }
                            help.current = "link" + currentLinkNumber;
                            $("#helpLeftDiv div").removeClass("selectedHelpDiv");
                            $("#helpLeftDiv a").removeClass("selected");
                            $("#helpItemDiv" + currentLinkNumber).addClass("selectedHelpDiv");
                            $("#" + help.current).addClass("selected");

                            help.enableOrDisableLinks();
                            $("#helpRightDiv").scrollTop(0);
                        }
                    );
                };

                /**
                 * Returns the name of the first element with the specified id or
                 * an empty string if there is no element with specified ID doesn't exist.
                 *
                 * @param id  element id
                 */
                help.findNameById = function(id) {
                    var name = "";
                    if (id != "") {
                        name += $("#" + id)[0].name;
                    }
                    return name;
                };

                /**
                 * Loads the necessary help file when a menu link is clicked.
                 */
                $("#helpLeftDiv a").click( function (e) {
                    e.preventDefault();
                    help.loadContent(this.name, this.id, 0);
                });

                /**
                 * Loads the necessary help file when the previous link is clicked if possible.
                 */
                $("#helpPreviuosPage").click( function(e) {
                    e.preventDefault(e);
                    var redirectTo = help.findNameById(help.previous);
                    if (redirectTo != "") {
                        help.loadContent(redirectTo, help.current, -1)
                    }
                });

                /**
                 * Loads the necessary help file when the next link is clicked if possible.
                 */
                $("#helpNextPage").click( function(e) {
                    e.preventDefault(e);
                    var redirectTo = help.findNameById(help.next);
                    if (redirectTo != "") {
                        help.loadContent(redirectTo, help.current, 1)
                    }
                });

                $("#helpIntroLoginLink").click( function(e) {
                    e.preventDefault();
                    help.loadContent("login", "link0", 0);
                });

            }
        });
    });

    $("#helpPrevNextLinksDiv").hide();

});