/*
 * Copyright 2010 Avaya Inc. All Rights Reserved.
 */

$(document).ready(function () {

    var linux_downloads = {};

    linux_downloads.viewedRpmsTable = false;
    linux_downloads.tableResizeHandler = null;

    linux_downloads.appsRpms = [];
    linux_downloads.systemRpms = [];

    linux_downloads.addFixedTableHeader = function(tableId) {
        linux_downloads.fixedHeaderTables.push(tableId);
    };

    linux_downloads.linuxDownloadsTableDivHeight = parseInt($(window).height() - $("#downloadRpmsContentDiv").offset().top - 25);
    $("#downloadRpmsTableDiv").css("height", "" + linux_downloads.linuxDownloadsTableDivHeight + "px");
    $("#downloadRpmsTableDiv").addClass("scroll");

    /**
     * Builds the rpms download fieldset.
     */
    linux_downloads.buildRpmDownloadsFieldset = function () {
        $.ajax({
            type: "GET",
            url: "/api/linux/downloads/",
            cache: false,
            dataType: "json",
            beforeSend: function () {
                $("#downloadRpmsTableDiv").mask($("#js_loading").text());
            },
            success: function (appsData) {
                linux_downloads.appsRpms = appsData;
                //linux_downloads.buildRpmDownloadsTable(data);
            },
            complete: function () {
                //$("#downloadRpmsTableDiv").unmask();
                $.ajax({
                    type: "GET",
                    url: "/api/linux/system/downloads/",
                    cache: false,
                    dataType: "json",
                    success: function (systemData) {
                        linux_downloads.systemRpms = systemData;
                        //linux_downloads.buildRpmDownloadsTable(data);
                    },
                    complete: function () {
                        linux_downloads.buildRpmDownloadsTable();
                        $("#downloadRpmsTableDiv").unmask();
                    }
                });
            }
        });
        $("#downloadRpmsRefreshButton").unbind("click").click( function () {
            linux_downloads.buildRpmDownloadsFieldset();
        });
    };

    /**
     * Builds the content of the RPMs download table
     */
    linux_downloads.buildRpmDownloadsTable = function () {

        $("#downloadRpmsTable tbody").empty();
        var downloadRpmsRows = "";
        for (var i = 0; i < linux_downloads.appsRpms.length; i++) {
            var appElem = "";
            appElem += "<tr><td>";
            appElem += "<a href='/api/linux/downloads/" + linux_downloads.appsRpms[i].id + "'>";
            appElem += linux_downloads.appsRpms[i].id;
            appElem += "</a>";
            appElem += "</td>";
            appElem += "<td>";
            appElem += linux_downloads.appsRpms[i].modif;
            appElem += "</td>";
            appElem += "<td>";
            appElem += linux_downloads.appsRpms[i].size;
            appElem += "</td>";
            appElem += "</td></tr>";
            downloadRpmsRows += appElem;
        }
        for (var i = 0; i < linux_downloads.systemRpms.length; i++) {
            var systemElem = "";
            systemElem += "<tr><td>";
            systemElem += "<a href='/api/linux/system/downloads/" + linux_downloads.systemRpms[i].id + "'>";
            systemElem += linux_downloads.systemRpms[i].id;
            systemElem += "</a>";
            systemElem += "</td>";
            systemElem += "<td>";
            systemElem += linux_downloads.systemRpms[i].modif;
            systemElem += "</td>";
            systemElem += "<td>";
            systemElem += linux_downloads.systemRpms[i].size;
            systemElem += "</td>";
            systemElem += "</td></tr>";
            downloadRpmsRows += systemElem;
        }
        $("#downloadRpmsTable tbody").append(downloadRpmsRows);

        var rowCount = linux_downloads.systemRpms.length + linux_downloads.appsRpms.length;
        globals.functions.showNoDataDiv("downloadRpmsTableDiv", "downloadRpmsTable", rowCount,
            $("#js_thereIsNoDataAvailable").text());

        if (linux_downloads.viewedRpmsTable) {
            try {
                $("#downloadRpmsTable").trigger("update");
                $("#downloadRpmsTable").trigger("sorton",[[[1,1]]]);
            } catch (e) {}
        } else {
            try {
                $("#downloadRpmsTable").tablesorter({
                    sortList: [[1,1]],
                    widgets: ['zebra'],
                    headers: {
                        1: {
                            sorter: "wcpDate"
                        },
                        2: {
                            sorter: "size"
                        }
                    }
                });
                globals.functions.makeFixedTableHeader("downloadRpmsTable");
                linux_downloads.addFixedTableHeader("downloadRpmsTable");
            } catch (e) {}
        }

        linux_downloads.viewedRpmsTable = true;
    };

    linux_downloads.buildRpmDownloadsFieldset();

    linux_downloads.adjustTableHeadersOnResize = function() {
        if (globals.variables.currentTab != "linux_downloads") {
            $(window).unbind("resize", linux_downloads.adjustTableHeadersOnResize);
            return;
        }
        for (var tableIdx in linux_downloads.fixedHeaderTables) {
            var tableId = linux_downloads.fixedHeaderTables[tableIdx];
            globals.functions.resizeFixedTableHeader(tableId);
        }
    };

    $(window).bind("resize", function() {
        if (linux_downloads.tableResizeHandler) {
            clearTimeout(linux_downloads.tableResizeHandler);
        }
        linux_downloads.tableResizeHandler = setTimeout(linux_downloads.adjustTableHeadersOnResize, 300);
    });

});