/*
 * Copyright 2010 Avaya Inc. All Rights Reserved.
 */

$(document).ready(function () {

    // Get inactivity timeout value and initialize the activity monitor
    $.ajax({
            type: "GET",
            url: "/api/settings/webcontrol",
            dataType: "json",
            cache: false,
            success: function(data) {
                // Initialize activity monitor
                $.activity.init({
                    // Set interval check to every 5 seconds
                    interval: 1000*5,
                    intervalFn: function(info){
                        //do nothing
                    },
                    // Set inactive check
                    inactive: 1000 * data.timeout,
                    inactiveFn: function(info) {
                        if (typeof globals.variables.REFERRER === 'undefined') {
                            alert($("#js_sessionExpiredStandalone").text());
                        } else {
                            alert($("#js_sessionExpiredReferred").text());
                        }
                        jQuery.ajax({
                            type: 'DELETE',
                            url: '/api/session',
                            complete: function(xhr, statusText) {
                                globals.functions.handleRedirection(globals.variables.REDIRECT_USER_INACTIVITY);
                            }
                        });
                    }
                });

                // Handle activity reactivation and update
                $(document).click(function(){
                    if ( $.activity.isActive() ) {
                        $.activity.update(new Date().getTime());
                    } else {
                        $.activity.reActivate();
                    }
                });
            }
    });


    $("#javascriptStringsDiv").load("/messages", function () {

        var helpWindow = null;
        var main = {};
        globals.variables.chartYFormat = "%.1f" + $("#js_percentage").text();

        // Add file size parser for the tablesorter plugin
        $.tablesorter.addParser({
            id: 'size', 
            is: function(s) {
                // return false so this parser is not auto detected
                return false;
            },
            format: function(s) {
                return globals.functions.parseBytes(s);
            },
            type: 'numeric'
        });

        $.tablesorter.addParser({
            id: 'string',
            is: function(s) {
                // return false so this parser is not auto detected
                return false;
            },
            format: function(s) {
                return s;
            },
            type: 'text'
        });

        $.tablesorter.addParser({
            // set a unique id
            id: 'wcpDate',
            is: function(s) {
                // return false so this parser is not auto detected
                return false;
            },
            format: function(s) {
                var sep = s[2];
                var datePart = "";
                if (isNaN(s[2])) {
                    datePart = s.slice(0, 10).split(s[2]).reverse().join("");
                } else if (isNaN(s[4])){
                    datePart = s.slice(0, 10).split(s[4]).join("");
                } else {
                    return "0";
                }
                var timePart = s.slice(11, s.length).split(":").join("");
                return datePart + timePart;
            },
            // set type, either numeric or text
            type: 'numeric'
        });

        // Global configuration for AJAX calls
        $.ajaxSetup({
            timeout: globals.variables.GLOBAL_AJAX_TIMEOUT,
            // Call a global error handler for AJAX calls
            error: function (xmlHttpReq, textStatus, errorThrown) {
                globals.functions.ajaxError(xmlHttpReq, textStatus, errorThrown);
            }
        });

        /**
         * Handle logout action
         */
        $("#logoutLink").click ( function (e) {
            e.preventDefault();
            jQuery.ajax({
                type: 'DELETE',
                url: '/api/session',
                complete: function(xhr, statusText) {
                    globals.functions.handleRedirection(globals.variables.REDIRECT_USER_LOGOUT);
                }
            });
        });

        /**
         * Adjust the WCP layout when it is embedded in Web Manager
         */
        main.adjustLayout = function (message) {
            if (typeof globals.variables.REFERRER !== 'undefined') {
                try {
                    var tabsHeight = $("#header a").outerHeight();
                    $("#header").css("height", "" + tabsHeight + "px");
                    $("#content").css("top", "" + tabsHeight + "px");
                } catch (e) {
                    //ignored
                }
            }
        };

        main.adjustLayout();

        /**
         * Opens the modal that warns the user the demo license is abut to expire
         *
         * @param message       The message to display
         */
        main.openLicenseExpireModal = function (message) {

            $("#licenseExpireModalText").html(message);

            //button click events
            $("#licenseExpireModalButtons button").unbind("click");
            $("#licenseExpireModalOk").click(function () {
                $.modal.close();
            });
            $('#licenseExpireModal').modal({
                closeHTML: "<a href='' title='" + $("#js_close").text() + "'></a>",
                overlayId: 'modal-overlay',
                containerId: 'licenseExpireModal-container',
                escClose: true
            });

        };

        /**
         * Opens the modal that warns the user that the certificate needs to be updated
         */
        main.openCertificateModal = function () {

            //button click events
            $("#certificateModalButtons button").unbind("click");
            $("#certificateModalOk").click(function () {
                globals.variables.showCertificateModal = !$("#certificateModalCheckbox")[0].checked;
                $.modal.close();
            });
            $('#certificateModal').modal({
                closeHTML: "<a href='' title='" + $("#js_close").text() + "'></a>",
                overlayId: 'modal-overlay',
                containerId: 'licenseExpireModal-container',
                escClose: true
            });

        };

        /**
         * Retrieve version data and set application title and version info
         */
        $.ajax({
            type: "GET",
            url : "/api/version",
            dataType: "json",
            cache: false,
            success : function (data) {
                document.title = data.TITLE;
                $("#titleLabel").text(data.TITLE);
                var fullVersion = data.VERSION + "." + data.RELEASE;
                var version = globals.functions.parseVersion(fullVersion).versionNumber;
                var build = globals.functions.parseVersion(fullVersion).buildNumber;
                if (version != null && build != null) {
                    globals.functions.composeText("versionNumberLabel", "js_versionFormat", [version, build]);
                }
                globals.variables.releaseType = data.RELEASE_TYPE;
                globals.variables.buildUID = data.BUILD_DATE;
                if (globals.variables.releaseType != "appl" && globals.variables.releaseType != "apc") {                
                    if (globals.variables.releaseType == "abe") {
                        $.ajax({
                            type: 'GET',
                            url: globals.REST_URL.IPOFFICE_MODE,
                            cache: false,
                            success: function(data) {
                                globals.variables.serverType = data.mode;
                            }
                        });
                    } else {
                        main.checkCertificate();
                    }
                }

                //Handle help window
                $("#helpLink").click ( function (e) {
                    e.preventDefault();
                    var webmanagerport = parseInt(window.location.port) - 1;
                    var weblanguage = globals.variables.language.split("_")[0];
                    if ( weblanguage == "nl" ) {
                        weblanguage = "en";
                    }
                    var webmanagerlink = 'https://' + window.location.hostname + ':' + webmanagerport + '/WebManagement/help/Premise/'+weblanguage+'/Solution.html';
                    helpWindow = window.open(webmanagerlink, "_blank");
                });
            }
        });

        /**
         * Retrieve the language used in the current session 
         */
        $.ajax({
            type: "GET",
            url: "/api/i18n/lang",
            cache: false,
            success: function (data) {
                globals.variables.language = data;
            }
        });

        /**
         * Check if automatic certificate generation is on
         */
        $.ajax({
            type: "GET",
            url: "/api/settings/certificate/generate",
            timeout: globals.variables.CERTIFICATE_DEFAULTS_TIMEOUT,
            cache: false,
            success: function (data) {
                globals.variables.autoCertCreation = data.auto_generate;
            }
        });

        /**
         * Periodically checks the certificate status
         */
        main.checkCertificate = function() {
            certificateCheck = function () {
                if (globals.variables.showCertificateModal && globals.variables.performCertificateCheck) {
                    $.ajax({
                        type: "GET",
                        url: '/api/settings/certificate',
                        cache: false,
                        timeout: globals.variables.GLOBAL_AJAX_TIMEOUT,
                        success: function(data) {
                            if (data != CertificateStatus.UNAVAILABLE) {
                                globals.variables.performCertificateCheck = false;
                                clearInterval(i);
                            } else {
                                main.openCertificateModal();
                            }
                        }
                    });
                }
            };
            var i = setInterval("certificateCheck()", 60000);
        };

        /**
         * Checks if the system is a virtual machine or not.
         */
        $.ajax({
            type: "GET",
            url: "/api/system/virtual",
            success: function (data) {
                if (data.virtual_system) {
                    globals.variables.isVirtual = true;
                    if (data.cloud_system) {
                        globals.variables.isCloud = true;
                    }
                }
            }
        });

        /**
         * Get and display license warning if necessary.
         */
        $.ajax({
            type: "GET",
            url: '/api/services/license',
            cache: false,
            timeout: globals.variables.GLOBAL_AJAX_TIMEOUT,
            error: function (xmlHttpReq, textStatus, errorThrown) {
                globals.functions.ajaxError(xmlHttpReq, textStatus, errorThrown);
            },
            success: function(data) {
                if (! $.isEmptyObject(data)) {
                    // demo version
                    if (data.license_expire_message != null && globals.variables.showLicenseExpireWarning) {
                        globals.variables.showLicenseExpireWarning = false;
                        main.openLicenseExpireModal(data.license_expire_message);
                    }
                } else {
                    $("#licenseNeededDiv").addClass("hiddenElement");
                }
            }
        });

        /**
         * Check if the system is gold edition.
         */
        $.ajax({
            type: "GET",
            url: "/api/system/gold_edition",
            cache: false,
            success: function (data) {
                globals.variables.goldEdition = data;
            }
        });
        $.ajax({
            type: "GET",
            url: "/api/settings/asg_status",
            dataType: "json",
            cache: false,
            success: function(data) {
                globals.variables.hasAsg = data.asg_status;
            }
        });

        /**
         * Open a tab when the header is clicked
         */
        main.addTabClickEvent = function() {
            $('div.tabs ul.tabNavigation a').click(function (e) {

                e.preventDefault();

                if (globals.variables.contentLoaded && globals.variables.currentTab != this.name) {

                    globals.variables.contentLoaded = false;
                    $('div.tabs ul.tabNavigation li div').removeClass('tabBorderSelected');
                    $('div.tabs ul.tabNavigation li div img').hide();
                    $('div.tabs ul.tabNavigation a').removeClass('selected');
                    $(this).addClass('selected');
                    var borderElementName = this.name;
                    if (this.name.indexOf("/") > -1) {
                        borderElementName = this.name.substring(this.name.lastIndexOf("/")+1)
                    }
                    borderElementName += "Border";
                    $("#" + borderElementName).addClass("tabBorderSelected");
                    $("#" + borderElementName + " img").show();
                    clearInterval(globals.variables.homeTabInterval);
                    clearInterval(globals.variables.appsInterval);
                    clearInterval(globals.variables.osInterval);
                    if (this.name == "home") {
                        try {
                            $.manageAjax.clear('servicesAjaxQueue', true);
                        } catch (e) {
                            //ignored
                        }
                        try {
                            $.manageAjax.clear('systemAjaxQueue', true);
                        } catch (e) {
                            //ignored
                        }
                        try {
                            $.manageAjax.clear('notificationsAjaxQueue', true);
                        } catch (e) {
                            //ignored
                        }
                        try {
                            $.manageAjax.clear('licenseAjaxQueue', true);
                        } catch (e) {
                            //ignored
                        }
                        try {
                            $.manageAjax.clear('vendorAjaxQueue', true);
                        } catch (e) {
                            //ignored
                        }
                    }

                    globals.functions.loadContent(this.name);
                }

                }).filter(':first').click();
        };

        /**
         * Add vendor tabs
         */
        $.ajax({
            type: "GET",
            url: "/api/vendor_tabs/",
            dataType: "json",
            cache: false,
            success: function (data) {
                for (var i in data) {
                    if (("name" in data[i]) && ("template" in data[i])) {
                        var extraTab = "";
                        extraTab += "<li>";
                        extraTab += "<a href='' name='api/vendor_tabs/" + data[i].template + "'>" + data[i].name + "</a>";
                        extraTab += "</li>";
                        if (data[i].prepend) {
                            $(".tabNavigation").prepend(extraTab);
                        } else {
                            $(".tabNavigation").append(extraTab);
                        }
                    }
                    if (data[i].init_script) {
                        $.getScript("/static/js/vendor_js/" + data[i].init_script + "?" + globals.variables.buildUID);
                    }
                }
                main.addTabClickEvent();
            },
            complete : function (xhr) {
                globals.functions.showHideUpdatesAvailableIcon();
                if (xhr.status != 500) {
                    main.addTabClickEvent();
                }
            }
        });

        /**
         * Get the name of current logged in user and display it in page header.
         */
        $.ajax({
            type: "GET",
            url: "/api/session",
            dataType: "json",
            cache: false,
            success: function(data) {
                $("#currentLoggedInUser").text(data.user);
                globals.variables.hasSecurityRights = data.security_rights;
                globals.variables.hasAdminRights = data.admin_rights;
                if (!globals.variables.hasAdminRights) {
                    $('[name="updates"]').parent().hide();
                }
            }
        });

    });

});

