/*
 * Copyright 2010 Avaya Inc. All Rights Reserved.
 */

$(document).ready(function () {

    var user_applications = {};


    /**
     * Gets the data and builds the download windows clients fieldset
     */
    user_applications.buildDownloadUserApplicationsFieldset = function () {

        $.ajax({
            type: "GET",
            url: "/user?files",
            cache: false,
            dataType: "json",
            error: function (xmlHttpReq, textStatus, errorThrown) {
                $("#downloadWindowsClientsContainer").unmask();
            },
            beforeSend: function () {
                $("#downloadWindowsClientsContainer").mask($("#js_loading").text());
            },
            success: function (data) {
                user_applications.buildAppWidgets(data);
            },
            complete: function () {
                $("#downloadWindowsClientsContainer").unmask();
            }
        });
    };

    user_applications.buildAppWidgets = function (data) {
        $("#downloadWindowsClientsContainer tbody").empty();
        var appWidgetsHTML = "";
        for (var i = 0; i < data.length; i++) {
            var appElem = "";
            var newRow = ((i % 2) == 0);
            if (newRow) {
                appElem += "<tr>";
            }
            appElem += "<td>";
            var imgSrc = "static/pics/vendor_pics/Default.png";
            if (data[i].icon && (data[i].icon.length > 0)) {
                imgSrc = "/user?file=" + data[i].icon;
            }
            appElem += "<div style='background: url(" + imgSrc + ") top left no-repeat'>";
            appElem += "<a href='/user?file=" + data[i].id + "'>" + data[i].id + "</a>";
            appElem += "<div><em>" + $("#js_addedAt").text() + " - </em> " + data[i].modif + "</div>";
            appElem += "<div><em>" + $("#js_size").text() + " - </em> " + data[i].size + "</div>";
            if (('description' in data[i]) && (data[i].description.length > 0)) {
                appElem += "<i>" + data[i].description + "</i>";
            }
            appElem += "<div>";
            appElem += "</td>";
            if (!newRow) {
                appElem += "</tr>";
            }
            appWidgetsHTML += appElem;
        }
        $("#downloadWindowsClientsContainer tbody").append(appWidgetsHTML);
    };

    user_applications.adjustLayout = function () {
        var contentHeight = parseInt($(window).height() - $("#userApplicationsContentDiv").offset().top
            - $("#userApplicationsContentDiv .groupHeader").outerHeight() - 14);

        $("#downloadWindowsClientsContainer").height(contentHeight);
        $("#downloadWindowsClientsContainer").addClass("scroll");
    };

    // Global configuration for AJAX calls
    $.ajaxSetup({
        timeout: globals.variables.GLOBAL_AJAX_TIMEOUT,
        // Call a global error handler for AJAX calls
        error: function (xmlHttpReq, textStatus, errorThrown) {
        }
    });

    /**
     * Retrieve version data and set application title and version info
     */
    $.ajax({
        type: "GET",
        url : "/api/version",
        dataType: "json",
        cache: false,
        success : function (data) {
            document.title = data.TITLE;
            $("#titleLabel").text(data.TITLE);
            var fullVersion = data.VERSION + "." + data.RELEASE;
            var version = globals.functions.parseVersion(fullVersion).versionNumber;
            var build = globals.functions.parseVersion(fullVersion).buildNumber;
            if (version != null && build != null) {
                globals.functions.composeText("versionNumberLabel", "js_versionFormat", [version, build]);
            }
            globals.variables.releaseType = data.RELEASE_TYPE;
            globals.variables.buildUID = data.BUILD_DATE;
        }
    });

    user_applications.adjustLayout();
    user_applications.buildDownloadUserApplicationsFieldset();


});