/*
 * Copyright 2010 Avaya Inc. All Rights Reserved.
 */

$(document).ready(function () {

    var vnc = {};
    vnc.tab = "";
    vnc.PROTOCOL = "http";
    vnc.PORT = null;
    vnc.portRange = {min: 5800, max: 5899};

    /**
     * Builds the setVnc fieldset
     */
    vnc.buildSetVncFieldset = function () {

        $.ajax({
            type: "GET",
            url: "/api/system/vnc",
            cache: false,
            dataType: "json",
            beforeSend: function () {
                $("#setVncFieldset").mask($("#js_loading").text());
            },
            success: function (data) {

                $("#vncPortInput").val(data.port);
                vnc.PORT = data.port;
                vnc.enableDisableButtons(data.running);

                $("#startStopVncDiv button").unbind("click");
                $("#startVncButton").click( function () {
                    vnc.startVNC();
                });
                $("#stopVncButton").click( function () {
                    vnc.stopVNC();
                });
                $("#saveVncButton").click( function () {
                    vnc.savePassword();
                });
            },
            complete: function () {
                $("#setVncFieldset").unmask();
            }
        });

    };

    /**
     * Enables or disables the buttons of the VNC settings fieldset depending on the VNC server's state
     *
     * @param isRunning     the VNC server's state
     */
    vnc.enableDisableButtons = function (isRunning) {
        globals.functions.enableButton("startVncButton", !isRunning);
        globals.functions.enableButton("saveVncButton", !isRunning);
        globals.functions.enableButton("stopVncButton", isRunning);
    };

    /**
     * Saves the new VNC server password
     */
    vnc.savePassword = function () {
        if (globals.validators.isNumeric($("#vncPortInput").val()) && $("#vncPortInput").val() >= vnc.portRange.min
            && $("#vncPortInput").val() <= vnc.portRange.max) {

            var dataString = "port=" + $("#vncPortInput").val();
            dataString += "&password=" + encodeURIComponent($("#vncPasswordInput").val());
            $.ajax({
                type: "POST",
                url: "/api/system/vnc",
                data: dataString,
                cache: false,
                beforeSend: function () {
                    $("#setVncFieldset").mask($("#js_loading").text());
                },
                complete: function (xhr) {
                    if (xhr.status == 200) {
                        vnc.PORT = $("#vncPortInput").val();
                    }
                    $("#setVncFieldset").unmask();
                }
            });

        } else {
            alert($("#js_invalidVncPort").text());
        }
    };

    /**
     * Starts the VNC connection
     */
    vnc.startVNC = function () {
        $.ajax({
            type: "PUT",
            url: "/api/system/vnc",
            cache: false,
            beforeSend: function () {
                $("#setVncFieldset").mask($("#js_loading").text());
            },
            complete: function (xhr) {
                if (xhr.status == 200) {
                    vnc.enableDisableButtons(true);
                }
                $("#setVncFieldset").unmask();
            }
        });
    };

    /**
     * Stops the VNC connection
     */
    vnc.stopVNC = function () {
        $.ajax({
            type: "DELETE",
            url: "/api/system/vnc",
            cache: false,
            beforeSend: function () {
                $("#setVncFieldset").mask($("#js_loading").text());
            },
            complete: function (xhr) {
                if (xhr.status == 200) {
                    vnc.enableDisableButtons(false);
                }
                $("#setVncFieldset").unmask();
            }
        });
    };

    /**
     * Renders a sub tab from the Remote Desktop tab.
     *
     * @param subTabName sub tab to render.
     */
    vnc.renderSubtab = function (subTabName) {

        if (subTabName == "setVnc") {
            vnc.buildSetVncFieldset();
        } else if (subTabName == "viewVnc") {
            if ($("#vncUrlInput").val() != "") {
                var ip = window.location.host.split(":")[0];
                var src = vnc.PROTOCOL + "://" + ip + ":" + vnc.PORT;
                if (navigator.appName.indexOf("Internet Explorer") > -1) {
                    document.getElementById("vncIframe").src = src;
                } else {
                    $("#vncIframe").attr("src", src);
                }
            }
        }

    };

    //Internet Explorer hacks in order to set height
    $("#vncContentDiv").height($(window).height() - $("#vncContentDiv").offset().top - 4);
    $("#vncIframe").height($("#vncContentDiv").height() - 10);

    /**
     * Makes the selected subtab content visible and calls the
     * render sub tab function when the sub tab is clicked.
     */
    $("#vncTabs li a").click(function (e) {

        e.preventDefault();
        if (vnc.tab != this.name) {
            $("#vncTabs li a").removeClass("selected");
            $(this).addClass("selected");
            if (this.name == "setVnc") {
                $("#setVncDiv").removeClass("hiddenElement");
                $("#viewVncDiv").addClass("hiddenElement");
            } else if (this.name == "viewVnc") {
                $("#viewVncDiv").removeClass("hiddenElement");
                $("#setVncDiv").addClass("hiddenElement");
            }
            vnc.renderSubtab(this.name);
            vnc.tab = this.name;
        }

    }).filter(':first').click();

});