/*
 * Copyright 2010 Avaya Inc. All Rights Reserved.
 */

$(document).ready(function () {

    var windows_clients = {};

    /**
     * Gets the data and builds the download windows clients fieldset
     */
    windows_clients.buildDownloadWindowsClientsFieldset = function () {
        $.ajax({
            type: "GET",
            url: "/api/windows/clients/",
            cache: false,
            dataType: "json",
            error: function (xmlHttpReq, textStatus, errorThrown) {
                globals.functions.ajaxError(xmlHttpReq, textStatus, errorThrown);
                $("#downloadWindowsClientsContainer").unmask();
            },
            beforeSend: function () {
                $("#downloadWindowsClientsContainer").mask($("#js_loading").text());
            },
            success: function (data) {
                windows_clients.buildAppWidgets(data.files, data.is_local_repo);
            },
            complete: function () {
                $("#downloadWindowsClientsContainer").unmask();
            }
        });
    };

    /**
     * Populates the windows clients fieldset, similar to windows explorer icon view.
     *
     * @param data      The data object array received from the device
     * @param isLocal   The repository's type (true if local , false if remote)
     */
    windows_clients.buildAppWidgets = function (data, isLocal) {
        $("#downloadWindowsClientsContainer tbody").empty();
        var appWidgetsHTML = "";
        for (var i = 0; i < data.length; i++) {
            var appElem = "";
            var newRow = ((i % 2) == 0);
            if (newRow) {
                appElem += "<tr>";
            }
            appElem += "<td>";
            if (isLocal) {
                var imgSrc = "static/pics/vendor_pics/Default.png";
                if (data[i].icon && (data[i].icon.length > 0)) {
                    imgSrc = "/api/windows/clients/" + data[i].icon;
                }
                appElem += "<div style='background: url(" + imgSrc + ") top left no-repeat'>";
                appElem += "<a href='/api/windows/clients/" + data[i].id + "'>" + data[i].id + "</a>";
                appElem += "<div><em>" + $("#js_addedAt").text() + " - </em> " + data[i].modif + "</div>";
                appElem += "<div><em>" + $("#js_size").text() + " - </em> " + data[i].size + "</div>";
                if (('description' in data[i]) && (data[i].description.length > 0)) {
                    appElem += "<i>" + data[i].description + "</i>";
                }
                appElem += "<div>";
            } else {
                appElem += "<a href='"+ data[i].url +"' title='" + data[i].url + "'>" + data[i].url + "</a>";
            }
            appElem += "</td>";
            if (!newRow) {
                appElem += "</tr>";
            }
            appWidgetsHTML += appElem;
        }
        $("#downloadWindowsClientsContainer tbody").append(appWidgetsHTML);
    }

    windows_clients.adjustLayout = function () {
        var contentHeight = parseInt($(window).height() - $("#windowsClientsContentDiv").offset().top
            - $("#downloadWindowsClientsFieldset .groupHeader").outerHeight() - 14);

        $("#downloadWindowsClientsContainer").height(contentHeight);
        $("#downloadWindowsClientsContainer").addClass("scroll");
    };

    windows_clients.adjustLayout();
    windows_clients.buildDownloadWindowsClientsFieldset();

});