#!/bin/bash
flag="/opt/Avaya/.allowdownload"

function allowd {
    if [ $1 = y ]; then
        if [ ! -f $2 ]; then
            touch $2
        fi
        if [ -f $2 ]; then
            echo Download is allowed!
        else
            echo An error occured when trying to allow download.
            echo The file $flag could not be created.
        fi
    fi
    if [ $1 = n ]; then
        if [ -f $2 ]; then
            rm -f $2
        fi
        if [ ! -f $2 ]; then
            echo Download is not allowed!
        else
            echo An error occured when trying to disallow download.
            echo The file $flag could not be deleted.
        fi
    fi
}

function except {
    grep "export.*IPOFFICE_BE_MODE.*$1" /etc/sysconfig/ipoffice
    if [ $? -eq 0 ]; then
        echo Allowing download of the Avaya applications ISO is not permitted on $1 
        exit
    fi
}

read -p "Do you want to allow the download of the lower version of Avaya applications ISO? This may fail or corrupt the operating system.(y/n)?" answer
case $answer in
    [Yy]* ) allowd y $flag;; 
    [Nn]* ) allowd n $flag;; 
    * ) exit ;;
esac
