#!/bin/bash

function usage()
{
	echo "$1" >&2
	echo -e "usage: $0 ipoffice|ipoffice-demo|ipoffice-sees|onexportal\n or $0 list ipoffice|ipoffice-demo|ipoffice-sees|oneportal|voicemail" >&2
	exit 1 
}

VMPRO_RESTORE_UTILITY="/opt/vmpro/VMProRestore"


case $1 in
list)
	case $2 in
	ipoffice|ipoffice-demo|ipoffice-sees)
        # List backups for IP Office
        # We only support one backup by design so just list directory contents of backup
        if [ ! -f /etc/sysconfig/ipoffice ]; then
            echo "IP Office is not installed"
            exit 1
        fi

        . /etc/sysconfig/ipoffice
        if [ -z "$IPOFFICE_BASE_DIRECTORY" ]; then
            IPOFFICE_BASE_DIRECTORY="/opt/ipoffice"
        fi

        IPOFFICE_BACKUP_DIR=${IPOFFICE_BASE_DIRECTORY}/system/backup
        if [ ! -d "$IPOFFICE_BACKUP_DIR" ]; then
            echo "No backup found"
            exit 1
        fi
        
        echo "IP Office only supports one backup."
        echo "Current backup directory contents: "
        ls -l $IPOFFICE_BACKUP_DIR
	;;
	onexportal)
	;;
	voicemail)
		if [ $3 = "Dir" ];then
			${VMPRO_RESTORE_UTILITY} /List:$3 $4	
		else
			${VMPRO_RESTORE_UTILITY} /List:$3
		fi 
	;;
	*)
		usage "Invalid paramater $2"
	esac
;;
ipoffice|ipoffice-demo)
    # Make a new backup.
    # Here we remove previous backup and create new one
    # based on contents of /system/primary
    if [ ! -f /etc/sysconfig/ipoffice ]; then
        echo "IP Office is not installed"
        exit 1
    fi

    . /etc/sysconfig/ipoffice
    if [ -z "$IPOFFICE_BASE_DIRECTORY" ]; then
        IPOFFICE_BASE_DIRECTORY="/opt/ipoffice"
    fi
    
    if [ ! -d "$IPOFFICE_BASE_DIRECTORY/system/primary" ]; then
        echo "Nothing to backup"
        exit 1
    fi
    
    rm -rf "$IPOFFICE_BASE_DIRECTORY/system/backup"
    sudo cp -rf "$IPOFFICE_BASE_DIRECTORY/system/primary" "$IPOFFICE_BASE_DIRECTORY/system/backup"
    
    echo "Backup complete"
;;
onexportal)
;;
*)
	usage "Invalid paramater $1"
esac
