#!/bin/bash

function usage()
{
	echo "$1" >&2
	echo -e "usage: $0 ipoffice|ipoffice-demo|ipoffice-sees|oneportal|voicemail" >&2
	exit 1 
}

SCRIPTS_PATH=/opt/Avaya/scripts
. ${SCRIPTS_PATH}/config $1

VMPRO_RESTORE_UTILITY="/opt/vmpro/VMProRestore"
IPOFFICE_BACKUP_DIR="/opt/Avaya/Backups/ipoffice"

case $1 in
ipoffice|ipoffice-demo|ipoffice-sees)
    #Restore backup of IP Office files.
    #This will copy contents of <ipoffice_path>/system/backup to <ipoffice_path>/system/primary
    #Will only be possible if IP Office is not running and backup exists
    if [ ! -f /etc/sysconfig/ipoffice ]; then
        echo "IP Office is not installed"
        exit 1
    fi
    
    CHECK=`sudo service ipoffice status | grep running`
    if [ ! -z "$CHECK" ]; then
        echo "IP Office is running, please stop IP Office before restore"
        exit 1
    fi
    
    . /etc/sysconfig/ipoffice
    if [ -z "$IPOFFICE_BASE_DIRECTORY" ]; then
        IPOFFICE_BASE_DIRECTORY="/opt/ipoffice"
    fi
    
    IPOFFICE_BACKUP_DIR=${IPOFFICE_BASE_DIRECTORY}/system/backup
    if [ ! -d "$IPOFFICE_BACKUP_DIR" ]; then
        echo "No backup found"
        exit 1
    fi

    sudo rm -rf ${IPOFFICE_BASE_DIRECTORY}/system/primary
    sudo cp -rf ${IPOFFICE_BASE_DIRECTORY}/system/backup ${IPOFFICE_BASE_DIRECTORY}/system/primary
    echo "Backup restored"
;;
voicemail)
	sudo ${VMPRO_RESTORE_UTILITY} /Restore:$2
	case "$?" in
		0) 
			echo "Restore completed"
		;;
		1) 
			echo "Unable to login to VmPro server"
		;;
		2) 
			echo "Directory not found"
		;;
		3) 
			echo "File not found"
		;;
		4) 
			echo "Exception occured"
		;;
		5) 
			echo "Failed to suspend VmPro server"
		;;
	esac
;;
onexportal)
;;
*)
	usage "Invalid parameter $1"
esac
