#!/bin/sh
FILE_NAME=$1
COREDIR="/var/www/html/coredumps" 

. /opt/Avaya/scripts/config_files/apps_logging_config
 
function do_empty() {
    # $1 = the file or folder path
    if [ -d $1 -o -f $1 ]; then
        find $1 -type f | xargs truncate --size 0  # truncate may yield failure, but that won't stop the script
    fi
}

if [[ "$FILE_NAME" == *"coredump"* ]]; then
     rm -f ${COREDIR}/*
else
    # Get list of files from archive.
    archive=( `tar -tf $FILE_NAME` )
    for log_file in ${archive[@]}
    do
        if [ -f "/$log_file" ]; then
            if [[ "$FILE_NAME" == *"sysmon"* ]]; then            
                # For sysmon we know we need to delete all archived files (.zip), excluding non-archived (.log.zip)
                if [[ ${log_file: -8} != ".log.zip" ]]; then
                    rm -f "/$log_file"
                fi
            else
                # For other application, better truncate the file size rather than delete it, since some application may not recreate log files.
                # Exclude any .cfg file (e.g. anaconda-ks.cfg) or network interface configuration script (e.g. ifcfg-eth0)
                if [[ ${log_file: -4} != ".cfg" && $log_file != *"ifcfg-eth"* ]]; then
                    do_empty "/$log_file"
                fi
            fi
        fi
    done
fi

echo "done"