#!/bin/bash
#
#  This script blanks the SSD.  It results in an unformatted drive.
#
#  Usage:
#     blankdrive [-force] <device>
#
#  -force : Do not prompt for confirmation
#
function show_usage
{
    echo "blankdrive : Performs secure erase on device"
    echo "Usage:  blankdrive [-force] <device>"
    echo "           -force : do not prompt for confirmation"
    echo "           device : SDD drive label"

    exit 0
}

#### MAIN
if [ $# -lt 1 ]; then
    show_usage
fi

if [ $1 != "-force" ]; then
    response=
    echo -n "This will erase /dev/$1.  Are you sure? "
    read response
    if [ "$response" != "y" ]; then
        echo "Quitting."
        exit 1
    fi
else
    shift
fi

echo "Securely erasing /dev/$1"
hdparm --user-master u --security-set-pass Eins /dev/$1
hdparm --user-master u --security-erase Eins /dev/$1
echo "Done."

