#!/bin/bash

JADE_CFG=/usr/Avaya/MediaServer/config/softMediaServer.cfg
PARAM_NAME="$1"
PARAM_VALUE=$2

# check configuration file
if [ ! -f "$JADE_CFG" ]; then
    echo "Could not find jade configuration file"
    exit 1
fi

case "$PARAM_NAME" in
    # 1- enabled, 0- disabled for debugMediaProcessing and EnableRTPRelay 
    "debugMediaProcessing" | "EnableRTPRelay" )
        if [ $PARAM_VALUE -gt 0 ]; then
            PARAM_VALUE=1
        fi
     ;;
esac

# add/replace parameter value
if grep "^$PARAM_NAME=*" $JADE_CFG > /dev/null; then
    echo "Current value: "`grep "^$PARAM_NAME=*" $JADE_CFG`
    perl -pi -e "s/$PARAM_NAME=.*/$PARAM_NAME=$PARAM_VALUE/g" $JADE_CFG
else
    echo "Adding parameter..."
    echo "$PARAM_NAME=$PARAM_VALUE" >> $JADE_CFG
fi

echo "New value: $PARAM_NAME=$PARAM_VALUE"
systemctl restart isa
