#!/bin/bash
function checkLinuxPassword() {
    correct=$(</etc/shadow awk -v user=$1 -F : 'user == $1 {print $2}')
    if [ ! -z "$correct" ]; then
        prefix=${correct%"${correct#\$*\$*\$}"}
        supplied=$(echo "$2" | perl -e '$_ = <STDIN>; chomp; print crypt($_, $ARGV[0])' "$prefix")
        if [ "$supplied" = "$correct" ]; then
            echo "0"
        else
            echo "1"
        fi
    else
        echo "1"
    fi
}

if [ -z $1 ]; then
    echo "Please provide a password"
    exit
fi

if [ -z $2 ]; then
    echo "Please provide a old password"
    exit
fi
if [ -z $3 ]; then
    echo "Please provide a user name"
    exit
fi

if [ "$2" != "IGN" ] && [ -f /opt/Avaya/.ignition ]; then
    retCode=$(checkLinuxPassword $3 $2)
    if [[ "$retCode" != "0" ]]; then
        echo "error Failed login."
        exit
    fi
fi

sudo echo -e "$1\n$1" | passwd $3
