#!/bin/bash
# set default ip address
# args $1 - interface
# 
. /etc/sysconfig/ipoffice

echo "$1 setted" >>/opt/ipoffice/lof.txt 
network_interface=$1
link_ip=`LANGUAGE=en_US.UTF-8 /sbin/ifconfig $network_interface | grep "inet" | tr -s ' ' | cut -d ' ' -f3 | grep -o "[0-9\.]*"`

if [ "$network_interface" == "$IPOFFICE_LAN1" ]; then
    DEFAULT_IP_CONFIG_LAN="192.168.42.1/24"
elif [ "$network_interface" == "$IPOFFICE_LAN2" ]; then
    DEFAULT_IP_CONFIG_LAN="192.168.43.1/24"
fi

if [ -z "$link_ip"  -a  ! -z "$DEFAULT_IP_CONFIG_LAN" ]; then
   ifconfig "$network_interface" down
   ifconfig "$network_interface" "$DEFAULT_IP_CONFIG_LAN"
   ifconfig "$network_interface" up
fi

