#!/bin/sh
BACKUP_TYPE=$1

. /opt/Avaya/scripts/config_files/apps_logging_config

SYSTEM_DIAGNOSTIC_BACKUP_DIR="/opt/ipoffice/system/logs"
IPOBIN="/usr/bin/ipoffice"
CORESDIR="/var/www/html/coredumps"

# Remove system logs content folder
if [ "$BACKUP_TYPE" == "auto" ]; then
   rm -rf ${SYSTEM_DIAGNOSTIC_BACKUP_DIR}/coredump*.tar.gz
fi

if [ ! -d /tmp/avaya/coredumps ]; then
    mkdir -p /tmp/avaya/coredumps/
fi
cd $CORESDIR

echo bt > /tmp/gdb_cmd
cwd=`pwd`
saveIFS="$IFS"

if [ -f /opt/Avaya/ABE_release ]; then
    RELEASE_VER=`cat /opt/Avaya/ABE_release | grep ABE_VERSION | cut -d';' -f1 | sed 's/[\\]//g' | sed 's/(/./g' | sed 's/)//g'`
elif [ -f /opt/Avaya/APPL_release ]; then
    RELEASE_VER=`cat /opt/Avaya/APPL_release | grep ABE_VERSION | cut -d';' -f1 | sed 's/[\\]//g' | sed 's/(/./g' | sed 's/)//g'`
elif [ -f /opt/Avaya/APC_release ]; then
    RELEASE_VER=`cat /opt/Avaya/APC_release | grep APC_VERSION | cut -d';' -f1 | sed 's/[\\]//g' | sed 's/(/./g' | sed 's/)//g'`
fi


files=$(ls "$CORESDIR"/core.* 2> /dev/null | wc -l)
if [ "$files" != "0" ]
then
   IPO_MD5SUM=`md5sum $IPOBIN`
   MD5SUM_ONLY=`echo $IPO_MD5SUM | cut -d' ' -f1`
   IPOFFICE_BIN_VER=`rpm -qf /etc/init.d/ipoffice --qf "%{VERSION}-%{RELEASE}\n" | cut -d. -f1-3`
   IPO_VER="IPOFFICE_VERSION=${IPOFFICE_BIN_VER}"
fi    

core_dumps=( `ls -1 core*`)
for core_file in ${core_dumps[@]}
do        
    edited_core_file=${core_file//vmpro/voicemail}
    edited_core_file=${core_file//csipo/contact_recorder}
    edited_core_file=${core_file//mgwebrtc/web_rtc}
    edited_core_file=${core_file//vmpro/vmpro_web}
    if [ -f /opt/Avaya/ABG_release ]; then
        edited_core_file=${core_file//ipoffice/B5800}
    fi
    if [ -f /opt/Avaya/APC_release -o -f /opt/Avaya/APPL_release ]; then
        edited_core_file=${core_file//ipoffice/management_services}
    fi

    if [ -f /etc/sysconfig/ipoffice ]; then
        if [[ "$core_file" == *ipoffice* ]]; then
            gdb --batch $IPOBIN $core_file -x /tmp/gdb_cmd > /tmp/backtrace.out
            if [ ! -z "${RELEASE_VER}" ]; then
                IFS=$'\n'
                GDB_TRACE=($(</tmp/backtrace.out))
                SELECT_TRACE=0
                STACK_TRACE=""
                IFS=$saveIFS
                for j in "${GDB_TRACE[@]}"
                do
                    if [ "$SELECT_TRACE" != "0" ]; then
                        ((SELECT_TRACE++))
                    fi
                    TERMINATION_INFO=`echo $j | grep "Program terminated"`
                    if [ ! -z "${TERMINATION_INFO}" ]; then
                        CORE_INFO=$TERMINATION_INFO
                        ((SELECT_TRACE++))
                    fi
                    if [ $SELECT_TRACE -gt 2 ]; then
                        TRACE=(${j// / })
                        FADDR=""
                        for x in ${TRACE[@]}
                        do
                            if [[ "$x" == 0x* ]]; then
                                if [ -z "$FADDR" ]; then
                                    FADDR=$x
                                    break
                                fi
                            fi
                        done
                        if [ ! -z "$FADDR" ]; then
                            if [ -z "${STACK_TRACE}" ]; then
                                STACK_TRACE="${FADDR}"
                            else          
                                STACK_TRACE="${STACK_TRACE}, ${FADDR}"
                            fi
                        fi
                    fi
                done
                CORE_PID="${core_file//[^0-9]/}"
            fi
            echo "${RELEASE_VER}" > profile.ipoffice_core.$CORE_PID.txt
            echo "${IPO_VER}" >> profile.ipoffice_core.$CORE_PID.txt
            MD5SUM_IPOFFICE="MD5SUM=$MD5SUM_ONLY"
            echo "${MD5SUM_IPOFFICE}" >> profile.ipoffice_core.$CORE_PID.txt
            CORE_DATE="CORE_DATE=""`ls -al $core_file|tr -s \ |cut -d" " -f6`""_""`ls -al $core_file|tr -s \ |cut -d" " -f7`""_""`ls -al $core_file|tr -s \ |cut -d" " -f8`"
            echo "${CORE_DATE}" >> profile.ipoffice_core.$CORE_PID.txt
            STATUS="TERMINATION_STATUS=$CORE_INFO"
            echo "${STATUS}" >> profile.ipoffice_core.$CORE_PID.txt
            TRACE_MESSAGE="STACK_TRACE=$STACK_TRACE"
            echo "${TRACE_MESSAGE}" >> profile.ipoffice_core.$CORE_PID.txt
        fi
    fi
    if [ ! -f arc_"$edited_core_file".tar.gz ]; then
        tar -czv "$core_file" -f /tmp/avaya/coredumps/arc_"$edited_core_file".tar.gz
        mv /tmp/avaya/coredumps/arc_"$edited_core_file".tar.gz $CORESDIR
    else
        # archive exists, removing core
        rm $core_file
    fi
done

if [ "$BACKUP_TYPE" == "auto" ]; then
    if [ "$(ls -A ${CORESDIR}/)" ]; then
        timestamp=`date +%Y%m%d_%H%M%S`
        tar -czv $CORESDIR/* -f ${SYSTEM_DIAGNOSTIC_BACKUP_DIR}/coredump_${timestamp}Z.tar.gz
    fi
fi

mv /tmp/avaya/coredumps/* ${APPS_MISC_COREDUMPS_DIR_NAME}

echo "done"                                                          