#!/bin/bash

UWS_REPO="/var/www/html/avaya/uws"
APPS_DIR="/opt/Avaya"

#Create local preupgrade repository for IPOffice servers
if [ -f $APPS_DIR/ABE_release ]; then
    release_version="ABE_VERSION"
    release_file="ABE_release"

    #create version folder
    UWS_VERSION=`grep "${release_version}=" $APPS_DIR/${release_file} | awk '{ print $1}' | cut -d= -f2 | cut -d')' -f1`
    UWS_MMVER=`echo $UWS_VERSION | cut -d'\' -f1`
    UWS_BDVER=`echo $UWS_VERSION | cut -d'\' -f2`
    UWS_BDVER=`echo $UWS_BDVER | cut -d'(' -f2`
    UWS_BDVER=`echo $UWS_BDVER | cut -d'_' -f1`
    if [ ! -d $UWS_REPO/"$UWS_MMVER-$UWS_BDVER"/Linux/UWS_repository/preupgrade ]; then
        if [ -d $UWS_REPO/"$UWS_MMVER-$UWS_BDVER"/Preupgrade/rpms/ ]; then
            mkdir -p $UWS_REPO/"$UWS_MMVER-$UWS_BDVER"/Linux/UWS_repository/preupgrade/i386
            cp $UWS_REPO/"$UWS_MMVER-$UWS_BDVER"/Preupgrade/rpms/*.rpm "$UWS_REPO/$UWS_MMVER-$UWS_BDVER/Linux/UWS_repository/preupgrade/i386/"
            cd $UWS_REPO/$UWS_MMVER-$UWS_BDVER/Linux/UWS_repository/preupgrade/
            createrepo .
            UWS_REPO_FILE=/etc/yum.repos.d/AVAYA_UWS_sG.repo
            TEMP=`mktemp /tmp/uwspreXXX`
            sed -n '/\[system*/,/^$/p' /etc/yum.repos.d/AVAYA_UWS_sG.repo > $TEMP
            while read -r line; do
                if [[ $line =~ \[system.* ]]; then
                    echo -e "\n${line/[system/[preupgrade}"  >> $UWS_REPO_FILE
                elif [[ $line =~ baseurl=.* ]]; then
                    if [[ $line =~ .*system$ ]]; then
                        echo "${line%???????}/preupgrade" >> $UWS_REPO_FILE
                    fi 
                elif [[ $line =~ name=.* ]];then
                    echo "name=Avaya Midsize preupgrade repository" >> $UWS_REPO_FILE
                else
                    echo "$line" >> $UWS_REPO_FILE
                fi
            done < $TEMP
        fi
    fi
fi

