#!/bin/sh
# display script for IP Office main prompt
####################################################
# remove console blank timeout

setterm -blank 0
setterm -powerdown 0
setterm -powersave off

export PS1='[\u@\h \W]\$'
. /etc/locale.conf
. /etc/profile.d/lang.sh
. /etc/bashrc

if [ -f /opt/Avaya/scripts/locale.sh ];then
  . /opt/Avaya/scripts/locale.sh
fi

DEFAULT_IP_CONFIG_LAN1="192.168.42.1/24"
DEFAULT_IP_CONFIG_LAN2="192.168.43.1/24"
DEFAULT_IP_CONFIG=""
NETWORK_INTERFACE=""

if [ -r "/etc/sysconfig/ipoffice" ]; then
    . /etc/sysconfig/ipoffice
    if [ ! -z "$JADE_INTERFACE" ]; then
        NETWORK_INTERFACE=$JADE_INTERFACE
    else
        NETWORK_INTERFACE="eth0"
    fi
else
    NETWORK_INTERFACE="eth0"
fi

_WEBCONTROL_PROTOCOL="http"
_WEBCONTROL_PORT="7070"
if [ -f /etc/sysconfig/webcontrol ];then
 . /etc/sysconfig/webcontrol
 if [ -n "$WEBCONTROL_PROTOCOL" ];then
  _WEBCONTROL_PROTOCOL="$WEBCONTROL_PROTOCOL"
 fi
 if [ -n "$WEBCONTROL_PORT" ];then
  _WEBCONTROL_PORT="$WEBCONTROL_PORT"
 fi
fi

# Don't display CLI greeting message while in graphical mode.
# Otherwise, the infinite loop below will keep the CPU(s) permanently on a ~ 50% load.
if [ -e /etc/X11/xorg.conf ]; then
    return
fi

plogin=`pgrep -la "login"| grep "login " | wc -l`
if [ $plogin != 0 ]; then
    plogin_auth=`pgrep -la "login"| grep "login " | grep "\-\-" | wc -l`
    if [ $plogin_auth != $plogin ]; then
	exit
    fi
fi
 
while true; do
    . /etc/locale.conf
    clear

    echo " ################################################## "

    if [ -r "/opt/Avaya/ABG_release" ]; then
        echo $" #    Avaya IP Office for Linux              # "
    elif [ -r "/opt/Avaya/APPL_release" -o -r "/opt/Avaya/APC_release" ]; then
        echo $" #            Application Server                  # "
    elif [ -r "/opt/Avaya/ABE_release" ]; then
        if [ `rpm -qa|grep ipoffice-demo` ]; then
            echo $" #         IP Office Demo Server Edition          # "
        else
            echo $" #          IP Office Server Edition              # "
        fi
    else
        echo $" #            Unofficial  Server                  # "  
    fi

    echo " ################################################## "
    if [ -f /opt/ipoffice/demo ]; then
        if [[ `rpm -qa|grep ipoffice-demo` && `grep demo_build_date /opt/ipoffice/demo` ]]; then
            demobuilddate=`grep demo_build_date /opt/ipoffice/demo|awk '{print $2}'`
            demoexpdate=`grep demo_build_date /opt/ipoffice/demo|awk '{print $4}'`
            demobd=`perl -e 'print scalar(localtime($ARGV[0]))' $demobuilddate`
            demoed=`perl -e 'print scalar(localtime($ARGV[0]))' $demoexpdate`
            echo " build date: $demobd"
            echo " expiration date: $demoed"
        else 
            echo ""
            echo $" Running."
        fi 
    else
        echo ""
        echo $" Running."
    fi

    link_ip=`LANGUAGE=en_US.UTF-8 /sbin/ifconfig $NETWORK_INTERFACE | grep "inet" | tr -s ' ' | cut -d ' ' -f3`
    function interf_exists {
        #
        # prints "true" or "false" according to whether the given network interface exists,
        # so we can avoid calling "ifconfig" on a non-existing interface, which yields errors
        # usage:  interf_exists  <network_interface_name>
        #
        local exists_in_ifconfig=`LANGUAGE=en_US.UTF-8 /sbin/ifconfig | grep -o ${1}`
        if [ -n "$exists_in_ifconfig" ]; then
           echo "true"
        else
           echo "false"
        fi
    }

    function link_ip_func {
        #
        # prints the IP (if configured) of the given network interface
        # usage:  link_ip_func  <network_interface_name>
        #
        local result=""

        if [ "true" == "$(interf_exists ${1})" ]; then
            result=`LANGUAGE=en_US.UTF-8 /sbin/ifconfig ${1} | grep "inet" | tr -s ' ' | cut -d ' ' -f3`
        fi
        echo "$result"
    }

    function config_page_url_descr {
        #
        # prints the URL of the config page corresponding to the given network interface
        # usage:  config_page_url_descr  <network_interface_name>   <interface_descriptive_name>
        #
        echo '('${2}'): '${_WEBCONTROL_PROTOCOL}'://'$(link_ip_func ${1})':'$((_WEBCONTROL_PORT-1))
    }

    function print_config_page_summary {
        #
        # usage:  print_config_page_summary  <network_interface_name>  <interface_descriptive_name>
        #
        if [ -n "$(link_ip_func ${1})" ]; then
            echo $" Config page" $(config_page_url_descr ${1} ${2})
        elif [ "true" == "$(interf_exists ${1})" ]; then
            echo " ${2}:"
            echo $" No IP on interface: check Cable/DHCP Server"
            
            if [ ${2} == "LAN1" ]; then
                DEFAULT_IP_CONFIG=$DEFAULT_IP_CONFIG_LAN1
            else
                DEFAULT_IP_CONFIG=$DEFAULT_IP_CONFIG_LAN2
            fi
  
            echo -e $" To have a temporary switch to $DEFAULT_IP_CONFIG type the following command: " \"default ip\"
            echo ""           
        fi
    }

    _WEBCONTROL_URL_DESCR_LAN1=$(config_page_url_descr "eth0" "LAN1")
    _WEBCONTROL_URL_DESCR_LAN2=$(config_page_url_descr "eth1" "LAN2")

    print_config_page_summary "eth0" "LAN1" 
    print_config_page_summary "eth1" "LAN2"

    echo ""
    echo $" General commands: "
    echo "  - \"login\" - " $"Log in "

    echo ""
    echo $" Configuration commands: "
    echo "  - \"1\" - " $"Change Language "
    echo "  - \"2\" - " $"Change Keyboard "


    echo ""
    echo ""

    echo -n $" Command: "

    command=""
    read -e -t 30 command
    if [ "$command" == "1" -o "$command" == "!" ]; then
        python /opt/Avaya/scripts/language.py
        exit
    elif [ "$command" == "2" -o "$command" == "@" ]; then
        python /opt/Avaya/scripts/keyboard.py
    elif [ "$command" == "login" ]; then
        clear
        exec /bin/login
    elif [ "$command" == "default ip" ]; then
        if [ -z "$link_ip" ]; then 
            ifconfig "$NETWORK_INTERFACE" down
            ifconfig "$NETWORK_INTERFACE" "$DEFAULT_IP_CONFIG_LAN1"
            ifconfig "$NETWORK_INTERFACE" up
        fi
    elif [ "$command" == "test" ]; then
        if [ -f "/opt/Avaya/scripts/test.sh" ]; then
            /opt/Avaya/scripts/test.sh
            sleep 6
        fi
    fi

done
