#!/bin/bash

uploaded_iso=$1

if [ -z ${uploaded_iso} ]; then
    uploaded_iso=/opt/WebManager/diskcache/testAbe.iso
fi

mount_dir=$(mktemp -d)
log_file=/root/force_upgrade_sh.log

if [ ! -f ${uploaded_iso} ]; then
        echo "There is no ISO transfered!"
fi

sudo mkdir -p ${mount_dir} &> ${log_file}
sudo mount -o loop ${uploaded_iso} ${mount_dir} &> ${log_file}

crt_dir=`pwd`

cd ${mount_dir}/avaya

shopt -s nullglob
#iterate all directories
for dir in */; do

    cd ${dir}
    for file in *.rpm; do

        new_file=${file%%.*};
        package=${new_file%-*}

        if [ ! -z "`rpm -qa | grep $package`" ]; then
                rpm -U --oldpackage --nodeps ${file} &> ${log_file}
                echo "Upgrade : "$package
        else
                echo "Not installed : "$package
        fi

    done
    cd ..
done

cd ${crt_dir}
sudo umount ${mount_dir} &> ${log_file}
sudo rm -rf ${mount_dir} &> ${log_file}

