#!/bin/bash
function GB_to_bytes() {
    if [ ! -z  $1 ]; then
        echo "scale=2;$1*1024*1024*1024" | bc | awk '{printf("%d\n",$1 + 1)}'
    fi
}
DISK=$1
CHECK=`fdisk -l -u=cylinders $DISK -c=dos | grep "cylinders" | awk '{print $2}'`
if [[ $CHECK == *"heads"* ]]; then
  TOTAL_CYL=`fdisk -l -u=cylinders $DISK -c=dos | grep "cylinders" | grep "heads" | awk '{print $5}'`
else
  TOTAL_CYL=`fdisk -l -u=cylinders $DISK -c=dos | grep "cylinders" | awk '{print $5}'`
fi
DISK_SIZE=`fdisk -l -u=cylinders $DISK | grep "Disk" | grep "bytes"|  awk '{print $5}'`
CYL_SIZE=`expr $DISK_SIZE / $TOTAL_CYL`
PARTITIONS_SIZE=( $(GB_to_bytes $2) $(GB_to_bytes $3) $(GB_to_bytes $4))
UNUSED_CYL=`expr $TOTAL_CYL - 1`
for part in ${PARTITIONS_SIZE[*]}; do
    cyl_used=`echo "scale=2;$part/$CYL_SIZE" | bc | awk '{printf("%d\n",$1 + 1)}'`
    UNUSED_CYL=`expr $UNUSED_CYL - $cyl_used`
done
if [ $UNUSED_CYL -gt 0 ]; then
    #will use at least 1 cylinder
    UNUSED_CYL=`expr $UNUSED_CYL - 1`
    echo "scale=2;$UNUSED_CYL*$CYL_SIZE/1024/1024/1024" | bc | awk '{printf "%.2f", $0}'
else
    echo "-1"
fi
