#!/bin/bash

# function to retrive hdd description
function getHDDdescr() {
    str=`smartctl -i $1 | egrep "Model Family|Device Model|Serial Number|User Capacity|Vendor|Product|Device type"`
    str=${str/Model Family/Vendor}
    str=${str/Device Model/Product}
    echo -e "$str"
    if ! smartctl -i $1 | grep "Device type" > /dev/null; then
       echo -e "Device type:\tdisk"
    fi
}

#function to get hdd options
function getHDDs() {
    all_disks=`LANG=en_US smartctl --scan | cut -d' ' -f1`

    # get all disks even those not recognized by smartctl on some virtual environments 
    if [[ -f /opt/Avaya/.notvmw ]]; then
        all_disks="$(lsblk -l -i -d -n| grep disk | cut -f1 -d' '|sed -e 's:^:/dev/:' | grep -v "/dev/fd")"
    fi

    rootvg=""
    options=""
    if [ ! -f /opt/Avaya/.ova ]; then
        for j in `lvm pvscan | grep "rootvg" | cut -d' ' -f4`; do
            for i in $all_disks; do       
                if fdisk -l $i | grep --quiet "^$j"; then
                    rootvg+="$i "
                fi 
            done
        done
    elif [ -d /mnt/resource ];then
        azure_disk=`mount | grep "/mnt/resource" | cut -d' ' -f1`
        if [ ! -z "$azure_disk" ]; then
            for i in $all_disks; do
                if [[ "$azure_disk" == $i* ]]; then
                    rootvg+="$i "
                fi
            done
        fi
    fi
    # for virtualization get / mount point
    for j in `mount | grep " / " | cut -d' ' -f1`; do
        for i in $all_disks; do       
           if fdisk -l $i | grep --quiet "^$j"; then
              rootvg+="$i "
           fi 
        done
    done
    for i in $all_disks; do
        if ! $(echo $rootvg | grep --quiet "$i"); then
            echo $i
        fi
    done 
}
if [ $# -ne 1 ]; then
    echo -e "Usage:  \n\t$0 get_options\n\t$0 <hard_drive>"
    exit 1
fi
if [ $1 == "get_options" ]; then
    getHDDs
else
    getHDDdescr $1
fi
