#!/usr/bin/env bash
state=""
if [ -f /opt/Avaya/.ova ]; then
    state=`grep -ix "restrict 127.0.0.1 ignore" /etc/ntp.conf`
else
    state=`systemctl status ntpd | grep "dead"`
fi
if [ ! -z "$state" ]; then
    use_ntp="False"
else
    use_ntp="True"
fi
servers=`grep ^server /etc/ntp.conf | grep -v "127.127.1.0" | awk -F ' ' '{print $2}' | tr '\r\n' ' '`
if grep -q "^server 127.127.1.0"   /etc/ntp.conf ; then
    use_local_source="True"
    if [ ! -f /opt/Avaya/.ova ]; then
        if [ -z "$servers"  ]; then
            use_ntp="False"
        fi
    fi
else
    use_local_source="False"
fi
echo "use_ntp=$use_ntp"
echo "servers=$servers"
echo "use_local_source=$use_local_source"
