#!/usr/bin/perl

# Usage:    set_static_ipaddr.pl <intf> 
# Purpose:  Obtain network configuration for web control.
# Works on: list of parameters, see end of file for format.

use warnings;
use File::Copy;

sub trim($)
{
	my $string = shift;
	$string =~ s/^\s+//;
	$string =~ s/\s+$//;
	return $string;
}

$filename1 = "/etc/sysconfig/network-scripts/ifcfg-$ARGV[0]";

my($dhcp) = "use_dhcp=no";
my($ipaddr) = "ipaddr=";
my($netmask) = "netmask=";
my($peerdns) = "";
my($gateway) = "gateway=";
my($prefix) = "";

if (open(file1, $filename1))
{
    while($line = <file1>)
    {
        if ($line =~ /^\s*BOOTPROTO\s*=/)
        {
            if ($line =~ /^.*dhcp.*/)
            {
                $dhcp = "use_dhcp=yes";
            }
            else
            {
                $dhcp = "use_dhcp=no";
            }
        }
        elsif ($line =~ /^\s*IPADDR\s*=/)
        {
            $line = lc($line);
            $ipaddr = $line;
        }
        elsif ($line =~ /^\s*NETMASK\s*=/)
        {
            $line = lc($line);
            $netmask = $line;
        }
        elsif ($line =~ /^\s*PEERDNS\s*=/)
        {
            $line = lc($line);
            $peerdns = $line;
        }
        elsif ($line =~ /^\s*PREFIX\s*=/)
        {
            my($nrprefix) = $line =~ m/"*([0-9]*)"*$/;
            my($temp) = 0;
            my($count) = 32;

            for (;$nrprefix>0;$nrprefix--)
            {
                $temp = ($temp << 1) + 1;
                $count--;
            }
            $temp = $temp << $count;

            $netmask = sprintf("netmask=%d.%d.%d.%d", ($temp >> 24), ($temp >> 16)&0xFF, ($temp >> 8)&0xFF, ($temp)&0xFF);
        }
    }
}

if ($dhcp eq "use_dhcp=yes")
{
    $ipaddr = `LANGUAGE=en_US.UTF-8 ifconfig -a $ARGV[0] | grep -oE "inet [0-9\.]*" | cut -d" " -f2`;
    $ipaddr = "ipaddr=" . $ipaddr;
    $netmask = `LANGUAGE=en_US.UTF-8 ifconfig -a $ARGV[0] | grep -oE "netmask [0-9\.]*" | cut -d" " -f2`;
    $netmask = "netmask=" . $netmask;

    if ($peerdns eq "")
    {
        $peerdns = "peerdns=yes";
    }
}
else
{
    if ($peerdns eq "")
    {
        $peerdns = "peerdns=no";
    }
}

$gateway = "gateway=" . `route -n | grep eth0 | grep -oE "^0.0.0.0 *\([0-9\.]\)* *0.0.0.0" | xargs -i expr match {} "^0.0.0.0 *\\([0-9\.]*\\) *0.0.0.0"`;

print "name=" . $ARGV[0] . "\n";
print trim($dhcp) . "\n";
print trim($ipaddr) . "\n";
print trim($netmask) . "\n";
print trim($gateway) . "\n";
print trim($peerdns) . "\n";
