#!/bin/bash

output=/opt/Avaya/.resources.txt

# clean output
rm -f $output

# get RAM capacity
echo -n "RAM_MB=" >> $output
free -m | awk '/Mem/{print $2;}' >> $output

# get swap space
echo -n "SWAP_MB=" >> $output
free -m | awk '/Swap/{print $2;}' >> $output

# get number of cores
echo -n "CORES=" >> $output
nproc >> $output

# get number of threads per core
echo -n "THREADS_PER_CORE=" >> $output
lscpu | awk '/Thread/{print $NF;}' >> $output

# get CPU frequency
echo -n "CPU_GHZ=" >> $output
awk '/model name/{print $NF;}' /proc/cpuinfo | sort -u | sed "s:GHz::" >> $output

# get platform
echo -n "CPU_MODEL_NAME=" >> $output
awk -F': ' '/model name/{print $NF;}' /proc/cpuinfo | head -1 >> $output

# get HDD total size
echo -n "HDD_GB=" >> $output
df --total / --block-size=G | awk '/total/{print $2;}' | sed "s:G::" >> $output

# print operating system
echo -n "OS=" >> $output
cat /etc/*-release | grep -E "^[^Linux]" | head -1 >> $output

# get kernel version
echo -n "KERNEL_VERSION=" >> $output
uname -r >> $output

# check if virtual machine or not
echo -n "VIRTUAL_MACHINE=" >> $output
vm=`/usr/lib/ipoffice/isa_disk_vendor.sh`
vm=`grep "VMware" <<< $vm || grep "QEMU" <<< $vm || grep "VBOX" <<< $vm || grep "Virtual" <<< $vm`
if [ -z "$vm" ]; then
    vm=`imvirt`
fi
echo $vm >> $output

vm=`grep "[Vv][Mm][Ww]are" <<< $vm`
if [ -n "$vm" ]; then
    echo -n "VMWARE_VERSION=" >> $output
    vmware-toolbox-cmd -v >> $output
fi

chmod 444 $output
