#!/bin/bash

#Utilities for backup and restore operations on Mid-Market

br_path="/opt/Avaya/Backup_Restore"
br_vmproLocation="/opt/Avaya/Backup_Restore/VMProBackup"
bvmproScript="/opt/vmpro/vmprobackupscript.sh"
rvmproUtility="/opt/vmpro/VMProRestore"
oneXbackupLocation="/opt/Avaya/oneXportal/backups"
br_systemLocation="/opt/ipoffice/system/backup_appl/linux/br/"
restore_status="/opt/ipoffice/system/backup_appl/linux/metadata/restore.status"
br_metadata="/opt/ipoffice/system/backup_appl/linux/metadata/backup.mdata"
ipoffice_backupLocation="/opt/ipoffice/system/backup/"
ipoffice_primaryLocation="/opt/ipoffice/system/primary/"
brwarning_message=""
brinfoStatus="status"
brinfoLog="log"
root_path="/"
tmp_backuprestore_folder="/tmp/br_storage"

AuthModuleBackupFilesPath="/opt/Avaya/apache-tomcat/webapps/authmodule/authmodule"
EscapedAuthModuleBackupFilesPath="\/opt\/Avaya\/apache-tomcat\/webapps\/authmodule\/authmodule"

#status files - report the state of operation in WCP
#log files - keep a history events
backupLog="backupLog"
bStatusFile="backupStatus"
bmessageRcv="bmessageRcv"
restoreLog="restoreLog"
rStatusFile="restoreStatus"
rmessageRcv="rmessageRcv"
md5sumfile="md5sumfile"

#release files
release_version="0"
appl_rf="/opt/Avaya/APPL_release"
se_rf="/opt/Avaya/ABE_release"
apc_rf="/opt/Avaya/APC_release"

#other variables
archiveName="ABE_Backup.tar.gz"
tarExtractOptions="-p --same-owner --atime-preserve -C / -xvf"
tarExtractOptionsNoPathDefined="-p --same-owner --atime-preserve"
wantDirectoryTree=0
restartRequired=0
systemRestore=0
systemBackup=0
wildcard="*"

#backup-restore error codes
BR_ERRORCODE_UNKNOWN_OPERATION=1
BR_ERRORCODE_URL_EMPTY=2
BR_ERRORCODE_URL_WRONGFORMAT=3
BR_ERRORCODE_URL_PARSE=4
BR_ERRORCODE_URL_PORT_PARSE=5
BR_ERRORCODE_URL_IPADDRESS_EMPTY=6
BR_ERRORCODE_URL_PROTOCOL_EMPTY=7
BR_ERRORCODE_URL_PROTOCOL_NOTSUPPORTED=8
BR_ERRORCODE_LOCK_CANNOTREMOVE=9
BR_ERRORCODE_LOCK_TAKEN=10
BR_ERRORCODE_CREDENTIALS_MISMATCH=11
BR_ERRORCODE_USERPATH_NOTFOUND=12
BR_ERRORCODE_USERPATH_INVALID=13
BR_ERRORCODE_ACCESSDENIED=14
BR_ERRORCODE_FOLDER_DOESNOTEXIST=15
BR_ERRORCODE_FILE_DOESNOTEXIST=16
BR_ERRORCODE_FILE_FAILEDTOCOPY=17
BR_ERRORCODE_FILE_INVALIDSIZE=18
BR_ERRORCODE_ARCHIVE_FAILEDTOCREATE=19
BR_ERRORCODE_ARCHIVE_FAILEDTOUNPACK=20
BR_ERRORCODE_FAILURE_MSGRCV=21
BR_ERRORCODE_MD5SUM_MISMATCH=22
BR_ERRORCODE_FOLDER_FAILEDTOCREATE=23
BR_ERRORCODE_ARCHIVE_CANNOTAPPLY=24


#Parse url into urlPROTO|urlUSERACCOUNT|urlIPADRESS|urlPORT|urlAPATH
#Input  - operation[Backup/Restore]  url
#Output - urlPROTO|urlUSERACCOUNT|urlIPADRESS|urlPORT|urlAPATH
function parse_url () {

    #backup/restore logfile
    if [ "$1" == "Backup" ]; then
	logfile=$br_path/backupLog
        statusFile=$br_path/backupStatus
    elif [ "$1" == "Restore" ]; then
	logfile=$br_path/restoreLog
        statusFile=$br_path/restoreStatus
    else
        echo "Wrong $1 operation."
        exit $BR_ERRORCODE_UNKNOWN_OPERATION
    fi
    url=$2
    if [ -z "$url" ]; then
        echo "`date +%k:%M_%d-%m-%Y` Error-Parser: Empty URL received." >> $logfile
        echo "$1 failed. Empty URL received." > $statusFile
        remove_lock $1
        exit $BR_ERRORCODE_URL_EMPTY
    fi

    #Count ':' character in url string
    colonc="${url//[^:]/}"
    if [ -z "$colonc" ]; then
        echo "Error-Parser: Wrong url format. Colon character is missing." >> $logfile
        echo "$1 failed. Wrong url format. Colon character missing." > $statusFile
        remove_lock $1
        exit $BR_ERRORCODE_URL_WRONGFORMAT
    fi

    if [[ ! "$url" =~ "://" ]]; then
        echo "Error-Parser: Wrong url format." >> $logfile
        echo "$1 failed. Wrong url format." > $statusFile
        remove_lock $1
        exit $BR_ERRORCODE_URL_WRONGFORMAT
    fi

    #search for @ character in url string
    at_index="${url//[^@]/}"
    if [ "${#at_index}" -gt 1 ]; then
        echo "Error-Parser: Wrong url format - too many at characters." >> $logfile
        echo "$1 failed. Wrong url format - too many at characters." > $statusFile
        remove_lock $1
        exit $BR_ERRORCODE_URL_WRONGFORMAT
    fi

    colonAppearance="${#colonc}"
    #find first position in string of : char
    if [ "$colonAppearance" -ge 1 ]; then
        fposcolon="`expr index $url :`"
        if [ -z $fposcolon ]; then
                echo "Error-Parser: Failed to find  colon position." >> $logfile
                echo "$1 failed. Failed to find  colon position." > $statusFile
                remove_lock $1
                exit $BR_ERRORCODE_URL_PARSE
        fi
    fi

    #get URL protocol between position 0 and firstcolon of url string
    urlPROTO="${url:0:$fposcolon-1}"

    #all url unless urlPROTO+://
    tempurl="${url#*'://'}"

    #get the user account from url
    #find @ position in tempurl
    if [ "${#at_index}" -eq 1 ]; then
         fposat="`expr index $tempurl @`"
         if [ -z $fposat ]; then
                echo "Error-Parser: Failed to find at  position." >> $logfile
                echo "$1 failed. Failed to find at  position." > $statusFile
                remove_lock $1
                exit $BR_ERRORCODE_URL_PARSE
         fi

         urlUSERACCOUNT="${tempurl:0:$fposat-1}"
         
         #all url unless urlPROTO+://+urlUSERACCOUNT+@
         tempurl="${tempurl#*'@'}"
    fi

    urlPORT=""
    #get the URL ipaddress-port-path
    if [ "$colonAppearance" -ge 2 ]; then
        #get next position of colon in tempurl
        sposcolon="`expr index $tempurl :`"
        #get urlIPADDRESS
        urlIPADDRESS="${tempurl:0:$sposcolon-1}"
        tempurl1="${tempurl#*':'}"
        #validate urlPORT
        if [[ "$tempurl1" =~ ^[0-9]{1,5}\/*[a-zA-Z\/]*$ ]]; then
                ffpos="`expr index $tempurl1 /`"
                if [ "$ffpos" -ge 1 ]; then
                        urlPORT=`echo ${tempurl1:0:$ffpos-1}`
                elif [ "$ffpos" -eq 0 ]; then
                        urlPORT=`echo ${tempurl1:0:${#tempurl1}}`
                        #default remote home directory 
                        urlPATH=":"
                else
                        echo "Error-Parser: Failed to parse url port." >> $logfile
                        echo "$1 failed. Failed to parse url port." > $statusFile
                        remove_lock $1
                        exit $BR_ERRORCODE_URL_PORT_PARSE
                fi
        else
                echo "Error-Parser: Unexpected format found. Failed to parse url <$url>." >> $logfile
                echo "$1 failed. Unexpected format found. Failed to parse url <$url>." > $statusFile
                remove_lock $1
                exit $BR_ERRORCODE_URL_WRONGFORMAT
        fi
        #get url PATH
        if [ ! -z "$urlPORT" -a "$ffpos" -ne 0 ]; then
                endpos=`expr ${#tempurl1}-${#ffpos}`
                urlPATH="${tempurl1:$ffpos-1:$endpos}"
                if [ "$urlPATH" == "/" ]; then
                      urlPATH=":"
                fi
        fi
    fi

    #if no urlPORT was found, get the urlPATH
    if [ -z "$urlPORT" ]; then
        if [ "$urlPROTO" != "file" -a "$urlPROTO" != "FILE" ]; then
                ffpos="`expr index $tempurl /`"
                if [ "$ffpos" -ge 1 ]; then
                        urlIPADDRESS="`echo ${tempurl:0:$ffpos-1}`"
                        urlPATH="${tempurl#*'/'}"
                        if [ -z "$urlPATH" ]; then
                                urlPATH=":"
                        else
                                urlPATH="/$urlPATH"
                        fi
                fi
                if [ "$ffpos" -eq 0 -a ${#tempurl} -ge 1 ]; then
                        urlIPADDRESS="$tempurl"
                        urlPATH=":"
                fi
        else
                #local path
                urlIPADDRESS=""
                urlPATH="/$tempurl"
                fchar=${urlPATH:0:1}
                schar=${urlPATH:1:1}
                if [ "$fchar" == "$schar" -a "$fchar" == "/" ]; then
                      urlPATH=${urlPATH:1:${#urlPATH}}
                fi
        fi
    fi
    
    #save url parameters to file
    echo "urlPROTO=$urlPROTO" > $br_path/parse.ini
    echo "urlUSERACCOUNT=$urlUSERACCOUNT" >>  $br_path/parse.ini
    echo "urlIPADDRESS=$urlIPADDRESS" >> $br_path/parse.ini
    echo "urlPORT=$urlPORT" >> $br_path/parse.ini
    echo "urlPATH=$urlPATH" >> $br_path/parse.ini
}

#remove lock file for Primary Server operation
function remove_lock () {
    
    oper=$1
    if [ "$oper" == "Backup" ]; then
         logfile=$br_path/backupLog
         rm -f $br_path/ipol_backup_restore.lock
         if (($? != 0)); then
           echo "Error-Parser: Remove backup lock file." >> $logfile
           exit $BR_ERRORCODE_LOCK_CANNOTREMOVE
         fi
    elif [ "$oper" == "Restore" ]; then
         logfile=$br_path/restoreLog
         rm -f $br_path/ipol_backup_restore.lock
         if (($? != 0)); then
           echo "Error-Parser: Remove restore lock file." >> $logfile
           exit $BR_ERRORCODE_LOCK_CANNOTREMOVE
         fi
    else
         echo "Error-Parser: Operation not supported. Remove lock failed."
         exit $BR_ERRORCODE_UNKNOWN_OPERATION
    fi
}

#set an warning messasge
# first argument  - warning message
# second argument - log file operation
function set_warning () {

    if [[ ! "$brwarning_message" =~ "$1"  ]]; then
        brwarning_message="$brwarning_message$1"
        echo "`date +%k:%M_%d-%m-%Y` set_warning: "$brwarning_message"" >> $2
    fi
}

#check for specific error message
# first argument  - message received attempting to copy files to remote host
# second argument - log file operation
function check_KeyVerificationFailed () {
    
    messageRcvd=`head $1`
    if [ -n "$messageRcvd" ]; then
          if [[ "$messageRcvd" =~ "Host key verification" ]]; then
                 set_warning "$messageRcvd" "$2"
          fi
    fi
}

#logging events to status/log file
# first  argument - type message
# second argument - event message
# third  argument - file to log to
function br_LogEvent () {
    
    info=$1
    if [ "$info" == "status" ]; then
         echo "$2 $brwarning_message" > "$3"
    elif [ "$info" == "log" ]; then
         echo "`date +%k:%M_%d-%m-%Y` $2" >> "$3"
    fi       
}

#get version from Avaya release file
#input version format PRODUCT_VERSION=A.B.C\(D_xyz\);
#output version format A.B.C-D
function br_getVersionFromReleaseFile ()
{
    if [ ! -z $1 -a -f $1 ]; then
             if [ "$1" == "$appl_rf" -o "$1" == "$se_rf" ]; then
                  rel_type="ABE"
             elif [ "$1" == "$apc_rf" ]; then
                  rel_type="APC"
             fi
             version=`cat $1 | grep $rel_type | cut -d'=' -f2 | cut -d';' -f1`
             underscore_pos="`expr index $version _`"
             version=${version:0:$underscore_pos-1}
             backslash_pos="`expr index $version '\\'`"
             version_majorminorrev=${version:0:$backslash_pos - 1}
             version_buildnr=${version:$backslash_pos + 1:$underscore_pos}
             release_version="$version_majorminorrev-$version_buildnr"
    fi
}
