#!/usr/bin/python
#
#login to remote server via ssh and get backup archive file
#

import pexpect
import os,sys,re,string

# This is a constant describing how much should pexpect wait for output from a command
SPAWN_TIMEOUT = 35

# Define an error Backup/Restore dictionary
br_EMSG = { 1:'Not enough rights. Permission denied.',
            2:'Connection timed out.',
            3:'Timeout occurred in transfer files.',
            4:'Username/Password may be incorrect!',
            5:'No such file or directory.',
            6:'No route to host.',
            7:'Host key verification not passed.',
            8:'Unknown server type.',
            9:'Unknown error.'}

# Pattern lists expected
PATTERN_LIST_1 = ['IP Office for Linux','Avaya Business Edition','Avaya Office','Avaya IP Office','Avaya','~]',']','#','Permission denied, please try again.','Permission denied','No such file or directory']
PATTERN_LIST_2 = ['password:','Are you sure you want to continue connecting (yes/no)?','No route to host','Host key verification failed.']
PATTERN_LIST_3 = ['Permission denied','No such file or directory']

# Error location(figure out the location of error raised in debugging mode. E.g.: exitWithError(2,DBG_FUNC_1))
DBG_FUNC_1 = "Login Error:"
DBG_FUNC_2 = "Run_Cmd Error:"
DBG_FUNC_3 = "Check_CT Error:"
DBG_FUNC_4 = "Check_Ex Error: "

pe_pol_logfile='/opt/Avaya/Backup_Restore/ipol_copy_logfile.txt'
br_KEYPATTERN= {1:'Offending key in',2:':'}

clishtype = 0
clishfound = 0
failedkey = 0

#return id and path of the key that should be remove from known_hosts file
def get_KeyId(filename):
    idval = None
    idpath = None
    if os.path.exists(filename):
       lines = open (filename,'r')
       for line in lines:
           mobj = re.match(br_KEYPATTERN[1],line)
           if mobj != None:
              listline = string.split(line)
              for s in listline:
                 startidx = string.find(s,br_KEYPATTERN[2])
                 if startidx > 0:
                    idval  = s[startidx+1:len(s)]
                    idpath = s[0:startidx]
       lines.close()
    return (idval,idpath)

#remove a file
def remove_brfile(filename):
    if os.path.exists(filename):
       os.remove(filename)

# Error message is catched by the caller script(backup/restore)
def exitWithError(errorid, func=""):
    if errorid == 0:
       errorid = 8
    print "%s" %(func+br_EMSG[errorid])
    remove_brfile(pe_ipol_logfile)
    sys.exit(errorid)

def checkClishType(child):
    global clishtype, clishfound
    if clishtype == 0 and clishfound == 0:
       ret = child.expect_exact(PATTERN_LIST_1)
       if ret in (0,1,2,3,4):
          #print "This is a Avaya Office machine."
          child.sendline('exit')
          clishtype = 1
          clishfound = 1
       elif ret in (5,6,7):
          #print "This is a common Linux machine."
          clishfound = 1
          pass
       elif ret == 8:
          exitWithError(4)
       elif ret == 9:
          exitWithError(1)
       elif ret ==10:
          exitWithError(5)
       else:
          exitWithError(8)

def login(ichild,upass,eof):
    global failedkey
    try:
       ret = ichild.expect_exact(PATTERN_LIST_2)
       #ichild.logfile = sys.stdout
       if ret == 0:
          ichild.sendline(upass)
          if eof == 'EoF':
             ichild.sendeof()
          #check for clish type
          checkClishType(ichild)
       elif ret == 1:
          ichild.sendline('yes')
          ret = ichild.expect('password:')
          if ret == 0:
             ichild.sendline(upass)
             if eof == 'EoF':
                ichild.sendeof()
             #check for clish type
             checkClishType(ichild)
       elif ret == 2:
          exitWithError(6)
       elif ret == 3:
          #need to remove the old key stored in .ssh/known_hosts file
          failedkey = failedkey + 1
          if failedkey == 1:
             (key_id,key_path) = get_KeyId(pe_ipol_logfile)
             if key_id != None:
                sarg = 'sudo sed -i ' + key_id + 'd ' + key_path
                os.system(sarg)
                print " Warning-%s Remote host key was changed!" %(br_EMSG[7])
             else:
                exitWithError(7)
          elif failedkey > 1:
             pass
       else:
          exitWithError(9)
    except pexpect.EOF:
       #print "Login - EOF found"
       pass
    except pexpect.TIMEOUT:
       exitWithError(2)

def run_cmd(ichild,evar,svar,fvar):
    ichild.sendline(svar)
    try:
        index = ichild.expect([evar, ' '])
    except pexpect.EOF:
        #print "Run_Cmd - EOF found"
        pass
    except pexpect.TIMEOUT:
        exitWithError(2)
    if fvar == 'exit':
       ichild.sendline(fvar)

def checkException(ichild):
    try:
       ret = ichild.expect_exact(PATTERN_LIST_3)
       if ret == 0:
          exitWithError(1)
       elif ret == 1:
          exitWithError(5)
    except pexpect.EOF:
       #print "Run_Cmd - EOF found"
       pass
    except pexpect.TIMEOUT:
       exitWithError(3)

if len(sys.argv) == 8:
    #print "[%s] [%s] [%s] [%s] [%s] [%s] [%s] [%s]" %(sys.argv[0], sys.argv[1], sys.argv[2], sys.argv[3], sys.argv[4], sys.argv[5], sys.argv[6], sys.argv[7])
    if sys.argv[7] == "Backup":
        """
        #name of the script file  - argv[0]
        #first filename           - argv[1]
        #second filename          - argv[2]
        #username                 - argv[3]
        #passwd                   - argv[4]
        #server ip address        - argv[5]
        #absolut path             - argv[6]
        #operation Backup/Restore - argv[7]
        """

        #Figure out the server type
        cmdLine = "ssh %s@%s" %(sys.argv[3],sys.argv[5])
        fout = file(pe_ipol_logfile,'w')
        pchild  = pexpect.spawn(cmdLine, timeout=SPAWN_TIMEOUT, logfile=fout)
        login(pchild,sys.argv[4],'')
        run_cmd(pchild,'# ','','exit')
        fout.close()
        
        if failedkey == 1:
           cmdLine = "ssh %s@%s" %(sys.argv[3],sys.argv[5])
           pchild  = pexpect.spawn(cmdLine, timeout=SPAWN_TIMEOUT)
           login(pchild,sys.argv[4],'')
           run_cmd(pchild,'# ','','exit')

        #copy files to remote server
        if sys.argv[6][0] ==":":
            sys.argv[6] = ""
        cmdLine = "scp -oPubKeyAuthentication=no %s %s  %s@%s:%s" % (sys.argv[1], sys.argv[2], sys.argv[3], sys.argv[5], sys.argv[6])
        pchild  = pexpect.spawn(cmdLine, timeout=SPAWN_TIMEOUT)
        login(pchild,sys.argv[4],'EoF')

        checkException(pchild)

        #verify that computed md5 is the same with the sent one
        if clishtype == 1:
            optstr='7375646f207375202d'
            cmdLine = "ssh -oPubKeyAuthentication=no %s@%s %s" % (sys.argv[3], sys.argv[5], optstr.decode('hex'))
        else:
            cmdLine = "ssh -oPubKeyAuthentication=no %s@%s" % (sys.argv[3], sys.argv[5])
        pchild = pexpect.spawn(cmdLine, timeout=SPAWN_TIMEOUT)
        login(pchild,sys.argv[4],'')        

        if sys.argv[6] == "":
            sarg = "cd ~%s" % sys.argv[3]
        else:
            sarg = "cd %s" % sys.argv[6]
        run_cmd(pchild,'#',sarg,'')
        sarg = "if [ -f ./md5sumfile -a -f ./ABE_Backup_tmp.tar.gz ]; then \
                     md5read=`cat md5sumfile`; \
                     md5comp=`md5sum ABE_Backup_tmp.tar.gz | awk '{ print $1 }'`; \
                     if [ \"$md5read\"==\"$md5comp\" ]; then \
                          mv -f ABE_Backup_tmp.tar.gz ABE_Backup.tar.gz; \
                          echo Backup succeeded > ./backupStatus; \
                     else \
                          echo Backup failed > ./backupStatus; \
                     fi; \
                else \
                     echo Backup transfer failed > ./backupStatus; \
                fi;"
        run_cmd(pchild,'# ',sarg,'exit')
        remove_brfile(pe_ipol_logfile)

    if  sys.argv[7] == "Restore":
        """
        #name of the script file  - argv[0]
        #username                 - argv[1]
        #passwd                   - argv[2]
        #server ip address        - argv[3]
        #first filename           - argv[4]
        #second filename          - argv[5]
        #absolut path             - argv[6]
        #operation Backup/Restore - argv[7]
        """
        #copy file from remote to local
        if sys.argv[4][0] == ":" or sys.argv[5][0] == ":":
           ffilepath = '~' + sys.argv[1] + sys.argv[4][1:]
           sfilepath = '~' + sys.argv[1] + sys.argv[5][1:]
        else:
           ffilepath = sys.argv[4]
           sfilepath = sys.argv[5]
        cmdLine = "scp -oPubKeyAuthentication=no %s@%s:{%s,%s} %s" % (sys.argv[1], sys.argv[3], ffilepath, sfilepath, sys.argv[6])
        pchild = pexpect.spawn(cmdLine, timeout=SPAWN_TIMEOUT)
        login(pchild,sys.argv[2],'EoF')
        checkException(pchild)
        remove_brfile(pe_ipol_logfile)

elif len(sys.argv) == 7  and  sys.argv[5] == ".":
    """
    #name of the script file  - argv[0]
    #username                 - argv[1]
    #passwd                   - argv[2]
    #server ip address        - argv[3]
    #absolut filepath         - argv[4]
    #remote  path             - argv[5]
    #operation Backup/Restore - argv[6]
    """
    #print "[%s] [%s] [%s] [%s] [%s] [%s] [%s]" % (sys.argv[0], sys.argv[1], sys.argv[2], sys.argv[3], sys.argv[4], sys.argv[5], sys.argv[6])
    #Figure out the server type
    if sys.argv[6] == "Restore":
       cmdLine = "ssh %s@%s" %(sys.argv[1],sys.argv[3])
       fout = file(pe_ipol_logfile,'w')
       pchild  = pexpect.spawn(cmdLine, timeout=SPAWN_TIMEOUT, logfile=fout)
       login(pchild,sys.argv[2],'EoF')
       run_cmd(pchild,'# ','','exit')
       fout.close()

       if failedkey == 1:
          cmdLine = "ssh %s@%s" %(sys.argv[1],sys.argv[3])
          pchild  = pexpect.spawn(cmdLine, timeout=SPAWN_TIMEOUT)
          login(pchild,sys.argv[2],'EoF')
          run_cmd(pchild,'# ','','exit')  

    if sys.argv[4][0] ==":":
       filepath = '~' + sys.argv[1] + sys.argv[4][1:]
    else:
       filepath = sys.argv[4]
    cmdLine = "scp -oPubKeyAuthentication=no %s@%s:%s %s" % (sys.argv[1], sys.argv[3], filepath, sys.argv[5])
    pchild = pexpect.spawn(cmdLine, timeout=SPAWN_TIMEOUT)
    login(pchild,sys.argv[2],'EoF')
    checkException(pchild)
    remove_brfile(pe_ipol_logfile)

else:
    print "For upload please use   :<fullpath filename1> <fullpath filename2> <username> <password> <server ipaddress> <remote path> <operation>"
    print "For download please use :<username> <password> <server ipaddress> <local location/file name> <remote path> <operation>"
