#!/bin/sh

lockfile=/var/lock/ipo_nat.LOCK
IPTABLES_BINARY=/sbin/iptables

# checks the existence of the SNAT and DNAT
# specific chains (this is done for the purpose
# of not adding an existing chain all over again
# in the chains list)
# example for Service0 interface a Service0_SNAT
# and Service0_DNAT chain have to exist

check_chains()
{
    IPTBL_NAT="`"$IPTABLES_BINARY" -n -t nat -L`"
    saveIFS=$IFS
    IFS=$'\n'
    IPTBL_NATARRAY=($IPTBL_NAT)
    IFS=$saveIFS

    CHAIN=""
    PRE_CHAIN_FOUND=no
    POST_CHAIN_FOUND=no
    for i in "${IPTBL_NATARRAY[@]}"
    do
        if [[ "$i" == *PREROUTING* ]]; then
            CHAIN="PREROUTING"
        elif [[ "$i" == *POSTROUTING* ]]; then
            CHAIN="POSTROUTING"
        elif [[ "$i" == *Chain* ]]; then
            CHAIN=""
        fi
        if [ "$CHAIN" == "PREROUTING" ]; then
            NATCHAIN="$SERVICE""_DNAT"
            if echo "$i" | grep -q "$NATCHAIN"; then
                PRE_CHAIN_FOUND=yes
            fi
        elif [ "$CHAIN" == "POSTROUTING" ]; then
            NATCHAIN="$SERVICE""_SNAT"
            if echo "$i" | grep -q "$NATCHAIN"; then
                POST_CHAIN_FOUND=yes
            fi
        fi
    done
}

# this will extract the iptables rules parameters
# from the file given to the script
extract_rule_params()
{
    RULE=$( echo "$1" | tr " " " " )
    INDX=0
    for i in $RULE
    do
        IPTBLRULE[$INDX]="$i"
        ((INDX++))
    done
    if [ "$INDX" == "5" ]; then
        RULES_OK=yes
        SERVICE="${IPTBLRULE[0]}"
        PROTOCOL="${IPTBLRULE[1]}"
        EXT_PORT="${IPTBLRULE[2]}"
        IPADDR="${IPTBLRULE[3]}"
        INT_PORT="${IPTBLRULE[4]}"
    fi
}

(
    # wait for 20s to aquire lock
    # else fail
    # 20 seconds is more than enough
    # for this script to finish what it is doing...
    PROCEED="no"
    SYNCRON="$1"
    COMMAND="$2"
    if [ "$COMMAND" == "add" ]; then
        RULESFILE="$3"
    elif [ "$COMMAND" == "remove" ]; then
        SERVICE="$3"
    fi
    if [ "$SYNCRON" == "async" ] ;then
        if flock -x -w 20 200; then
            PROCEED="yes"
        else
            # could not obtain lock?
            DATE="`date`"
            HOST="`hostname`"
            APPL="ipoffice"
            ERRSTR="$DATE $HOST $APP"" - ERROR - could not obtain napt lock"
            echo "$ERRSTR" >> /var/log/messages
            PROCEED="no"
        fi
    elif [ "$SYNCRON" == "sync" ] ;then
        PROCEED="yes"
    fi
    if [ "$PROCEED" == "yes" ]; then
        # do our stuff
 
        if [ "$COMMAND" == "add" ]; then
            MASQUERADE_MODULE="`lsmod | grep ipt_MASQUERADE`"
            NFCONNTRACK_MODULE="`lsmod | grep nf_conntrack`"
            if [ -z "$MASQUERADE_MODULE" ]; then
                # try to load masquerade
                modprobe ipt_MASQUERADE
            fi
            if [ -z "$NFCONNTRACK_MODULE" ]; then
                # try to load nf_conntrack
                modprobe nf_conntrack
            fi
        fi
 
        if [ "$COMMAND" == "remove" ]; then
            check_chains
            while [ "$PRE_CHAIN_FOUND" == "yes" -o "$POST_CHAIN_FOUND" == "yes" ]; do
                if [ "$PRE_CHAIN_FOUND" == "yes" ]; then
                    NATCHAIN="$SERVICE""_DNAT"
                    "$IPTABLES_BINARY" -t nat -D PREROUTING -j "$NATCHAIN"
                    "$IPTABLES_BINARY" -t nat -F "$NATCHAIN"
                    "$IPTABLES_BINARY" -t nat -X "$NATCHAIN"
                fi
                if [ "$POST_CHAIN_FOUND" == "yes" ]; then
                    NATCHAIN="$SERVICE""_SNAT"
                    "$IPTABLES_BINARY" -t nat -D POSTROUTING -j "$NATCHAIN"
                    "$IPTABLES_BINARY" -t nat -F "$NATCHAIN"
                    "$IPTABLES_BINARY" -t nat -X "$NATCHAIN"
                fi
                check_chains
            done
        elif [ "$COMMAND" == "add" ]; then
            # construct DNAT chain
            if [ -f $RULESFILE ]; then
                PRE_CHAIN_EXISTS=no
                POST_CHAIN_EXISTS=no
                SERVICE_NAME=""
                while read line         
                do         
                    RULES_OK=no
                    extract_rule_params "$line"
                    if [ "$RULES_OK" == "yes" ]; then

                        # more general check of chains
                        if [ -z "$SERVICE_NAME" ]; then
                            SERVICE_NAME="$SERVICE"
                        fi
                        if [ "$PRE_CHAIN_EXISTS" == "no" -o "$POST_CHAIN_EXISTS" == "no" ]; then
                            check_chains
                            PRE_CHAIN_EXISTS="$PRE_CHAIN_FOUND"
                            POST_CHAIN_EXISTS="$POST_CHAIN_FOUND"
                        elif [ "$SERVICE_NAME" != "$SERVICE" ]; then
                            check_chains
                            PRE_CHAIN_EXISTS="$PRE_CHAIN_FOUND"
                            POST_CHAIN_EXISTS="$POST_CHAIN_FOUND"
                            SERVICE_NAME="$SERVICE"
                        fi
                        
                        # construct DNAT chain
                        DNAT_CHAIN="$SERVICE""_DNAT"
                        if [ "$PRE_CHAIN_EXISTS" == "yes" ]; then
                            "$IPTABLES_BINARY" -t nat -A "$DNAT_CHAIN" -p "$PROTOCOL" --dport "$EXT_PORT" -i "$SERVICE" -j DNAT --to "$IPADDR":"$INT_PORT"
                        else
                            "$IPTABLES_BINARY" -t nat -N "$DNAT_CHAIN"
                            "$IPTABLES_BINARY" -t nat -A "$DNAT_CHAIN" -p "$PROTOCOL" --dport "$EXT_PORT" -i "$SERVICE" -j DNAT --to "$IPADDR":"$INT_PORT"
                            "$IPTABLES_BINARY" -t nat -A PREROUTING -j "$DNAT_CHAIN"
                        fi
                        
                         # construct SNAT chain
                         SNAT_CHAIN="$SERVICE""_SNAT"
                         if [ "$POST_CHAIN_EXISTS" == "yes" ]; then
                             "$IPTABLES_BINARY" -t nat -A "$SNAT_CHAIN" -p "$PROTOCOL" -d "$IPADDR" --dport "$INT_PORT" -j MASQUERADE
                         else
                             "$IPTABLES_BINARY" -t nat -N "$SNAT_CHAIN"
                             "$IPTABLES_BINARY" -t nat -A "$SNAT_CHAIN" -p "$PROTOCOL" -d "$IPADDR" --dport "$INT_PORT" -j MASQUERADE
                             "$IPTABLES_BINARY" -t nat -A POSTROUTING -j "$SNAT_CHAIN"
                         fi
                    fi
                done < $RULESFILE
                rm -f $RULESFILE
            fi
        fi
    fi
) 200>$lockfile

