#!/usr/bin/python
# -*- coding: utf-8 -*-

import sys
from snack import *
import os
import sys
import locale
import codecs
import fnmatch
import gettext
import system_config_keyboard.keyboard as keyboard
from locale import setlocale, LC_ALL

# get system language
language=os.environ.get('LANG');
if language == None or language == "C":
    language="en_US.UTF-8"

# encode strings
def _( var ):
    if not (var is None):
        return (var).encode('utf-8', 'replace')
    else:
        return "None"

# translate strings
def _t( var ):
    if var == "Change Keyboard ":
        if language == "en_US.UTF-8" :
            return unicode("Change Keyboard",         'utf-8')
        elif language == "fr_FR.UTF-8":
            return unicode("Modifier le clavier",         'utf-8')
        elif language == "de_DE.UTF-8":
            return unicode("Tastaturlayout ändern",         'utf-8')
        elif language == "zh_CN.UTF-8":
            return unicode("Change Keyboard",         'utf-8')
        elif language == "pt_BR.UTF-8":
            return unicode("Alterar teclado",         'utf-8')
        elif language == "ru_RU.UTF-8":
            return unicode("Изменение раскладки клавиатуры",         'utf-8')
        elif language == "es_ES.UTF-8":
            return unicode("Cambiar teclado",         'utf-8')
        elif language == "it_IT.UTF-8":
            return unicode("Modifica tastiera",         'utf-8')
        elif language == "nl_NL.UTF-8":
            return unicode("Toetsenbord wijzigen",         'utf-8')
	else:
            return unicode("Change Keyboard",         'utf-8')
    if var == "OK":
        if language == "es_ES.UTF-8":
            return unicode("Aceptar",         'utf-8')
        else:
            return unicode("OK",         'utf-8')

# create screen
screen = SnackScreen()

# get keyboards types from system-config-keyboard
kbd = keyboard.Keyboard()
kbd.read()
kbdDict = kbd.modelDict
        
kbdKeys = kbdDict.keys()
kbdKeys.sort()

# configure button
button = ButtonBar(screen, [_(_t("OK"))])
l = Listbox(8, scroll = 1, returnExit = 0)
key = 0
default = ""
# populate list
for k in kbdKeys:
	if k == kbd.get():
		default = k

	name = kbdDict[k][0]
	l.append(name, k)
	key = key + 1

try:
	l.setCurrent(default)
except:
	pass

# create form
g = GridFormHelp(screen, _(_t("Change Keyboard ")), None, 1, 7)
g.add(l, 0, 3, padding = (0, 0, 0, 1))
g.add(button, 0, 5, padding = (0,0,0,0))

# erase default bottom line with some useless help commands
screen.pushHelpLine(' ');
g.run()
screen.popWindow()
screen.finish()

# apply changes
choice = l.current()
kbd.set(choice)
kbdData = kbdDict[choice]
kbd.write()
kbd.activate()

