#!/usr/bin/python
# -*- coding: utf-8 -*-

import sys

from snack import *
import os
import sys
import locale
import codecs
import fnmatch

from locale import setlocale, LC_ALL

import gettext

# Encode string for output on screen
def _( var ):
    # utf-8 for now until someone complains
    if not (var is None):
        return (var).encode('utf-8', 'replace')
    else:
        return "None"



language=os.environ.get('LANG');
if language == None or language == "C":
    language="en_US.UTF-8"

def checked( var ):
    if language == var:
        return 1
    else:
        return 0

# Quick hack to avoid gettext/packaging of mo files/... since we only have two strings.
english=   unicode("English",         'utf-8')
french    =unicode("Français",        'utf-8')
german    =unicode("Deutsch",         'utf-8')
chinese   =unicode("Chinese",             'utf-8')
portuguese=unicode("Português",       'utf-8')
russian=   unicode("Русский",         'utf-8')
spanish=   unicode("Español",         'utf-8')
italian=   unicode("Italiano",        'utf-8')
nederland= unicode("Nederlands",      'utf-8')

def _t( var ):
    if var == "Language select":
        if language == "en_US.UTF-8":
            return unicode("Language select",         'utf-8')
        elif language == "fr_FR.UTF-8":
            return unicode("Sélection de la langue",         'utf-8')
        elif language == "de_DE.UTF-8":
            return unicode("Sprache wählen",         'utf-8')
        elif language == "zh_CN.UTF-8":
            return unicode("Language select",         'utf-8')
        elif language == "pt_BR.UTF-8":
            return unicode("Seleção de idioma",         'utf-8')
        elif language == "ru_RU.UTF-8":
            return unicode("Выбор языка",         'utf-8')
        elif language == "es_ES.UTF-8":
            return unicode("Selección de idioma",         'utf-8')
        elif language == "it_IT.UTF-8":
            return unicode("Selezione lingua",         'utf-8')
        elif language == "nl_NL.UTF-8":
            return unicode("Taalkeuze",         'utf-8')
    if var == "Choose a Language":
        if language == "en_US.UTF-8":
            return unicode("Choose a Language",         'utf-8')
        elif language == "fr_FR.UTF-8":
            return unicode("Choisir une langue",         'utf-8')
        elif language == "de_DE.UTF-8":
            return unicode("Wählen Sie eine Sprache aus",         'utf-8')
        elif language == "zh_CN.UTF-8":
            return unicode("Choose a Language",         'utf-8')
        elif language == "pt_BR.UTF-8":
            return unicode("Escolha um idioma:",         'utf-8')
        elif language == "ru_RU.UTF-8":
            return unicode("Выберите язык:",         'utf-8')
        elif language == "es_ES.UTF-8":
            return unicode("Elija un idioma",         'utf-8')
        elif language == "it_IT.UTF-8":
            return unicode("Selezione della lingua",         'utf-8')
        elif language == "nl_NL.UTF-8":
            return unicode("Kies een taal",         'utf-8')
    if var == "OK":
        if language == "es_ES.UTF-8":
            return unicode("Aceptar",         'utf-8')
        else:
            return unicode("OK",         'utf-8')

screen = SnackScreen()

grid = GridFormHelp(screen,_(_t("Language select")), None , 1, 7)
t = TextboxReflowed(53, _(_t("Choose a Language")))
grid.add(t, 0, 0, padding = (0, 0, 0, 1))


buttonList=[]
buttonList.append([_(english), "en_US.UTF-8", checked("en_US.UTF-8")])
buttonList.append([_(french), "fr_FR.UTF-8", checked("fr_FR.UTF-8")])
buttonList.append([_(german), "de_DE.UTF-8", checked("de_DE.UTF-8")])
buttonList.append([_(portuguese), "pt_BR.UTF-8", checked("pt_BR.UTF-8")])
buttonList.append([_(russian), "ru_RU.UTF-8", checked("ru_RU.UTF-8")])
buttonList.append([_(spanish),  "es_ES.UTF-8", checked("es_ES.UTF-8")])
buttonList.append([_(italian),  "it_IT.UTF-8", checked("it_IT.UTF-8")])
buttonList.append([_(nederland),  "nl_NL.UTF-8", checked("nl_NL.UTF-8")])
buttonList.append([_(chinese),  "zh_CN.UTF-8", checked("zh_CN.UTF-8")])

radioButtonGrid = RadioBar(screen, buttonList)
grid.add(radioButtonGrid, 0, 3, padding = (0,0,0,1))
button = ButtonBar(screen, [ _(_t("OK")) ] )
grid.add(button, 0, 5, padding = (0,0,0,0))
# erase untranslated default bottom line 
screen.pushHelpLine(' ');
grid.run()
screen.popWindow()
screen.finish()

LANG=radioButtonGrid.getSelection()

f = open("/etc/sysconfig/i18n")

newtext = ""
for line in f:
    if 'LANG=' in line:
        newtext = newtext + 'LANG="' + LANG + '"\n'
    #IPOFFICE-37918 Chinese is not supported in TEXT mode
    #this will fix TEXT mode for all terminals except tty1(used by Avaya CLI)
    elif 'LANGUAGE=' in line:
	if LANG == 'zh_CN.UTF-8':
		newtext = newtext + 'LANGUAGE="en_US.UTF-8"\n'
	else:
        	newtext = newtext + 'LANGUAGE="' + LANG + '"\n'
    elif line != '\n':
        newtext = newtext + line + "\n"
        
f.close()
f = open("/etc/sysconfig/i18n", "w")

f.write(newtext)
