#!/bin/sh
BACKUP_TYPE=$1

. /opt/Avaya/scripts/config_files/apps_logging_config

SYSTEM_DIAGNOSTIC_BACKUP_DIR="/opt/ipoffice/system/logs"
TCPDUMP_BASE_DIR="/opt/Avaya/logs/tcpdump_pkgs"
TCPDUMP_BASE_FILENAME=$TCPDUMP_BASE_DIR"/tcpdump_capture"
TCPDUMP_BASE_PID_FILENAME="/opt/Avaya/.tcpdump_pid"
TCPDUMP_TIMESTAMP_FILE=$TCPDUMP_BASE_DIR"/tcpdumpLastTimeStamp"

# Remove system logs content folder
if [ "$BACKUP_TYPE" == "auto" ]; then
   rm -rf ${SYSTEM_DIAGNOSTIC_BACKUP_DIR}/webmanagement_logs*.tar.gz
   rm -rf ${SYSTEM_DIAGNOSTIC_BACKUP_DIR}/system_logs*.tar.gz
   rm -rf ${SYSTEM_DIAGNOSTIC_BACKUP_DIR}/install_logs*.tar.gz
   rm -rf ${SYSTEM_DIAGNOSTIC_BACKUP_DIR}/webcontrol_logs*.tar.gz
   rm -rf ${SYSTEM_DIAGNOSTIC_BACKUP_DIR}/voicemail_logs*.tar.gz
   rm -rf ${SYSTEM_DIAGNOSTIC_BACKUP_DIR}/ipoffice_logs*.tar.gz
   rm -rf ${SYSTEM_DIAGNOSTIC_BACKUP_DIR}/onex_logs*.tar.gz
   rm -rf ${SYSTEM_DIAGNOSTIC_BACKUP_DIR}/openfire_logs*.tar.gz	
   rm -rf ${SYSTEM_DIAGNOSTIC_BACKUP_DIR}/sysmon_logs*.tar.gz
   rm -rf ${SYSTEM_DIAGNOSTIC_BACKUP_DIR}/mediamanager_logs*.tar.gz	
   rm -rf ${SYSTEM_DIAGNOSTIC_BACKUP_DIR}/WebRTCGateway_logs*.tar.gz
   rm -rf ${SYSTEM_DIAGNOSTIC_BACKUP_DIR}/upgrade_logs*.tar.gz
fi 

#if the tcpdump is stopped when the archiving started get the timestamp of stop time
#else get current time as timestamp

if [ -f $TCPDUMP_TIMESTAMP_FILE ]; then 
    timestamp=$(<$TCPDUMP_TIMESTAMP_FILE)
else
    if [ "$BACKUP_TYPE" == "auto" ]; then
        timestamp=`date +%Y%m%d_%H%M%S`
    else
        timestamp=`date +%F-%H-%M`
    fi
fi

rm -rf /tmp/avayatmp/
mkdir -p /tmp/avayatmp/
log_archives_dir=/tmp/avayatmp/
apache_home=/opt/Avaya/apache-tomcat
noSEC=$1

#
#tcpdump
#

if [ -d $TCPDUMP_BASE_DIR ]; then
    #pause process if running
    if [ -f $TCPDUMP_BASE_PID_FILENAME ]; then
        TCPDUMP_PID=$(<$TCPDUMP_BASE_PID_FILENAME)
        if [ -n "$TCPDUMP_PID" ]; then
            pkill -STOP $TCPDUMP_PID
        fi
    fi

    tcpdump_files=( `ls $TCPDUMP_BASE_FILENAME*` )
    if [ ${#tcpdump_files[@]} -ne 0 ]; then
        if [ "$BACKUP_TYPE" == "auto" ]; then
            tar -czv ${tcpdump_files[@]} -f ${log_archives_dir}/tcpdump_logs_${timestamp}Z.tar.gz
        else
            tar -czv ${tcpdump_files[@]} -f ${log_archives_dir}/tcpdump_logs_${timestamp}.tar.gz
        fi
    fi

    #resume paused process after archiving
    if [ -f $TCPDUMP_BASE_PID_FILENAME ]; then 
        TCPDUMP_PID=$(<$TCPDUMP_BASE_PID_FILENAME)
        if [ -n "$TCPDUMP_PID" ]; then
            pkill -CONT $TCPDUMP_PID
        fi
    fi

fi

if [ "$BACKUP_TYPE" == "auto" ]; then
    timestamp=`date +%Y%m%d_%H%M%S`
else
    timestamp=`date +%F-%H-%M`
fi

#
# Auth Module
#
if false; then
    if [ -f /etc/sysconfig/AuthModule ]; then
        if [ -d ${apache_home}/webapps/authmodule/authmodule/logs/ ]; then
            auth_logs=( `ls -d ${apache_home}/webapps/authmodule/authmodule/logs/*` )
            if [ "$BACKUP_TYPE" == "auto" ]; then
                tar -czv ${auth_logs[@]} -f ${log_archives_dir}/AuthModule_logs_${timestamp}Z.tar.gz
            else
                tar -czv ${auth_logs[@]} -f ${log_archives_dir}/AuthModule_logs_${timestamp}.tar.gz
            fi
        fi
        if [ -z "$noSEC" ]; then
            if [ -d ${apache_home}/logs ]; then
                authSEC_logs=( `ls -d ${apache_home}/logs/authmodule.log` )
                if [ "$BACKUP_TYPE" == "auto" ]; then
                    tar -czv ${authSEC_logs[@]} -f ${log_archives_dir}/AuthModule_SEClogs_${timestamp}Z.tar.gz
                else
                    tar -czv ${authSEC_logs[@]} -f ${log_archives_dir}/AuthModule_SEClogs_${timestamp}.tar.gz
                fi
            fi
        fi

    fi
fi

#
#CallAnalytics log archive
#
CALLANALYTICS_LOGS_PATH="${apache_home}/webapps/CallAnalytics/logs"
if [ -f /etc/sysconfig/CallAnalytics ]; then
  callAnalytics_logs=( `ls -d ${CALLANALYTICS_LOGS_PATH}/*` )
	if [ "$BACKUP_TYPE" == "auto" ]; then
    tar -czv ${callAnalytics_logs[@]} -f ${log_archives_dir}/CallAnalytics_logs_${timestamp}Z.tar.gz
  else
    tar -czv ${callAnalytics_logs[@]} -f ${log_archives_dir}/CallAnalytics_logs_${timestamp}.tar.gz
  fi
fi

#
# WebLM log archive
#
if [ -f /etc/sysconfig/WebLM ]; then
    if [ -d ${apache_home}/webapps/WebLM/data/log ]; then
      weblm_logs=( `ls -d ${apache_home}/webapps/WebLM/data/log/*operational.log` `ls -d ${apache_home}/webapps/WebLM/data/log/*debug.log` )
      if [ "$BACKUP_TYPE" == "auto" ]; then
          tar -czv ${weblm_logs[@]} -f ${log_archives_dir}/WebLM_logs_${timestamp}Z.tar.gz
      else
          tar -czv ${weblm_logs[@]} -f ${log_archives_dir}/WebLM_logs_${timestamp}.tar.gz
      fi
      if [ -z "$noSEC" ]; then
          weblmSEC_logs=( `ls -d ${apache_home}/webapps/WebLM/data/log/*security.log` `ls -d ${apache_home}/webapps/WebLM/data/log/*audit.log` )
          if [ "$BACKUP_TYPE" == "auto" ]; then
              tar -czv ${weblmSEC_logs[@]} -f ${log_archives_dir}/WebLM_SEClogs_${timestamp}Z.tar.gz
          else
              tar -czv ${weblmSEC_logs[@]} -f ${log_archives_dir}/WebLM_SEClogs_${timestamp}.tar.gz
          fi
      fi
     fi
fi


#
# WebRTC log archive
#
if [ -f /etc/sysconfig/webrtcgw ]; then
   . /etc/sysconfig/webrtcgw
   if [ -d ${MG_PATH}/logs ] || [ -d ${SG_PATH}/logs ] || [ -d ${SG_PATH}/apache-tomcat-*/logs ] || [ -d ${WEBRTC_HOME}/logs ] ; then
     
        webrtc_logs=""
        if [ -d ${WEBRTC_HOME}logs ]; then
            webrtc_logs=( ${webrtc_logs[@]} `ls -d ${WEBRTC_HOME}logs` )
        fi
        if [ -d ${MG_PATH}logs ]; then
            webrtc_logs=( ${webrtc_logs[@]} `ls -d ${MG_PATH}logs` )
        fi
        if [ -d ${SG_PATH}logs ]; then
            webrtc_logs=( ${webrtc_logs[@]} `ls -d ${SG_PATH}logs` )
        fi
        if [ -d ${SG_PATH}apache-tomcat-*/logs ]; then
            webrtc_logs=( ${webrtc_logs[@]} `ls -d ${SG_PATH}apache-tomcat-*/logs` )
        fi
        if [ -f ${MG_PATH}hs_err_pid* ]; then
            webrtc_logs=( ${webrtc_logs[@]} `ls -d ${MG_PATH}hs_err_pid*` )
        fi
        if [ "$BACKUP_TYPE" == "auto" ]; then
            tar -czv ${webrtc_logs[@]} -f ${log_archives_dir}/WebRTCGateway_logs_${timestamp}Z.tar.gz
        else
            tar -czv ${webrtc_logs[@]} -f ${log_archives_dir}/WebRTCGateway_logs_${timestamp}.tar.gz
        fi
    fi
fi
#
# SysMon log archives
#
if [ -d /var/log/sysmon ]; then
    set -x
    date_time=`date +%Y%m%d_%H`
    systemctl stop rsyslog
    for file in `find /var/log/sysmon -type f -name "*.log.zip*"`; do
        zcat $file > ${file/.zip/}
        zip -j ${file/.log.zip/}.zip ${file/.zip/}
        rm -f ${file/.zip/}
        if [[ $file != *"$date_time.log.zip" ]]; then
            rm -f $file
        fi
    done
    if [ "$BACKUP_TYPE" == "auto" ]; then
        tar -czv /var/log/sysmon -f ${log_archives_dir}/sysmon_logs_${timestamp}Z.tar.gz --exclude="*.log.zip"
    else
        tar -czv /var/log/sysmon -f ${log_archives_dir}/sysmon_logs_${timestamp}.tar.gz --exclude="*.log.zip"
    fi
    systemctl start rsyslog
    set +x
fi

#
# CSIPO log archives
#
if false; then
if [ -d /opt/witness/logs/ ] || [ -d /opt/witness/tomcat7/logs/ ]; then
    csipo_logs=""
    if [ -d /opt/witness/logs/ ]; then
        csipo_logs=( $csipo_logs `ls -d /opt/witness/logs` )
    fi
    if [ -d /opt/witness/tomcat7/logs/ ]; then
        csipo_logs=( $csipo_logs `ls -d /opt/witness/tomcat7/logs` )
    fi
    if [ "$BACKUP_TYPE" == "auto" ]; then
        tar -czv ${csipo_logs[@]} -f ${log_archives_dir}/contact_recorder_logs_${timestamp}Z.tar.gz
    else
        tar -czv ${csipo_logs[@]} -f ${log_archives_dir}/contact_recorder_logs_${timestamp}.tar.gz
    fi 
fi
fi

# mediamanager archive
if [ -f /etc/sysconfig/mediamanager ]; then
    . /etc/sysconfig/mediamanager
    mediamanager_logs=(`ls -d /opt/Avaya/apache-tomcat/logs/MediaManager* ` "/opt/MediaManager/Migration.properties" "/opt/MediaManager/MigrationSummary" "/opt/MediaManager/UtilitySummary" "/opt/MediaManager/log_migration.txt")
    if [ "$BACKUP_TYPE" == "auto" ]; then
        tar -czv ${mediamanager_logs[@]} --exclude="$TCPDUMP_BASE_DIR" -f ${log_archives_dir}/mediamanager_logs_${timestamp}Z.tar.gz
    else
        tar -czv ${mediamanager_logs[@]} --exclude="$TCPDUMP_BASE_DIR" -f ${log_archives_dir}/mediamanager_logs_${timestamp}.tar.gz
    fi
fi


#
# OneX Portal log archives
#
if [ -f /etc/sysconfig/onexportal ]; then
    . /etc/sysconfig/onexportal
    onex_logs=( `ls -d ${ONEX_PATH}/apache-tomcat/logs/*` `ls -d /opt/Avaya/logs/` )
    ira_logs=""
    if [ -f /etc/sysconfig/ipora ]; then
        . /etc/sysconfig/ipora
        ira_logs=(`ls -d ${ONEX_PATH}/apache-tomcat/logs/helsinki_reporter/*` `ls -d ${IPORA_HOME}logs/` )
        if [ "$BACKUP_TYPE" == "auto" ]; then
            tar -czv ${ira_logs[@]} --exclude="$TCPDUMP_BASE_DIR" -f ${log_archives_dir}/icr_logs_${timestamp}Z.tar.gz
        else
            tar -czv ${ira_logs[@]} --exclude="$TCPDUMP_BASE_DIR" -f ${log_archives_dir}/icr_logs_${timestamp}.tar.gz
        fi
    fi
    if [ -d "/opt/Avaya/oneXportal/openfire/logs" ]; then
        onex_logs=( ${onex_logs[@]} `ls -d "/opt/Avaya/oneXportal/openfire/logs/"` )
    fi

    if [ -d "/var/log/One-X" ]; then
        onex_logs=( ${onex_logs[@]} `ls -d "/var/log/One-X"` )
    fi

    if [ -d "/var/log/OpenFire" ]; then
        onex_logs=( ${onex_logs[@]} `ls -d "/var/log/OpenFire"`)
    fi

    if [ "$BACKUP_TYPE" == "auto" ]; then
        tar -czv ${onex_logs[@]} --exclude="$TCPDUMP_BASE_DIR" -f ${log_archives_dir}/onex_logs_${timestamp}Z.tar.gz
    else
        tar -czv ${onex_logs[@]} --exclude="$TCPDUMP_BASE_DIR" -f ${log_archives_dir}/onex_logs_${timestamp}.tar.gz
    fi
fi

#
# OpenFire log archives
#
openfire_logs=( )
if [ -d "/opt/Avaya/oneXportal/openfire/logs" ]; then
    openfire_logs=( ${openfire_logs[@]} `ls -d "/opt/Avaya/oneXportal/openfire/logs"` )
fi

if [ -d "/var/log/OpenFire" ]; then
    openfire_logs=( ${openfire_logs[@]} `ls -d "/var/log/OpenFire"` )
fi
if [ "$BACKUP_TYPE" == "auto" ]; then
    tar -czv ${openfire_logs[@]} -f ${log_archives_dir}/openfire_logs_${timestamp}Z.tar.gz
else
    tar -czv ${openfire_logs[@]} -f ${log_archives_dir}/openfire_logs_${timestamp}.tar.gz
fi

#
# IPOffice log archives
#
if [ ! -z "`rpm -q ipoffice | grep -v "not installed"`" ]; then
    ipoffice_logs=( "${ISA_LOG_PATH_NAME}" "${GEN_CERTS_LOG_PATH_NAME}" "${IPOFFICE_LOG_PATH_NAME}" "${IPOFFICE_SERVICE_LOG_PATH_NAME}" "/opt/Avaya/uws_logs/" "/opt/ipoffice/system/logs/" `ls ${IPOFFICE_SERVICE_LOG_PATH_NAME}.*.gz` `ls /usr3/Avaya/MediaServer/log/*` "/opt/ipoffice/.swerrs" "/opt/ipoffice/network_changes.log" )
    for log_file in ${ipoffice_logs[@]}
    do
        if [ -f $log_file ]; then
            if [ -f /opt/Avaya/ABG_release ]; then
                if [ "$BACKUP_TYPE" == "auto" ]; then
                    tar -czv ${ipoffice_logs[@]} -f ${log_archives_dir}/B5800_logs_${timestamp}Z.tar.gz
                else
                    tar -czv ${ipoffice_logs[@]} -f ${log_archives_dir}/B5800_logs_${timestamp}.tar.gz
                fi
                break;
            elif [ -f /opt/Avaya/APC_release -o -f /opt/Avaya/APPL_release ]; then
                if [ "$BACKUP_TYPE" == "auto" ]; then
                   tar -czv ${ipoffice_logs[@]} -f ${log_archives_dir}/management_services_logs_${timestamp}Z.tar.gz
                else
                    tar -czv ${ipoffice_logs[@]} -f ${log_archives_dir}/management_services_logs_${timestamp}.tar.gz
                fi
                break;
            else
                if [ "$BACKUP_TYPE" == "auto" ]; then
                    tar -czv ${ipoffice_logs[@]} -f ${log_archives_dir}/ipoffice_logs_${timestamp}Z.tar.gz --exclude="*Z.tar.gz"
                else
                    tar -czv ${ipoffice_logs[@]} -f ${log_archives_dir}/ipoffice_logs_${timestamp}.tar.gz --exclude="*Z.tar.gz"
                fi
                break;
            fi
        fi
    done
fi
#
# VoiceMail Pro log archives
#
if [ -f /etc/sysconfig/vmpro ]; then
    . /etc/sysconfig/vmpro
    if [ -e "${VMPRO_LOGFILE}" ]; then
        if [ "$BACKUP_TYPE" == "auto" ]; then
            tar -czv `dirname ${VMPRO_LOGFILE}` -f ${log_archives_dir}/voicemail_logs_${timestamp}Z.tar.gz
        else
            tar -czv `dirname ${VMPRO_LOGFILE}` -f ${log_archives_dir}/voicemail_logs_${timestamp}.tar.gz
        fi
    fi
fi

#
# CLI log archives
#
cli_logs=( "${AUDIT_LOG_PATH_NAME}" `ls ${AUDIT_LOG_PATH_NAME}.*.gz ` )
for log_file in ${cli_logs[@]}
do
    if [ -f $log_file ]; then
        if [ "$BACKUP_TYPE" == "auto" ]; then
            tar -czv ${cli_logs[@]} -f ${log_archives_dir}/cli_logs_${timestamp}Z.tar.gz
        else
            tar -czv ${cli_logs[@]} -f ${log_archives_dir}/cli_logs_${timestamp}.tar.gz
        fi
        break;
    fi
done

#
# Web Control log archives
#
if [ -f /etc/sysconfig/webcontrol ]; then
    . /etc/sysconfig/webcontrol
    webcontrol_logs=( `ls ${WEBCONTROL_LOG_DIR}/*` )
    for log_file in ${webcontrol_logs[@]}
    do
        if [ -f $log_file ]; then
            if [ "$BACKUP_TYPE" == "auto" ]; then
                tar -czv ${webcontrol_logs[@]} -f ${log_archives_dir}/webcontrol_logs_${timestamp}Z.tar.gz
            else
                tar -czv ${webcontrol_logs[@]} -f ${log_archives_dir}/webcontrol_logs_${timestamp}.tar.gz
            fi
            break;
        fi
    done
fi

# Watchdog log archives
#
watchdog_logs=( "${WATCHDOG_LOG_PATH_NAME}" "${WATCHDOG_TEST_LOG_PATH_NAME}" )
for log_file in ${watchdog_logs[@]}
do
    if [ -f $log_file ]; then
        if [ "$BACKUP_TYPE" == "auto" ]; then
            tar -czv ${watchdog_logs[@]} -f ${log_archives_dir}/watchdog_logs_${timestamp}Z.tar.gz
        else
            tar -czv ${watchdog_logs[@]} -f ${log_archives_dir}/watchdog_logs_${timestamp}.tar.gz
        fi
        break;
    fi
done

#
# APC Thermal log archives; ignore listing errors (for ABE)
#
apc_thermal_logs=( `ls ${APC_THERMAL_LOG_DIR_NAME}/* 2>/dev/null` ${APC_THERMAL_ERROR_LOG_PATH_NAME} )
for log_file in ${apc_thermal_logs[@]}
do
    if [ -f $log_file ]; then
        if [ "$BACKUP_TYPE" == "auto" ]; then
            tar -czv ${apc_thermal_logs[@]} -f ${log_archives_dir}/apc_thermal_logs_${timestamp}Z.tar.gz
        else
            tar -czv ${apc_thermal_logs[@]} -f ${log_archives_dir}/apc_thermal_logs_${timestamp}.tar.gz
        fi
        break;
    fi
done

#
# APC Heartbeat log archives; ingore listing errors (for ABE)
#
heartbeat_logs=( `ls ${HEARTBEAT_LOG_DIR_NAME} 2>/dev/null` ${HEARTBEAT_ERROR_LOG_PATH_NAME} )
for log_file in ${heartbeat_logs[@]}
do
    if [ -f $log_file ]; then
        if [ "$BACKUP_TYPE" == "auto" ]; then
            tar -czv ${heartbeat_logs[@]} -f ${log_archives_dir}/heartbeat_logs_${timestamp}Z.tar.gz
        else
            tar -czv ${heartbeat_logs[@]} -f ${log_archives_dir}/heartbeat_logs_${timestamp}.tar.gz
        fi
        break;
    fi
done

#
# Install log archives
#
install_log_files=( "/root/install.log" "/root/install_log_nochroot.txt" "/root/install.log.syslog" "/root/install_log.txt" "/root/install_sh_log.txt" "/root/anaconda-ks.cfg" "/root/backup_logs.txt" "/root/install_scanHDD.txt" "/root/restore_logs.txt" "/root/log.txt" "/root/install_default-partition.txt" "/root/firewall_log.txt" "/root/factory.conf" "/root/original-ks.cfg" "/root/install_text" )

for log_file in ${install_log_files[@]}
do
    if [ -f $log_file ]; then
        if [ "$BACKUP_TYPE" == "auto" ]; then
            tar -czv ${install_log_files[@]} -f ${log_archives_dir}/install_logs_${timestamp}Z.tar.gz
        else
            tar -czv ${install_log_files[@]} -f ${log_archives_dir}/install_logs_${timestamp}.tar.gz
        fi
        break;
    fi
done

#
# Upgrade log archives
#
upgrade_log_files=( "/root/upgrade.log" "/root/upgrade_log_nochroot.txt" "/root/upgrade.log.syslog" "/root/upgrade_log.txt" "/root/upgrade_sh_log.txt" )
    
for log_file in ${upgrade_log_files[@]}
do
    if [ -f $log_file ]; then
        if [ "$BACKUP_TYPE" == "auto" ]; then
            tar -czv ${upgrade_log_files[@]} -f ${log_archives_dir}/upgrade_logs_${timestamp}Z.tar.gz
        else
            tar -czv ${upgrade_log_files[@]} -f ${log_archives_dir}/upgrade_logs_${timestamp}.tar.gz
        fi
        break;
    fi
done

#
# System log archives
#

(
    set -x
    CWD=`pwd`
    date
    /sbin/ifconfig -a 
    /sbin/route -n
    ls -l /var/www/html/coredumps/
    /sbin/hdparm -I /dev/[hsv]d?
    sudo sdparm -i /dev/[hsv]d?
    ls -l /etc/localtime /etc/sysconfig/clock
    cat /etc/sysconfig/clock
    df -h
    free
    dmidecode
    ps -eo rss,cmd --sort=rss
    rpm -qa
    
    prelink --md5 --verify /usr/bin/ipoffice
    for i in /usr/Avaya/MediaServer/bin/*; do
        prelink --md5 --verify $i
    done
    if [ -f /root/checknet.txt ]; then
        cat /root/checknet.txt
    fi

    for i in /dev/[hsv]d?; do
        smartctl -a $i
        hdparm -t $i
    done

    iostat 
    top -b -n 1

    ls -r /opt/Avaya/
    service --status-all
) &> /tmp/avayasyslog.txt

system_logs=( "/var/log/rsyslog" "/var/log/messages" "/var/log/configure_rsyslog_output.log" "/var/log/httpd" `ls /var/log/messages*` `ls /var/log/yum.log` `ls /etc/sysconfig/network-scripts/ifcfg-eth*` "/tmp/avayasyslog.txt" `ls /var/log/system_status_log/*` `ls /tmp/B5800_UWS*` `ls /tmp/yumOut_*` )
if [ -f "/opt/Avaya/Backup_Restore/backupLog" ]; then
     system_logs=("${system_logs[@]}" "/opt/Avaya/Backup_Restore/backupLog")
fi
if [ -f "/opt/Avaya/Backup_Restore/restoreLog" ]; then
     system_logs=("${system_logs[@]}" "/opt/Avaya/Backup_Restore/restoreLog")
fi
if [ -f "/tmp/.getprocessid" ]; then
     system_logs=("${system_logs[@]}" "/tmp/.getprocessid")
fi
if [ -f "/tmp/.rpmpkginfo" ]; then
     system_logs=("${system_logs[@]}" "/tmp/.rpmpkginfo")
fi
if [ -f "/tmp/.ipolreboot" ]; then
     system_logs=("${system_logs[@]}" "/tmp/.ipolreboot")
fi
if [ -f "/var/log/top_processes.log" ]; then
     system_logs=("${system_logs[@]}" `ls /var/log/top_processes*` )	
fi

for log_file in ${system_logs[@]}
do
    if [ -f $log_file ]; then
        if [ "$BACKUP_TYPE" == "auto" ]; then
            tar -czv ${system_logs[@]} -f ${log_archives_dir}/system_logs_${timestamp}Z.tar.gz
        else
            tar -czv ${system_logs[@]} -f ${log_archives_dir}/system_logs_${timestamp}.tar.gz
        fi
        break;
    fi
done

if rpm -q webmanagement; then
    if [ "$BACKUP_TYPE" == "auto" ]; then
        tar -czv /opt/Avaya/apache-tomcat/logs -f ${log_archives_dir}/webmanagement_logs_${timestamp}Z.tar.gz
    else
        tar -czv /opt/Avaya/apache-tomcat/logs -f ${log_archives_dir}/webmanagement_logs_${timestamp}.tar.gz
    fi
fi

rm -f /tmp/avayasyslog.txt

chmod 644 ${log_archives_dir}/*

if [ "$BACKUP_TYPE" == "auto" ]; then
    mv ${log_archives_dir}/* ${SYSTEM_DIAGNOSTIC_BACKUP_DIR}
else
    mv ${log_archives_dir}/* ${APPS_MISC_LOGS_DIR_NAME}
fi

