#!/bin/bash
#
#script to create/modify entry in /etc/yum.repos.d/Avaya_Inside.repo file
#usage: ./setup_repo.sh <services|os|windows_clients> <new_repository_path>
#


SCRIPTS_PATH=/opt/Avaya/scripts
. ${SCRIPTS_PATH}/config

function usage()
{
    echo "Error:$1"
    echo "usage: ./setup_repo.sh <services|os|windows_clients> <new_repository_path>"
}

function create_yum_entry()
{
	sudo touch "$UPDATES_FILE"
	sudo chmod 666 $UPDATES_FILE

	if [ "$1" = "new_file" ];then
		echo "[$section]" > $UPDATES_FILE
	else 
		echo -e "\n" >> $UPDATES_FILE
		echo "[$section]" >> $UPDATES_FILE
	fi
	echo "name=$name" >> $UPDATES_FILE
	echo "baseurl=$baseurl" >> $UPDATES_FILE 
	echo "gpgcheck=$gpgcheck" >> $UPDATES_FILE
	echo "enabled=$enabled" >> $UPDATES_FILE
}

function modify_yum_repo()
{
	if [ -z "`grep "\[$section\]" $UPDATES_FILE`" ];then
		create_yum_entry existing_file
	else
		baseurl="${baseurl//\\/\\\\}"
		baseurl="${baseurl//\//\/}"

		sudo sed   -i "
			/\[$section\]/ {
				N;N
				s/\nbaseurl *=.*/\nbaseurl = $baseurl/

			}" ${UPDATES_FILE}
	fi
}


case $1 in
    services)
	section="apps"
        name="Application Updates"
        baseurl=$2
        gpgcheck=0
        enabled=0	
    ;;
    os) 	
        section="system"
        name="YUM System Updates"
        baseurl=$2
        gpgcheck=0
        enabled=1
    ;;
    windows_clients)
        section="winapps"
        name="Windows Clients Repository"
        baseurl=$2
        gpgcheck=0
        enabled=0
    ;;
    *)
        usage "Invalid parameter."
	exit 1
    ;; 
esac
	
if [ ! -e $UPDATES_FILE ];then
    create_yum_entry new_file
else
    modify_yum_repo 
fi

