#!/bin/bash

SCRIPTS_PATH=/opt/Avaya/scripts
OUTPUT_FILE=/tmp/output.$$
WATCHDOG_MSG=IPOfficeWatchdog

function show_logging()
{
	for ((i=0;i<${#log_files[@]};i++)); do
		echo ${delimiter}
		echo "Logs for application ${log_binary_names[${i}]}" 
		echo -e "\n"
		if [ ${log_files[${i}]} = "/var/log/messages" ]; then
			if [ -z "$1" ]; then
				sudo cat /var/log/messages | grep ${log_binary_names[${i}]} | grep -v ${WATCHDOG_MSG}
			else
				sudo cat /var/log/messages | grep ${log_binary_names[${i}]} | grep -v ${WATCHDOG_MSG} | tail -n $1 -
			fi
		else
			if [ -z "$1" ]; then
				cat ${log_files[${i}]} | tr -d '\0'
			else
				tail -n $1 ${log_files[${i}]} | tr -d '\0'
			fi
		fi
		echo -e "\n\n\n" 
	done
}

. ${SCRIPTS_PATH}/config $1 

#Output of the last command
echo ${delimiter} > ${OUTPUT_FILE}
echo "Output of the last command:" >> ${OUTPUT_FILE}

for ((i=0;i<${#last_output[@]};i++)); do
	if [ -e ${last_output[${i}]} ];then
		echo -e "\nLast output for ${display_names[${i}]}" >> ${OUTPUT_FILE}
		cat ${last_output[${i}]} >> ${OUTPUT_FILE} 
	fi 
done
echo -e "\n" >> ${OUTPUT_FILE}

#Watchdog output for this application
watchdog_alarms >> ${OUTPUT_FILE}

#show logs of this application
echo ${delimiter} >> ${OUTPUT_FILE}
show_logging $2 >> ${OUTPUT_FILE}

echo ${delimiter} >> ${OUTPUT_FILE}
echo "Press q to quit" >> ${OUTPUT_FILE}
LESSSECURE=1 less ${OUTPUT_FILE}
rm -rf ${OUTPUT_FILE}
