#!/usr/bin/env bash

function checkAndApply() {
    
    check=`grep "$*" /etc/ntp.conf`
    if [ -z "$check" ]; then
        echo "$*" >> /etc/ntp.conf
    fi
}

if ((`id -u` != 0)) 
then
  echo error: You need to be root to start/configure NTP!
  exit 1
fi

rm -f /tmp/ntp.conf
touch /tmp/ntp.conf

#disable sanity limit
checkAndApply "tinker panic 0"

checkAndApply "restrict default kod nomodify notrap nopeer noquery"
checkAndApply "restrict -6 default kod nomodify notrap nopeer noquery"

#Erase all time servers from /etc/ntp.conf
grep -v ^server /etc/ntp.conf >> /tmp/ntp.conf
sed -i '/^restrict 127.0.0.1 ignore/ d' /tmp/ntp.conf
mv /tmp/ntp.conf /etc/ntp.conf

if [ -f /opt/Avaya/.ova ]; then
    checkAndApply "restrict 127.0.0.1"
fi

echo > /etc/ntp/step-tickers

checkAndApply "server 127.127.1.0"
#Append new NTS to /etc/ntp.conf if not already present
for i in "$@"
do
    if [ -f /opt/Avaya/.ova ]; then
        if [[ "$i" == 127.* ]]; then
            continue
        fi
    fi
    echo "server $i" >> /etc/ntp.conf

    # initial time tickers, might be needed for non-virtualization as well...
    if [ -f /opt/Avaya/.ova ]; then
        echo "server $i" >> /etc/ntp/step-tickers
    fi

    # Only disable VMWare timesync if we have a valid server
    if [ ! -z "`which vmware-toolbox-cmd`" ]; then
        vmware-toolbox-cmd timesync disable
    fi
done

#If NTP is not on, start it.
#If NTP is on, restart it.
if [ "`systemctl status ntpd | grep running`" = "" ]
then	
    systemctl start ntpd
else
    systemctl restart ntpd
fi	

#If NTP is not set to run on startup, add it to the list of startup services.
if [ "`systemctl list-unit-files | grep ntpd | grep enabled`" = "" ]
then
    systemctl enable ntpd
fi

#If NTP failed to start, display error message.
if [ "`pgrep ntpd`" = "" ]
then
  echo Error: could not start NTP service
  exit 2
fi

